/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.toolbars;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import net.sourceforge.fidocadj.dialogs.LayerCellRenderer;
import net.sourceforge.fidocadj.geom.ChangeCoordinatesListener;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.layers.LayerDesc;
import net.sourceforge.fidocadj.toolbars.ChangeGridState;
import net.sourceforge.fidocadj.toolbars.ChangeSelectedLayer;
import net.sourceforge.fidocadj.toolbars.ChangeZoomListener;
import net.sourceforge.fidocadj.toolbars.ZoomToFitListener;

public class ToolbarZoom
extends JToolBar
implements ActionListener,
ChangeZoomListener,
ChangeCoordinatesListener {
    private final JComboBox<String> zoom;
    private final JToggleButton showGrid;
    private final JToggleButton snapGrid;
    private final JToggleButton showLibs;
    private final JLabel coords;
    private ChangeGridState changeListener;
    private boolean flagModify;
    private double oldzoom;
    private ChangeZoomListener notifyZoomChangeListener;
    private ZoomToFitListener actualZoomToFitListener;
    private final JComboBox<LayerDesc> layerSel;
    private ChangeSelectedLayer changeLayerListener;

    public ToolbarZoom(Vector<LayerDesc> vector) {
        this.putClientProperty("Quaqua.ToolBar.style", "title");
        this.zoom = new JComboBox();
        this.zoom.addItem("25%");
        this.zoom.addItem("50%");
        this.zoom.addItem("75%");
        this.zoom.addItem("100%");
        this.zoom.addItem("150%");
        this.zoom.addItem("200%");
        this.zoom.addItem("300%");
        this.zoom.addItem("400%");
        this.zoom.addItem("600%");
        this.zoom.addItem("800%");
        this.zoom.addItem("1000%");
        this.zoom.addItem("1500%");
        this.zoom.addItem("2000%");
        this.zoom.addItem("3000%");
        this.zoom.addItem("4000%");
        this.zoom.setPreferredSize(new Dimension(100, 29));
        this.zoom.setMaximumSize(new Dimension(100, 38));
        this.zoom.setMinimumSize(new Dimension(100, 18));
        JButton jButton = new JButton(Globals.messages.getString("Zoom_fit"));
        this.showGrid = new JToggleButton(Globals.messages.getString("ShowGrid"));
        this.snapGrid = new JToggleButton(Globals.messages.getString("SnapToGrid"));
        this.coords = new JLabel("");
        this.setBorderPainted(false);
        this.layerSel = new JComboBox<LayerDesc>(new Vector<LayerDesc>(vector));
        this.layerSel.setToolTipText(Globals.messages.getString("tooltip_layerSel"));
        this.layerSel.setRenderer(new LayerCellRenderer());
        this.changeListener = null;
        this.showLibs = new JToggleButton(Globals.messages.getString("Libs"));
        jButton.putClientProperty("Quaqua.Button.style", "toggleWest");
        this.showGrid.putClientProperty("Quaqua.Button.style", "toggleCenter");
        this.snapGrid.putClientProperty("Quaqua.Button.style", "toggleCenter");
        this.showLibs.putClientProperty("Quaqua.Button.style", "toggleEast");
        String string = "recessed";
        jButton.putClientProperty("JButton.buttonType", string);
        jButton.putClientProperty("JButton.segmentPosition", "first");
        this.showGrid.putClientProperty("JButton.buttonType", string);
        this.showGrid.putClientProperty("JButton.segmentPosition", "middle");
        this.snapGrid.putClientProperty("JButton.buttonType", string);
        this.snapGrid.putClientProperty("JButton.segmentPosition", "middle");
        this.showLibs.putClientProperty("JButton.buttonType", string);
        this.showLibs.putClientProperty("JButton.segmentPosition", "last");
        this.zoom.addActionListener(this);
        jButton.addActionListener(this);
        this.showGrid.addActionListener(this);
        this.snapGrid.addActionListener(this);
        this.showLibs.addActionListener(this);
        this.layerSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ToolbarZoom.this.layerSel.getSelectedIndex() >= 0 && ToolbarZoom.this.changeListener != null) {
                    ToolbarZoom.this.changeLayerListener.changeSelectedLayer(ToolbarZoom.this.layerSel.getSelectedIndex());
                }
            }
        });
        this.changeListener = null;
        this.add(this.zoom);
        this.add(jButton);
        this.add(this.showGrid);
        this.add(this.snapGrid);
        this.add(this.showLibs);
        this.add(this.layerSel);
        this.add(Box.createGlue());
        this.add(this.coords);
        this.add(Box.createGlue());
        this.coords.setPreferredSize(new Dimension(300, 28));
        this.coords.setMinimumSize(new Dimension(300, 18));
        this.coords.setMaximumSize(new Dimension(300, 38));
        this.setFloatable(true);
        this.setRollover(false);
        this.zoom.setEditable(true);
        this.showGrid.setSelected(true);
        this.snapGrid.setSelected(true);
        this.showLibs.setSelected(true);
        this.changeCoordinates(0, 0);
    }

    public void addLayerListener(ChangeSelectedLayer changeSelectedLayer) {
        this.changeLayerListener = changeSelectedLayer;
    }

    public void addGridStateListener(ChangeGridState changeGridState) {
        this.changeListener = changeGridState;
    }

    public void addChangeZoomListener(ChangeZoomListener changeZoomListener) {
        this.notifyZoomChangeListener = changeZoomListener;
    }

    public void addZoomToFitListener(ZoomToFitListener zoomToFitListener) {
        this.actualZoomToFitListener = zoomToFitListener;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(Globals.messages.getString("ShowGrid"))) {
            if (this.changeListener != null) {
                this.changeListener.setGridVisibility(this.showGrid.isSelected());
            }
        } else if (string.equals(Globals.messages.getString("SnapToGrid"))) {
            if (this.changeListener != null) {
                this.changeListener.setSnapState(this.snapGrid.isSelected());
            }
        } else if (string.equals(Globals.messages.getString("Zoom_fit"))) {
            if (this.actualZoomToFitListener != null) {
                this.actualZoomToFitListener.zoomToFit();
            }
        } else if (actionEvent.getSource() instanceof JComboBox) {
            this.handleZoomChangeEvents(actionEvent);
        } else if (string.equals(Globals.messages.getString("Libs"))) {
            this.actualZoomToFitListener.showLibs(this.showLibs.isSelected());
        }
    }

    public void setShowLibsState(boolean bl) {
        this.showLibs.setSelected(bl);
    }

    private void handleZoomChangeEvents(ActionEvent actionEvent) {
        if (this.notifyZoomChangeListener != null) {
            try {
                String string = (String)this.zoom.getSelectedItem();
                string = string.replace('%', ' ').trim();
                double d = Double.parseDouble(string);
                if (d == this.oldzoom) {
                    return;
                }
                this.oldzoom = d;
                if (10.0 <= d && d <= 4000.0) {
                    this.notifyZoomChangeListener.changeZoom(d / 100.0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void changeZoom(double d) {
        this.zoom.setSelectedItem((int)(d * 100.0) + "%");
    }

    @Override
    public void changeCoordinates(int n, int n2) {
        int n3 = n * 127;
        int n4 = n2 * 127;
        float f = (float)n3 / 1000.0f;
        float f2 = (float)n4 / 1000.0f;
        Color color = UIManager.getColor("Label.foreground");
        Color color2 = UIManager.getColor("Label.background");
        if (color != null && color2 != null) {
            this.coords.setOpaque(false);
            this.coords.setForeground(color);
            this.coords.setBackground(color2);
        }
        this.coords.setText(n + "; " + n2 + " (" + f + " mm; " + f2 + " mm)");
    }

    public void changeStrict(boolean bl) {
    }

    public void setShowLibs(boolean bl) {
        this.showLibs.setSelected(bl);
    }

    public void setShowGrid(boolean bl) {
        this.showGrid.setSelected(bl);
    }

    public void setSnapGrid(boolean bl) {
        this.snapGrid.setSelected(bl);
    }

    @Override
    public void changeInfos(String string) {
        Color color = UIManager.getColor("Label.background");
        Color color2 = UIManager.getColor("Label.foreground");
        if (color != null && color2 != null) {
            this.coords.setOpaque(true);
            this.coords.setForeground(Color.WHITE);
            this.coords.setBackground(Color.GREEN.darker().darker());
        }
        this.coords.setText(string);
    }
}

