/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.toolbars;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.sourceforge.fidocadj.toolbars.ChangeSelectionListener;
import net.sourceforge.fidocadj.toolbars.ToolButton;

public class ToolbarTools
extends JToolBar
implements ChangeSelectionListener {
    private ChangeSelectionListener selectionListener;
    private final JToggleButton selection;
    private final JToggleButton zoom;
    private final JToggleButton hand;
    private final JToggleButton line;
    private final JToggleButton advtext;
    private final JToggleButton bezier;
    private final JToggleButton polygon;
    private final JToggleButton ellipse;
    private final JToggleButton complexcurve;
    private final JToggleButton rectangle;
    private final JToggleButton connection;
    private final JToggleButton pcbline;
    private final JToggleButton pcbpad;
    private final JLabel fileName;
    private final String base;
    private final boolean showText;
    private final ButtonGroup group;
    private final ArrayList<JToggleButton> toolButtonsList;
    private final HashMap<JToggleButton, Integer> circuitPanelConstants;

    public void setTitle(String string) {
        this.fileName.setText(string);
    }

    public String getBase() {
        return this.base;
    }

    public boolean getShowText() {
        return this.showText;
    }

    public void addToolButton(JToggleButton jToggleButton, int n) {
        this.add(jToggleButton);
        this.group.add(jToggleButton);
        this.toolButtonsList.add(jToggleButton);
        this.circuitPanelConstants.put(jToggleButton, n);
    }

    public ToolbarTools(boolean bl, boolean bl2) {
        this.base = bl2 ? "icons16/" : "icons32/";
        this.showText = bl;
        this.putClientProperty("Quaqua.ToolBar.style", "title");
        this.setBorderPainted(false);
        this.group = new ButtonGroup();
        this.toolButtonsList = new ArrayList();
        this.circuitPanelConstants = new HashMap();
        ToolButton toolButton = new ToolButton(this, "arrow.png", "Selection", "selection", "tooltip_selection");
        this.selection = toolButton.getToolButton();
        this.addToolButton(this.selection, 1);
        this.selection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.selection);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton2 = new ToolButton(this, "magnifier.png", "Zoom_p", "zoom", "tooltip_zoom");
        this.zoom = toolButton2.getToolButton();
        this.addToolButton(this.zoom, 2);
        this.zoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.zoom);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton3 = new ToolButton(this, "move.png", "Hand", "hand", "tooltip_hand");
        this.hand = toolButton3.getToolButton();
        this.addToolButton(this.hand, 3);
        this.hand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.hand);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton4 = new ToolButton(this, "line.png", "Line", "line", "tooltip_line");
        this.line = toolButton4.getToolButton();
        this.addToolButton(this.line, 4);
        this.line.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.line);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton5 = new ToolButton(this, "text.png", "Text", "text", "tooltip_text");
        this.advtext = toolButton5.getToolButton();
        this.addToolButton(this.advtext, 5);
        this.advtext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.advtext);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton6 = new ToolButton(this, "bezier.png", "Bezier", "bezier", "tooltip_bezier");
        this.bezier = toolButton6.getToolButton();
        this.addToolButton(this.bezier, 6);
        this.bezier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.bezier);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton7 = new ToolButton(this, "polygon.png", "Polygon", "polygon", "tooltip_polygon");
        this.polygon = toolButton7.getToolButton();
        this.addToolButton(this.polygon, 7);
        this.polygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.polygon);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton8 = new ToolButton(this, "complexcurve.png", "Complexcurve", "complexcurve", "tooltip_curve");
        this.complexcurve = toolButton8.getToolButton();
        this.addToolButton(this.complexcurve, 14);
        this.complexcurve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.complexcurve);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton9 = new ToolButton(this, "ellipse.png", "Ellipse", "ellipse", "tooltip_ellipse");
        this.ellipse = toolButton9.getToolButton();
        this.addToolButton(this.ellipse, 8);
        this.ellipse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.ellipse);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton10 = new ToolButton(this, "rectangle.png", "Rectangle", "rectangle", "tooltip_rectangle");
        this.rectangle = toolButton10.getToolButton();
        this.addToolButton(this.rectangle, 9);
        this.rectangle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.rectangle);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton11 = new ToolButton(this, "connection.png", "Connection", "connection", "tooltip_connection");
        this.connection = toolButton11.getToolButton();
        this.addToolButton(this.connection, 10);
        this.connection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.connection);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton12 = new ToolButton(this, "pcbline.png", "PCBline", "pcbline", "tooltip_pcbline");
        this.pcbline = toolButton12.getToolButton();
        this.addToolButton(this.pcbline, 11);
        this.pcbline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.pcbline);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        ToolButton toolButton13 = new ToolButton(this, "pcbpad.png", "PCBpad", "pcbpad", "tooltip_pcbpad");
        this.pcbpad = toolButton13.getToolButton();
        this.addToolButton(this.pcbpad, 12);
        this.pcbpad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)ToolbarTools.this.circuitPanelConstants.get(ToolbarTools.this.pcbpad);
                int n2 = n;
                ToolbarTools.this.selectionListener.setSelectionState(n2, "");
            }
        });
        this.fileName = new JLabel("");
        this.add(Box.createGlue());
        this.add(this.fileName);
        this.add(Box.createGlue());
        this.setFloatable(false);
        this.setRollover(true);
    }

    public void addSelectionListener(ChangeSelectionListener changeSelectionListener) {
        this.selectionListener = changeSelectionListener;
    }

    public JToggleButton getSelectedButton() {
        for (JToggleButton jToggleButton : this.toolButtonsList) {
            if (!jToggleButton.isSelected()) continue;
            return jToggleButton;
        }
        return null;
    }

    @Override
    public int getSelectionState() {
        JToggleButton jToggleButton = this.getSelectedButton();
        if (jToggleButton == null) {
            return 0;
        }
        Integer n = this.circuitPanelConstants.get(jToggleButton);
        return n;
    }

    @Override
    public void setStrictCompatibility(boolean bl) {
        this.complexcurve.setEnabled(!bl);
    }

    @Override
    public void setSelectionState(int n, String string) {
        for (int i = 0; i < this.toolButtonsList.size() && n != 0 && n != 13; ++i) {
            JToggleButton jToggleButton = this.toolButtonsList.get(i);
            Integer n2 = this.circuitPanelConstants.get(jToggleButton);
            int n3 = n2;
            if (n != n3) continue;
            jToggleButton.setSelected(true);
        }
    }
}

