/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fidocadj.dialogs.DashInfo;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.GeometricDistances;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.graphic.PointDouble;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.graphic.PolygonInterface;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;

public final class PrimitivePolygon
extends GraphicPrimitive {
    private int nPoints;
    private boolean isFilled;
    private int dashStyle;
    private PolygonInterface p;
    int storageSize = 5;
    private int xmin;
    private int ymin;
    private int width;
    private int height;
    private float w;

    @Override
    public int getControlPointNumber() {
        return this.nPoints + 2;
    }

    public PrimitivePolygon(String string, int n) {
        this.isFilled = false;
        this.nPoints = 0;
        this.p = null;
        this.initPrimitive(this.storageSize, string, n);
    }

    public PrimitivePolygon(boolean bl, int n, int n2, String string, int n3) {
        this.p = null;
        this.initPrimitive(this.storageSize, string, n3);
        this.nPoints = 0;
        this.isFilled = bl;
        this.dashStyle = n2;
        this.setLayer(n);
    }

    public void removePoint(int n, int n2, double d) {
        int n3;
        if (this.nPoints <= 3) {
            return;
        }
        double d2 = GeometricDistances.pointToPoint(this.virtualPoint[0].x, this.virtualPoint[0].y, n, n2);
        int n4 = -1;
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            double d3 = GeometricDistances.pointToPoint(this.virtualPoint[n3].x, this.virtualPoint[n3].y, n, n2);
            if (!(d3 < d2)) continue;
            d2 = d3;
            n4 = n3;
        }
        if (d2 <= d) {
            --this.nPoints;
            for (n3 = 0; n3 < this.nPoints; ++n3) {
                if (n3 >= n4) {
                    this.virtualPoint[n3].x = this.virtualPoint[n3 + 1].x;
                    this.virtualPoint[n3].y = this.virtualPoint[n3 + 1].y;
                }
                this.changed = true;
            }
        }
    }

    public void addPointClosest(int n, int n2) {
        int[] nArray = new int[this.storageSize];
        int[] nArray2 = new int[this.storageSize];
        for (int i = 0; i < this.nPoints; ++i) {
            nArray[i] = this.virtualPoint[i].x;
            nArray2[i] = this.virtualPoint[i].y;
        }
        int n3 = (int)Math.sqrt((n - nArray[0]) * (n - nArray[0]) + (n2 - nArray2[0]) * (n2 - nArray2[0]));
        int n4 = 0;
        for (int i = 0; i < this.nPoints; ++i) {
            int n5;
            int n6 = i;
            if (n6 == this.nPoints - 1) {
                n6 = -1;
            }
            if ((n5 = GeometricDistances.pointToSegment(nArray[i], nArray2[i], nArray[n6 + 1], nArray2[n6 + 1], n, n2)) >= n3) continue;
            n3 = n5;
            n4 = n6 + 1;
        }
        this.addPoint(n, n2);
        for (int i = this.nPoints - 1; i > n4; --i) {
            this.virtualPoint[i].x = this.virtualPoint[i - 1].x;
            this.virtualPoint[i].y = this.virtualPoint[i - 1].y;
        }
        this.virtualPoint[n4].x = n;
        this.virtualPoint[n4].y = n2;
        this.changed = true;
    }

    public void addPoint(int n, int n2) {
        if (this.nPoints + 2 >= this.storageSize) {
            int n3;
            int n4 = this.storageSize;
            this.storageSize += 10;
            PointG[] pointGArray = new PointG[this.storageSize];
            for (n3 = 0; n3 < n4; ++n3) {
                pointGArray[n3] = this.virtualPoint[n3];
            }
            while (n3 < this.storageSize) {
                pointGArray[n3] = new PointG();
                ++n3;
            }
            this.virtualPoint = pointGArray;
        }
        this.virtualPoint[this.nPoints].x = n;
        ++this.nPoints;
        this.virtualPoint[this.nPoints].y = n2;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = n2 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = n2 + 10;
        this.changed = true;
    }

    public void createPolygon(MapCoordinates mapCoordinates, GraphicsInterface graphicsInterface) {
        this.xmin = Integer.MAX_VALUE;
        this.ymin = Integer.MAX_VALUE;
        int n = -2147483647;
        int n2 = -2147483647;
        this.p = graphicsInterface.createPolygon();
        this.p.reset();
        for (int i = 0; i < this.nPoints; ++i) {
            int n3 = mapCoordinates.mapX(this.virtualPoint[i].x, this.virtualPoint[i].y);
            int n4 = mapCoordinates.mapY(this.virtualPoint[i].x, this.virtualPoint[i].y);
            this.p.addPoint(n3, n4);
            if (n3 < this.xmin) {
                this.xmin = n3;
            }
            if (n3 > n) {
                n = n3;
            }
            if (n4 < this.ymin) {
                this.ymin = n4;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        this.width = n - this.xmin;
        this.height = n2 - this.ymin;
    }

    @Override
    public void draw(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector) {
        if (!this.selectLayer(graphicsInterface, vector)) {
            return;
        }
        this.drawText(graphicsInterface, mapCoordinates, vector, -1);
        if (this.changed) {
            this.changed = false;
            this.createPolygon(mapCoordinates, graphicsInterface);
            this.w = (float)(Globals.lineWidth * mapCoordinates.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
        }
        if (!graphicsInterface.hitClip(this.xmin, this.ymin, this.width, this.height)) {
            return;
        }
        graphicsInterface.applyStroke(this.w, this.dashStyle);
        if (this.isFilled && this.width >= 2 && this.height >= 2) {
            graphicsInterface.fillPolygon(this.p);
        }
        graphicsInterface.drawPolygon(this.p);
    }

    @Override
    public void parseTokens(String[] stringArray, int n) throws IOException {
        this.changed = true;
        if (stringArray[0].equals("PP") || stringArray[0].equals("PV")) {
            if (n < 6) {
                IOException iOException = new IOException("bad arguments on PP/PV");
                throw iOException;
            }
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (!(n2 >= n - 1 || n2 + 1 < n - 1 && stringArray[n2 + 1].equals("FCJ"))) {
                n4 = Integer.parseInt(stringArray[n2++]);
                n5 = Integer.parseInt(stringArray[n2++]);
                ++n3;
                this.addPoint(n4, n5);
            }
            this.nPoints = n3;
            this.virtualPoint[this.getNameVirtualPointNumber()].x = n4 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = n5 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = n4 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = n5 + 10;
            if (n > n2) {
                this.parseLayer(stringArray[n2++]);
                if (n2 < n - 1 && stringArray[n2++].equals("FCJ")) {
                    this.dashStyle = this.checkDashStyle(Integer.parseInt(stringArray[n2++]));
                }
            }
            this.isFilled = stringArray[0].equals("PP");
        } else {
            IOException iOException = new IOException("PP/PV: Invalid primitive:" + stringArray[0] + " programming error?");
            throw iOException;
        }
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> vector = super.getControls();
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.isFilled;
        parameterDescription.description = Globals.messages.getString("ctrl_filled");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = new DashInfo(this.dashStyle);
        parameterDescription.description = Globals.messages.getString("ctrl_dash_style");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        return vector;
    }

    @Override
    public int setControls(Vector<ParameterDescription> vector) {
        int n = super.setControls(vector);
        ParameterDescription parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof Boolean) {
            this.isFilled = (Boolean)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n++);
        if (parameterDescription.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)parameterDescription.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return n;
    }

    @Override
    public int getDistanceToPoint(int n, int n2) {
        if (this.checkText(n, n2)) {
            return 0;
        }
        int[] nArray = new int[this.storageSize];
        int[] nArray2 = new int[this.storageSize];
        for (int i = 0; i < this.nPoints; ++i) {
            nArray[i] = this.virtualPoint[i].x;
            nArray2[i] = this.virtualPoint[i].y;
        }
        if (this.isFilled && GeometricDistances.pointInPolygon(nArray, nArray2, this.nPoints, n, n2)) {
            return 1;
        }
        int n3 = (int)Math.sqrt((n - nArray[0]) * (n - nArray[0]) + (n2 - nArray2[0]) * (n2 - nArray2[0]));
        for (int i = 0; i < this.nPoints; ++i) {
            int n4;
            int n5 = i;
            if (n5 == this.nPoints - 1) {
                n5 = -1;
            }
            if ((n4 = GeometricDistances.pointToSegment(nArray[i], nArray2[i], nArray[n5 + 1], nArray2[n5 + 1], n, n2)) >= n3) continue;
            n3 = n4;
        }
        return n3;
    }

    @Override
    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(25);
        if (this.isFilled) {
            stringBuffer.append("PP ");
        } else {
            stringBuffer.append("PV ");
        }
        for (int i = 0; i < this.nPoints; ++i) {
            stringBuffer.append(this.virtualPoint[i].x);
            stringBuffer.append(" ");
            stringBuffer.append(this.virtualPoint[i].y);
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.getLayer());
        stringBuffer.append("\n");
        Object object = stringBuffer.toString();
        if (bl && (this.dashStyle > 0 || this.hasName() || this.hasValue())) {
            String string = "0";
            if (this.name.length() != 0 || this.value.length() != 0) {
                string = "1";
            }
            object = (String)object + "FCJ " + this.dashStyle + " " + string + "\n";
        }
        object = (String)object + this.saveText(false);
        return object;
    }

    @Override
    public void export(ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        this.exportText(exportInterface, mapCoordinates, -1);
        PointDouble[] pointDoubleArray = new PointDouble[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            pointDoubleArray[i] = new PointDouble();
            pointDoubleArray[i].x = mapCoordinates.mapX(this.virtualPoint[i].x, this.virtualPoint[i].y);
            pointDoubleArray[i].y = mapCoordinates.mapY(this.virtualPoint[i].x, this.virtualPoint[i].y);
        }
        exportInterface.exportPolygon(pointDoubleArray, this.nPoints, this.isFilled, this.getLayer(), this.dashStyle, Globals.lineWidth * mapCoordinates.getXMagnitude());
    }

    @Override
    public int getNameVirtualPointNumber() {
        return this.nPoints;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return this.nPoints + 1;
    }
}

