/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.GeometricDistances;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;

public final class PrimitivePCBPad
extends GraphicPrimitive {
    private int rx;
    private int ry;
    private int sty;
    private int ri;
    private static final int CORNER_DIAMETER = 5;
    private boolean drawOnlyPads;
    static final int N_POINTS = 3;
    private int x1;
    private int y1;
    private int rrx;
    private int rry;
    private int xa;
    private int ya;
    private int rox;
    private int roy;
    private int rix;
    private int riy;
    private int rrx2;
    private int rry2;
    private int rix2;
    private int riy2;

    @Override
    public int getControlPointNumber() {
        return 3;
    }

    public PrimitivePCBPad(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string, int n8) {
        this.initPrimitive(-1, string, n8);
        this.virtualPoint[0].x = n;
        this.virtualPoint[0].y = n2;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = n2 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = n2 + 10;
        this.rx = n3;
        this.ry = n4;
        this.ri = n5;
        this.sty = n6;
        this.setLayer(n7);
    }

    public PrimitivePCBPad(String string, int n) {
        this.rx = 0;
        this.ry = 0;
        this.sty = 0;
        this.ri = 0;
        this.initPrimitive(-1, string, n);
    }

    @Override
    public boolean needsHoles() {
        return true;
    }

    @Override
    public void draw(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector) {
        if (!this.selectLayer(graphicsInterface, vector)) {
            return;
        }
        this.drawText(graphicsInterface, mapCoordinates, vector, -1);
        if (this.changed) {
            this.changed = false;
            this.x1 = this.virtualPoint[0].x;
            this.y1 = this.virtualPoint[0].y;
            this.xa = mapCoordinates.mapXi(this.x1, this.y1, false);
            this.ya = mapCoordinates.mapYi(this.x1, this.y1, false);
            this.rrx = Math.abs(this.xa - mapCoordinates.mapXi(this.x1 + this.rx, this.y1 + this.ry, false));
            this.rry = Math.abs(this.ya - mapCoordinates.mapYi(this.x1 + this.rx, this.y1 + this.ry, false));
            this.rrx2 = this.rrx / 2;
            this.rry2 = this.rry / 2;
            mapCoordinates.trackPoint(this.xa - this.rrx2, this.ya - this.rry2);
            mapCoordinates.trackPoint(this.xa + this.rrx2, this.ya + this.rry2);
            this.rox = Math.abs(this.xa - mapCoordinates.mapXi(this.x1 + 5, this.y1 + 5, false));
            this.roy = Math.abs(this.ya - mapCoordinates.mapYi(this.x1 + 5, this.y1 + 5, false));
            this.rix = Math.abs(this.xa - mapCoordinates.mapXi(this.x1 + this.ri, this.y1 + this.ri, false));
            this.riy = Math.abs(this.ya - mapCoordinates.mapYi(this.x1 + this.ri, this.y1 + this.ri, false));
            this.rix2 = this.rix / 2;
            this.riy2 = this.riy / 2;
        }
        if (!graphicsInterface.hitClip(this.xa - this.rrx2, this.ya - this.rry2, this.rrx, this.rry)) {
            return;
        }
        graphicsInterface.applyStroke(1.0f, 0);
        if (this.drawOnlyPads) {
            graphicsInterface.setColor(graphicsInterface.getColor().white());
            graphicsInterface.fillOval(this.xa - this.rix2, this.ya - this.riy2, this.rix, this.riy);
        } else {
            switch (this.sty) {
                case 1: {
                    graphicsInterface.fillRect(this.xa - this.rrx2, this.ya - this.rry2, this.rrx, this.rry);
                    break;
                }
                case 2: {
                    graphicsInterface.fillRoundRect(this.xa - this.rrx2, this.ya - this.rry2, this.rrx, this.rry, this.rox, this.roy);
                    break;
                }
                default: {
                    graphicsInterface.fillOval(this.xa - this.rrx2, this.ya - this.rry2, this.rrx, this.rry);
                }
            }
        }
    }

    @Override
    public void parseTokens(String[] stringArray, int n) throws IOException {
        this.changed = true;
        if (stringArray[0].equals("PA")) {
            if (n < 7) {
                IOException iOException = new IOException("bad arguments on PA");
                throw iOException;
            }
            int n2 = this.virtualPoint[0].x = Integer.parseInt(stringArray[1]);
            int n3 = this.virtualPoint[0].y = Integer.parseInt(stringArray[2]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = n3 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = n3 + 10;
            this.rx = Integer.parseInt(stringArray[3]);
            this.ry = Integer.parseInt(stringArray[4]);
            this.ri = Integer.parseInt(stringArray[5]);
            this.sty = Integer.parseInt(stringArray[6]);
            if (n > 7) {
                this.parseLayer(stringArray[7]);
            }
        } else {
            IOException iOException = new IOException("PA: Invalid primitive:" + stringArray[0] + " programming error?");
            throw iOException;
        }
    }

    @Override
    public void setDrawOnlyPads(boolean bl) {
        this.drawOnlyPads = bl;
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> vector = super.getControls();
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.rx;
        parameterDescription.description = Globals.messages.getString("ctrl_x_radius");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.ry;
        parameterDescription.description = Globals.messages.getString("ctrl_y_radius");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.ri;
        parameterDescription.description = Globals.messages.getString("ctrl_internal_radius");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.sty;
        parameterDescription.description = Globals.messages.getString("ctrl_pad_style");
        vector.add(parameterDescription);
        return vector;
    }

    @Override
    public int setControls(Vector<ParameterDescription> vector) {
        int n = super.setControls(vector);
        ParameterDescription parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof Integer) {
            this.rx = (Integer)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof Integer) {
            this.ry = (Integer)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof Integer) {
            this.ri = (Integer)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof Integer) {
            this.sty = (Integer)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        return n;
    }

    @Override
    public void rotatePrimitive(boolean bl, int n, int n2) {
        super.rotatePrimitive(bl, n, n2);
        int n3 = this.rx;
        this.rx = this.ry;
        this.ry = n3;
    }

    @Override
    public int getDistanceToPoint(int n, int n2) {
        if (this.checkText(n, n2)) {
            return 0;
        }
        int n3 = GeometricDistances.pointToPoint(this.virtualPoint[0].x, this.virtualPoint[0].y, n, n2) - Math.min(this.rx, this.ry) / 2;
        return n3 > 0 ? n3 : 0;
    }

    @Override
    public String toString(boolean bl) {
        String string = "PA " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.rx + " " + this.ry + " " + this.ri + " " + this.sty + " " + this.getLayer() + "\n";
        string = string + this.saveText(bl);
        return string;
    }

    @Override
    public void export(ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        this.exportText(exportInterface, mapCoordinates, -1);
        exportInterface.exportPCBPad(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), this.sty, Math.abs(mapCoordinates.mapX(this.virtualPoint[0].x + this.rx, this.virtualPoint[0].y + this.ry) - mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y)), Math.abs(mapCoordinates.mapY(this.virtualPoint[0].x + this.rx, this.virtualPoint[0].y + this.ry) - mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y)), (int)((double)this.ri * mapCoordinates.getXMagnitude()), this.getLayer(), this.drawOnlyPads);
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 1;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 2;
    }
}

