/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.GeometricDistances;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;

public final class PrimitivePCBLine
extends GraphicPrimitive {
    private float width;
    static final int N_POINTS = 4;
    private int xa;
    private int ya;
    private int xb;
    private int yb;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private float wi_pix;
    private int xbpap1;
    private int ybpap1;

    @Override
    public int getControlPointNumber() {
        return 4;
    }

    public PrimitivePCBLine(String string, int n) {
        this.width = 0.0f;
        this.initPrimitive(-1, string, n);
    }

    public PrimitivePCBLine(int n, int n2, int n3, int n4, float f, int n5, String string, int n6) {
        this.initPrimitive(-1, string, n6);
        this.virtualPoint[0].x = n;
        this.virtualPoint[0].y = n2;
        this.virtualPoint[1].x = n3;
        this.virtualPoint[1].y = n4;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = n2 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = n2 + 10;
        this.width = f;
        this.setLayer(n5);
    }

    @Override
    public void draw(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector) {
        if (!this.selectLayer(graphicsInterface, vector)) {
            return;
        }
        this.drawText(graphicsInterface, mapCoordinates, vector, -1);
        if (this.changed) {
            this.changed = false;
            this.x1 = mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.y1 = mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.x2 = mapCoordinates.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y);
            this.y2 = mapCoordinates.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y);
            this.wi_pix = (float)Math.abs(mapCoordinates.mapXr(this.virtualPoint[0].x, this.virtualPoint[0].y) - mapCoordinates.mapXr((float)this.virtualPoint[0].x + this.width, (float)this.virtualPoint[0].y + this.width));
            this.xa = (int)((float)Math.min(this.x1, this.x2) - this.wi_pix / 2.0f);
            this.ya = (int)((float)Math.min(this.y1, this.y2) - this.wi_pix / 2.0f);
            this.xb = (int)((float)Math.max(this.x1, this.x2) + this.wi_pix / 2.0f);
            this.yb = (int)((float)Math.max(this.y1, this.y2) + this.wi_pix / 2.0f);
            mapCoordinates.trackPoint(this.xa, this.ya);
            mapCoordinates.trackPoint(this.xb, this.yb);
            this.xbpap1 = this.xb - this.xa + 1;
            this.ybpap1 = this.yb - this.ya + 1;
        }
        if (!graphicsInterface.hitClip(this.xa, this.ya, this.xbpap1, this.ybpap1)) {
            return;
        }
        graphicsInterface.applyStroke(this.wi_pix, 0);
        graphicsInterface.drawLine(this.x1, this.y1, this.x2, this.y2);
    }

    @Override
    public void parseTokens(String[] stringArray, int n) throws IOException {
        this.changed = true;
        if (stringArray[0].equals("PL")) {
            if (n < 6) {
                IOException iOException = new IOException("bad arguments on PL");
                throw iOException;
            }
            int n2 = this.virtualPoint[0].x = Integer.parseInt(stringArray[1]);
            int n3 = this.virtualPoint[0].y = Integer.parseInt(stringArray[2]);
            this.virtualPoint[1].x = Integer.parseInt(stringArray[3]);
            this.virtualPoint[1].y = Integer.parseInt(stringArray[4]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = n3 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = n3 + 10;
            this.width = Float.parseFloat(stringArray[5]);
            if (n > 6) {
                this.parseLayer(stringArray[6]);
            }
        } else {
            IOException iOException = new IOException("PL: Invalid primitive:" + stringArray[0] + " programming error?");
            throw iOException;
        }
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> vector = super.getControls();
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.parameter = Float.valueOf(this.width);
        parameterDescription.description = Globals.messages.getString("ctrl_width");
        vector.add(parameterDescription);
        return vector;
    }

    @Override
    public int setControls(Vector<ParameterDescription> vector) {
        int n = super.setControls(vector);
        ParameterDescription parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof Float) {
            this.width = ((Float)parameterDescription.parameter).floatValue();
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        return n;
    }

    @Override
    public int getDistanceToPoint(int n, int n2) {
        if (this.checkText(n, n2)) {
            return 0;
        }
        int n3 = (int)((float)GeometricDistances.pointToSegment(this.virtualPoint[0].x, this.virtualPoint[0].y, this.virtualPoint[1].x, this.virtualPoint[1].y, n, n2) - this.width / 2.0f);
        return n3 < 0 ? 0 : n3;
    }

    @Override
    public String toString(boolean bl) {
        String string = "PL " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.virtualPoint[1].x + " " + this.virtualPoint[1].y + " " + this.roundIntelligently(this.width) + " " + this.getLayer() + "\n";
        string = string + this.saveText(bl);
        return string;
    }

    @Override
    public void export(ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        this.exportText(exportInterface, mapCoordinates, -1);
        exportInterface.exportPCBLine(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), mapCoordinates.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), (int)((double)this.width * mapCoordinates.getXMagnitude()), this.getLayer());
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 2;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 3;
    }
}

