/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fidocadj.dialogs.DashInfo;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.GeometricDistances;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;

public final class PrimitiveOval
extends GraphicPrimitive {
    static final int N_POINTS = 4;
    private boolean isFilled;
    private int dashStyle;
    private int xa;
    private int ya;
    private int xb;
    private int yb;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private float w;

    @Override
    public int getControlPointNumber() {
        return 4;
    }

    public PrimitiveOval(String string, int n) {
        this.isFilled = false;
        this.initPrimitive(-1, string, n);
    }

    public PrimitiveOval(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, String string, int n7) {
        this.initPrimitive(-1, string, n7);
        this.virtualPoint[0].x = n;
        this.virtualPoint[0].y = n2;
        this.virtualPoint[1].x = n3;
        this.virtualPoint[1].y = n4;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = n2 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = n2 + 10;
        this.isFilled = bl;
        this.dashStyle = n6;
        this.setLayer(n5);
    }

    @Override
    public void draw(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector) {
        if (!this.selectLayer(graphicsInterface, vector)) {
            return;
        }
        this.drawText(graphicsInterface, mapCoordinates, vector, -1);
        if (this.changed) {
            this.changed = false;
            this.x1 = mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.y1 = mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.x2 = mapCoordinates.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y);
            this.y2 = mapCoordinates.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y);
            if (this.x1 > this.x2) {
                this.xa = this.x2;
                this.xb = this.x1;
            } else {
                this.xa = this.x1;
                this.xb = this.x2;
            }
            if (this.y1 > this.y2) {
                this.ya = this.y2;
                this.yb = this.y1;
            } else {
                this.ya = this.y1;
                this.yb = this.y2;
            }
            mapCoordinates.trackPoint(this.xa, this.ya);
            mapCoordinates.trackPoint(this.xb, this.yb);
            this.w = (float)(Globals.lineWidth * mapCoordinates.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
        }
        if (!graphicsInterface.hitClip(this.xa, this.ya, this.xb - this.xa + 1, this.yb - this.ya + 1)) {
            return;
        }
        graphicsInterface.applyStroke(this.w, this.dashStyle);
        if (this.isFilled) {
            graphicsInterface.fillOval(this.xa, this.ya, this.xb - this.xa, this.yb - this.ya);
        } else if (this.xa != this.xb && this.ya != this.yb) {
            graphicsInterface.drawOval(this.xa, this.ya, this.xb - this.xa, this.yb - this.ya);
        } else {
            graphicsInterface.drawLine(this.xa, this.ya, this.xb, this.yb);
        }
    }

    @Override
    public void parseTokens(String[] stringArray, int n) throws IOException {
        this.changed = true;
        if (stringArray[0].equals("EV") || stringArray[0].equals("EP")) {
            if (n < 5) {
                IOException iOException = new IOException("bad arguments on EV/EP");
                throw iOException;
            }
            int n2 = this.virtualPoint[0].x = Integer.parseInt(stringArray[1]);
            int n3 = this.virtualPoint[0].y = Integer.parseInt(stringArray[2]);
            this.virtualPoint[1].x = Integer.parseInt(stringArray[3]);
            this.virtualPoint[1].y = Integer.parseInt(stringArray[4]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = n3 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = n3 + 10;
            if (n > 5) {
                this.parseLayer(stringArray[5]);
            }
            this.isFilled = stringArray[0].equals("EP");
            if (n > 6 && stringArray[6].equals("FCJ")) {
                this.dashStyle = this.checkDashStyle(Integer.parseInt(stringArray[7]));
            }
        } else {
            IOException iOException = new IOException("EV/EP: Invalid primitive:" + stringArray[0] + " programming error?");
            throw iOException;
        }
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> vector = super.getControls();
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.isFilled;
        parameterDescription.description = Globals.messages.getString("ctrl_filled");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = new DashInfo(this.dashStyle);
        parameterDescription.description = Globals.messages.getString("ctrl_dash_style");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        return vector;
    }

    @Override
    public int setControls(Vector<ParameterDescription> vector) {
        int n = super.setControls(vector);
        ParameterDescription parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof Boolean) {
            this.isFilled = (Boolean)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n++);
        if (parameterDescription.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)parameterDescription.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return n;
    }

    @Override
    public int getDistanceToPoint(int n, int n2) {
        if (this.checkText(n, n2)) {
            return 0;
        }
        int n3 = Math.min(this.virtualPoint[0].x, this.virtualPoint[1].x);
        int n4 = Math.min(this.virtualPoint[0].y, this.virtualPoint[1].y);
        int n5 = Math.max(this.virtualPoint[0].x, this.virtualPoint[1].x);
        int n6 = Math.max(this.virtualPoint[0].y, this.virtualPoint[1].y);
        if (this.isFilled) {
            if (GeometricDistances.pointInEllipse(n3, n4, n5 - n3, n6 - n4, n, n2)) {
                return 0;
            }
            return 1000;
        }
        return GeometricDistances.pointToEllipse(n3, n4, n5 - n3, n6 - n4, n, n2);
    }

    @Override
    public String toString(boolean bl) {
        Object object = this.isFilled ? "EP " : "EV ";
        object = (String)object + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.virtualPoint[1].x + " " + this.virtualPoint[1].y + " " + this.getLayer() + "\n";
        if (bl && (this.dashStyle > 0 || this.hasName() || this.hasValue())) {
            String string = "0";
            if (this.name.length() != 0 || this.value.length() != 0) {
                string = "1";
            }
            object = (String)object + "FCJ " + this.dashStyle + " " + string + "\n";
        }
        object = (String)object + this.saveText(false);
        return object;
    }

    @Override
    public void export(ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        this.exportText(exportInterface, mapCoordinates, -1);
        exportInterface.exportOval(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), mapCoordinates.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), this.isFilled, this.getLayer(), this.dashStyle, Globals.lineWidth * mapCoordinates.getXMagnitude());
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 2;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 3;
    }
}

