/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.fidocadj.circuit.controllers.EditorActions;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.circuit.views.Drawing;
import net.sourceforge.fidocadj.circuit.views.Export;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.layers.LayerDesc;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.primitives.MacroDesc;

public final class PrimitiveMacro
extends GraphicPrimitive {
    static final int N_POINTS = 3;
    private final Map<String, MacroDesc> library;
    private final Vector<LayerDesc> layers;
    private int o;
    private boolean m;
    private boolean drawOnlyPads;
    private int drawOnlyLayer;
    private boolean alreadyExported;
    private DrawingModel macro;
    private final MapCoordinates macroCoord;
    private boolean selected;
    private String macroName;
    private String macroDesc;
    private boolean exportInvisible;
    private Drawing drawingAgent;
    private int x1;
    private int y1;

    public void setExportInvisible(boolean bl) {
        this.exportInvisible = bl;
    }

    @Override
    public int getControlPointNumber() {
        return 3;
    }

    public PrimitiveMacro(Map<String, MacroDesc> map, Vector<LayerDesc> vector, String string, int n) {
        this.library = map;
        this.layers = vector;
        this.drawOnlyPads = false;
        this.drawOnlyLayer = -1;
        this.macro = new DrawingModel();
        this.macroCoord = new MapCoordinates();
        this.changed = true;
        this.initPrimitive(-1, string, n);
        this.macroStore(this.layers);
    }

    public PrimitiveMacro(Map<String, MacroDesc> map, Vector<LayerDesc> vector, int n, int n2, String string, String string2, int n3, int n4, String string3, int n5, int n6, String string4, int n7, int n8, boolean bl) throws IOException {
        this.initPrimitive(-1, string4, n7);
        this.library = map;
        this.layers = vector;
        String string5 = string.toLowerCase(new Locale("en"));
        this.macro = new DrawingModel();
        this.macroCoord = new MapCoordinates();
        this.changed = true;
        this.setMacroFontSize(n7);
        this.o = n8;
        this.m = bl;
        this.virtualPoint[0].x = n;
        this.virtualPoint[0].y = n2;
        this.virtualPoint[1].x = n3;
        this.virtualPoint[1].y = n4;
        this.virtualPoint[2].x = n5;
        this.virtualPoint[2].y = n6;
        this.name = string2;
        this.value = string3;
        MacroDesc macroDesc = this.library.get(string5);
        if (macroDesc == null) {
            IOException iOException = new IOException("Unrecognized macro " + string5);
            throw iOException;
        }
        this.macroDesc = macroDesc.description;
        this.macroName = string5;
        this.macroFont = string4;
        this.macroStore(this.layers);
    }

    @Override
    public boolean containsLayer(int n) {
        return this.macro.containsLayer(n);
    }

    private void drawMacroContents(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector) {
        if (this.changed) {
            this.changed = false;
            this.x1 = this.virtualPoint[0].x;
            this.y1 = this.virtualPoint[0].y;
            this.macroCoord.setXMagnitude(mapCoordinates.getXMagnitude());
            this.macroCoord.setYMagnitude(mapCoordinates.getYMagnitude());
            this.macroCoord.setXCenter(mapCoordinates.mapXr(this.x1, this.y1));
            this.macroCoord.setYCenter(mapCoordinates.mapYr(this.x1, this.y1));
            this.macroCoord.setOrientation((this.o + mapCoordinates.getOrientation()) % 4);
            this.macroCoord.mirror = this.m ^ mapCoordinates.mirror;
            this.macroCoord.isMacro = true;
            this.macroCoord.resetMinMax();
            this.macro.setChanged(true);
        }
        if (this.getSelected()) {
            new SelectionActions(this.macro).setSelectionAll(true);
            this.selected = true;
        } else if (this.selected) {
            new SelectionActions(this.macro).setSelectionAll(false);
            this.selected = false;
        }
        this.macro.setDrawOnlyLayer(this.drawOnlyLayer);
        this.macro.setDrawOnlyPads(this.drawOnlyPads);
        this.drawingAgent = new Drawing(this.macro);
        this.drawingAgent.draw(graphicsInterface, this.macroCoord);
        if (this.macroCoord.getXMax() > this.macroCoord.getXMin() && this.macroCoord.getYMax() > this.macroCoord.getYMin()) {
            mapCoordinates.trackPoint(this.macroCoord.getXMax(), this.macroCoord.getYMax());
            mapCoordinates.trackPoint(this.macroCoord.getXMin(), this.macroCoord.getYMin());
        }
    }

    @Override
    public void setChanged(boolean bl) {
        super.setChanged(bl);
        this.macro.setChanged(bl);
    }

    private void macroStore(Vector<LayerDesc> vector) {
        this.macro.setLibrary(this.library);
        this.macro.setLayers(vector);
        this.changed = true;
        if (this.macroDesc != null) {
            ParserActions parserActions = new ParserActions(this.macro);
            parserActions.parseString(new StringBuffer(this.macroDesc));
        }
    }

    public void setLayers(Vector<LayerDesc> vector) {
        this.macro.setLayers(vector);
    }

    @Override
    public void draw(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector) {
        this.setLayer(0);
        if (this.selectLayer(graphicsInterface, vector)) {
            this.drawText(graphicsInterface, mapCoordinates, vector, this.drawOnlyLayer);
        }
        this.drawMacroContents(graphicsInterface, mapCoordinates, vector);
    }

    @Override
    public void setDrawOnlyPads(boolean bl) {
        this.drawOnlyPads = bl;
    }

    @Override
    public void setDrawOnlyLayer(int n) {
        this.drawOnlyLayer = n;
    }

    @Override
    public int getMaxLayer() {
        return this.macro.getMaxLayer();
    }

    @Override
    public void parseTokens(String[] stringArray, int n) throws IOException {
        MacroDesc macroDesc;
        this.changed = true;
        if (stringArray[0].equals("MC")) {
            if (n < 6) {
                IOException iOException = new IOException("bad arguments on MC");
                throw iOException;
            }
            this.virtualPoint[0].x = Integer.parseInt(stringArray[1]);
            this.virtualPoint[0].y = Integer.parseInt(stringArray[2]);
            this.virtualPoint[1].x = this.virtualPoint[0].x + 10;
            this.virtualPoint[1].y = this.virtualPoint[0].y + 10;
            this.virtualPoint[2].x = this.virtualPoint[0].x + 10;
            this.virtualPoint[2].y = this.virtualPoint[0].y + 5;
            this.o = Integer.parseInt(stringArray[3]);
            this.m = Integer.parseInt(stringArray[4]) == 1;
            this.macroName = stringArray[5];
            for (int i = 6; i < n; ++i) {
                this.macroName = this.macroName + " " + stringArray[i];
            }
            this.macroName = this.macroName.toLowerCase(new Locale("en"));
            macroDesc = this.library.get(this.macroName);
            if (macroDesc == null) {
                IOException iOException = new IOException("Unrecognized macro '" + this.macroName + "'");
                throw iOException;
            }
        } else {
            IOException iOException = new IOException("MC: Invalid primitive:" + stringArray[0] + " programming error?");
            throw iOException;
        }
        this.macroDesc = macroDesc.description;
        this.macroStore(this.layers);
    }

    @Override
    public boolean needsHoles() {
        return this.drawingAgent.getNeedHoles();
    }

    @Override
    public int getDistanceToPoint(int n, int n2) {
        int n3 = this.virtualPoint[0].x;
        int n4 = this.virtualPoint[0].y;
        int n5 = Integer.MAX_VALUE;
        if (this.checkText(n, n2)) {
            return 0;
        }
        int n6 = n - n3 + 100;
        int n7 = n2 - n4 + 100;
        if (this.m) {
            switch (this.o) {
                case 1: {
                    n6 = n2 - n4 + 100;
                    n7 = n - n3 + 100;
                    break;
                }
                case 2: {
                    n6 = n - n3 + 100;
                    n7 = -(n2 - n4) + 100;
                    break;
                }
                case 3: {
                    n6 = -(n2 - n4) + 100;
                    n7 = -(n - n3) + 100;
                    break;
                }
                case 0: {
                    n6 = -(n - n3) + 100;
                    n7 = n2 - n4 + 100;
                    break;
                }
                default: {
                    n6 = 0;
                    n7 = 0;
                    break;
                }
            }
        } else {
            switch (this.o) {
                case 1: {
                    n6 = n2 - n4 + 100;
                    n7 = -(n - n3) + 100;
                    break;
                }
                case 2: {
                    n6 = -(n - n3) + 100;
                    n7 = -(n2 - n4) + 100;
                    break;
                }
                case 3: {
                    n6 = -(n2 - n4) + 100;
                    n7 = n - n3 + 100;
                    break;
                }
                case 0: {
                    n6 = n - n3 + 100;
                    n7 = n2 - n4 + 100;
                    break;
                }
                default: {
                    n6 = 0;
                    n7 = 0;
                }
            }
        }
        if (this.macroDesc != null) {
            SelectionActions selectionActions = new SelectionActions(this.macro);
            EditorActions editorActions = new EditorActions(this.macro, selectionActions, null);
            return Math.min(editorActions.distancePrimitive(n6, n7), n5);
        }
        System.out.println("1-Unrecognized macro WARNING this can be a programming problem...");
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean selectRect(int n, int n2, int n3, int n4) {
        SelectionActions selectionActions = new SelectionActions(this.macro);
        EditorActions editorActions = new EditorActions(this.macro, selectionActions, null);
        if (editorActions.distancePrimitive(0, 0) < Integer.MAX_VALUE) {
            return super.selectRect(n, n2, n3, n4);
        }
        return false;
    }

    public int getOrientation() {
        return this.o;
    }

    public boolean isMirrored() {
        return this.m;
    }

    @Override
    public void rotatePrimitive(boolean bl, int n, int n2) {
        super.rotatePrimitive(bl, n, n2);
        if (bl) {
            this.o = (this.o + 3) % 4;
        } else {
            ++this.o;
            this.o %= 4;
        }
        this.changed = true;
    }

    @Override
    public void mirrorPrimitive(int n) {
        super.mirrorPrimitive(n);
        this.m ^= true;
        this.changed = true;
    }

    @Override
    public String toString(boolean bl) {
        String string = "0";
        if (this.m) {
            string = "1";
        }
        String string2 = "MC " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.o + " " + string + " " + this.macroName + "\n";
        string2 = string2 + this.saveText(bl);
        return string2;
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> vector = new Vector<ParameterDescription>(10);
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.name;
        parameterDescription.description = Globals.messages.getString("ctrl_name");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.value;
        parameterDescription.description = Globals.messages.getString("ctrl_value");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        return vector;
    }

    @Override
    public int setControls(Vector<ParameterDescription> vector) {
        int n = 0;
        this.changed = true;
        ParameterDescription parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof String) {
            this.name = (String)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof String) {
            this.value = (String)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        return n;
    }

    public void resetExport() {
        this.alreadyExported = false;
    }

    @Override
    public void export(ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        if (this.alreadyExported) {
            return;
        }
        if (exportInterface.exportMacro(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), this.m, this.o * 90, this.macroName, this.macroDesc, this.name, mapCoordinates.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), mapCoordinates.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), this.value, mapCoordinates.mapX(this.virtualPoint[2].x, this.virtualPoint[2].y), mapCoordinates.mapY(this.virtualPoint[2].x, this.virtualPoint[2].y), this.macroFont, (int)(mapCoordinates.mapYr(this.getMacroFontSize(), this.getMacroFontSize()) - mapCoordinates.mapYr(0.0, 0.0)), this.library)) {
            this.alreadyExported = true;
            return;
        }
        int n = this.virtualPoint[0].x;
        int n2 = this.virtualPoint[0].y;
        MapCoordinates mapCoordinates2 = new MapCoordinates();
        mapCoordinates2.setXMagnitude(mapCoordinates.getXMagnitude());
        mapCoordinates2.setYMagnitude(mapCoordinates.getYMagnitude());
        mapCoordinates2.setXCenter(mapCoordinates.mapXr(n, n2));
        mapCoordinates2.setYCenter(mapCoordinates.mapYr(n, n2));
        mapCoordinates2.setOrientation((this.o + mapCoordinates.getOrientation()) % 4);
        mapCoordinates2.mirror = this.m ^ mapCoordinates.mirror;
        mapCoordinates2.isMacro = true;
        this.macro.setDrawOnlyLayer(this.drawOnlyLayer);
        if (this.getSelected()) {
            new SelectionActions(this.macro).setSelectionAll(true);
        }
        this.macro.setDrawOnlyPads(this.drawOnlyPads);
        new Export(this.macro).exportDrawing(exportInterface, this.exportInvisible, mapCoordinates2);
        this.exportText(exportInterface, mapCoordinates, this.drawOnlyLayer);
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 1;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 2;
    }

    public String getMacroDesc() {
        return this.macroDesc;
    }

    public void setMacroDesc(String string) {
        this.macroDesc = string;
    }
}

