/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fidocadj.dialogs.DashInfo;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.GeometricDistances;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.primitives.Arrow;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;

public final class PrimitiveLine
extends GraphicPrimitive {
    static final int N_POINTS = 4;
    private final Arrow arrowData = new Arrow();
    private int dashStyle;
    private int xa;
    private int ya;
    private int xb;
    private int yb;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private float w;
    private int length2;
    private int xbpap1;
    private int ybpap1;
    private boolean arrows;

    public PrimitiveLine(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int n6, int n7, int n8, int n9, String string, int n10) {
        this.arrowData.setArrowStart(bl);
        this.arrowData.setArrowEnd(bl2);
        this.arrowData.setArrowHalfWidth(n8);
        this.arrowData.setArrowLength(n7);
        this.arrowData.setArrowStyle(n6);
        this.dashStyle = n9;
        this.initPrimitive(-1, string, n10);
        this.virtualPoint[0].x = n;
        this.virtualPoint[0].y = n2;
        this.virtualPoint[1].x = n3;
        this.virtualPoint[1].y = n4;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = n2 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = n2 + 10;
        this.setLayer(n5);
    }

    public PrimitiveLine(String string, int n) {
        this.initPrimitive(-1, string, n);
    }

    @Override
    public int getControlPointNumber() {
        return 4;
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> vector = super.getControls();
        this.arrowData.getControlsForArrow(vector);
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.parameter = new DashInfo(this.dashStyle);
        parameterDescription.description = Globals.messages.getString("ctrl_dash_style");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        return vector;
    }

    @Override
    public int setControls(Vector<ParameterDescription> vector) {
        int n = super.setControls(vector);
        n = this.arrowData.setParametersForArrow(vector, n);
        ParameterDescription parameterDescription = vector.get(n++);
        if (parameterDescription.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)parameterDescription.parameter).style;
        } else {
            System.out.println("Warning: 6-unexpected parameter!" + parameterDescription);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return n;
    }

    @Override
    public void draw(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector) {
        int n;
        if (!this.selectLayer(graphicsInterface, vector)) {
            return;
        }
        this.drawText(graphicsInterface, mapCoordinates, vector, -1);
        if (this.changed) {
            this.changed = false;
            this.x1 = mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.y1 = mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.x2 = mapCoordinates.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y);
            this.y2 = mapCoordinates.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y);
            if (this.x1 > this.x2) {
                this.xa = this.x2;
                this.xb = this.x1;
            } else {
                this.xa = this.x1;
                this.xb = this.x2;
            }
            if (this.y1 > this.y2) {
                this.ya = this.y2;
                this.yb = this.y1;
            } else {
                this.ya = this.y1;
                this.yb = this.y2;
            }
            this.w = (float)(Globals.lineWidth * mapCoordinates.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
            this.length2 = (this.xa - this.xb) * (this.xa - this.xb) + (this.ya - this.yb) * (this.ya - this.yb);
            this.arrows = this.arrowData.atLeastOneArrow();
            if (this.arrows) {
                n = this.arrowData.prepareCoordinateMapping(mapCoordinates);
                this.xa -= Math.abs(n);
                this.ya -= Math.abs(n);
                this.xb += Math.abs(n);
                this.yb += Math.abs(n);
            }
            this.xbpap1 = this.xb - this.xa + 1;
            this.ybpap1 = this.yb - this.ya + 1;
        }
        if (this.length2 > 2) {
            if (!graphicsInterface.hitClip(this.xa, this.ya, this.xbpap1, this.ybpap1)) {
                return;
            }
            graphicsInterface.applyStroke(this.w, this.dashStyle);
            n = this.x1;
            int n2 = this.y1;
            int n3 = this.x2;
            int n4 = this.y2;
            if (this.arrows) {
                PointG pointG;
                this.arrowData.prepareCoordinateMapping(mapCoordinates);
                if (this.arrowData.isArrowStart()) {
                    pointG = this.arrowData.drawArrow(graphicsInterface, this.x1, this.y1, this.x2, this.y2);
                    if (this.arrowData.getArrowLength() > 0.0f) {
                        n = pointG.x;
                        n2 = pointG.y;
                    }
                }
                if (this.arrowData.isArrowEnd()) {
                    pointG = this.arrowData.drawArrow(graphicsInterface, this.x2, this.y2, this.x1, this.y1);
                    if (this.arrowData.getArrowLength() > 0.0f) {
                        n3 = pointG.x;
                        n4 = pointG.y;
                    }
                }
            }
            graphicsInterface.drawLine(n, n2, n3, n4);
        }
    }

    @Override
    public void parseTokens(String[] stringArray, int n) throws IOException {
        this.changed = true;
        if (stringArray[0].equals("LI")) {
            if (n < 5) {
                IOException iOException = new IOException("bad arguments on LI");
                throw iOException;
            }
            int n2 = this.virtualPoint[0].x = Integer.parseInt(stringArray[1]);
            int n3 = this.virtualPoint[0].y = Integer.parseInt(stringArray[2]);
            this.virtualPoint[1].x = Integer.parseInt(stringArray[3]);
            this.virtualPoint[1].y = Integer.parseInt(stringArray[4]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = n3 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = n3 + 10;
            if (n > 5) {
                this.parseLayer(stringArray[5]);
            }
            if (n > 6 && stringArray[6].equals("FCJ")) {
                int n4 = this.arrowData.parseTokens(stringArray, 7);
                this.dashStyle = this.checkDashStyle(Integer.parseInt(stringArray[n4]));
            }
        } else {
            IOException iOException = new IOException("LI: Invalid primitive:" + stringArray[0] + " programming error?");
            throw iOException;
        }
    }

    @Override
    public int getDistanceToPoint(int n, int n2) {
        if (this.checkText(n, n2)) {
            return 0;
        }
        if (this.arrowData.atLeastOneArrow()) {
            boolean bl = false;
            boolean bl2 = false;
            MapCoordinates mapCoordinates = new MapCoordinates();
            this.arrowData.prepareCoordinateMapping(mapCoordinates);
            PointG pointG = new PointG();
            if (this.arrowData.isArrowStart()) {
                bl2 = this.arrowData.isInArrow(n, n2, this.virtualPoint[0].x, this.virtualPoint[0].y, this.virtualPoint[1].x, this.virtualPoint[1].y, pointG);
            }
            if (this.arrowData.isArrowEnd()) {
                bl = this.arrowData.isInArrow(n, n2, this.virtualPoint[1].x, this.virtualPoint[1].y, this.virtualPoint[0].x, this.virtualPoint[0].y, pointG);
            }
            if (bl || bl2) {
                return 1;
            }
        }
        return GeometricDistances.pointToSegment(this.virtualPoint[0].x, this.virtualPoint[0].y, this.virtualPoint[1].x, this.virtualPoint[1].y, n, n2);
    }

    @Override
    public String toString(boolean bl) {
        if (this.name.length() == 0 && this.value.length() == 0 && this.virtualPoint[0].x == this.virtualPoint[1].x && this.virtualPoint[0].y == this.virtualPoint[1].y) {
            return "";
        }
        String string = "LI " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.virtualPoint[1].x + " " + this.virtualPoint[1].y + " " + this.getLayer() + "\n";
        if (bl && (this.arrowData.atLeastOneArrow() || this.dashStyle > 0 || this.name != null && this.name.length() != 0) || this.value != null && this.value.length() != 0) {
            String string2 = "0";
            if (this.hasName() || this.hasValue()) {
                string2 = "1";
            }
            string = string + "FCJ " + this.arrowData.createArrowTokens() + " " + this.dashStyle + " " + string2 + "\n";
        }
        string = string + this.saveText(false);
        return string;
    }

    @Override
    public void export(ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        this.exportText(exportInterface, mapCoordinates, -1);
        exportInterface.exportLine(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), mapCoordinates.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), this.getLayer(), this.arrowData.isArrowStart(), this.arrowData.isArrowEnd(), this.arrowData.getArrowStyle(), (int)((double)this.arrowData.getArrowLength() * mapCoordinates.getXMagnitude()), (int)((double)this.arrowData.getArrowHalfWidth() * mapCoordinates.getXMagnitude()), this.dashStyle, Globals.lineWidth * mapCoordinates.getXMagnitude());
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 2;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 3;
    }
}

