/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.GeometricDistances;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;

public final class PrimitiveConnection
extends GraphicPrimitive {
    static final int N_POINTS = 3;
    private int x1;
    private int y1;
    private int xa1;
    private int ya1;
    private int ni;
    private double nn;
    private float w;

    @Override
    public int getControlPointNumber() {
        return 3;
    }

    public PrimitiveConnection(String string, int n) {
        this.initPrimitive(-1, string, n);
    }

    public PrimitiveConnection(int n, int n2, int n3, String string, int n4) {
        this.initPrimitive(-1, string, n4);
        this.virtualPoint[0].x = n;
        this.virtualPoint[0].y = n2;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = n2 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = n2 + 10;
        this.setLayer(n3);
    }

    @Override
    public void draw(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector) {
        if (!this.selectLayer(graphicsInterface, vector)) {
            return;
        }
        this.drawText(graphicsInterface, mapCoordinates, vector, -1);
        if (this.changed) {
            this.changed = false;
            this.x1 = this.virtualPoint[0].x;
            this.y1 = this.virtualPoint[0].y;
            this.nn = Math.abs(mapCoordinates.mapXr(0.0, 0.0) - mapCoordinates.mapXr(10.0, 10.0)) * Globals.diameterConnection / 10.0;
            if (this.nn < 2.0) {
                this.nn = (int)(Math.abs(mapCoordinates.mapXr(0.0, 0.0) - mapCoordinates.mapXr(20.0, 20.0)) * Globals.diameterConnection / 12.0);
            }
            this.xa1 = (int)Math.round((double)mapCoordinates.mapX(this.x1, this.y1) - this.nn / 2.0);
            this.ya1 = (int)Math.round((double)mapCoordinates.mapY(this.x1, this.y1) - this.nn / 2.0);
            this.ni = (int)Math.round(this.nn);
            if (this.ni == 0) {
                this.ni = 1;
            }
            this.w = (float)(Globals.lineWidth * mapCoordinates.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
        }
        if (!graphicsInterface.hitClip(this.xa1, this.ya1, this.ni, this.ni)) {
            return;
        }
        graphicsInterface.applyStroke(this.w, 0);
        if (this.ni > 1) {
            graphicsInterface.fillOval(this.xa1, this.ya1, this.ni, this.ni);
        } else {
            graphicsInterface.fillRect(this.xa1, this.ya1, this.ni, this.ni);
        }
    }

    @Override
    public void parseTokens(String[] stringArray, int n) throws IOException {
        this.changed = true;
        if (stringArray[0].equals("SA")) {
            if (n < 3) {
                IOException iOException = new IOException("bad arguments on SA");
                throw iOException;
            }
            int n2 = this.virtualPoint[0].x = Integer.parseInt(stringArray[1]);
            int n3 = this.virtualPoint[0].y = Integer.parseInt(stringArray[2]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = n3 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = n3 + 10;
            if (n > 3) {
                this.parseLayer(stringArray[3]);
            }
        } else {
            IOException iOException = new IOException("Invalid primitive: programming error?");
            throw iOException;
        }
    }

    @Override
    public int getDistanceToPoint(int n, int n2) {
        if (this.checkText(n, n2)) {
            return 0;
        }
        return GeometricDistances.pointToPoint(this.virtualPoint[0].x, this.virtualPoint[0].y, n, n2) - 1;
    }

    @Override
    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("SA ");
        stringBuffer.append(this.virtualPoint[0].x);
        stringBuffer.append(" ");
        stringBuffer.append(this.virtualPoint[0].y);
        stringBuffer.append(" ");
        stringBuffer.append(this.getLayer());
        stringBuffer.append("\n");
        stringBuffer.append(this.saveText(bl));
        return stringBuffer.toString();
    }

    @Override
    public void export(ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        this.exportText(exportInterface, mapCoordinates, -1);
        exportInterface.exportConnection(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), this.getLayer(), Globals.diameterConnection * mapCoordinates.getXMagnitude());
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 1;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 2;
    }
}

