/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fidocadj.dialogs.DashInfo;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.GeometricDistances;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.graphic.PointDouble;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.graphic.PolygonInterface;
import net.sourceforge.fidocadj.graphic.ShapeInterface;
import net.sourceforge.fidocadj.primitives.Arrow;
import net.sourceforge.fidocadj.primitives.Cubic;
import net.sourceforge.fidocadj.primitives.CurveStorage;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;

public final class PrimitiveComplexCurve
extends GraphicPrimitive {
    private int nPoints;
    private boolean isFilled;
    private boolean isClosed;
    private final Arrow arrowData = new Arrow();
    private int dashStyle;
    private PolygonInterface p;
    private PolygonInterface q;
    int storageSize = 5;
    static final int STEPS = 24;
    private int xmin;
    private int ymin;
    private int width;
    private int height;
    private float w;
    private ShapeInterface gp;

    @Override
    public int getControlPointNumber() {
        return this.nPoints + 2;
    }

    public PrimitiveComplexCurve(String string, int n) {
        this.isFilled = false;
        this.nPoints = 0;
        this.p = null;
        this.initPrimitive(this.storageSize, string, n);
    }

    public PrimitiveComplexCurve(boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, int n2, int n3, int n4, int n5, String string, int n6) {
        this.arrowData.setArrowStart(bl3);
        this.arrowData.setArrowEnd(bl4);
        this.arrowData.setArrowHalfWidth(n4);
        this.arrowData.setArrowLength(n3);
        this.arrowData.setArrowStyle(n2);
        this.dashStyle = n5;
        this.p = null;
        this.initPrimitive(this.storageSize, string, n6);
        this.nPoints = 0;
        this.isFilled = bl;
        this.isClosed = bl2;
        this.dashStyle = n5;
        this.setLayer(n);
    }

    public void addPointClosest(int n, int n2) {
        int[] nArray = new int[this.storageSize];
        int[] nArray2 = new int[this.storageSize];
        for (int i = 0; i < this.nPoints; ++i) {
            nArray[i] = this.virtualPoint[i].x;
            nArray2[i] = this.virtualPoint[i].y;
        }
        int n3 = (int)Math.sqrt((n - nArray[0]) * (n - nArray[0]) + (n2 - nArray2[0]) * (n2 - nArray2[0]));
        int n4 = 0;
        for (int i = 0; i < this.q.getNpoints() - 1; ++i) {
            int n5 = GeometricDistances.pointToSegment(this.q.getXpoints()[i], this.q.getYpoints()[i], this.q.getXpoints()[i + 1], this.q.getYpoints()[i + 1], n, n2);
            if (n5 >= n3) continue;
            n3 = n5;
            n4 = i - 1;
        }
        n4 /= 24;
        if (++n4 < 0) {
            n4 = this.nPoints - 1;
        }
        this.addPoint(n, n2);
        for (int i = this.nPoints - 1; i > n4; --i) {
            this.virtualPoint[i].x = this.virtualPoint[i - 1].x;
            this.virtualPoint[i].y = this.virtualPoint[i - 1].y;
        }
        this.virtualPoint[n4].x = n;
        this.virtualPoint[n4].y = n2;
        this.changed = true;
    }

    public void addPoint(int n, int n2) {
        if (this.nPoints + 2 >= this.storageSize) {
            int n3;
            int n4 = this.storageSize;
            this.storageSize += 10;
            PointG[] pointGArray = new PointG[this.storageSize];
            for (n3 = 0; n3 < n4; ++n3) {
                pointGArray[n3] = this.virtualPoint[n3];
            }
            while (n3 < this.storageSize) {
                pointGArray[n3] = new PointG();
                ++n3;
            }
            this.virtualPoint = pointGArray;
        }
        this.virtualPoint[this.nPoints].x = n;
        ++this.nPoints;
        this.virtualPoint[this.nPoints].y = n2;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = n2 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = n2 + 10;
        this.changed = true;
    }

    public CurveStorage createComplexCurve(MapCoordinates mapCoordinates) {
        Object object;
        Cubic[] cubicArray;
        Cubic[] cubicArray2;
        double[] dArray = new double[this.nPoints];
        double[] dArray2 = new double[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            dArray[i] = mapCoordinates.mapXr(this.virtualPoint[i].x, this.virtualPoint[i].y);
            dArray2[i] = mapCoordinates.mapYr(this.virtualPoint[i].x, this.virtualPoint[i].y);
        }
        if (this.isClosed) {
            cubicArray2 = this.calcNaturalCubicClosed(this.nPoints - 1, dArray);
            cubicArray = this.calcNaturalCubicClosed(this.nPoints - 1, dArray2);
        } else {
            cubicArray2 = this.calcNaturalCubic(this.nPoints - 1, dArray);
            cubicArray = this.calcNaturalCubic(this.nPoints - 1, dArray2);
            if (this.arrowData.atLeastOneArrow()) {
                this.arrowData.prepareCoordinateMapping(mapCoordinates);
                if (this.arrowData.isArrowStart()) {
                    object = new PointG();
                    this.arrowData.isInArrow(0, 0, (int)Math.round(cubicArray2[0].eval(0.0)), (int)Math.round(cubicArray[0].eval(0.0)), (int)Math.round(cubicArray2[0].eval(0.05)), (int)Math.round(cubicArray[0].eval(0.05)), (PointG)object);
                    if (this.arrowData.getArrowLength() > 0.0f) {
                        dArray[0] = ((PointG)object).x;
                        dArray2[0] = ((PointG)object).y;
                    }
                }
                if (this.arrowData.isArrowEnd()) {
                    int n = cubicArray2.length - 1;
                    PointG pointG = new PointG();
                    this.arrowData.isInArrow(0, 0, (int)Math.round(cubicArray2[n].eval(1.0)), (int)Math.round(cubicArray[n].eval(1.0)), (int)Math.round(cubicArray2[n].eval(0.95)), (int)Math.round(cubicArray[n].eval(0.95)), pointG);
                    if (this.arrowData.getArrowLength() > 0.0f) {
                        dArray[this.nPoints - 1] = pointG.x;
                        dArray2[this.nPoints - 1] = pointG.y;
                    }
                }
                if (this.arrowData.getArrowLength() > 0.0f) {
                    cubicArray2 = this.calcNaturalCubic(this.nPoints - 1, dArray);
                    cubicArray = this.calcNaturalCubic(this.nPoints - 1, dArray2);
                }
            }
        }
        if (cubicArray2 == null || cubicArray == null) {
            return null;
        }
        object = new CurveStorage();
        ((CurveStorage)object).pp.add(new PointDouble(cubicArray2[0].eval(0.0), cubicArray[0].eval(0.0)));
        for (int i = 0; i < cubicArray2.length; ++i) {
            ((CurveStorage)object).dd.add(new PointDouble(cubicArray2[i].d1, cubicArray[i].d1));
            for (int j = 1; j <= 24; ++j) {
                double d = (double)j / 24.0;
                ((CurveStorage)object).pp.add(new PointDouble(cubicArray2[i].eval(d), cubicArray[i].eval(d)));
            }
        }
        ((CurveStorage)object).dd.add(new PointDouble(cubicArray2[cubicArray2.length - 1].d2, cubicArray[cubicArray2.length - 1].d2));
        return object;
    }

    public PolygonInterface createComplexCurvePoly(MapCoordinates mapCoordinates, PolygonInterface polygonInterface) {
        this.xmin = Integer.MAX_VALUE;
        this.ymin = Integer.MAX_VALUE;
        int n = -2147483647;
        int n2 = -2147483647;
        CurveStorage curveStorage = this.createComplexCurve(mapCoordinates);
        if (curveStorage == null) {
            return null;
        }
        Vector<PointDouble> vector = curveStorage.pp;
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n3 = (int)Math.round(vector.get((int)i).x);
            int n4 = (int)Math.round(vector.get((int)i).y);
            polygonInterface.addPoint(n3, n4);
            mapCoordinates.trackPoint(n3, n4);
            if (n3 < this.xmin) {
                this.xmin = n3;
            }
            if (n3 > n) {
                n = n3;
            }
            if (n4 < this.ymin) {
                this.ymin = n4;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        this.width = n - this.xmin;
        this.height = n2 - this.ymin;
        return polygonInterface;
    }

    Cubic[] calcNaturalCubic(int n, double ... dArray) {
        int n2;
        if (n < 1) {
            return null;
        }
        double[] dArray2 = new double[n + 1];
        double[] dArray3 = new double[n + 1];
        double[] dArray4 = new double[n + 1];
        dArray2[0] = 0.5;
        for (n2 = 1; n2 < n; ++n2) {
            dArray2[n2] = 1.0 / (4.0 - dArray2[n2 - 1]);
        }
        dArray2[n] = 1.0 / (2.0 - dArray2[n - 1]);
        dArray3[0] = 3.0 * (dArray[1] - dArray[0]) * dArray2[0];
        for (n2 = 1; n2 < n; ++n2) {
            dArray3[n2] = (3.0 * (dArray[n2 + 1] - dArray[n2 - 1]) - dArray3[n2 - 1]) * dArray2[n2];
        }
        dArray3[n] = (3.0 * (dArray[n] - dArray[n - 1]) - dArray3[n - 1]) * dArray2[n];
        dArray4[n] = dArray3[n];
        for (n2 = n - 1; n2 >= 0; --n2) {
            dArray4[n2] = dArray3[n2] - dArray2[n2] * dArray4[n2 + 1];
        }
        Cubic[] cubicArray = new Cubic[n];
        for (n2 = 0; n2 < n; ++n2) {
            cubicArray[n2] = new Cubic(dArray[n2], dArray4[n2], 3.0 * (dArray[n2 + 1] - dArray[n2]) - 2.0 * dArray4[n2] - dArray4[n2 + 1], 2.0 * (dArray[n2] - dArray[n2 + 1]) + dArray4[n2] + dArray4[n2 + 1]);
            cubicArray[n2].d1 = dArray4[n2];
            cubicArray[n2].d2 = dArray4[n2 + 1];
        }
        return cubicArray;
    }

    Cubic[] calcNaturalCubicClosed(int n, double ... dArray) {
        int n2;
        if (n < 1) {
            return null;
        }
        double[] dArray2 = new double[n + 1];
        double[] dArray3 = new double[n + 1];
        double[] dArray4 = new double[n + 1];
        double[] dArray5 = new double[n + 1];
        double d = 0.25;
        dArray3[1] = 0.25;
        dArray2[1] = 0.25;
        dArray4[0] = d * 3.0 * (dArray[1] - dArray[n]);
        double d2 = 4.0;
        double d3 = 3.0 * (dArray[0] - dArray[n - 1]);
        double d4 = 1.0;
        for (n2 = 1; n2 < n; ++n2) {
            dArray3[n2 + 1] = d = 1.0 / (4.0 - dArray3[n2]);
            dArray2[n2 + 1] = -d * dArray2[n2];
            dArray4[n2] = d * (3.0 * (dArray[n2 + 1] - dArray[n2 - 1]) - dArray4[n2 - 1]);
            d2 -= d4 * dArray2[n2];
            d3 -= d4 * dArray4[n2 - 1];
            d4 = -dArray3[n2] * d4;
        }
        dArray4[n] = d3 - (d4 + 1.0) * dArray4[n - 1];
        dArray5[n] = dArray4[n] / (d2 -= (d4 + 1.0) * (dArray3[n] + dArray2[n]));
        dArray5[n - 1] = dArray4[n - 1] - (dArray3[n] + dArray2[n]) * dArray5[n];
        for (n2 = n - 2; n2 >= 0; --n2) {
            dArray5[n2] = dArray4[n2] - dArray3[n2 + 1] * dArray5[n2 + 1] - dArray2[n2 + 1] * dArray5[n];
        }
        Cubic[] cubicArray = new Cubic[n + 1];
        for (n2 = 0; n2 < n; ++n2) {
            cubicArray[n2] = new Cubic((float)dArray[n2], dArray5[n2], 3.0 * (dArray[n2 + 1] - dArray[n2]) - 2.0 * dArray5[n2] - dArray5[n2 + 1], 2.0 * (dArray[n2] - dArray[n2 + 1]) + dArray5[n2] + dArray5[n2 + 1]);
            cubicArray[n2].d1 = dArray5[n2];
            cubicArray[n2].d2 = dArray5[n2 + 1];
        }
        cubicArray[n] = new Cubic((float)dArray[n], dArray5[n], 3.0 * (dArray[0] - dArray[n]) - 2.0 * dArray5[n] - dArray5[0], 2.0 * (dArray[n] - dArray[0]) + dArray5[n] + dArray5[0]);
        cubicArray[n].d1 = dArray5[n];
        cubicArray[n].d2 = dArray5[0];
        return cubicArray;
    }

    public void removePoint(int n, int n2, double d) {
        int n3;
        if (this.nPoints <= 3) {
            return;
        }
        double d2 = GeometricDistances.pointToPoint(this.virtualPoint[0].x, this.virtualPoint[0].y, n, n2);
        int n4 = -1;
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            double d3 = GeometricDistances.pointToPoint(this.virtualPoint[n3].x, this.virtualPoint[n3].y, n, n2);
            if (!(d3 < d2)) continue;
            d2 = d3;
            n4 = n3;
        }
        if (d2 <= d) {
            --this.nPoints;
            for (n3 = 0; n3 < this.nPoints; ++n3) {
                if (n3 >= n4) {
                    this.virtualPoint[n3].x = this.virtualPoint[n3 + 1].x;
                    this.virtualPoint[n3].y = this.virtualPoint[n3 + 1].y;
                }
                this.changed = true;
            }
        }
    }

    @Override
    public void draw(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector) {
        if (!this.selectLayer(graphicsInterface, vector)) {
            return;
        }
        this.drawText(graphicsInterface, mapCoordinates, vector, -1);
        if (this.changed) {
            this.changed = false;
            this.q = this.createComplexCurvePoly(new MapCoordinates(), graphicsInterface.createPolygon());
            this.p = this.createComplexCurvePoly(mapCoordinates, graphicsInterface.createPolygon());
            CurveStorage curveStorage = this.createComplexCurve(mapCoordinates);
            if (curveStorage == null) {
                return;
            }
            Vector<PointDouble> vector2 = curveStorage.dd;
            Vector<PointDouble> vector3 = curveStorage.pp;
            if (this.q == null) {
                return;
            }
            this.gp = graphicsInterface.createShape();
            this.gp.createGeneralPath(this.q.getNpoints());
            this.gp.moveTo((float)vector3.get((int)0).x, (float)vector3.get((int)0).y);
            int n = 24;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.666667;
            double d6 = 0.666667;
            int n2 = 0;
            for (int i = 0; i < vector3.size() - n; i += n) {
                d = vector2.get((int)n2).x / 2.0 * d5;
                d3 = vector2.get((int)n2).y / 2.0 * d5;
                d2 = vector2.get((int)(n2 + 1)).x / 2.0 * d6;
                d4 = vector2.get((int)(n2 + 1)).y / 2.0 * d6;
                ++n2;
                this.gp.curveTo((float)(vector3.get((int)i).x + d), (float)(vector3.get((int)i).y + d3), (float)(vector3.get((int)(i + n)).x - d2), (float)(vector3.get((int)(i + n)).y - d4), (float)vector3.get((int)(i + n)).x, (float)vector3.get((int)(i + n)).y);
            }
            if (this.isClosed) {
                this.gp.closePath();
            }
            this.w = (float)(Globals.lineWidth * mapCoordinates.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
        }
        if (this.p == null || this.gp == null) {
            return;
        }
        graphicsInterface.applyStroke(this.w, this.dashStyle);
        if (this.arrowData.atLeastOneArrow() && this.p.getNpoints() > 2) {
            this.arrowData.prepareCoordinateMapping(mapCoordinates);
            if (this.arrowData.isArrowStart() && !this.isClosed) {
                this.arrowData.drawArrow(graphicsInterface, mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), this.p.getXpoints()[1], this.p.getYpoints()[1]);
            }
            if (this.arrowData.isArrowEnd() && !this.isClosed) {
                int n = this.nPoints - 1;
                this.arrowData.drawArrow(graphicsInterface, mapCoordinates.mapX(this.virtualPoint[n].x, this.virtualPoint[n].y), mapCoordinates.mapY(this.virtualPoint[n].x, this.virtualPoint[n].y), this.p.getXpoints()[this.p.getNpoints() - 2], this.p.getYpoints()[this.p.getNpoints() - 2]);
            }
        }
        if (!graphicsInterface.hitClip(this.xmin, this.ymin, this.width + 1, this.height + 1)) {
            return;
        }
        if (this.isFilled) {
            graphicsInterface.fill(this.gp);
        }
        if (this.width == 0 || this.height == 0) {
            int n = this.nPoints - 1;
            graphicsInterface.drawLine(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapX(this.virtualPoint[n].x, this.virtualPoint[n].y), mapCoordinates.mapY(this.virtualPoint[n].x, this.virtualPoint[n].y));
        } else {
            graphicsInterface.draw(this.gp);
        }
    }

    @Override
    public void parseTokens(String[] stringArray, int n) throws IOException {
        this.changed = true;
        if (stringArray[0].equals("CP") || stringArray[0].equals("CV")) {
            if (n < 6) {
                IOException iOException = new IOException("bad arguments on CP/CV");
                throw iOException;
            }
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            this.isClosed = stringArray[n2++].equals("1");
            while (!(n2 >= n - 1 || n2 + 1 < n - 1 && stringArray[n2 + 1].equals("FCJ"))) {
                n4 = Integer.parseInt(stringArray[n2++]);
                if (n2 >= n - 1) {
                    IOException iOException = new IOException("bad arguments on CP/CV");
                    throw iOException;
                }
                n5 = Integer.parseInt(stringArray[n2++]);
                ++n3;
                this.addPoint(n4, n5);
            }
            this.nPoints = n3;
            this.virtualPoint[this.getNameVirtualPointNumber()].x = n4 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = n5 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = n4 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = n5 + 10;
            if (n > n2) {
                this.parseLayer(stringArray[n2++]);
                if (n > n2 && stringArray[n2++].equals("FCJ")) {
                    n2 = this.arrowData.parseTokens(stringArray, n2);
                    this.dashStyle = this.checkDashStyle(Integer.parseInt(stringArray[n2++]));
                }
            }
            this.isFilled = stringArray[0].equals("CP");
        } else {
            IOException iOException = new IOException("CP/CV: Invalid primitive:" + stringArray[0] + " programming error?");
            throw iOException;
        }
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> vector = super.getControls();
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.isFilled;
        parameterDescription.description = Globals.messages.getString("ctrl_filled");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.isClosed;
        parameterDescription.description = Globals.messages.getString("ctrl_closed_curve");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        this.arrowData.getControlsForArrow(vector);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = new DashInfo(this.dashStyle);
        parameterDescription.description = Globals.messages.getString("ctrl_dash_style");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        return vector;
    }

    @Override
    public int setControls(Vector<ParameterDescription> vector) {
        int n = super.setControls(vector);
        ParameterDescription parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof Boolean) {
            this.isFilled = (Boolean)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n++);
        if (parameterDescription.parameter instanceof Boolean) {
            this.isClosed = (Boolean)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        n = this.arrowData.setParametersForArrow(vector, n);
        parameterDescription = vector.get(n++);
        if (parameterDescription.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)parameterDescription.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter 6!" + parameterDescription);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return n;
    }

    @Override
    public int getDistanceToPoint(int n, int n2) {
        int n3;
        int n4;
        if (this.checkText(n, n2)) {
            return 0;
        }
        int n5 = 100;
        if (this.p == null) {
            return GeometricDistances.pointToPoint(this.virtualPoint[0].x, this.virtualPoint[0].y, n, n2);
        }
        if (this.isFilled && this.q.contains(n, n2)) {
            return 1;
        }
        int[] nArray = this.q.getXpoints();
        int[] nArray2 = this.q.getYpoints();
        if (this.arrowData.atLeastOneArrow() && !this.isClosed) {
            n4 = 0;
            n3 = 0;
            MapCoordinates mapCoordinates = new MapCoordinates();
            this.arrowData.prepareCoordinateMapping(mapCoordinates);
            if (this.arrowData.isArrowStart()) {
                n3 = this.arrowData.isInArrow(n, n2, this.virtualPoint[0].x, this.virtualPoint[0].y, nArray[0], nArray2[0], null) ? 1 : 0;
            }
            if (this.arrowData.isArrowEnd()) {
                n4 = this.arrowData.isInArrow(n, n2, nArray[this.q.getNpoints() - 1], nArray2[this.q.getNpoints() - 1], this.virtualPoint[this.nPoints - 1].x, this.virtualPoint[this.nPoints - 1].y, null) ? 1 : 0;
            }
            if (n4 != 0 || n3 != 0) {
                return 1;
            }
        }
        for (n4 = 0; n4 < this.q.getNpoints() - 1; ++n4) {
            n3 = GeometricDistances.pointToSegment(nArray[n4], nArray2[n4], nArray[n4 + 1], nArray2[n4 + 1], n, n2);
            if (n3 >= n5) continue;
            n5 = n3;
        }
        return n5;
    }

    @Override
    public String toString(boolean bl) {
        if (this.name.length() == 0 && this.value.length() == 0 && this.nPoints == 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(25);
        if (this.isFilled) {
            stringBuffer.append("CP ");
        } else {
            stringBuffer.append("CV ");
        }
        if (this.isClosed) {
            stringBuffer.append("1 ");
        } else {
            stringBuffer.append("0 ");
        }
        for (int i = 0; i < this.nPoints; ++i) {
            stringBuffer.append(this.virtualPoint[i].x);
            stringBuffer.append(" ");
            stringBuffer.append(this.virtualPoint[i].y);
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.getLayer());
        stringBuffer.append("\n");
        Object object = stringBuffer.toString();
        if (bl && (this.arrowData.atLeastOneArrow() || this.dashStyle > 0 || this.hasName() || this.hasValue())) {
            String string = "0";
            if (this.name.length() != 0 || this.value.length() != 0) {
                string = "1";
            }
            object = (String)object + "FCJ " + this.arrowData.createArrowTokens() + " " + this.dashStyle + " " + string + "\n";
        }
        object = (String)object + this.saveText(false);
        return object;
    }

    @Override
    public void export(ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        int n;
        double[] dArray = new double[this.nPoints];
        double[] dArray2 = new double[this.nPoints];
        PointDouble[] pointDoubleArray = new PointDouble[this.nPoints * 24 + 1];
        for (n = 0; n < this.nPoints; ++n) {
            dArray[n] = mapCoordinates.mapXr(this.virtualPoint[n].x, this.virtualPoint[n].y);
            dArray2[n] = mapCoordinates.mapYr(this.virtualPoint[n].x, this.virtualPoint[n].y);
            pointDoubleArray[n] = new PointDouble();
            pointDoubleArray[n].x = dArray[n];
            pointDoubleArray[n].y = dArray2[n];
        }
        if (!exportInterface.exportCurve(pointDoubleArray, this.nPoints, this.isFilled, this.isClosed, this.getLayer(), this.arrowData.isArrowStart(), this.arrowData.isArrowEnd(), this.arrowData.getArrowStyle(), (int)((double)this.arrowData.getArrowLength() * mapCoordinates.getXMagnitude()), (int)((double)this.arrowData.getArrowHalfWidth() * mapCoordinates.getXMagnitude()), this.dashStyle, Globals.lineWidth * mapCoordinates.getXMagnitude())) {
            this.exportAsPolygonInterface(dArray, dArray2, pointDoubleArray, exportInterface, mapCoordinates);
            n = this.q.getNpoints();
            if (this.q.getNpoints() > 2) {
                if (this.arrowData.isArrowStart() && !this.isClosed) {
                    exportInterface.exportArrow(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), pointDoubleArray[1].x, pointDoubleArray[1].y, (double)this.arrowData.getArrowLength() * mapCoordinates.getXMagnitude(), (double)this.arrowData.getArrowHalfWidth() * mapCoordinates.getXMagnitude(), this.arrowData.getArrowStyle());
                }
                if (this.arrowData.isArrowEnd() && !this.isClosed) {
                    int n2 = this.nPoints - 1;
                    exportInterface.exportArrow(mapCoordinates.mapX(this.virtualPoint[n2].x, this.virtualPoint[n2].y), mapCoordinates.mapY(this.virtualPoint[n2].x, this.virtualPoint[n2].y), pointDoubleArray[n - 2].x, pointDoubleArray[n - 2].y, (double)this.arrowData.getArrowLength() * mapCoordinates.getXMagnitude(), (double)this.arrowData.getArrowHalfWidth() * mapCoordinates.getXMagnitude(), this.arrowData.getArrowStyle());
                }
            }
        }
        this.exportText(exportInterface, mapCoordinates, -1);
    }

    private void exportAsPolygonInterface(double[] dArray, double[] dArray2, PointDouble[] pointDoubleArray, ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        int n;
        Cubic[] cubicArray;
        Cubic[] cubicArray2;
        if (this.isClosed) {
            cubicArray2 = this.calcNaturalCubicClosed(this.nPoints - 1, dArray);
            cubicArray = this.calcNaturalCubicClosed(this.nPoints - 1, dArray2);
        } else {
            cubicArray2 = this.calcNaturalCubic(this.nPoints - 1, dArray);
            cubicArray = this.calcNaturalCubic(this.nPoints - 1, dArray2);
            if (this.arrowData.atLeastOneArrow()) {
                this.arrowData.prepareCoordinateMapping(mapCoordinates);
                if (this.arrowData.isArrowStart()) {
                    PointG pointG = new PointG();
                    this.arrowData.isInArrow(0, 0, (int)Math.round(cubicArray2[0].eval(0.0)), (int)Math.round(cubicArray[0].eval(0.0)), (int)Math.round(cubicArray2[0].eval(0.05)), (int)Math.round(cubicArray[0].eval(0.05)), pointG);
                    if (this.arrowData.getArrowLength() > 0.0f) {
                        dArray[0] = pointG.x;
                        dArray2[0] = pointG.y;
                    }
                }
                if (this.arrowData.isArrowEnd()) {
                    int n2 = cubicArray2.length - 1;
                    PointG pointG = new PointG();
                    this.arrowData.isInArrow(0, 0, (int)Math.round(cubicArray2[n2].eval(1.0)), (int)Math.round(cubicArray[n2].eval(1.0)), (int)Math.round(cubicArray2[n2].eval(0.95)), (int)Math.round(cubicArray[n2].eval(0.95)), pointG);
                    if (this.arrowData.getArrowLength() > 0.0f) {
                        dArray[this.nPoints - 1] = pointG.x;
                        dArray2[this.nPoints - 1] = pointG.y;
                    }
                }
                if (this.arrowData.getArrowLength() > 0.0f) {
                    cubicArray2 = this.calcNaturalCubic(this.nPoints - 1, dArray);
                    cubicArray = this.calcNaturalCubic(this.nPoints - 1, dArray2);
                }
            }
        }
        if (cubicArray2 == null || cubicArray == null) {
            return;
        }
        pointDoubleArray[0] = new PointDouble();
        pointDoubleArray[0].x = cubicArray2[0].eval(0.0);
        pointDoubleArray[0].y = cubicArray[0].eval(0.0);
        for (n = 0; n < cubicArray2.length; ++n) {
            for (int i = 1; i <= 24; ++i) {
                double d = (double)i / 24.0;
                pointDoubleArray[n * 24 + i] = new PointDouble();
                pointDoubleArray[n * 24 + i].x = cubicArray2[n].eval(d);
                pointDoubleArray[n * 24 + i].y = cubicArray[n].eval(d);
            }
        }
        pointDoubleArray[cubicArray2.length * 24] = new PointDouble();
        pointDoubleArray[cubicArray2.length * 24].x = cubicArray2[cubicArray2.length - 1].eval(1.0);
        pointDoubleArray[cubicArray2.length * 24].y = cubicArray[cubicArray2.length - 1].eval(1.0);
        if (this.isClosed) {
            exportInterface.exportPolygon(pointDoubleArray, cubicArray2.length * 24 + 1, this.isFilled, this.getLayer(), this.dashStyle, Globals.lineWidth * mapCoordinates.getXMagnitude());
        } else {
            float f = 0.0f;
            for (n = 1; n < cubicArray2.length * 24 + 1; ++n) {
                exportInterface.setDashPhase(f);
                exportInterface.exportLine(pointDoubleArray[n - 1].x, pointDoubleArray[n - 1].y, pointDoubleArray[n].x, pointDoubleArray[n].y, this.getLayer(), false, false, 0, 0, 0, this.dashStyle, Globals.lineWidth * mapCoordinates.getXMagnitude());
                f = (float)((double)f + Math.sqrt(Math.pow(pointDoubleArray[n - 1].x - pointDoubleArray[n].x, 2.0) + Math.pow(pointDoubleArray[n - 1].y - pointDoubleArray[n].y, 2.0)));
            }
        }
    }

    @Override
    public int getNameVirtualPointNumber() {
        return this.nPoints;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return this.nPoints + 1;
    }
}

