/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fidocadj.dialogs.DashInfo;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.GeometricDistances;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.graphic.RectangleG;
import net.sourceforge.fidocadj.graphic.ShapeInterface;
import net.sourceforge.fidocadj.primitives.Arrow;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;

public final class PrimitiveBezier
extends GraphicPrimitive {
    static final int N_POINTS = 6;
    private int dashStyle;
    private final Arrow arrowData = new Arrow();
    private ShapeInterface shape1;
    private float w;
    private int xmin;
    private int ymin;
    private int width;
    private int height;

    @Override
    public int getControlPointNumber() {
        return 6;
    }

    public PrimitiveBezier(String string, int n) {
        this.initPrimitive(-1, string, n);
    }

    public PrimitiveBezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, int n10, int n11, int n12, int n13, String string, int n14) {
        this.arrowData.setArrowStart(bl);
        this.arrowData.setArrowEnd(bl2);
        this.arrowData.setArrowHalfWidth(n12);
        this.arrowData.setArrowLength(n11);
        this.arrowData.setArrowStyle(n10);
        this.dashStyle = n13;
        this.initPrimitive(-1, string, n14);
        this.virtualPoint[0].x = n;
        this.virtualPoint[0].y = n2;
        this.virtualPoint[1].x = n3;
        this.virtualPoint[1].y = n4;
        this.virtualPoint[2].x = n5;
        this.virtualPoint[2].y = n6;
        this.virtualPoint[3].x = n7;
        this.virtualPoint[3].y = n8;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = n2 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = n + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = n2 + 10;
        this.setLayer(n9);
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> vector = super.getControls();
        this.arrowData.getControlsForArrow(vector);
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.parameter = new DashInfo(this.dashStyle);
        parameterDescription.description = Globals.messages.getString("ctrl_dash_style");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        return vector;
    }

    @Override
    public int setControls(Vector<ParameterDescription> vector) {
        int n = super.setControls(vector);
        n = this.arrowData.setParametersForArrow(vector, n);
        ParameterDescription parameterDescription = vector.get(n++);
        if (parameterDescription.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)parameterDescription.parameter).style;
        } else {
            System.out.println("Warning: 6-unexpected parameter!" + parameterDescription);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return n;
    }

    @Override
    public void draw(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector) {
        if (!this.selectLayer(graphicsInterface, vector)) {
            return;
        }
        int n = 0;
        PointG pointG = new PointG(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y));
        PointG pointG2 = new PointG(mapCoordinates.mapX(this.virtualPoint[3].x, this.virtualPoint[3].y), mapCoordinates.mapY(this.virtualPoint[3].x, this.virtualPoint[3].y));
        this.drawText(graphicsInterface, mapCoordinates, vector, -1);
        if (this.changed) {
            this.w = (float)(Globals.lineWidth * mapCoordinates.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
        }
        graphicsInterface.applyStroke(this.w, this.dashStyle);
        if (this.arrowData.atLeastOneArrow()) {
            n = this.arrowData.prepareCoordinateMapping(mapCoordinates);
            if (this.arrowData.isArrowStart()) {
                if (this.arrowData.getArrowLength() > 0.0f) {
                    pointG = this.drawArrow(graphicsInterface, mapCoordinates, 0, 1, 2, 3);
                } else {
                    this.drawArrow(graphicsInterface, mapCoordinates, 0, 1, 2, 3);
                }
            }
            if (this.arrowData.isArrowEnd()) {
                if (this.arrowData.getArrowLength() > 0.0f) {
                    pointG2 = this.drawArrow(graphicsInterface, mapCoordinates, 3, 2, 1, 0);
                } else {
                    this.drawArrow(graphicsInterface, mapCoordinates, 3, 2, 1, 0);
                }
            }
        }
        if (this.changed) {
            this.changed = false;
            this.shape1 = graphicsInterface.createShape();
            this.shape1.createCubicCurve(pointG.x, pointG.y, mapCoordinates.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), mapCoordinates.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), mapCoordinates.mapX(this.virtualPoint[2].x, this.virtualPoint[2].y), mapCoordinates.mapY(this.virtualPoint[2].x, this.virtualPoint[2].y), pointG2.x, pointG2.y);
            RectangleG rectangleG = this.shape1.getBounds();
            this.xmin = rectangleG.x - n;
            this.ymin = rectangleG.y - n;
            this.width = rectangleG.width + 2 * n;
            this.height = rectangleG.height + 2 * n;
        }
        if (!graphicsInterface.hitClip(this.xmin, this.ymin, this.width + 1, this.height + 1)) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            graphicsInterface.drawLine(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapX(this.virtualPoint[3].x, this.virtualPoint[3].y), mapCoordinates.mapY(this.virtualPoint[3].x, this.virtualPoint[3].y));
        } else {
            graphicsInterface.draw(this.shape1);
        }
    }

    private PointG drawArrow(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = this.virtualPoint[n].x;
        int n8 = this.virtualPoint[n].y;
        if (this.virtualPoint[n].x != this.virtualPoint[n2].x || this.virtualPoint[n].y != this.virtualPoint[n2].y) {
            n6 = this.virtualPoint[n2].x;
            n5 = this.virtualPoint[n2].y;
        } else if (this.virtualPoint[n].x != this.virtualPoint[n3].x || this.virtualPoint[n].y != this.virtualPoint[n3].y) {
            n6 = this.virtualPoint[n3].x;
            n5 = this.virtualPoint[n3].y;
        } else {
            n6 = this.virtualPoint[n4].x;
            n5 = this.virtualPoint[n4].y;
        }
        return this.arrowData.drawArrow(graphicsInterface, mapCoordinates.mapX(n7, n8), mapCoordinates.mapY(n7, n8), mapCoordinates.mapX(n6, n5), mapCoordinates.mapY(n6, n5));
    }

    @Override
    public void parseTokens(String[] stringArray, int n) throws IOException {
        this.changed = true;
        if (stringArray[0].equals("BE")) {
            if (n < 9) {
                IOException iOException = new IOException("bad arguments on BE");
                throw iOException;
            }
            int n2 = this.virtualPoint[0].x = Integer.parseInt(stringArray[1]);
            int n3 = this.virtualPoint[0].y = Integer.parseInt(stringArray[2]);
            this.virtualPoint[1].x = Integer.parseInt(stringArray[3]);
            this.virtualPoint[1].y = Integer.parseInt(stringArray[4]);
            this.virtualPoint[2].x = Integer.parseInt(stringArray[5]);
            this.virtualPoint[2].y = Integer.parseInt(stringArray[6]);
            this.virtualPoint[3].x = Integer.parseInt(stringArray[7]);
            this.virtualPoint[3].y = Integer.parseInt(stringArray[8]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = n3 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = n2 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = n3 + 10;
            if (n > 9) {
                this.parseLayer(stringArray[9]);
            }
            if (n > 10 && stringArray[10].equals("FCJ")) {
                int n4 = this.arrowData.parseTokens(stringArray, 11);
                this.dashStyle = this.checkDashStyle(Integer.parseInt(stringArray[n4]));
            }
        } else {
            IOException iOException = new IOException("Invalid primitive:  programming error?");
            throw iOException;
        }
    }

    @Override
    public int getDistanceToPoint(int n, int n2) {
        if (this.checkText(n, n2)) {
            return 0;
        }
        PointG pointG = new PointG(this.virtualPoint[0].x, this.virtualPoint[0].y);
        PointG pointG2 = new PointG(this.virtualPoint[3].x, this.virtualPoint[3].y);
        if (this.arrowData.atLeastOneArrow()) {
            boolean bl = false;
            boolean bl2 = false;
            MapCoordinates mapCoordinates = new MapCoordinates();
            this.arrowData.prepareCoordinateMapping(mapCoordinates);
            if (this.arrowData.isArrowStart()) {
                bl2 = this.arrowData.getArrowLength() > 0.0f ? this.arrowData.isInArrow(n, n2, this.virtualPoint[0].x, this.virtualPoint[0].y, this.virtualPoint[1].x, this.virtualPoint[1].y, pointG) : this.arrowData.isInArrow(n, n2, this.virtualPoint[0].x, this.virtualPoint[0].y, this.virtualPoint[1].x, this.virtualPoint[1].y, null);
            }
            if (this.arrowData.isArrowEnd()) {
                bl = this.arrowData.getArrowLength() > 0.0f ? this.arrowData.isInArrow(n, n2, this.virtualPoint[3].x, this.virtualPoint[3].y, this.virtualPoint[2].x, this.virtualPoint[2].y, pointG2) : this.arrowData.isInArrow(n, n2, this.virtualPoint[3].x, this.virtualPoint[3].y, this.virtualPoint[2].x, this.virtualPoint[2].y, null);
            }
            if (bl || bl2) {
                return 1;
            }
        }
        return GeometricDistances.pointToBezier(pointG.x, pointG.y, this.virtualPoint[1].x, this.virtualPoint[1].y, this.virtualPoint[2].x, this.virtualPoint[2].y, pointG2.x, pointG2.y, n, n2);
    }

    @Override
    public String toString(boolean bl) {
        String string = "BE " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.virtualPoint[1].x + " " + this.virtualPoint[1].y + " " + this.virtualPoint[2].x + " " + this.virtualPoint[2].y + " " + this.virtualPoint[3].x + " " + this.virtualPoint[3].y + " " + this.getLayer() + "\n";
        if (bl && (this.arrowData.atLeastOneArrow() || this.dashStyle > 0 || this.hasName() || this.hasValue())) {
            String string2 = "0";
            if (this.name.length() != 0 || this.value.length() != 0) {
                string2 = "1";
            }
            string = string + "FCJ " + this.arrowData.createArrowTokens() + " " + this.dashStyle + " " + string2 + "\n";
        }
        string = string + this.saveText(false);
        return string;
    }

    @Override
    public void export(ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        this.exportText(exportInterface, mapCoordinates, -1);
        exportInterface.exportBezier(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), mapCoordinates.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), mapCoordinates.mapX(this.virtualPoint[2].x, this.virtualPoint[2].y), mapCoordinates.mapY(this.virtualPoint[2].x, this.virtualPoint[2].y), mapCoordinates.mapX(this.virtualPoint[3].x, this.virtualPoint[3].y), mapCoordinates.mapY(this.virtualPoint[3].x, this.virtualPoint[3].y), this.getLayer(), this.arrowData.isArrowStart(), this.arrowData.isArrowEnd(), this.arrowData.getArrowStyle(), (int)((double)this.arrowData.getArrowLength() * mapCoordinates.getXMagnitude()), (int)((double)this.arrowData.getArrowHalfWidth() * mapCoordinates.getXMagnitude()), this.dashStyle, Globals.lineWidth * mapCoordinates.getXMagnitude());
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 4;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 5;
    }
}

