/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fidocadj.dialogs.LayerInfo;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.GeometricDistances;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.FontG;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.graphic.nil.GraphicsNull;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;

public final class PrimitiveAdvText
extends GraphicPrimitive {
    private String txt = "";
    private int six = 3;
    private int siy = 4;
    private int sty;
    private int o = 0;
    private String fontName = "Courier New";
    private boolean recalcSize;
    static final int TEXT_BOLD = 1;
    static final int TEXT_MIRRORED = 4;
    static final int TEXT_ITALIC = 2;
    static final int MAXSIZE = 2000;
    static final int MINSIZE = 1;
    static final int N_POINTS = 1;
    private int xaSCI;
    private int yaSCI;
    private int orientationSCI;
    private int hSCI;
    private int thSCI;
    private int wSCI;
    private int[] xpSCI;
    private int[] ypSCI;
    private boolean mirror;
    private int orientation;
    private int h;
    private int th;
    private int w;
    private double ymagnitude;
    private boolean coordmirroring;
    private int x1;
    private int y1;
    private int xa;
    private int ya;
    private int qq;
    private double xyfactor;
    private double si;
    private double co;
    private boolean needsStretching;

    @Override
    public int getControlPointNumber() {
        return 1;
    }

    public PrimitiveAdvText() {
        this.virtualPoint = new PointG[1];
        for (int i = 0; i < 1; ++i) {
            this.virtualPoint[i] = new PointG();
        }
        this.changed = true;
        this.recalcSize = true;
    }

    public PrimitiveAdvText(int n, int n2, int n3, int n4, String string, int n5, int n6, String string2, int n7) {
        this();
        this.virtualPoint[0] = new PointG(n, n2);
        this.six = n3;
        this.siy = n4;
        this.sty = n6;
        this.txt = string2;
        this.o = n5;
        this.fontName = string;
        this.setLayer(n7);
        this.changed = true;
        this.recalcSize = true;
    }

    @Override
    public void draw(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector) {
        if (!this.selectLayer(graphicsInterface, vector)) {
            return;
        }
        if (this.txt.length() == 0) {
            return;
        }
        this.changed = true;
        this.ymagnitude = mapCoordinates.getYMagnitude();
        this.coordmirroring = mapCoordinates.getMirror();
        if (this.changed) {
            this.changed = false;
            this.mirror = false;
            this.recalcSize = true;
            this.x1 = this.virtualPoint[0].x;
            this.y1 = this.virtualPoint[0].y;
            this.xa = mapCoordinates.mapX(this.x1, this.y1);
            this.ya = mapCoordinates.mapY(this.x1, this.y1);
            graphicsInterface.setFont(this.fontName, (double)(this.six * 12) * mapCoordinates.getYMagnitude() / 7.0 + 0.5, (this.sty & 2) != 0, (this.sty & 1) != 0);
            this.orientation = this.o;
            this.mirror = false;
            if ((this.sty & 4) != 0) {
                this.mirror = !this.mirror;
                this.orientation = -this.orientation;
            }
            if (this.six == 0 || this.siy == 0) {
                this.siy = 10;
                this.six = 7;
            }
            this.orientation -= mapCoordinates.getOrientation() * 90;
            if (this.coordmirroring) {
                this.mirror = !this.mirror;
                this.orientation = -this.orientation;
            }
            this.h = graphicsInterface.getFontAscent();
            this.th = this.h + graphicsInterface.getFontDescent();
            this.w = graphicsInterface.getStringWidth(this.txt);
            this.xyfactor = 1.0;
            this.needsStretching = false;
            if (this.siy / this.six != 1) {
                this.xyfactor = (double)this.siy / (double)this.six * 22.0 / 40.0;
                this.needsStretching = true;
            }
            if (this.orientation == 0) {
                if (this.mirror) {
                    mapCoordinates.trackPoint(this.xa - this.w, this.ya);
                    mapCoordinates.trackPoint(this.xa, this.ya + (int)((double)this.th * this.xyfactor));
                } else {
                    mapCoordinates.trackPoint(this.xa + this.w, this.ya);
                    mapCoordinates.trackPoint(this.xa, this.ya + (int)((double)this.h * this.xyfactor));
                }
            } else {
                if (this.mirror) {
                    this.si = Math.sin(Math.toRadians(-this.orientation));
                    this.co = Math.cos(Math.toRadians(-this.orientation));
                } else {
                    this.si = Math.sin(Math.toRadians(this.orientation));
                    this.co = Math.cos(Math.toRadians(this.orientation));
                }
                double d = this.xa;
                double d2 = this.ya;
                double d3 = (double)this.xa + (double)this.th * this.si;
                double d4 = (double)this.ya + (double)this.th * this.co * this.xyfactor;
                double d5 = (double)this.xa + (double)this.w * this.co + (double)this.th * this.si;
                double d6 = (double)this.ya + ((double)this.th * this.co - (double)this.w * this.si) * this.xyfactor;
                double d7 = (double)this.xa + (double)this.w * this.co;
                double d8 = (double)this.ya - (double)this.w * this.si * this.xyfactor;
                if (this.mirror) {
                    d3 = (double)this.xa - (double)this.th * this.si;
                    d5 = (double)this.xa - (double)this.w * this.co - (double)this.th * this.si;
                    d7 = (double)this.xa - (double)this.w * this.co;
                }
                mapCoordinates.trackPoint((int)d, (int)d2);
                mapCoordinates.trackPoint((int)d3, (int)d4);
                mapCoordinates.trackPoint((int)d5, (int)d6);
                mapCoordinates.trackPoint((int)d7, (int)d8);
            }
            this.qq = (int)((double)this.ya / this.xyfactor);
        }
        graphicsInterface.drawAdvText(this.xyfactor, this.xa, this.ya, this.qq, this.h, this.w, this.h, this.needsStretching, this.orientation, this.mirror, this.txt);
    }

    @Override
    public void parseTokens(String[] stringArray, int n) throws IOException {
        this.changed = true;
        this.recalcSize = true;
        if (stringArray[0].equals("TY")) {
            if (n < 9) {
                IOException iOException = new IOException("bad arguments on TY");
                throw iOException;
            }
            this.virtualPoint[0].x = Integer.parseInt(stringArray[1]);
            this.virtualPoint[0].y = Integer.parseInt(stringArray[2]);
            this.siy = (int)Math.round(Double.parseDouble(stringArray[3]));
            this.six = (int)Math.round(Double.parseDouble(stringArray[4]));
            this.checkSizes();
            this.o = Integer.parseInt(stringArray[5]);
            this.sty = Integer.parseInt(stringArray[6]);
            this.parseLayer(stringArray[7]);
            int n2 = 8;
            StringBuffer stringBuffer = new StringBuffer();
            this.fontName = stringArray[8].equals("*") ? "Courier New" : stringArray[8].replaceAll("\\+\\+", " ");
            while (n2 < n - 1) {
                stringBuffer.append(stringArray[++n2]);
                if (n2 >= n - 1) continue;
                stringBuffer.append(" ");
            }
            this.txt = stringBuffer.toString();
        } else if (stringArray[0].equals("TE")) {
            if (n < 4) {
                IOException iOException = new IOException("bad arguments on TE");
                throw iOException;
            }
            this.virtualPoint[0].x = Integer.parseInt(stringArray[1]);
            this.virtualPoint[0].y = Integer.parseInt(stringArray[2]);
            this.six = 3;
            this.siy = 4;
            this.o = 0;
            this.sty = 0;
            int n3 = 2;
            this.txt = "";
            while (n3 < n - 1) {
                this.txt = this.txt + stringArray[++n3] + " ";
            }
            this.parseLayer("0");
        } else {
            IOException iOException = new IOException("Invalid primitive: programming error?");
            throw iOException;
        }
    }

    public void checkSizes() {
        if (this.siy < 1) {
            this.siy = 1;
        }
        if (this.six < 1) {
            this.six = 1;
        }
        if (this.siy > 2000) {
            this.siy = 2000;
        }
        if (this.six > 2000) {
            this.six = 2000;
        }
    }

    @Override
    public int getDistanceToPoint(int n, int n2) {
        if (this.changed || this.recalcSize) {
            if (this.changed) {
                GraphicsNull graphicsNull = new GraphicsNull();
                graphicsNull.setFont(this.fontName, (int)((double)this.six * 12.0 / 7.0 + 0.5), (this.sty & 2) != 0, (this.sty & 1) != 0);
                this.hSCI = graphicsNull.getFontAscent();
                this.thSCI = this.hSCI + graphicsNull.getFontDescent();
                this.wSCI = graphicsNull.getStringWidth(this.txt);
            } else {
                this.hSCI = (int)((double)this.h / this.ymagnitude);
                this.thSCI = (int)((double)this.th / this.ymagnitude);
                this.wSCI = (int)((double)this.w / this.ymagnitude);
            }
            this.recalcSize = false;
            this.xaSCI = this.virtualPoint[0].x;
            this.yaSCI = this.virtualPoint[0].y;
            this.orientationSCI = this.o;
            if (this.siy / this.six != 1) {
                this.hSCI = (int)Math.round((double)this.hSCI * ((double)this.siy * 22.0 / 40.0 / (double)this.six));
                this.thSCI = (int)Math.round((double)this.thSCI * ((double)this.siy * 22.0 / 40.0 / (double)this.six));
            }
            if ((this.sty & 4) != 0) {
                this.orientationSCI = -this.orientationSCI;
                this.wSCI = -this.wSCI;
            }
            if (this.coordmirroring) {
                this.wSCI = -this.wSCI;
            }
            if (this.orientationSCI != 0) {
                double d = Math.sin(Math.toRadians(this.orientation));
                double d2 = Math.cos(Math.toRadians(this.orientation));
                this.xpSCI = new int[4];
                this.ypSCI = new int[4];
                this.xpSCI[0] = this.xaSCI;
                this.ypSCI[0] = this.yaSCI;
                this.xpSCI[1] = (int)((double)this.xaSCI + (double)this.thSCI * d);
                this.ypSCI[1] = (int)((double)this.yaSCI + (double)this.thSCI * d2);
                this.xpSCI[2] = (int)((double)this.xaSCI + (double)this.thSCI * d + (double)this.wSCI * d2);
                this.ypSCI[2] = (int)((double)this.yaSCI + (double)this.thSCI * d2 - (double)this.wSCI * d);
                this.xpSCI[3] = (int)((double)this.xaSCI + (double)this.wSCI * d2);
                this.ypSCI[3] = (int)((double)this.yaSCI - (double)this.wSCI * d);
            }
        }
        if (this.orientationSCI == 0 ? GeometricDistances.pointInRectangle(Math.min(this.xaSCI, this.xaSCI + this.wSCI), this.yaSCI, Math.abs(this.wSCI), this.thSCI, n, n2) : GeometricDistances.pointInPolygon(this.xpSCI, this.ypSCI, 4, n, n2)) {
            return 0;
        }
        return 0x3FFFFFFF;
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> vector = new Vector<ParameterDescription>(10);
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.txt;
        parameterDescription.description = Globals.messages.getString("ctrl_text");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = new LayerInfo(this.getLayer());
        parameterDescription.description = Globals.messages.getString("ctrl_layer");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.six;
        parameterDescription.description = Globals.messages.getString("ctrl_xsize");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.siy;
        parameterDescription.description = Globals.messages.getString("ctrl_ysize");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.o;
        parameterDescription.description = Globals.messages.getString("ctrl_angle");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = (this.sty & 4) != 0;
        parameterDescription.description = Globals.messages.getString("ctrl_mirror");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = (this.sty & 2) != 0;
        parameterDescription.description = Globals.messages.getString("ctrl_italic");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = (this.sty & 1) != 0;
        parameterDescription.description = Globals.messages.getString("ctrl_boldface");
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = new FontG(this.fontName);
        parameterDescription.description = Globals.messages.getString("ctrl_font");
        vector.add(parameterDescription);
        return vector;
    }

    @Override
    public int setControls(Vector<ParameterDescription> vector) {
        int n = 0;
        this.changed = true;
        this.recalcSize = true;
        ParameterDescription parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof String) {
            this.txt = (String)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof LayerInfo) {
            this.setLayer(((LayerInfo)parameterDescription.parameter).getLayer());
        } else {
            System.out.println("Warning: unexpected parameter!");
        }
        parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof Integer) {
            this.six = (Integer)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof Integer) {
            this.siy = (Integer)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof Integer) {
            this.o = (Integer)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n++);
        if (parameterDescription.parameter instanceof Boolean) {
            this.sty = (Boolean)parameterDescription.parameter != false ? this.sty | 4 : this.sty & 0xFFFFFFFB;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n++);
        if (parameterDescription.parameter instanceof Boolean) {
            this.sty = (Boolean)parameterDescription.parameter != false ? this.sty | 2 : this.sty & 0xFFFFFFFD;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n++);
        if (parameterDescription.parameter instanceof Boolean) {
            this.sty = (Boolean)parameterDescription.parameter != false ? this.sty | 1 : this.sty & 0xFFFFFFFE;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n++);
        if (parameterDescription.parameter instanceof FontG) {
            this.fontName = ((FontG)parameterDescription.parameter).getFamily();
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        this.checkSizes();
        return n;
    }

    @Override
    public void rotatePrimitive(boolean bl, int n, int n2) {
        boolean bl2 = bl;
        super.rotatePrimitive(bl2, n, n2);
        int n3 = this.o / 90;
        if ((this.sty & 4) != 0) {
            boolean bl3 = bl2 = !bl2;
        }
        if (bl2) {
            ++n3;
            n3 %= 4;
        } else {
            n3 = (n3 + 3) % 4;
        }
        this.o = 90 * n3;
    }

    @Override
    public void mirrorPrimitive(int n) {
        super.mirrorPrimitive(n);
        this.sty ^= 4;
        this.changed = true;
        this.recalcSize = true;
    }

    @Override
    public String toString(boolean bl) {
        String string;
        if (this.fontName.equals("Courier New")) {
            string = "*";
        } else {
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = 0; i < this.fontName.length(); ++i) {
                if (this.fontName.charAt(i) == ' ') {
                    stringBuffer.append("++");
                    continue;
                }
                stringBuffer.append(this.fontName.charAt(i));
            }
            string = stringBuffer.toString();
        }
        return "TY " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.siy + " " + this.six + " " + this.o + " " + this.sty + " " + this.getLayer() + " " + string + " " + this.txt + "\n";
    }

    @Override
    public void export(ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        int n = this.o - mapCoordinates.getOrientation() * 90;
        exportInterface.exportAdvText(mapCoordinates.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), mapCoordinates.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), (int)Math.abs(mapCoordinates.mapXr(this.six, this.six) - mapCoordinates.mapXr(0.0, 0.0)), (int)Math.abs(mapCoordinates.mapYr(this.siy, this.siy) - mapCoordinates.mapYr(0.0, 0.0)), this.fontName, (this.sty & 1) != 0, (this.sty & 4) != 0, (this.sty & 2) != 0, n, this.getLayer(), this.txt);
    }

    @Override
    public int getNameVirtualPointNumber() {
        return -1;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return -1;
    }
}

