/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fidocadj.dialogs.LayerInfo;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.GeometricDistances;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.DecoratedText;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.layers.LayerDesc;

public abstract class GraphicPrimitive {
    public static final int NO_DRAG = -1;
    public static final int DRAG_PRIMITIVE = -2;
    public static final int RECT_SELECTION = -3;
    private static final int MAX_TOKENS = 120;
    public boolean selectedState = false;
    protected static final float D_MIN = 0.5f;
    public int layer = 0;
    private float mult = 1.0f;
    private static final int BASE_RESOLUTION = 112;
    private static final int HANDLE_WIDTH = 10;
    private static final double INT_TOLERANCE = 1.0E-5;
    public PointG[] virtualPoint;
    protected boolean changed = true;
    private int macroFontSize;
    protected String macroFont;
    protected String name = "";
    protected String value = "";
    private LayerDesc currentLayer;
    private float alpha;
    private static float oldalpha = 1.0f;
    private int old_layer = -1;
    private int xa;
    private int ya;
    private int xb;
    private int yb;
    private int h;
    private int th;
    private int w1;
    private int w2;
    private int t_th;
    private int t_w1;
    private int t_w2;
    private int x2;
    private int y2;
    private int x3;
    private int y3;

    public GraphicPrimitive(String string, int n) {
        this.setMacroFontSize(n);
        this.macroFont = string;
    }

    public GraphicPrimitive() {
        this.setMacroFontSize(4);
        this.macroFont = "";
    }

    public void setMacroFont(String string, int n) {
        this.macroFont = string;
        this.setMacroFontSize(n);
        this.changed = true;
    }

    public void initPrimitive(int n, String string, int n2) {
        this.setMacroFontSize(n2);
        this.macroFont = string;
        this.name = "";
        this.value = "";
        int n3 = n;
        if (n3 < 0) {
            n3 = this.getControlPointNumber();
        }
        this.virtualPoint = new PointG[n3];
        for (int i = 0; i < n3; ++i) {
            this.virtualPoint[i] = new PointG();
        }
    }

    public String getMacroFont() {
        return this.macroFont;
    }

    public int getMacroFontSize() {
        return this.macroFontSize;
    }

    public void setMacroFontSize(int n) {
        this.macroFontSize = n;
        if (this.macroFontSize <= 0) {
            this.macroFontSize = 1;
        }
    }

    public int checkDashStyle(int n) {
        if (n >= 5) {
            return 4;
        }
        if (n < 0) {
            return 0;
        }
        return n;
    }

    protected void drawText(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates, Vector vector, int n) {
        if (this.value == null && this.name == null) {
            return;
        }
        if ("".equals(this.value) && "".equals(this.name)) {
            return;
        }
        if (n >= 0 && n != this.getLayer()) {
            return;
        }
        if (this.changed) {
            this.x2 = this.virtualPoint[this.getNameVirtualPointNumber()].x;
            this.y2 = this.virtualPoint[this.getNameVirtualPointNumber()].y;
            this.x3 = this.virtualPoint[this.getValueVirtualPointNumber()].x;
            this.y3 = this.virtualPoint[this.getValueVirtualPointNumber()].y;
            this.xa = mapCoordinates.mapX(this.x2, this.y2);
            this.ya = mapCoordinates.mapY(this.x2, this.y2);
            this.xb = mapCoordinates.mapX(this.x3, this.y3);
            this.yb = mapCoordinates.mapY(this.x3, this.y3);
            graphicsInterface.setFont(this.macroFont, (int)((double)(this.macroFontSize * 12) * mapCoordinates.getYMagnitude() / 7.0 + 0.5));
            this.h = graphicsInterface.getFontAscent();
            this.th = this.h + graphicsInterface.getFontDescent();
            this.w1 = this.name == null ? 0 : graphicsInterface.getStringWidth(this.name);
            this.w2 = this.value == null ? 0 : graphicsInterface.getStringWidth(this.value);
            this.t_w1 = (int)((double)this.w1 / mapCoordinates.getXMagnitude());
            this.t_w2 = (int)((double)this.w2 / mapCoordinates.getXMagnitude());
            this.t_th = (int)((double)this.th / mapCoordinates.getYMagnitude());
            mapCoordinates.trackPoint(this.xa, this.ya);
            mapCoordinates.trackPoint(this.xa + this.w1, this.ya + this.th);
            mapCoordinates.trackPoint(this.xb, this.yb);
            mapCoordinates.trackPoint(this.xb + this.w2, this.yb + this.th);
        }
        if (!graphicsInterface.hitClip(this.xa, this.ya, this.w1, this.th) && !graphicsInterface.hitClip(this.xb, this.yb, this.w2, this.th)) {
            return;
        }
        if (this.th < 4) {
            graphicsInterface.drawLine(this.xa, this.ya, this.xa + this.w1 - 1, this.ya);
            graphicsInterface.drawLine(this.xb, this.yb, this.xb + this.w2 - 1, this.yb);
            return;
        }
        if (!this.changed) {
            graphicsInterface.setFont(this.macroFont, (int)((double)(this.macroFontSize * 12) * mapCoordinates.getYMagnitude() / 7.0 + 0.5));
        }
        DecoratedText decoratedText = new DecoratedText(graphicsInterface.getTextInterface());
        if (this.name != null && this.name.length() != 0) {
            decoratedText.drawString(this.name, this.xa, this.ya + this.h);
        }
        if (this.value != null && this.value.length() != 0) {
            decoratedText.drawString(this.value, this.xb, this.yb + this.h);
        }
    }

    public String saveText(boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.macroFont.equals("Courier New")) {
            string = "*";
        } else {
            StringBuffer stringBuffer2 = new StringBuffer("");
            for (int i = 0; i < this.macroFont.length(); ++i) {
                if (this.macroFont.charAt(i) == ' ') {
                    stringBuffer2.append("++");
                    continue;
                }
                stringBuffer2.append(this.macroFont.charAt(i));
            }
            string = stringBuffer2.toString();
        }
        if (this.name != null && !"".equals(this.name) || this.value != null && !"".equals(this.value)) {
            if (bl) {
                stringBuffer.append("FCJ\n");
            }
            stringBuffer.append("TY ");
            stringBuffer.append(this.virtualPoint[this.getNameVirtualPointNumber()].x);
            stringBuffer.append(" ");
            stringBuffer.append(this.virtualPoint[this.getNameVirtualPointNumber()].y);
            stringBuffer.append(" ");
            stringBuffer.append(this.macroFontSize * 4 / 3);
            stringBuffer.append(" ");
            stringBuffer.append(this.macroFontSize);
            stringBuffer.append(" 0 0 ");
            stringBuffer.append(this.getLayer());
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(this.name == null ? "" : this.name);
            stringBuffer.append("\n");
            stringBuffer.append("TY ");
            stringBuffer.append(this.virtualPoint[this.getValueVirtualPointNumber()].x);
            stringBuffer.append(" ");
            stringBuffer.append(this.virtualPoint[this.getValueVirtualPointNumber()].y);
            stringBuffer.append(" ");
            stringBuffer.append(this.macroFontSize * 4 / 3);
            stringBuffer.append(" ");
            stringBuffer.append(this.macroFontSize);
            stringBuffer.append(" 0 0 ");
            stringBuffer.append(this.getLayer());
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(this.value == null ? "" : this.value);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void exportText(ExportInterface exportInterface, MapCoordinates mapCoordinates, int n) throws IOException {
        double d = Math.abs(mapCoordinates.mapXr(this.macroFontSize, this.macroFontSize) - mapCoordinates.mapXr(0.0, 0.0));
        if (n < 0 || n == this.getLayer()) {
            if (this.name != null && !this.name.equals("")) {
                exportInterface.exportAdvText(mapCoordinates.mapX(this.virtualPoint[this.getNameVirtualPointNumber()].x, this.virtualPoint[this.getNameVirtualPointNumber()].y), mapCoordinates.mapY(this.virtualPoint[this.getNameVirtualPointNumber()].x, this.virtualPoint[this.getNameVirtualPointNumber()].y), (int)d, (int)(d * 12.0 / 7.0 + 0.5), this.macroFont, false, false, false, 0, this.getLayer(), this.name);
            }
            if (this.value != null && !this.value.equals("")) {
                exportInterface.exportAdvText(mapCoordinates.mapX(this.virtualPoint[this.getValueVirtualPointNumber()].x, this.virtualPoint[this.getValueVirtualPointNumber()].y), mapCoordinates.mapY(this.virtualPoint[this.getValueVirtualPointNumber()].x, this.virtualPoint[this.getValueVirtualPointNumber()].y), (int)d, (int)(d * 12.0 / 7.0 + 0.5), this.macroFont, false, false, false, 0, this.getLayer(), this.value);
            }
        }
    }

    public boolean checkText(int n, int n2) {
        return !"".equals(this.name) && GeometricDistances.pointInRectangle(this.virtualPoint[this.getNameVirtualPointNumber()].x, this.virtualPoint[this.getNameVirtualPointNumber()].y, this.t_w1, this.t_th, n, n2) || !"".equals(this.value) && GeometricDistances.pointInRectangle(this.virtualPoint[this.getValueVirtualPointNumber()].x, this.virtualPoint[this.getValueVirtualPointNumber()].y, this.t_w2, this.t_th, n, n2);
    }

    public void setValue(String[] stringArray, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 8;
        this.changed = true;
        if (stringArray[0].equals("TY")) {
            if (n < 9) {
                IOException iOException = new IOException("bad arguments on TY");
                throw iOException;
            }
            this.virtualPoint[this.getValueVirtualPointNumber()].x = Integer.parseInt(stringArray[1]);
            this.virtualPoint[this.getValueVirtualPointNumber()].y = Integer.parseInt(stringArray[2]);
            this.macroFont = stringArray[8].equals("*") ? "Courier New" : stringArray[8].replaceAll("\\+\\+", " ");
            this.setMacroFontSize(Integer.parseInt(stringArray[4]));
            while (n2 < n - 1) {
                stringBuffer.append(stringArray[++n2]);
                if (n2 >= n - 1) continue;
                stringBuffer.append(" ");
            }
        } else {
            IOException iOException = new IOException("Invalid primitive: " + stringArray[0] + " programming error?");
            throw iOException;
        }
        this.value = stringBuffer.toString();
    }

    public void setName(String[] stringArray, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 8;
        this.changed = true;
        if (stringArray[0].equals("TY")) {
            if (n < 9) {
                IOException iOException = new IOException("bad arguments on TY");
                throw iOException;
            }
            this.virtualPoint[this.getNameVirtualPointNumber()].x = Integer.parseInt(stringArray[1]);
            this.virtualPoint[this.getNameVirtualPointNumber()].y = Integer.parseInt(stringArray[2]);
            while (n2 < n - 1) {
                stringBuffer.append(stringArray[++n2]);
                if (n2 >= n - 1) continue;
                stringBuffer.append(" ");
            }
        } else {
            IOException iOException = new IOException("Invalid primitive:" + stringArray[0] + " programming error?");
            throw iOException;
        }
        this.name = stringBuffer.toString();
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public PointG getFirstPoint() {
        return this.virtualPoint[0];
    }

    public void movePrimitive(int n, int n2) {
        int n3 = this.getControlPointNumber();
        for (int i = 0; i < n3; ++i) {
            this.virtualPoint[i].x += n;
            this.virtualPoint[i].y += n2;
        }
        this.changed = true;
    }

    public void mirrorPrimitive(int n) {
        int n2 = this.getControlPointNumber();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.virtualPoint[i].x;
            this.virtualPoint[i].x = 2 * n - n3;
        }
        this.changed = true;
    }

    public void rotatePrimitive(boolean bl, int n, int n2) {
        int n3 = this.getControlPointNumber();
        PointG pointG = new PointG();
        PointG pointG2 = new PointG();
        pointG2.x = n;
        pointG2.y = n2;
        for (int i = 0; i < n3; ++i) {
            pointG.x = this.virtualPoint[i].x;
            pointG.y = this.virtualPoint[i].y;
            if (bl) {
                this.virtualPoint[i].x = pointG2.x + pointG.y - pointG2.y;
                this.virtualPoint[i].y = pointG2.y - (pointG.x - pointG2.x);
                continue;
            }
            this.virtualPoint[i].x = pointG2.x - (pointG.y - pointG2.y);
            this.virtualPoint[i].y = pointG2.y + pointG.x - pointG2.x;
        }
        this.changed = true;
    }

    public void setDrawOnlyLayer(int n) {
    }

    public boolean containsLayer(int n) {
        return n == this.layer;
    }

    public int getMaxLayer() {
        return this.layer;
    }

    public final void setSelected(boolean bl) {
        this.selectedState = bl;
    }

    public final boolean getSelected() {
        return this.selectedState;
    }

    public final int getLayer() {
        return this.layer;
    }

    public void parseLayer(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        this.layer = n < 0 || n >= 16 ? 0 : n;
        this.changed = true;
    }

    public final void setLayer(int n) {
        this.layer = n < 0 || n >= 16 ? 0 : n;
        this.changed = true;
    }

    protected final boolean selectLayer(GraphicsInterface graphicsInterface, Vector vector) {
        if (this.old_layer != this.layer || this.changed) {
            if (this.layer >= vector.size()) {
                this.layer = vector.size() - 1;
            }
            this.currentLayer = (LayerDesc)vector.get(this.layer);
            this.old_layer = this.layer;
        }
        if (!this.currentLayer.isVisible) {
            return false;
        }
        if (this.selectedState) {
            graphicsInterface.activateSelectColor(this.currentLayer);
        } else if (graphicsInterface.getColor() != this.currentLayer.getColor() || oldalpha != this.alpha) {
            graphicsInterface.setColor(this.currentLayer.getColor());
            oldalpha = this.alpha = this.currentLayer.getAlpha();
            graphicsInterface.setAlpha(this.alpha);
        }
        return true;
    }

    public void drawHandles(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates) {
        graphicsInterface.setColor(graphicsInterface.getColor().red());
        graphicsInterface.applyStroke(2.0f, 0);
        this.mult = graphicsInterface.getScreenDensity() / 112.0f;
        int n = Math.round(this.mult * 10.0f);
        int n2 = Math.round(this.mult * 10.0f);
        for (int i = 0; i < this.getControlPointNumber(); ++i) {
            int n3;
            int n4;
            if (!this.testIfValidHandle(i) || !graphicsInterface.hitClip((n4 = mapCoordinates.mapX(this.virtualPoint[i].x, this.virtualPoint[i].y)) - n / 2, (n3 = mapCoordinates.mapY(this.virtualPoint[i].x, this.virtualPoint[i].y)) - n2 / 2, n, n2)) continue;
            graphicsInterface.fillRect(n4 - n / 2, n3 - n2 / 2, n, n2);
        }
    }

    public int onHandle(MapCoordinates mapCoordinates, int n, int n2) {
        int n3 = 5;
        int n4 = Math.round(this.mult * 10.0f / 2.0f);
        int n5 = Math.round(this.mult * 10.0f / 2.0f);
        for (int i = 0; i < this.getControlPointNumber(); ++i) {
            if (!this.testIfValidHandle(i)) continue;
            int n6 = mapCoordinates.mapX(this.virtualPoint[i].x, this.virtualPoint[i].y);
            int n7 = mapCoordinates.mapY(this.virtualPoint[i].x, this.virtualPoint[i].y);
            if (!GeometricDistances.pointInRectangle(n6 - n4 - Math.round(this.mult * (float)n3), n7 - n5 - Math.round(this.mult * (float)n3), Math.round(this.mult * (float)(10 + 2 * n3)), Math.round(this.mult * (float)(10 + 2 * n3)), n, n2)) continue;
            return i;
        }
        return -1;
    }

    public boolean selectRect(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.getControlPointNumber(); ++i) {
            if (!this.testIfValidHandle(i)) continue;
            int n5 = this.virtualPoint[i].x;
            int n6 = this.virtualPoint[i].y;
            if (n > n5 || n5 >= n + n3 || n2 > n6 || n6 >= n2 + n4) continue;
            this.setSelected(true);
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null && this.name.length() != 0;
    }

    public boolean hasValue() {
        return this.value != null && this.value.length() != 0;
    }

    protected boolean testIfValidHandle(int n) {
        if (n == this.getNameVirtualPointNumber()) {
            if (this.name == null) {
                return false;
            }
            if (this.name.length() == 0) {
                return false;
            }
        }
        if (n == this.getValueVirtualPointNumber()) {
            if (this.value == null) {
                return false;
            }
            if (this.value.length() == 0) {
                return false;
            }
        }
        return true;
    }

    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> vector = new Vector<ParameterDescription>(10);
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.name == null ? "" : this.name;
        parameterDescription.description = Globals.messages.getString("ctrl_name");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.value == null ? "" : this.value;
        parameterDescription.description = Globals.messages.getString("ctrl_value");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = new LayerInfo(this.layer);
        parameterDescription.description = Globals.messages.getString("ctrl_layer");
        vector.add(parameterDescription);
        return vector;
    }

    public int setControls(Vector<ParameterDescription> vector) {
        int n = 0;
        this.changed = true;
        ParameterDescription parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof String) {
            this.name = (String)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n);
        ++n;
        if (parameterDescription.parameter instanceof String) {
            this.value = (String)parameterDescription.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n);
        if (parameterDescription.parameter instanceof LayerInfo) {
            this.layer = ((LayerInfo)parameterDescription.parameter).getLayer();
        } else {
            System.out.println("Warning: unexpected parameter! (layer)");
        }
        return ++n;
    }

    public boolean needsHoles() {
        return false;
    }

    public void setDrawOnlyPads(boolean bl) {
    }

    public abstract void draw(GraphicsInterface var1, MapCoordinates var2, Vector var3);

    public abstract void parseTokens(String[] var1, int var2) throws IOException;

    public abstract int getDistanceToPoint(int var1, int var2);

    public abstract int getControlPointNumber();

    public abstract String toString(boolean var1);

    public abstract void export(ExportInterface var1, MapCoordinates var2) throws IOException;

    public abstract int getNameVirtualPointNumber();

    public abstract int getValueVirtualPointNumber();

    public DimensionG getSize() {
        GraphicPrimitive graphicPrimitive = this;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < graphicPrimitive.getControlPointNumber(); ++i) {
            if (i == graphicPrimitive.getNameVirtualPointNumber() || i == graphicPrimitive.getValueVirtualPointNumber()) continue;
            for (int j = i + 1; j < graphicPrimitive.getControlPointNumber(); ++j) {
                if (j == graphicPrimitive.getNameVirtualPointNumber() || j == graphicPrimitive.getValueVirtualPointNumber()) continue;
                n = Math.abs(graphicPrimitive.virtualPoint[i].x - graphicPrimitive.virtualPoint[j].x);
                n2 = Math.abs(graphicPrimitive.virtualPoint[i].y - graphicPrimitive.virtualPoint[j].y);
            }
        }
        return new DimensionG(n, n2);
    }

    public PointG getPosition() {
        GraphicPrimitive graphicPrimitive = this;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < graphicPrimitive.getControlPointNumber(); ++i) {
            if (i == graphicPrimitive.getNameVirtualPointNumber() || i == graphicPrimitive.getValueVirtualPointNumber()) continue;
            if (graphicPrimitive.virtualPoint[i].x < n) {
                n = graphicPrimitive.virtualPoint[i].x;
            }
            if (graphicPrimitive.virtualPoint[i].y >= n2) continue;
            n2 = graphicPrimitive.virtualPoint[i].y;
        }
        return new PointG(n, n2);
    }

    public StringBuffer roundIntelligently(double d) {
        StringBuffer stringBuffer;
        if (Math.abs(d - (double)Math.round(d)) < 1.0E-5) {
            int n = (int)Math.round(d);
            stringBuffer = new StringBuffer("" + n);
        } else {
            stringBuffer = new StringBuffer("" + d);
        }
        return stringBuffer;
    }
}

