/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.primitives;

import java.util.Vector;
import net.sourceforge.fidocadj.dialogs.ArrowInfo;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.export.PointPr;
import net.sourceforge.fidocadj.geom.GeometricDistances;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.graphic.PolygonInterface;

public final class Arrow {
    public static final int flagLimiter = 1;
    public static final int flagEmpty = 2;
    private float arrowLength = 3.0f;
    private float arrowHalfWidth = 1.0f;
    private static final float roundTolerance = 1.0E-5f;
    MapCoordinates m;
    private int arrowStyle;
    private boolean arrowStart;
    private boolean arrowEnd;
    private int h;
    private int l;

    public boolean atLeastOneArrow() {
        return this.arrowStart || this.arrowEnd;
    }

    public String createArrowTokens() {
        int n = (this.arrowStart ? 1 : 0) | (this.arrowEnd ? 2 : 0);
        Object object = new String();
        object = (String)object + n + " ";
        object = (String)object + this.arrowStyle + " ";
        object = Math.abs(this.arrowLength - (float)Math.round(this.arrowLength)) < 1.0E-5f ? (String)object + new Integer(Math.round(this.arrowLength)) : (String)object + this.arrowLength;
        object = (String)object + " ";
        object = Math.abs(this.arrowHalfWidth - (float)Math.round(this.arrowHalfWidth)) < 1.0E-5f ? (String)object + new Integer(Math.round(this.arrowHalfWidth)) : (String)object + this.arrowHalfWidth;
        return object;
    }

    public boolean isArrowStart() {
        return this.arrowStart;
    }

    public void setArrowStart(boolean bl) {
        this.arrowStart = bl;
    }

    public boolean isArrowEnd() {
        return this.arrowEnd;
    }

    public void setArrowEnd(boolean bl) {
        this.arrowEnd = bl;
    }

    public int getArrowStyle() {
        return this.arrowStyle;
    }

    public void setArrowStyle(int n) {
        this.arrowStyle = n;
    }

    public float getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(float f) {
        this.arrowLength = f;
    }

    public float getArrowHalfWidth() {
        return this.arrowHalfWidth;
    }

    public void setArrowHalfWidth(float f) {
        this.arrowHalfWidth = f;
    }

    public int parseTokens(String[] stringArray, int n) {
        int n2;
        int n3 = n;
        this.arrowStart = ((n2 = Integer.parseInt(stringArray[n3++])) & 1) != 0;
        this.arrowEnd = (n2 & 2) != 0;
        this.arrowStyle = Integer.parseInt(stringArray[n3++]);
        this.arrowLength = Float.parseFloat(stringArray[n3++]);
        this.arrowHalfWidth = Float.parseFloat(stringArray[n3++]);
        return n3;
    }

    public int prepareCoordinateMapping(MapCoordinates mapCoordinates) {
        this.m = mapCoordinates;
        this.h = Math.abs(mapCoordinates.mapXi(this.arrowHalfWidth, this.arrowHalfWidth, false) - mapCoordinates.mapXi(0.0, 0.0, false));
        this.l = Math.abs(mapCoordinates.mapXi(this.arrowLength, this.arrowLength, false) - mapCoordinates.mapXi(0.0, 0.0, false));
        if (this.arrowHalfWidth < 0.0f) {
            this.h = -this.h;
        }
        if (this.arrowLength < 0.0f) {
            this.l = -this.l;
        }
        return this.h;
    }

    public Vector<ParameterDescription> getControlsForArrow(Vector<ParameterDescription> vector) {
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.isArrowStart();
        parameterDescription.description = Globals.messages.getString("ctrl_arrow_start");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = this.isArrowEnd();
        parameterDescription.description = Globals.messages.getString("ctrl_arrow_end");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = Float.valueOf(this.getArrowLength());
        parameterDescription.description = Globals.messages.getString("ctrl_arrow_length");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = Float.valueOf(this.getArrowHalfWidth());
        parameterDescription.description = Globals.messages.getString("ctrl_arrow_half_width");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        parameterDescription = new ParameterDescription();
        parameterDescription.parameter = new ArrowInfo(this.getArrowStyle());
        parameterDescription.description = Globals.messages.getString("ctrl_arrow_style");
        parameterDescription.isExtension = true;
        vector.add(parameterDescription);
        return vector;
    }

    public int setParametersForArrow(Vector<ParameterDescription> vector, int n) {
        int n2 = n;
        ParameterDescription parameterDescription = vector.get(n2++);
        if (parameterDescription.parameter instanceof Boolean) {
            this.setArrowStart((Boolean)parameterDescription.parameter);
        } else {
            System.out.println("Warning: 1-unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n2++);
        if (parameterDescription.parameter instanceof Boolean) {
            this.setArrowEnd((Boolean)parameterDescription.parameter);
        } else {
            System.out.println("Warning: 2-unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n2++);
        if (parameterDescription.parameter instanceof Float) {
            this.setArrowLength(((Float)parameterDescription.parameter).floatValue());
        } else {
            System.out.println("Warning: 3-unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n2++);
        if (parameterDescription.parameter instanceof Float) {
            this.setArrowHalfWidth(((Float)parameterDescription.parameter).floatValue());
        } else {
            System.out.println("Warning: 4-unexpected parameter!" + parameterDescription);
        }
        parameterDescription = vector.get(n2++);
        if (parameterDescription.parameter instanceof ArrowInfo) {
            this.setArrowStyle(((ArrowInfo)parameterDescription.parameter).style);
        } else {
            System.out.println("Warning: 5-unexpected parameter!" + parameterDescription);
        }
        return n2;
    }

    public PointG drawArrowPixels(GraphicsInterface graphicsInterface, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.h = n6;
        this.l = n5;
        this.arrowStyle = n7;
        return this.drawArrow(graphicsInterface, n, n2, n3, n4);
    }

    public boolean isInArrow(int n, int n2, int n3, int n4, int n5, int n6, PointG pointG) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        PointPr[] pointPrArray = this.calculateArrowPoints(n3, n4, n5, n6);
        nArray[0] = n3;
        nArray[1] = (int)Math.round(pointPrArray[1].x);
        nArray[2] = (int)Math.round(pointPrArray[2].x);
        nArray2[0] = n4;
        nArray2[1] = (int)Math.round(pointPrArray[1].y);
        nArray2[2] = (int)Math.round(pointPrArray[2].y);
        if (pointG != null) {
            pointG.x = (int)Math.round(pointPrArray[0].x);
            pointG.y = (int)Math.round(pointPrArray[0].y);
        }
        return GeometricDistances.pointInPolygon(nArray, nArray2, 3, n, n2);
    }

    private PointPr[] calculateArrowPoints(int n, int n2, int n3, int n4) {
        double d = this.getArrowAngle(n, n2, n3, n4);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        PointPr[] pointPrArray = new PointPr[5];
        pointPrArray[0] = new PointPr((double)n - (double)this.l * d2, (double)n2 - (double)this.l * d3);
        pointPrArray[1] = new PointPr(pointPrArray[0].x - (double)this.h * d3, pointPrArray[0].y + (double)this.h * d2);
        pointPrArray[2] = new PointPr(pointPrArray[0].x + (double)this.h * d3, pointPrArray[0].y - (double)this.h * d2);
        if ((this.arrowStyle & 1) != 0) {
            pointPrArray[3] = new PointPr((double)n - (double)this.h * d3, (double)n2 + (double)this.h * d2);
            pointPrArray[4] = new PointPr((double)n + (double)this.h * d3, (double)n2 - (double)this.h * d2);
        }
        return pointPrArray;
    }

    private double getArrowAngle(int n, int n2, int n3, int n4) {
        double d = n == n3 ? 1.5707963267948966 + ((double)(n2 - n4) < 0.0 ? 0.0 : Math.PI) : Math.atan((double)(n2 - n4) / (double)(n - n3));
        return d += (double)(n - n3) > 0.0 ? 0.0 : Math.PI;
    }

    public PointG drawArrow(GraphicsInterface graphicsInterface, int n, int n2, int n3, int n4) {
        PointPr[] pointPrArray = this.calculateArrowPoints(n, n2, n3, n4);
        PolygonInterface polygonInterface = graphicsInterface.createPolygon();
        polygonInterface.addPoint(n, n2);
        polygonInterface.addPoint((int)Math.round(pointPrArray[1].x), (int)Math.round(pointPrArray[1].y));
        polygonInterface.addPoint((int)Math.round(pointPrArray[2].x), (int)Math.round(pointPrArray[2].y));
        if (this.m != null) {
            this.m.trackPoint(n, n2);
            this.m.trackPoint(pointPrArray[1].x, pointPrArray[1].y);
            this.m.trackPoint(pointPrArray[2].x, pointPrArray[2].y);
        }
        if ((this.arrowStyle & 2) == 0) {
            graphicsInterface.fillPolygon(polygonInterface);
        } else {
            graphicsInterface.drawPolygon(polygonInterface);
        }
        if ((this.arrowStyle & 1) != 0) {
            graphicsInterface.drawLine((int)Math.round(pointPrArray[3].x), (int)Math.round(pointPrArray[3].y), (int)Math.round(pointPrArray[4].x), (int)Math.round(pointPrArray[4].y));
            if (this.m != null) {
                this.m.trackPoint(pointPrArray[3].x, pointPrArray[3].y);
                this.m.trackPoint(pointPrArray[4].x, pointPrArray[4].y);
            }
        }
        return new PointG((int)pointPrArray[0].x, (int)pointPrArray[0].y);
    }
}

