/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.macropicker.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.fidocadj.librarymodel.Category;
import net.sourceforge.fidocadj.librarymodel.Library;
import net.sourceforge.fidocadj.librarymodel.LibraryModel;
import net.sourceforge.fidocadj.librarymodel.event.AddEvent;
import net.sourceforge.fidocadj.librarymodel.event.KeyChangeEvent;
import net.sourceforge.fidocadj.librarymodel.event.LibraryListener;
import net.sourceforge.fidocadj.librarymodel.event.RemoveEvent;
import net.sourceforge.fidocadj.librarymodel.event.RenameEvent;
import net.sourceforge.fidocadj.macropicker.model.AbstractMacroTreeNode;
import net.sourceforge.fidocadj.macropicker.model.MacroTreeNode;
import net.sourceforge.fidocadj.macropicker.model.NodeFilterInterface;
import net.sourceforge.fidocadj.primitives.MacroDesc;

public class MacroTreeModel
implements TreeModel,
LibraryListener {
    public static final int ROOT = 0;
    public static final int LIBRARY = 1;
    public static final int CATEGORY = 2;
    public static final int MACRO = 3;
    private RootNode rootNode;
    private final LibraryModel libraryModel;
    private final List<TreeModelListener> listeners;
    private HashMap<TreePath, AbstractMacroTreeNode> libraryNodeMap;
    private String filterWord;

    public MacroTreeModel(LibraryModel libraryModel) {
        this.libraryModel = libraryModel;
        this.listeners = new ArrayList<TreeModelListener>();
        this.createMap();
        this.synchronizeTree(null);
        this.fireChanged();
    }

    public void setFilterWord(String string) {
        this.filterWord = string;
        if (string == null || string.length() == 0) {
            this.synchronizeTree(null);
            this.filterWord = null;
            this.fireChanged();
        } else {
            final Locale locale = new Locale("en");
            final String string2 = string.toLowerCase(locale);
            this.synchronizeTree(new NodeFilterInterface(){

                @Override
                public boolean accept(MacroTreeNode macroTreeNode) {
                    String[] stringArray = string2.trim().split(" ");
                    int n = 0;
                    for (String string : stringArray) {
                        if (0 <= macroTreeNode.toString().toLowerCase(locale).indexOf(string)) {
                            ++n;
                            continue;
                        }
                        if (string.length() != 0) continue;
                        ++n;
                    }
                    return stringArray.length == n;
                }
            });
            this.fireChanged();
        }
    }

    private void resetSearchMode() {
        this.filterWord = null;
    }

    public boolean isSearchMode() {
        return this.filterWord != null;
    }

    private void createMap() {
        this.libraryNodeMap = new HashMap();
    }

    public int getNodeType(TreePath treePath) {
        if (treePath == null) {
            return -1;
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof RootNode) {
            return 0;
        }
        if (object instanceof LibraryNode) {
            return 1;
        }
        if (object instanceof CategoryNode) {
            return 2;
        }
        if (object instanceof MacroNode) {
            return 3;
        }
        return -1;
    }

    public String getFilterWord() {
        return this.filterWord;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        return ((TreeNode)object).getChildAt(n);
    }

    @Override
    public int getChildCount(Object object) {
        return ((TreeNode)object).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((TreeNode)object).getIndex((TreeNode)object2);
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((TreeNode)object).isLeaf();
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public MacroDesc getMacro(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Object object = this.getPathComponentAt(treePath, 3);
        if (object instanceof MacroNode) {
            return ((MacroNode)object).getMacro();
        }
        return null;
    }

    public Category getCategory(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Object object = this.getPathComponentAt(treePath, 2);
        if (object instanceof CategoryNode) {
            return ((CategoryNode)object).getCategory();
        }
        return null;
    }

    public Library getLibrary(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Object object = this.getPathComponentAt(treePath, 1);
        if (object instanceof LibraryNode) {
            return ((LibraryNode)object).getLibrary();
        }
        return null;
    }

    private Object getPathComponentAt(TreePath treePath, int n) {
        if (n <= treePath.getPathCount() - 1) {
            return treePath.getPathComponent(n);
        }
        return null;
    }

    private void fireChanged() {
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.rootNode), null, null));
        }
    }

    private TreePath createAbsolutePath(TreeNode treeNode) {
        TreeNode treeNode2 = treeNode.getParent();
        if (treeNode2 == null) {
            return new TreePath(treeNode);
        }
        return this.createAbsolutePath(treeNode2).pathByAddingChild(treeNode);
    }

    @Override
    public void libraryNodeRenamed(RenameEvent renameEvent) {
        Object object = renameEvent.getRenamedNode();
        if (object == null) {
            this.fireTreeNodeChanged(new TreePath(this.rootNode));
        } else {
            for (TreePath treePath : this.libraryNodeMap.keySet()) {
                if (treePath.getLastPathComponent() != object) continue;
                TreeNode treeNode = this.libraryNodeMap.get(treePath);
                TreePath treePath2 = this.createAbsolutePath(treeNode);
                this.fireTreeNodeChanged(treePath2);
            }
        }
    }

    @Override
    public void libraryNodeRemoved(RemoveEvent removeEvent) {
        this.resetSearchMode();
        this.synchronizeTree(null);
        Object object = removeEvent.getParentNode();
        if (object == null) {
            this.fireTreeStructureChanged(new TreePath(this.rootNode));
        } else {
            for (TreePath treePath : this.libraryNodeMap.keySet()) {
                if (treePath.getLastPathComponent() != object) continue;
                TreeNode treeNode = this.libraryNodeMap.get(treePath);
                TreePath treePath2 = this.createAbsolutePath(treeNode);
                this.fireTreeStructureChanged(treePath2);
            }
        }
    }

    @Override
    public void libraryNodeAdded(AddEvent addEvent) {
        this.resetSearchMode();
        this.synchronizeTree(null);
        Object object = addEvent.getParentNode();
        if (object == null) {
            this.fireTreeStructureChanged(new TreePath(this.rootNode));
        } else {
            for (TreePath treePath : this.libraryNodeMap.keySet()) {
                if (treePath.getLastPathComponent() != object) continue;
                TreeNode treeNode = this.libraryNodeMap.get(treePath);
                TreePath treePath2 = this.createAbsolutePath(treeNode);
                this.fireTreeStructureChanged(treePath2);
            }
        }
    }

    @Override
    public void libraryNodeKeyChanged(KeyChangeEvent keyChangeEvent) {
    }

    @Override
    public void libraryLoaded() {
        this.resetSearchMode();
        this.synchronizeTree(null);
        this.fireChanged();
    }

    private void fireTreeNodeChanged(TreePath treePath) {
        if (treePath != null) {
            for (TreeModelListener treeModelListener : this.listeners) {
                treeModelListener.treeNodesChanged(new TreeModelEvent((Object)this, treePath));
            }
        }
    }

    private void fireTreeStructureChanged(TreePath treePath) {
        if (treePath != null) {
            for (TreeModelListener treeModelListener : this.listeners) {
                treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, treePath));
            }
        }
    }

    private void synchronizeTree(NodeFilterInterface nodeFilterInterface) {
        HashMap<TreePath, AbstractMacroTreeNode> hashMap = this.libraryNodeMap;
        this.libraryNodeMap = new HashMap();
        if (this.rootNode == null) {
            this.rootNode = new RootNode();
        }
        if (nodeFilterInterface == null) {
            this.rootNode.setLabel("FidoCadJ");
        } else {
            this.rootNode.setLabel("Search results...");
        }
        this.rootNode.clearChildNodes();
        for (Library library : this.libraryModel.getAllLibraries()) {
            LibraryNode libraryNode;
            TreePath treePath = new TreePath(library);
            if (this.libraryNodeMap.containsKey(treePath)) {
                libraryNode = (LibraryNode)hashMap.get(treePath);
                libraryNode.clearChildNodes();
            } else {
                libraryNode = new LibraryNode(library);
            }
            for (Category category : library.getAllCategories()) {
                CategoryNode categoryNode;
                if (category.isHidden()) continue;
                TreePath treePath2 = treePath.pathByAddingChild(category);
                if (hashMap.containsKey(treePath2)) {
                    categoryNode = (CategoryNode)hashMap.get(treePath2);
                    categoryNode.clearChildNodes();
                } else {
                    categoryNode = new CategoryNode(category);
                }
                for (MacroDesc macroDesc : category.getAllMacros()) {
                    TreePath treePath3 = treePath2.pathByAddingChild(macroDesc);
                    MacroNode macroNode = hashMap.containsKey(treePath3) ? (MacroNode)hashMap.get(treePath3) : new MacroNode(macroDesc);
                    if (nodeFilterInterface != null && !nodeFilterInterface.accept(macroNode)) continue;
                    categoryNode.addMacroNode(macroNode);
                    this.libraryNodeMap.put(treePath3, macroNode);
                }
                if (nodeFilterInterface != null && categoryNode.getChildCount() == 0) continue;
                libraryNode.addCategoryNode(categoryNode);
                this.libraryNodeMap.put(treePath2, categoryNode);
            }
            if (nodeFilterInterface != null && libraryNode.getChildCount() == 0) continue;
            this.rootNode.addLibraryNode(libraryNode);
            this.libraryNodeMap.put(treePath, libraryNode);
        }
        this.rootNode.sortTree();
    }

    private class RootNode
    extends AbstractMacroTreeNode {
        RootNode() {
            this.parent = null;
            this.label = "FidoCadJ";
            this.icon = MetalIconFactory.getTreeComputerIcon();
        }

        RootNode(String string) {
            this.parent = null;
            this.label = string;
            this.icon = MetalIconFactory.getTreeComputerIcon();
        }

        RootNode(String string, Icon icon) {
            this.parent = null;
            this.label = string;
            this.icon = icon;
        }

        public void addLibraryNode(LibraryNode libraryNode) {
            this.childNodes.add(libraryNode);
            libraryNode.setParent(this);
        }

        public void setLabel(String string) {
            this.label = string;
        }
    }

    private static class LibraryNode
    extends AbstractMacroTreeNode
    implements Comparable<LibraryNode> {
        private final Library library;

        LibraryNode(Library library) {
            this.library = library;
            this.icon = library.isStdLib() ? MetalIconFactory.getTreeHardDriveIcon() : MetalIconFactory.getTreeFloppyDriveIcon();
        }

        public Library getLibrary() {
            return this.library;
        }

        public void addCategoryNode(CategoryNode categoryNode) {
            this.childNodes.add(categoryNode);
            categoryNode.setParent(this);
        }

        @Override
        public int compareTo(LibraryNode libraryNode) {
            Library library = this.library;
            Library library2 = libraryNode.getLibrary();
            if (library.isStdLib() == library2.isStdLib()) {
                return library.getName().compareToIgnoreCase(library2.getName());
            }
            if (library.isStdLib()) {
                return -1;
            }
            return 1;
        }

        @Override
        public String toString() {
            return this.library.getName();
        }

        public boolean equals(Object object) {
            if (object instanceof LibraryNode) {
                return this.compareTo((LibraryNode)object) == 0;
            }
            return false;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }
    }

    private static class CategoryNode
    extends AbstractMacroTreeNode
    implements Comparable<CategoryNode> {
        private final Category category;

        CategoryNode(Category category) {
            this.category = category;
            this.icon = null;
        }

        public Category getCategory() {
            return this.category;
        }

        public void addMacroNode(MacroNode macroNode) {
            this.childNodes.add(macroNode);
            macroNode.setParent(this);
        }

        @Override
        public int compareTo(CategoryNode categoryNode) {
            Category category = this.category;
            Category category2 = categoryNode.getCategory();
            return category.getName().compareToIgnoreCase(category2.getName());
        }

        @Override
        public String toString() {
            return this.category.getName();
        }

        public boolean equals(Object object) {
            if (object instanceof CategoryNode) {
                return this.compareTo((CategoryNode)object) == 0;
            }
            return false;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }
    }

    private class MacroNode
    extends AbstractMacroTreeNode
    implements Comparable<MacroNode> {
        MacroDesc macro;

        MacroNode(MacroDesc macroDesc) {
            this.macro = macroDesc;
            this.icon = null;
        }

        public MacroDesc getMacro() {
            return this.macro;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public int compareTo(MacroNode macroNode) {
            MacroDesc macroDesc = this.macro;
            MacroDesc macroDesc2 = macroNode.getMacro();
            int n = macroDesc.name.compareToIgnoreCase(macroDesc2.name);
            if (n == 0) {
                n = macroDesc.key.compareToIgnoreCase(macroDesc2.key);
            }
            return n;
        }

        @Override
        public String toString() {
            return this.macro.name;
        }

        public boolean equals(Object object) {
            if (object instanceof MacroNode) {
                return this.compareTo((MacroNode)object) == 0;
            }
            return false;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }
    }
}

