/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.macropicker.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import net.sourceforge.fidocadj.macropicker.model.MacroTreeNode;

public abstract class AbstractMacroTreeNode
implements MacroTreeNode {
    protected Vector<AbstractMacroTreeNode> childNodes = new Vector();
    protected TreeNode parent;
    protected String label = "";
    protected Icon icon;

    AbstractMacroTreeNode() {
    }

    public Enumeration children() {
        return this.childNodes.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.childNodes.get(n);
    }

    @Override
    public int getChildCount() {
        return this.childNodes.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.childNodes.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode treeNode) {
        this.parent = treeNode;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void sortTree() {
        Collections.sort(this.childNodes, new Comparator<AbstractMacroTreeNode>(){

            @Override
            public int compare(AbstractMacroTreeNode abstractMacroTreeNode, AbstractMacroTreeNode abstractMacroTreeNode2) {
                return abstractMacroTreeNode.toString().compareTo(abstractMacroTreeNode2.toString());
            }
        });
        for (AbstractMacroTreeNode abstractMacroTreeNode : this.childNodes) {
            abstractMacroTreeNode.sortTree();
        }
    }

    public void removeChildNode(TreeNode treeNode) {
        this.childNodes.remove(treeNode);
    }

    public int getIndexAt(TreeNode treeNode) {
        return this.childNodes.indexOf(treeNode);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String toString() {
        return this.label;
    }

    public void clearChildNodes() {
        this.childNodes.clear();
    }
}

