/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.macropicker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.LineMetrics;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import net.sourceforge.fidocadj.globals.Globals;

public class SearchField
extends JTextField
implements FocusListener {
    private static final Border CANCEL_BORDER = new CancelBorder();
    private boolean sendsNotificationForEachKeystroke = false;
    private static final boolean showingPlaceholderText = false;
    private boolean armed = false;
    private String placeholderText;

    public SearchField(String string) {
        super(15);
        this.putClientProperty("JTextField.style", "search");
        this.putClientProperty("Quaqua.TextField.style", "search");
        this.placeholderText = string;
        this.initBorder();
        this.initKeyListener();
        this.addFocusListener(this);
    }

    public SearchField() {
        this("Search");
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (Globals.weAreOnAMac) {
            Rectangle rectangle = this.getBounds();
            int n = rectangle.x + 4;
            int n2 = rectangle.y + 4;
            int n3 = rectangle.width - 8;
            int n4 = rectangle.height - 8;
            graphics.setColor(this.getBackground());
            graphics.fillOval(n - 2, n2, n4, n4);
            graphics.fillOval(n + n3 - n4 + 2, n2, n4, n4);
            graphics.fillRect(n + n4 / 2, n2, n3 - n4, n4);
        }
        super.paintComponent(graphics);
        this.showPlaceHolder(graphics);
    }

    private void showPlaceHolder(Graphics graphics) {
        Font font = graphics.getFont();
        LineMetrics lineMetrics = font.getLineMetrics(this.placeholderText, graphics.getFontMetrics().getFontRenderContext());
        float f = lineMetrics.getHeight();
        int n = this.getBorder().getBorderInsets((Component)this).left;
        int n2 = (int)((double)(this.getHeight() - 4) / 2.0 + (double)f / 2.0);
        if (!this.isFocusOwner() && this.getText().length() == 0) {
            graphics.setColor(Color.GRAY);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawString(this.placeholderText, n, n2);
        }
    }

    private void initBorder() {
        this.setBorder(new CompoundBorder(this.getBorder(), CANCEL_BORDER));
        CancelListener cancelListener = new CancelListener();
        this.addMouseListener(cancelListener);
        this.addMouseMotionListener(cancelListener);
        this.setMaximumSize(new Dimension(5000, 30));
    }

    private void initKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    SearchField.this.cancel();
                } else if (SearchField.this.sendsNotificationForEachKeystroke) {
                    SearchField.this.maybeNotify();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (SearchField.this.isFocusOwner() && (keyEvent.getKeyCode() == 82 || keyEvent.getKeyCode() == 83)) {
                    keyEvent.consume();
                }
            }
        });
    }

    private void cancel() {
        this.setText("");
        this.postActionEvent();
    }

    private void maybeNotify() {
        this.postActionEvent();
    }

    public void setSendsNotificationForEachKeystroke(boolean bl) {
        this.sendsNotificationForEachKeystroke = bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    class CancelListener
    extends MouseInputAdapter {
        CancelListener() {
        }

        private boolean isOverButton(MouseEvent mouseEvent) {
            if (!SearchField.this.contains(mouseEvent.getPoint())) {
                return false;
            }
            Rectangle rectangle = SwingUtilities.calculateInnerArea(SearchField.this, null);
            return !rectangle.contains(mouseEvent.getPoint());
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.arm(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.arm(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.disarm();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.arm(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SearchField.this.armed) {
                SearchField.this.cancel();
            }
            this.disarm();
        }

        private void arm(MouseEvent mouseEvent) {
            SearchField.this.armed = this.isOverButton(mouseEvent) && SwingUtilities.isLeftMouseButton(mouseEvent);
            SearchField.this.repaint();
        }

        private void disarm() {
            SearchField.this.armed = false;
            SearchField.this.repaint();
        }
    }

    static class CancelBorder
    extends EmptyBorder {
        private static final Color GRAY = new Color(0.7f, 0.7f, 0.7f);

        CancelBorder() {
            super(0, 20, 0, 15);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            SearchField searchField = (SearchField)component;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n5 = n;
            int n6 = n2;
            super.paintBorder(component, graphics, n, n2, n3, n4);
            graphics2D.setColor(Color.GRAY);
            graphics2D.fillOval(n5, n6, 12, 12);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.drawLine(n5 + 6, n6 + 6, n5 + 14, n6 + 14);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillOval(n5 + 2, n6 + 2, 8, 8);
            graphics2D.setColor(searchField.armed ? Color.GRAY : GRAY);
            if (searchField.getText().length() == 0) {
                return;
            }
            int n7 = n + n3 - 14;
            int n8 = n2 + (n4 - 1 - 14) / 2;
            graphics2D.setColor(searchField.armed ? Color.GRAY : GRAY);
            graphics2D.fillOval(n7, n8, 14, 14);
            int n9 = n7 + 4;
            int n10 = n8 + 4;
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawLine(n9, n10, n9 + 6, n10 + 6);
            graphics2D.drawLine(n9, n10 + 6, n9 + 6, n10);
        }
    }
}

