/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.macropicker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.librarymodel.Category;
import net.sourceforge.fidocadj.librarymodel.Library;
import net.sourceforge.fidocadj.macropicker.MacroTree;
import net.sourceforge.fidocadj.macropicker.OperationPermissions;
import net.sourceforge.fidocadj.primitives.MacroDesc;

public class MacroTreePopupMenu
extends JPopupMenu
implements ChangeListener {
    private final MacroTree macroTree;
    private final OperationPermissions permission;
    private final JMenuItem copyMenu;
    private final JMenuItem pasteMenu;
    private final JMenuItem renameMenu;
    private final JMenuItem removeMenu;
    private final JMenuItem renkeyMenu;

    public MacroTreePopupMenu(MacroTree macroTree) {
        this.macroTree = macroTree;
        this.permission = macroTree.getOperationPermission();
        this.copyMenu = new JMenuItem(Globals.messages.getString("Copy"));
        this.pasteMenu = new JMenuItem(Globals.messages.getString("Paste"));
        this.removeMenu = new JMenuItem(Globals.messages.getString("Delete"));
        this.renameMenu = new JMenuItem(Globals.messages.getString("Rename"));
        this.renkeyMenu = new JMenuItem(Globals.messages.getString("RenKey"));
        this.add(this.copyMenu);
        this.add(this.pasteMenu);
        this.add(this.removeMenu);
        this.add(this.renameMenu);
        this.add(this.renkeyMenu);
        this.copyMenu.addActionListener(this.createCopyActionListener());
        this.pasteMenu.addActionListener(this.createPasteActionListener());
        this.removeMenu.addActionListener(this.createRemoveActionListener());
        this.renameMenu.addActionListener(this.createRenameActionListener());
        this.renkeyMenu.addActionListener(this.createRenkeyActionListener());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.copyMenu.setEnabled(this.permission.isCopyAvailable());
        this.pasteMenu.setEnabled(this.permission.isPasteAvailable());
        this.removeMenu.setEnabled(this.permission.isRemoveAvailable());
        this.renameMenu.setEnabled(this.permission.isRenameAvailable());
        this.renkeyMenu.setEnabled(this.permission.isRenKeyAvailable());
    }

    private ActionListener createRenameActionListener() {
        final MacroTree macroTree = this.macroTree;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (macroTree.getSelectedType()) {
                    case 2: {
                        MacroDesc macroDesc = macroTree.getSelectedMacro();
                        if (macroDesc == null) break;
                        macroTree.rename(macroDesc);
                        break;
                    }
                    case 1: {
                        Category category = macroTree.getSelectedCategory();
                        if (category == null) break;
                        macroTree.rename(category);
                        break;
                    }
                    case 0: {
                        Library library = macroTree.getSelectedLibrary();
                        if (library == null) break;
                        macroTree.rename(library);
                        break;
                    }
                }
            }
        };
    }

    private ActionListener createRemoveActionListener() {
        final MacroTree macroTree = this.macroTree;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (macroTree.getSelectedType()) {
                    case 2: {
                        MacroDesc macroDesc = macroTree.getSelectedMacro();
                        if (macroDesc == null) break;
                        macroTree.remove(macroDesc);
                        break;
                    }
                    case 1: {
                        Category category = macroTree.getSelectedCategory();
                        if (category == null) break;
                        macroTree.remove(category);
                        break;
                    }
                    case 0: {
                        Library library = macroTree.getSelectedLibrary();
                        if (library == null) break;
                        macroTree.remove(library);
                        break;
                    }
                }
            }
        };
    }

    private ActionListener createRenkeyActionListener() {
        final MacroTree macroTree = this.macroTree;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (macroTree.getSelectedType()) {
                    case 2: {
                        MacroDesc macroDesc = macroTree.getSelectedMacro();
                        if (macroDesc == null) break;
                        macroTree.changeKey(macroDesc);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
            }
        };
    }

    private ActionListener createCopyActionListener() {
        final MacroTree macroTree = this.macroTree;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                macroTree.setSelectedNodeToCopyTarget();
            }
        };
    }

    private ActionListener createPasteActionListener() {
        final MacroTree macroTree = this.macroTree;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                macroTree.pasteIntoSelectedNode();
            }
        };
    }
}

