/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.macropicker;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.TreePath;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.geom.DrawingSize;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.layermodel.LayerModel;
import net.sourceforge.fidocadj.librarymodel.Category;
import net.sourceforge.fidocadj.librarymodel.Library;
import net.sourceforge.fidocadj.librarymodel.LibraryModel;
import net.sourceforge.fidocadj.librarymodel.event.LibraryListenerAdapter;
import net.sourceforge.fidocadj.macropicker.ExpandableJTree;
import net.sourceforge.fidocadj.macropicker.MacroTreeCellRenderer;
import net.sourceforge.fidocadj.macropicker.MacroTreePopupMenu;
import net.sourceforge.fidocadj.macropicker.OperationPermissions;
import net.sourceforge.fidocadj.macropicker.SearchField;
import net.sourceforge.fidocadj.macropicker.model.MacroTreeModel;
import net.sourceforge.fidocadj.primitives.MacroDesc;
import net.sourceforge.fidocadj.toolbars.ChangeSelectionListener;

public class MacroTree
extends JPanel {
    public static final int LIBRARY = 0;
    public static final int CATEGORY = 1;
    public static final int MACRO = 2;
    private ExpandableJTree treeComponent;
    private SearchField searchField;
    private CircuitPanel previewPanel;
    private JScrollPane treeScrollPane;
    private LibraryModel libraryModel;
    private LayerModel layerModel;
    private MacroTreeModel macroTreeModel;
    private ChangeSelectionListener selectionListener;
    private ArrayList<ChangeListener> changeListeners;
    private TreePath copyTarget = null;
    private OperationPermissions permissionObject;

    public MacroTree(LibraryModel libraryModel, LayerModel layerModel) {
        this.libraryModel = libraryModel;
        this.layerModel = layerModel;
        this.initComponents();
    }

    private void initComponents() {
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.putClientProperty("JSplitPane.style", "thick");
        Box box = Box.createVerticalBox();
        this.setLayout(new GridLayout(1, 0));
        this.createListenerArray();
        this.createTreeView();
        this.createPreviewPanel();
        this.createSearchField();
        this.createPermissionObject();
        this.createPopupMenu();
        this.bindSearchField();
        this.bindLibraryModel();
        this.bindPreviewPanel();
        box.add(this.searchField);
        box.add(this.treeScrollPane);
        jSplitPane.setTopComponent(box);
        jSplitPane.setBottomComponent(this.previewPanel);
        jSplitPane.setResizeWeight(0.9);
        this.add(jSplitPane);
    }

    private void createListenerArray() {
        this.changeListeners = new ArrayList();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public int getSelectedType() {
        TreePath treePath = this.treeComponent.getSelectionPath();
        if (treePath == null) {
            return -1;
        }
        int n = this.macroTreeModel.getNodeType(treePath);
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public void remove(Library library) {
        if (library == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, Globals.messages.getString("remove_library_confirm") + library.getName() + "?", Globals.messages.getString("remove_library"), 0);
        if (n == 0) {
            try {
                this.libraryModel.remove(library);
            }
            catch (LibraryModel.IllegalLibraryAccessException illegalLibraryAccessException) {
                JOptionPane.showMessageDialog(null, illegalLibraryAccessException.getMessage(), Globals.messages.getString("error"), 0);
            }
        }
    }

    public void remove(Category category) {
        if (category == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, Globals.messages.getString("remove_category_confirm") + category.getName() + "?", Globals.messages.getString("remove_category"), 0);
        if (n == 0) {
            try {
                this.libraryModel.remove(category);
            }
            catch (LibraryModel.IllegalLibraryAccessException illegalLibraryAccessException) {
                JOptionPane.showMessageDialog(null, illegalLibraryAccessException.getMessage(), Globals.messages.getString("error"), 0);
            }
        }
    }

    public void remove(MacroDesc macroDesc) {
        if (macroDesc == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, Globals.messages.getString("remove_macro_confirm") + macroDesc.name + "?", Globals.messages.getString("remove_macro"), 0);
        if (n == 0) {
            try {
                this.libraryModel.remove(macroDesc);
            }
            catch (LibraryModel.IllegalLibraryAccessException illegalLibraryAccessException) {
                JOptionPane.showMessageDialog(null, illegalLibraryAccessException.getMessage(), Globals.messages.getString("error"), 0);
            }
        }
    }

    public void rename(MacroDesc macroDesc) {
        if (macroDesc == null) {
            return;
        }
        String string = JOptionPane.showInputDialog(null, Globals.messages.getString("new_macro_name"), macroDesc.name);
        if (string == null || string.equals(macroDesc.name)) {
            return;
        }
        try {
            this.libraryModel.rename(macroDesc, string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), Globals.messages.getString("error"), 0);
        }
    }

    public void rename(Category category) {
        if (category == null) {
            return;
        }
        String string = JOptionPane.showInputDialog(null, Globals.messages.getString("new_category_name"), category.getName());
        if (string == null || string.equals(category.getName())) {
            return;
        }
        try {
            this.libraryModel.rename(category, string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), Globals.messages.getString("error"), 0);
        }
    }

    public void rename(Library library) {
        if (library == null) {
            return;
        }
        String string = JOptionPane.showInputDialog(null, Globals.messages.getString("new_library_name"), library.getName());
        if (string == null || string.equals(library.getName())) {
            return;
        }
        try {
            this.libraryModel.rename(library, string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), Globals.messages.getString("error"), 0);
        }
    }

    public void changeKey(MacroDesc macroDesc) {
        if (macroDesc == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, Globals.messages.getString("ChangeKeyWarning"), Globals.messages.getString("RenKey"), 0);
        if (n == 1) {
            return;
        }
        String string = LibraryModel.getPlainMacroKey(macroDesc);
        String string2 = JOptionPane.showInputDialog(null, Globals.messages.getString("Key"), string);
        if (string2 == null || string2.equals(string)) {
            return;
        }
        try {
            this.libraryModel.changeKey(macroDesc, string2);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), Globals.messages.getString("error"), 0);
        }
    }

    public void setSelectedNodeToCopyTarget() {
        this.copyTarget = this.treeComponent.getSelectionPath();
    }

    public void pasteIntoSelectedNode() {
        if (this.copyTarget == null) {
            return;
        }
        int n = this.macroTreeModel.getNodeType(this.copyTarget);
        int n2 = this.getSelectedType();
        if (n == 2 && n2 == 0) {
            this.copyCategoryIntoLibrary();
        } else if (n == 3 && n2 == 1) {
            this.copyMacroIntoCategory();
        }
        this.copyTarget = null;
        this.updateOperationPermission();
    }

    private void copyCategoryIntoLibrary() {
        Library library = this.getSelectedLibrary();
        Category category = this.macroTreeModel.getCategory(this.copyTarget);
        this.libraryModel.copy(category, library);
    }

    private void copyMacroIntoCategory() {
        Category category = this.getSelectedCategory();
        MacroDesc macroDesc = this.macroTreeModel.getMacro(this.copyTarget);
        this.libraryModel.copy(macroDesc, category);
    }

    private void createPermissionObject() {
        this.permissionObject = new OperationPermissions();
    }

    public OperationPermissions getOperationPermission() {
        return this.permissionObject;
    }

    private void updateOperationPermission() {
        Library library = this.getSelectedLibrary();
        Category category = this.getSelectedCategory();
        MacroDesc macroDesc = this.getSelectedMacro();
        TreePath treePath = this.treeComponent.getSelectionPath();
        this.permissionObject.disableAll();
        int n = this.getSelectedType();
        if (n == 1 || n == 2) {
            this.permissionObject.copyAvailable = true;
        }
        if (!this.macroTreeModel.isSearchMode()) {
            if (this.copyTarget != null && library != null && !library.isStdLib()) {
                int n2 = this.macroTreeModel.getNodeType(this.copyTarget);
                if (n2 == 2 && n == 0) {
                    this.permissionObject.pasteAvailable = true;
                } else if (n2 == 3 && n == 1) {
                    this.permissionObject.pasteAvailable = true;
                }
            }
            if (library != null && !library.isStdLib()) {
                this.permissionObject.renameAvailable = true;
                this.permissionObject.removeAvailable = true;
                if (n == 2) {
                    this.permissionObject.renKeyAvailable = true;
                }
            }
        }
    }

    private void createPopupMenu() {
        MacroTreePopupMenu macroTreePopupMenu = new MacroTreePopupMenu(this);
        this.treeComponent.setComponentPopupMenu(macroTreePopupMenu);
        this.addChangeListener(macroTreePopupMenu);
    }

    private void bindPreviewPanel() {
        this.treeComponent.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MacroDesc macroDesc = MacroTree.this.macroTreeModel.getMacro(treeSelectionEvent.getPath());
                if (macroDesc != null) {
                    MacroTree.this.previewPanel.getParserActions().parseString(new StringBuffer(macroDesc.description));
                    MapCoordinates mapCoordinates = DrawingSize.calculateZoomToFit(((MacroTree)MacroTree.this).previewPanel.dmp, ((MacroTree)MacroTree.this).previewPanel.getSize().width * 85 / 100, ((MacroTree)MacroTree.this).previewPanel.getSize().height * 85 / 100, true);
                    mapCoordinates.setXCenter(-mapCoordinates.getXCenter() + 10.0);
                    mapCoordinates.setYCenter(-mapCoordinates.getYCenter() + 10.0);
                    MacroTree.this.previewPanel.setMapCoordinates(mapCoordinates);
                    MacroTree.this.previewPanel.repaint();
                }
            }
        });
        LibraryListenerAdapter libraryListenerAdapter = new LibraryListenerAdapter(){

            @Override
            public void libraryLoaded() {
                ((MacroTree)MacroTree.this).previewPanel.dmp.setLibrary(MacroTree.this.libraryModel.getAllMacros());
            }
        };
        this.libraryModel.addLibraryListener(libraryListenerAdapter);
    }

    public void setSelectionListener(ChangeSelectionListener changeSelectionListener) {
        this.selectionListener = changeSelectionListener;
        this.treeComponent.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (MacroTree.this.selectionListener != null) {
                    MacroDesc macroDesc = MacroTree.this.macroTreeModel.getMacro(treeSelectionEvent.getPath());
                    if (macroDesc == null) {
                        MacroTree.this.selectionListener.setSelectionState(1, "");
                    } else {
                        MacroTree.this.selectionListener.setSelectionState(13, macroDesc.key);
                    }
                }
            }
        });
    }

    private void bindLibraryModel() {
        this.macroTreeModel = new MacroTreeModel(this.libraryModel);
        this.treeComponent.setModel(this.macroTreeModel);
        this.libraryModel.addLibraryListener(this.macroTreeModel);
    }

    private void createTreeView() {
        this.treeComponent = new ExpandableJTree();
        this.treeComponent.setCellRenderer(new MacroTreeCellRenderer());
        this.treeComponent.getSelectionModel().setSelectionMode(1);
        this.treeScrollPane = new JScrollPane(this.treeComponent);
        this.treeScrollPane.setMinimumSize(new Dimension(150, 100));
        this.treeScrollPane.setPreferredSize(new Dimension(350, 600));
        this.treeComponent.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MacroTree.this.updateOperationPermission();
                for (ChangeListener changeListener : MacroTree.this.changeListeners) {
                    changeListener.stateChanged(new ChangeEvent(this));
                }
            }
        });
    }

    private void createSearchField() {
        this.searchField = new SearchField();
    }

    private void createPreviewPanel() {
        this.previewPanel = new CircuitPanel(false);
        this.previewPanel.dmp.setLayers(this.layerModel.getAllLayers());
        this.previewPanel.dmp.setLibrary(this.libraryModel.getAllMacros());
        this.previewPanel.setGridVisibility(false);
        this.previewPanel.setMinimumSize(new Dimension(150, 100));
        this.previewPanel.setPreferredSize(new Dimension(350, 300));
    }

    private void bindSearchField() {
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setWord(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setWord(documentEvent);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void setWord(DocumentEvent documentEvent) {
                String string = null;
                Document document = documentEvent.getDocument();
                try {
                    string = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    string = "";
                    System.out.println("[SearchFieldListener] BadLocationException");
                }
                finally {
                    if ("".equals(string)) {
                        MacroTree.this.treeComponent.collapseOnce();
                    } else {
                        MacroTree.this.treeComponent.expandOnce();
                    }
                    MacroTree.this.macroTreeModel.setFilterWord(string);
                }
            }
        };
        this.searchField.getDocument().addDocumentListener(documentListener);
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (keyEvent.isShiftDown()) {
                        MacroTree.this.treeComponent.selectPrevLeaf();
                    } else {
                        MacroTree.this.treeComponent.selectNextLeaf();
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    public void setLibraryModel(LibraryModel libraryModel) {
        this.libraryModel = libraryModel;
        this.previewPanel.dmp.setLibrary(libraryModel.getAllMacros());
        this.bindSearchField();
    }

    public void setLayerModel(LayerModel layerModel) {
        this.layerModel = layerModel;
        this.previewPanel.dmp.setLayers(layerModel.getAllLayers());
    }

    public MacroDesc getSelectedMacro() {
        TreePath treePath = this.treeComponent.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return this.macroTreeModel.getMacro(treePath);
    }

    public Category getSelectedCategory() {
        TreePath treePath = this.treeComponent.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return this.macroTreeModel.getCategory(treePath);
    }

    public Library getSelectedLibrary() {
        TreePath treePath = this.treeComponent.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return this.macroTreeModel.getLibrary(treePath);
    }
}

