/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.macropicker;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ExpandableJTree
extends JTree {
    private boolean runOnce = false;
    private boolean direction = false;

    public ExpandableJTree() {
        int n = Toolkit.getDefaultToolkit().getScreenResolution();
        Font font = this.getFont();
        this.setFont(font.deriveFont(font.getSize() * n / 114));
        this.setRowHeight(this.getRowHeight() * n / 114);
    }

    private void fillExpandState(boolean bl) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            TreePath treePath = this.getPathForRow(i);
            if (this.getModel().isLeaf(treePath.getLastPathComponent())) continue;
            this.setExpandedState(treePath, bl);
        }
    }

    public void expandOnce() {
        this.runOnce = true;
        this.direction = true;
    }

    public void collapseOnce() {
        this.runOnce = true;
        this.direction = false;
    }

    public void selectNextLeaf() {
        int n = this.searchNextLeaf(true);
        if (0 <= n && n < this.getRowCount()) {
            this.setSelectionRow(n);
            this.scrollRowToVisible(n);
        }
    }

    public void selectPrevLeaf() {
        int n = this.searchNextLeaf(false);
        if (0 <= n && n < this.getRowCount()) {
            this.setSelectionRow(n);
            this.scrollRowToVisible(n);
        }
    }

    private int getSelectedRow() {
        int n = -1;
        int[] nArray = this.getSelectionRows();
        n = nArray == null || nArray.length == 0 ? -1 : nArray[0];
        return n;
    }

    private int searchNextLeaf(boolean bl) {
        int n = this.getSelectedRow();
        for (int i = 0; i < this.getRowCount(); ++i) {
            n = bl ? ++n : --n;
            if (n < 0) {
                n = this.getRowCount();
                continue;
            }
            if (this.getRowCount() <= n) {
                n = -1;
                continue;
            }
            if (!this.getModel().isLeaf(this.getPathForRow(n).getLastPathComponent())) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.runOnce) {
            this.fillExpandState(this.direction);
            this.runOnce = false;
        }
        super.paint(graphics);
    }
}

