/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.librarymodel.utils;

import net.sourceforge.fidocadj.FidoFrame;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.librarymodel.event.AddEvent;
import net.sourceforge.fidocadj.librarymodel.event.KeyChangeEvent;
import net.sourceforge.fidocadj.librarymodel.event.LibraryListener;
import net.sourceforge.fidocadj.librarymodel.event.RemoveEvent;
import net.sourceforge.fidocadj.librarymodel.event.RenameEvent;

public class CircuitPanelUpdater
implements LibraryListener {
    FidoFrame fidoFrame;

    public CircuitPanelUpdater(FidoFrame fidoFrame) {
        this.fidoFrame = fidoFrame;
    }

    @Override
    public void libraryLoaded() {
        this.updateCircuitPanel();
    }

    @Override
    public void libraryNodeRenamed(RenameEvent renameEvent) {
    }

    @Override
    public void libraryNodeRemoved(RemoveEvent removeEvent) {
        this.updateCircuitPanel();
    }

    @Override
    public void libraryNodeAdded(AddEvent addEvent) {
    }

    @Override
    public void libraryNodeKeyChanged(KeyChangeEvent keyChangeEvent) {
        this.updateCircuitPanel();
    }

    private void updateCircuitPanel() {
        CircuitPanel circuitPanel = this.fidoFrame.cc;
        DrawingModel drawingModel = circuitPanel.dmp;
        ParserActions parserActions = new ParserActions(drawingModel);
        circuitPanel.getParserActions().parseString(parserActions.getText(true));
        circuitPanel.repaint();
    }
}

