/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.librarymodel;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.globals.LibUtils;
import net.sourceforge.fidocadj.librarymodel.Category;
import net.sourceforge.fidocadj.librarymodel.Library;
import net.sourceforge.fidocadj.librarymodel.event.AddEvent;
import net.sourceforge.fidocadj.librarymodel.event.KeyChangeEvent;
import net.sourceforge.fidocadj.librarymodel.event.LibraryListener;
import net.sourceforge.fidocadj.librarymodel.event.RemoveEvent;
import net.sourceforge.fidocadj.librarymodel.event.RenameEvent;
import net.sourceforge.fidocadj.primitives.MacroDesc;
import net.sourceforge.fidocadj.undo.UndoActorListener;

public class LibraryModel {
    private final ArrayList<LibraryListener> libraryListeners;
    private final DrawingModel drawingModel;
    private final List<Library> libraries;
    private Map<String, MacroDesc> masterLibrary;
    private UndoActorListener undoActorListener;

    public LibraryModel(DrawingModel drawingModel) {
        this.drawingModel = drawingModel;
        this.libraryListeners = new ArrayList();
        this.libraries = new ArrayList<Library>();
        this.updateLibraries();
    }

    public void addLibraryListener(LibraryListener libraryListener) {
        this.libraryListeners.add(libraryListener);
    }

    public void removeLibraryListener(LibraryListener libraryListener) {
        this.libraryListeners.remove(libraryListener);
    }

    public void remove(Category category) throws IllegalLibraryAccessException {
        if (category == null) {
            return;
        }
        Library library = category.getParentLibrary();
        if (library.isStdLib()) {
            throw new IllegalLibraryAccessException("A category in standard library can't be removed.");
        }
        library.removeCategory(category);
        this.synchronizeMasterLibrary();
        this.save();
        this.saveLibraryState();
        this.fireRemoved(library, category);
    }

    public void remove(Library library) throws IllegalLibraryAccessException {
        if (library == null) {
            return;
        }
        if (library.isStdLib()) {
            throw new IllegalLibraryAccessException("A standard library can't be removed.");
        }
        this.libraries.remove(library);
        this.synchronizeMasterLibrary();
        try {
            LibUtils.deleteLib(library.getFileName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("library not found:" + library.getFileName());
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
        this.saveLibraryState();
        this.fireRemoved(null, library);
    }

    public void remove(MacroDesc macroDesc) throws IllegalLibraryAccessException {
        if (macroDesc == null) {
            return;
        }
        Category category = (Category)this.getParentNode(macroDesc);
        if (category == null) {
            throw new IllegalLibraryAccessException("It's a wondering macro.");
        }
        if (category.getParentLibrary().isStdLib()) {
            throw new IllegalLibraryAccessException("A standard library can't be removed.");
        }
        category.removeMacro(macroDesc);
        this.synchronizeMasterLibrary();
        this.save();
        this.saveLibraryState();
        this.fireRemoved(category, macroDesc);
    }

    public void rename(MacroDesc macroDesc, String string) throws IllegalNameException, IllegalLibraryAccessException {
        if (macroDesc == null) {
            return;
        }
        String string2 = macroDesc.name;
        if (string == null || string.length() == 0) {
            throw new IllegalNameException("Name length must not be zero.");
        }
        if (this.isStdLib(macroDesc)) {
            throw new IllegalLibraryAccessException("A macro in standard library can't be renamed.");
        }
        macroDesc.name = string;
        this.save();
        this.saveLibraryState();
        this.fireRenamed(this.getParentNode(macroDesc), macroDesc, string2);
    }

    public void rename(Category category, String string) throws IllegalNameException, IllegalLibraryAccessException {
        String string2 = category.getName();
        if (string == null || string.length() == 0) {
            throw new IllegalNameException("Name length must not be zero.");
        }
        if (category.getParentLibrary().isStdLib()) {
            throw new IllegalLibraryAccessException("A category in standard library can't be renamed.");
        }
        if (!Category.isValidName(string)) {
            throw new IllegalNameException("invalid name");
        }
        category.setName(string);
        this.synchronizeMacros(category.getParentLibrary());
        this.save();
        this.saveLibraryState();
        this.fireRenamed(this.getParentNode(category), category, string2);
    }

    public void rename(Library library, String string) throws IllegalNameException, IllegalLibraryAccessException {
        String string2 = library.getName();
        if (string == null || string.length() == 0) {
            throw new IllegalNameException("Name length must not be zero.");
        }
        if (library.isStdLib()) {
            throw new IllegalLibraryAccessException("A standard library can't be renamed.");
        }
        if (!Library.isValidName(string)) {
            throw new IllegalNameException("invalid name");
        }
        library.setName(string);
        this.synchronizeMacros(library);
        this.synchronizeMasterLibrary();
        this.save();
        this.saveLibraryState();
        this.fireRenamed(null, library, string2);
    }

    public void copy(MacroDesc macroDesc, Category category) {
        System.out.println("copy:" + macroDesc + category);
        MacroDesc macroDesc2 = this.copyMacro(macroDesc, category);
        this.synchronizeMacros(category.getParentLibrary());
        this.synchronizeMasterLibrary();
        this.save();
        this.saveLibraryState();
        this.fireAdded(category, macroDesc2);
    }

    private MacroDesc copyMacro(MacroDesc macroDesc, Category category) {
        int n;
        if (macroDesc == null || category == null) {
            return null;
        }
        MacroDesc macroDesc2 = this.cloneMacro(macroDesc);
        String string = LibraryModel.createRandomMacroKey();
        for (n = 20; 0 < n && category.getParentLibrary().containsMacroKey(string); --n) {
        }
        if (n < 0) {
            throw new RuntimeException("Key generation failed.");
        }
        macroDesc2.key = LibraryModel.createMacroKey(category.getParentLibrary().getFileName(), string);
        category.addMacro(macroDesc2);
        return macroDesc2;
    }

    public void copy(Category category, Library library) {
        if (category == null || library == null) {
            return;
        }
        Category category2 = new Category(category.getName(), category.getParentLibrary(), false);
        for (MacroDesc macroDesc : category.getAllMacros()) {
            this.copyMacro(macroDesc, category2);
        }
        library.addCategory(category2);
        this.synchronizeMacros(library);
        this.synchronizeMasterLibrary();
        this.save();
        this.saveLibraryState();
        this.fireAdded(library, category2);
    }

    public void changeKey(MacroDesc macroDesc, String string) throws IllegalKeyException, IllegalLibraryAccessException {
        if (macroDesc == null || string.length() == 0) {
            throw new IllegalKeyException("Name length must not be zero.");
        }
        if (this.isStdLib(macroDesc)) {
            throw new IllegalLibraryAccessException("A macro in standard library can't be renamed.");
        }
        Category category = (Category)this.getParentNode(macroDesc);
        if (category.getParentLibrary().containsMacroKey(string)) {
            throw new IllegalKeyException("New key already exists.");
        }
        String string2 = LibraryModel.getPlainMacroKey(macroDesc);
        macroDesc.key = LibraryModel.createMacroKey(macroDesc.filename, string);
        this.save();
        this.saveLibraryState();
        this.fireKeyChanged(this.getParentNode(macroDesc), macroDesc, string2);
    }

    private MacroDesc cloneMacro(MacroDesc macroDesc) {
        return new MacroDesc(macroDesc.key, macroDesc.name, macroDesc.description, macroDesc.category, macroDesc.library, macroDesc.filename);
    }

    public static String getPlainMacroKey(MacroDesc macroDesc) {
        if (macroDesc == null) {
            return null;
        }
        String[] stringArray = macroDesc.key.split("\\.");
        if (1 < stringArray.length) {
            return stringArray[1];
        }
        return stringArray[0];
    }

    public static String createRandomMacroKey() {
        long l = System.nanoTime();
        long l2 = 0L;
        int n = 0;
        while (l > 0L) {
            l2 ^= (l >>= n * 8) & 0xFFL;
            ++n;
        }
        return String.valueOf(l2);
    }

    public static String createMacroKey(String string, String string2) {
        String string3 = string + "." + string2;
        return string3.toLowerCase(new Locale("en"));
    }

    private void synchronizeMacros(Library library) {
        if (library.isStdLib()) {
            return;
        }
        for (Category category : library.getAllCategories()) {
            for (MacroDesc macroDesc : category.getAllMacros()) {
                macroDesc.category = category.getName();
                macroDesc.library = library.getName();
                macroDesc.filename = library.getFileName();
                String string = LibraryModel.getPlainMacroKey(macroDesc);
                macroDesc.key = LibraryModel.createMacroKey(library.getFileName(), string);
            }
        }
    }

    public void setUndoActorListener(UndoActorListener undoActorListener) {
        this.undoActorListener = undoActorListener;
    }

    private boolean isStdLib(MacroDesc macroDesc) {
        for (Library library : this.getAllLibraries()) {
            if (!library.isStdLib()) continue;
            for (Category category : library.getAllCategories()) {
                for (MacroDesc macroDesc2 : category.getAllMacros()) {
                    if (!macroDesc.equals(macroDesc2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void fireAdded(Object object, Object object2) {
        for (LibraryListener libraryListener : this.libraryListeners) {
            libraryListener.libraryNodeAdded(new AddEvent(object, object2));
        }
    }

    private void fireRenamed(Object object, Object object2, String string) {
        for (LibraryListener libraryListener : this.libraryListeners) {
            libraryListener.libraryNodeRenamed(new RenameEvent(object, object2, string));
        }
    }

    private void fireRemoved(Object object, Object object2) {
        for (LibraryListener libraryListener : this.libraryListeners) {
            libraryListener.libraryNodeRemoved(new RemoveEvent(object, object2));
        }
    }

    private void fireKeyChanged(Object object, Object object2, String string) {
        for (LibraryListener libraryListener : this.libraryListeners) {
            libraryListener.libraryNodeKeyChanged(new KeyChangeEvent(object, object2, string));
        }
    }

    private Object getParentNode(Object object) {
        for (Library library : this.getAllLibraries()) {
            if (object.equals(library)) {
                return null;
            }
            for (Category category : library.getAllCategories()) {
                if (object.equals(category)) {
                    return library;
                }
                for (MacroDesc macroDesc : category.getAllMacros()) {
                    if (!object.equals(macroDesc)) continue;
                    return category;
                }
            }
        }
        return null;
    }

    public Map<String, MacroDesc> getAllMacros() {
        return this.masterLibrary;
    }

    public List<Library> getAllLibraries() {
        return this.libraries;
    }

    public void save() {
        for (Library library : this.libraries) {
            try {
                if (library.isStdLib()) continue;
                LibUtils.save(this.masterLibrary, LibUtils.getLibPath(library.getFileName()), library.getName().trim(), library.getFileName());
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    public void saveLibraryState() {
        try {
            LibUtils.saveLibraryState(this.undoActorListener);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
    }

    public void undoLibrary() {
    }

    public void forceUpdate() {
        this.updateLibraries();
        this.fireChanged();
    }

    private void fireChanged() {
        for (LibraryListener libraryListener : this.libraryListeners) {
            libraryListener.libraryLoaded();
        }
    }

    private void synchronizeMasterLibrary() {
        this.masterLibrary.clear();
        for (Library library : this.libraries) {
            for (Category category : library.getAllCategories()) {
                for (MacroDesc macroDesc : category.getAllMacros()) {
                    this.masterLibrary.put(macroDesc.key, macroDesc);
                }
            }
        }
    }

    private void updateLibraries() {
        HashMap<CallSite, Library> hashMap = new HashMap<CallSite, Library>();
        this.masterLibrary = this.drawingModel.getLibrary();
        this.libraries.clear();
        for (MacroDesc macroDesc : this.masterLibrary.values()) {
            Category category;
            Library library;
            this.cleanMacro(macroDesc);
            String string = macroDesc.filename + "/" + macroDesc.library;
            if (hashMap.containsKey(string)) {
                library = (Library)hashMap.get(string);
            } else {
                library = new Library(macroDesc.library, macroDesc.filename, LibUtils.isStdLib(macroDesc));
                hashMap.put((CallSite)((Object)string), library);
                this.libraries.add(library);
            }
            if (library.getCategory(macroDesc.category) == null) {
                boolean bl = "hidden".equals(macroDesc.category);
                category = new Category(macroDesc.category, library, bl);
                library.addCategory(category);
            } else {
                category = library.getCategory(macroDesc.category);
            }
            category.addMacro(macroDesc);
        }
        this.fireChanged();
    }

    private void cleanMacro(MacroDesc macroDesc) {
        macroDesc.name = macroDesc.name.trim();
    }

    public class IllegalLibraryAccessException
    extends LibraryException {
        IllegalLibraryAccessException(String string) {
            super(string);
        }
    }

    public class IllegalNameException
    extends LibraryException {
        IllegalNameException(String string) {
            super(string);
        }
    }

    public class IllegalKeyException
    extends LibraryException {
        IllegalKeyException(String string) {
            super(string);
        }
    }

    public class LibraryException
    extends Exception {
        LibraryException(String string) {
            super(string);
        }
    }
}

