/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.librarymodel;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.fidocadj.librarymodel.Category;

public class Library {
    private String libraryName;
    private final String filename;
    private final boolean isStd;
    private final ArrayList<Category> categories;

    Library(String string, String string2, boolean bl) {
        this.libraryName = string;
        this.filename = string2;
        this.isStd = bl;
        this.categories = new ArrayList();
    }

    public String getName() {
        return this.libraryName;
    }

    public void setName(String string) {
        this.libraryName = string;
    }

    public String getFileName() {
        return this.filename;
    }

    public List<Category> getAllCategories() {
        return this.categories;
    }

    public Category getCategory(String string) {
        Category category = null;
        for (Category category2 : this.categories) {
            if (!category2.getName().equals(string)) continue;
            category = category2;
            break;
        }
        return category;
    }

    public void addCategory(Category category) {
        this.categories.add(category);
    }

    public void removeCategory(Category category) {
        this.categories.remove(category);
    }

    public boolean isStdLib() {
        return this.isStd;
    }

    public boolean isHidden() {
        return false;
    }

    public static boolean isValidName(String string) {
        return true;
    }

    public boolean containsMacroKey(String string) {
        if (string == null) {
            return true;
        }
        for (Category category : this.categories) {
            if (!category.containsMacroKey(string)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }
}

