/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.graphic.swing;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.ColorInterface;
import net.sourceforge.fidocadj.graphic.DecoratedText;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.graphic.PolygonInterface;
import net.sourceforge.fidocadj.graphic.ShapeInterface;
import net.sourceforge.fidocadj.graphic.TextInterface;
import net.sourceforge.fidocadj.graphic.swing.ColorSwing;
import net.sourceforge.fidocadj.graphic.swing.PolygonSwing;
import net.sourceforge.fidocadj.graphic.swing.ShapeSwing;
import net.sourceforge.fidocadj.layers.LayerDesc;

public class Graphics2DSwing
implements GraphicsInterface,
TextInterface {
    private static final int maxAllowableGridBrushWidth = 500;
    private static final int maxAllowableGridBrushHeight = 500;
    Graphics2D g;
    private BufferedImage bufferedImage;
    private double oldZoom;
    private TexturePaint tp;
    private int width;
    private int height;
    private BasicStroke[] strokeList;
    private float actual_w;
    private double zoom;
    private double actualZoom;
    private static final int FONTSIZE = 100;
    private Font f;
    private double fontScale = 1.0;
    private Font mf;

    public Graphics2DSwing(Graphics2D graphics2D) {
        this.g = graphics2D;
        this.oldZoom = -1.0;
        this.actualZoom = -1.0;
        this.zoom = 1.0;
        this.g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public Graphics2DSwing(Graphics graphics) {
        this.g = (Graphics2D)graphics;
        this.oldZoom = -1.0;
        this.actualZoom = -1.0;
        this.zoom = 1.0;
    }

    public Graphics2DSwing() {
        this.g = null;
        this.oldZoom = -1.0;
        this.actualZoom = -1.0;
        this.zoom = 1.0;
    }

    @Override
    public TextInterface getTextInterface() {
        return this;
    }

    @Override
    public void applyStroke(float f, int n) {
        Object object;
        if (f != this.actual_w && f > 0.0f || this.zoom != this.actualZoom) {
            this.strokeList = new BasicStroke[5];
            this.strokeList[0] = new BasicStroke(f, 1, 1);
            if (this.zoom < 1.0) {
                this.zoom = 1.0;
            }
            for (int i = 1; i < 5; ++i) {
                object = new float[Globals.dash[i].length];
                for (int j = 0; j < Globals.dash[i].length; ++j) {
                    object[j] = Globals.dash[i][j] * (float)this.zoom / 2.0f;
                }
                this.strokeList[i] = new BasicStroke(f, 1, 1, (float)(10.0 * this.zoom), (float[])object, 0.0f);
            }
            this.actual_w = f;
            this.actualZoom = this.zoom;
        }
        if (!((BasicStroke)(object = this.strokeList[n])).equals(this.g.getStroke())) {
            this.g.setStroke((Stroke)object);
        }
    }

    @Override
    public void setZoom(double d) {
        this.zoom = d;
    }

    @Override
    public double getZoom() {
        return this.zoom;
    }

    public void setGraphicContext(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    public Graphics2D getGraphicContext() {
        return this.g;
    }

    @Override
    public void setColor(ColorInterface colorInterface) {
        ColorSwing colorSwing = (ColorSwing)colorInterface;
        this.g.setColor(colorSwing.getColorSwing());
    }

    @Override
    public ColorInterface getColor() {
        return new ColorSwing(this.g.getColor());
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.g.drawRect(n, n2, n3, n4);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, n2, n3, n4);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    @Override
    public boolean hitClip(int n, int n2, int n3, int n4) {
        return this.g.hitClip(n, n2, n3, n4);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n, n2, n3, n4);
    }

    @Override
    public void setFont(String string, double d, boolean bl, boolean bl2) {
        this.mf = new Font(string, 0 + (bl ? 2 : 0) + (bl2 ? 1 : 0), 100);
        this.fontScale = d;
        this.f = this.mf.deriveFont((float)d);
        if (!this.g.getFont().equals(this.f)) {
            this.g.setFont(this.f);
        }
    }

    @Override
    public void setFont(String string, double d) {
        this.setFont(string, d, false, false);
    }

    @Override
    public double getFontSize() {
        return this.fontScale;
    }

    @Override
    public void setFontSize(double d) {
        this.fontScale = d;
        if (this.mf == null) {
            return;
        }
        this.f = this.mf.deriveFont((float)d);
        if (!this.g.getFont().equals(this.f)) {
            this.g.setFont(this.f);
        }
    }

    @Override
    public int getFontAscent() {
        FontMetrics fontMetrics = this.g.getFontMetrics(this.g.getFont());
        return Math.round(fontMetrics.getAscent());
    }

    @Override
    public int getFontDescent() {
        FontMetrics fontMetrics = this.g.getFontMetrics(this.g.getFont());
        return Math.round(fontMetrics.getDescent());
    }

    @Override
    public int getStringWidth(String string) {
        FontMetrics fontMetrics = this.g.getFontMetrics(this.g.getFont());
        return Math.round(fontMetrics.stringWidth(string));
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.g.drawString(string, n, n2);
    }

    @Override
    public void setAlpha(float f) {
        this.g.setComposite(AlphaComposite.getInstance(3, f));
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.g.fillOval(n, n2, n3, n4);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.g.drawOval(n, n2, n3, n4);
    }

    @Override
    public void fill(ShapeInterface shapeInterface) {
        ShapeSwing shapeSwing = (ShapeSwing)shapeInterface;
        this.g.fill(shapeSwing.getShapeInSwing());
    }

    @Override
    public void draw(ShapeInterface shapeInterface) {
        ShapeSwing shapeSwing = (ShapeSwing)shapeInterface;
        this.g.draw(shapeSwing.getShapeInSwing());
    }

    @Override
    public void fillPolygon(PolygonInterface polygonInterface) {
        PolygonSwing polygonSwing = (PolygonSwing)polygonInterface;
        this.g.fillPolygon(polygonSwing.getSwingPolygon());
    }

    @Override
    public void drawPolygon(PolygonInterface polygonInterface) {
        PolygonSwing polygonSwing = (PolygonSwing)polygonInterface;
        this.g.drawPolygon(polygonSwing.getSwingPolygon());
    }

    @Override
    public void activateSelectColor(LayerDesc layerDesc) {
        if (layerDesc == null) {
            this.g.setColor(Color.green);
        } else {
            ColorSwing colorSwing = (ColorSwing)layerDesc.getColor();
            this.g.setColor(Graphics2DSwing.blendColors(Color.green, colorSwing.getColorSwing(), 0.6f));
        }
        this.g.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public static Color blendColors(Color color, Color color2, float f) {
        float f2 = 1.0f - f;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        color.getColorComponents(fArray);
        color2.getColorComponents(fArray2);
        return new Color(fArray[0] * f + fArray2[0] * f2, fArray[1] * f + fArray2[1] * f2, fArray[2] * f + fArray2[2] * f2);
    }

    @Override
    public void drawAdvText(double d, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, boolean bl2, String string) {
        AffineTransform affineTransform = (AffineTransform)this.g.getTransform().clone();
        AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
        AffineTransform affineTransform3 = new AffineTransform();
        AffineTransform affineTransform4 = new AffineTransform();
        DecoratedText decoratedText = new DecoratedText(this);
        affineTransform3.scale(1.0, d);
        if (bl2) {
            affineTransform4.scale(-1.0, 1.0);
        }
        if (n7 == 0) {
            if (bl2) {
                affineTransform.scale(-1.0, d);
                this.g.setTransform(affineTransform);
                if (this.g.hitClip(-n, n3, n5, n4)) {
                    if (!this.g.getFont().equals(this.f)) {
                        this.g.setFont(this.f);
                    }
                    decoratedText.drawString(string, -n, n3 + n4);
                }
            } else {
                if (bl) {
                    affineTransform.concatenate(affineTransform3);
                    this.g.setTransform(affineTransform);
                }
                if (this.g.hitClip(n, n3, n5, n6)) {
                    if (n6 < 4) {
                        this.g.drawLine(n, n3, n + n5, n3);
                        if (bl) {
                            this.g.setTransform(affineTransform2);
                        }
                        return;
                    }
                    if (!this.g.getFont().equals(this.f)) {
                        this.g.setFont(this.f);
                    }
                    decoratedText.drawString(string, n, n3 + n4);
                    if (bl) {
                        this.g.setTransform(affineTransform2);
                    }
                    return;
                }
            }
        } else if (bl2) {
            affineTransform.concatenate(affineTransform4);
            affineTransform.rotate(Math.toRadians(n7), -n, n2);
            if (bl) {
                affineTransform.concatenate(affineTransform3);
            }
            this.g.setTransform(affineTransform);
            if (!this.g.getFont().equals(this.f)) {
                this.g.setFont(this.f);
            }
            decoratedText.drawString(string, -n, n3 + n4);
        } else {
            affineTransform.rotate(Math.toRadians(-n7), n, n2);
            if (bl) {
                affineTransform.concatenate(affineTransform3);
            }
            this.g.setTransform(affineTransform);
            if (!this.g.getFont().equals(this.f)) {
                this.g.setFont(this.f);
            }
            decoratedText.drawString(string, n, n3 + n4);
        }
        this.g.setTransform(affineTransform2);
    }

    @Override
    public void drawGrid(MapCoordinates mapCoordinates, int n, int n2, int n3, int n4) {
        int n5 = mapCoordinates.getXGridStep();
        int n6 = mapCoordinates.getYGridStep();
        int n7 = 1;
        double d = 0.01;
        double d2 = mapCoordinates.getYMagnitude();
        double d3 = 0.0;
        double d4 = 1.0;
        if (this.oldZoom != d2 || this.bufferedImage == null || this.tp == null) {
            Object object;
            Object object2;
            double d5;
            for (d5 = 1.0; d5 < 105.0; d5 += 1.0) {
                if (!(Math.abs(d5 * d2 - (double)Math.round(d5 * d2)) < d)) continue;
                n7 = (int)d5;
                break;
            }
            this.tp = null;
            d5 = Math.abs(mapCoordinates.mapXi(n5, 0.0, false) - mapCoordinates.mapXi(0.0, 0.0, false));
            double d6 = Math.abs(mapCoordinates.mapYi(0.0, n6, false) - mapCoordinates.mapYi(0.0, 0.0, false));
            double d7 = 1.0;
            if (d5 > 35.0 || d6 > 35.0) {
                this.bufferedImage = null;
                d7 = 2.0;
                this.g.setColor(new Color(220, 220, 220));
                for (double d8 = (double)mapCoordinates.unmapXsnap(n); d8 <= (double)mapCoordinates.unmapXsnap(n3); d8 += (double)n5) {
                    this.g.drawLine((int)Math.round(mapCoordinates.mapXr(d8, 0.0)), n2, (int)Math.round(mapCoordinates.mapXr(d8, 0.0)), n4);
                }
                for (double d9 = (double)mapCoordinates.unmapYsnap(n2); d9 <= (double)mapCoordinates.unmapYsnap(n4); d9 += (double)n6) {
                    this.g.drawLine(n, (int)Math.round(mapCoordinates.mapYr(0.0, d9)), n3, (int)Math.round(mapCoordinates.mapYr(0.0, d9)));
                }
                return;
            }
            if (d5 < 3.0 || d6 < 3.0) {
                n5 = 5 * mapCoordinates.getXGridStep();
                n6 = 5 * mapCoordinates.getYGridStep();
                d5 = Math.abs(mapCoordinates.mapXi(n5, 0.0, false) - mapCoordinates.mapXi(0.0, 0.0, false));
            }
            this.width = Math.abs(mapCoordinates.mapX(n7 * n5, 0.0) - mapCoordinates.mapX(0.0, 0.0));
            if (this.width <= 0) {
                this.width = 1;
            }
            this.height = Math.abs(mapCoordinates.mapY(0.0, 0.0) - mapCoordinates.mapY(0.0, n7 * n6));
            if (this.height <= 0) {
                this.height = 1;
            }
            if (this.width > 500 || this.height > 500) {
                this.g.setColor(Color.gray);
                for (double d10 = (double)mapCoordinates.unmapXsnap(n); d10 <= (double)mapCoordinates.unmapXsnap(n3); d10 += (double)n5) {
                    for (double d11 = (double)mapCoordinates.unmapYsnap(n2); d11 <= (double)mapCoordinates.unmapYsnap(n4); d11 += (double)n6) {
                        this.g.fillRect((int)Math.round(mapCoordinates.mapXr(d10, d11) - d3), (int)Math.round(mapCoordinates.mapYr(d10, d11) - d3), (int)d7, (int)d7);
                    }
                }
                return;
            }
            try {
                object2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
                object = ((GraphicsEnvironment)object2).getDefaultScreenDevice();
                GraphicsConfiguration graphicsConfiguration = ((GraphicsDevice)object).getDefaultConfiguration();
                this.bufferedImage = graphicsConfiguration.createCompatibleImage(this.width, this.height, 3);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.out.println("Out of memory error when painting grid");
                return;
            }
            object2 = this.bufferedImage.createGraphics();
            ((Graphics)object2).setColor(Color.white);
            ((Graphics)object2).setColor(Color.gray);
            for (double d12 = 0.0; d12 <= (double)mapCoordinates.unmapXsnap(this.width); d12 += (double)n5) {
                for (double d13 = 0.0; d13 <= (double)mapCoordinates.unmapYsnap(this.height); d13 += (double)n6) {
                    ((Graphics)object2).fillRect((int)Math.round(mapCoordinates.mapXr(d12, d13) - d3), (int)Math.round(mapCoordinates.mapYr(d12, d13) - d3), (int)d7, (int)d7);
                }
            }
            this.oldZoom = d2;
            object = new Rectangle(this.width, this.height);
            this.tp = new TexturePaint(this.bufferedImage, (Rectangle2D)object);
        }
        this.g.setPaint(this.tp);
        this.g.fillRect(0, 0, n3, n4);
    }

    @Override
    public PolygonInterface createPolygon() {
        return new PolygonSwing();
    }

    @Override
    public ShapeInterface createShape() {
        return new ShapeSwing();
    }

    @Override
    public ColorInterface createColor() {
        return new ColorSwing(this.g.getColor());
    }

    @Override
    public float getScreenDensity() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }
}

