/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.graphic;

import net.sourceforge.fidocadj.graphic.TextInterface;

public class DecoratedText {
    private TextInterface g;
    private StringBuffer btoken;
    private String bstr;
    private int currentIndex;
    private int lastIndex;
    private int exponentLevel;
    static final int CHUNK = 0;
    static final int INDEX = 1;
    static final int EXPONENT = 2;
    static final int END = 3;

    public DecoratedText(TextInterface textInterface) {
        this.g = textInterface;
    }

    public int getStringWidth(String string) {
        return this.g.getStringWidth(string);
    }

    private int getToken() {
        if (this.currentIndex >= this.lastIndex) {
            return 3;
        }
        char c = this.bstr.charAt(this.currentIndex);
        char c2 = '\u0000';
        if (this.currentIndex < this.lastIndex - 1) {
            c2 = this.bstr.charAt(this.currentIndex + 1);
        }
        if (c == '\\') {
            c = c2;
            ++this.currentIndex;
        } else {
            if (c == '_') {
                ++this.currentIndex;
                return 1;
            }
            if (c == '^') {
                ++this.currentIndex;
                return 2;
            }
        }
        this.btoken = new StringBuffer();
        do {
            this.btoken.append(c);
            ++this.currentIndex;
            if (this.currentIndex < this.lastIndex) continue;
            return 0;
        } while ((c = this.bstr.charAt(this.currentIndex)) != '_' && c != '^' && c != '\\');
        return 0;
    }

    private void resetTokenization(String string) {
        this.bstr = string;
        this.currentIndex = 0;
        this.exponentLevel = 0;
        this.lastIndex = string.length();
    }

    private float getSizeMultLevel() {
        switch (Math.abs(this.exponentLevel)) {
            case 0: {
                return 1.0f;
            }
            case 1: {
                return 0.8f;
            }
            case 2: {
                return 0.7f;
            }
            case 3: {
                return 0.6f;
            }
        }
        return 0.5f;
    }

    public void drawString(String string, int n, int n2) {
        int n3;
        this.resetTokenization(string);
        int n4 = n;
        double d = this.g.getFontSize();
        block6: while ((n3 = this.getToken()) != 3) {
            switch (n3) {
                case 0: {
                    this.g.setFontSize(d * (double)this.getSizeMultLevel());
                    this.g.drawString(this.btoken.toString(), n4, n2 - (int)Math.round((double)this.exponentLevel * d * (double)this.getSizeMultLevel() * 0.5));
                    n4 += this.g.getStringWidth(this.btoken.toString());
                    continue block6;
                }
                case 2: {
                    ++this.exponentLevel;
                    continue block6;
                }
                case 1: {
                    --this.exponentLevel;
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
    }
}

