/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.globals;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public abstract class Utf8ResourceBundle {
    public static final ResourceBundle getBundle(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        return Utf8ResourceBundle.createUtf8PropertyResourceBundle(resourceBundle);
    }

    public static final ResourceBundle getBundle(String string, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
        return Utf8ResourceBundle.createUtf8PropertyResourceBundle(resourceBundle);
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
        return Utf8ResourceBundle.createUtf8PropertyResourceBundle(resourceBundle);
    }

    private static ResourceBundle createUtf8PropertyResourceBundle(ResourceBundle resourceBundle) {
        if (!(resourceBundle instanceof PropertyResourceBundle)) {
            return resourceBundle;
        }
        return new Utf8PropertyResourceBundle((PropertyResourceBundle)resourceBundle);
    }

    private static class Utf8PropertyResourceBundle
    extends ResourceBundle {
        PropertyResourceBundle bundle;

        public Utf8PropertyResourceBundle(PropertyResourceBundle propertyResourceBundle) {
            this.bundle = propertyResourceBundle;
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.bundle.getKeys();
        }

        @Override
        protected Object handleGetObject(String string) {
            String string2 = this.bundle.getString(string);
            String string3 = System.getProperty("java.specification.version");
            if ("1.7".equals(string3) || "1.8".equals(string3)) {
                try {
                    return new String(string2.getBytes("ISO-8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.err.println("Unsupported encoding. Problems in Utf8PropertyResourceBundle class.");
                    return null;
                }
            }
            return string2;
        }
    }
}

