/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.globals;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import net.sourceforge.fidocadj.FidoMain;
import net.sourceforge.fidocadj.globals.FileUtils;
import net.sourceforge.fidocadj.primitives.MacroDesc;
import net.sourceforge.fidocadj.undo.UndoActorListener;

public final class LibUtils {
    private LibUtils() {
    }

    public static Map<String, MacroDesc> getLibrary(Map<String, MacroDesc> map, String string) {
        TreeMap<String, MacroDesc> treeMap = new TreeMap<String, MacroDesc>();
        for (Map.Entry<String, MacroDesc> entry : map.entrySet()) {
            String string2;
            MacroDesc macroDesc = entry.getValue();
            int n = macroDesc.key.lastIndexOf(".");
            if (n < 0 || !(string2 = macroDesc.key.substring(0, n).trim()).equalsIgnoreCase(string)) continue;
            treeMap.put(entry.getKey(), macroDesc);
        }
        return treeMap;
    }

    public static String prepareText(Map<String, MacroDesc> map, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        stringBuffer.append("[FIDOLIB " + string + "]\n");
        for (Map.Entry<String, MacroDesc> entry : map.entrySet()) {
            MacroDesc macroDesc = entry.getValue();
            if (string2 == null || !string2.equalsIgnoreCase(macroDesc.category.trim())) {
                stringBuffer.append("{" + macroDesc.category + "}\n");
                string2 = macroDesc.category.toLowerCase(new Locale("en")).trim();
            }
            stringBuffer.append("[");
            stringBuffer.append(macroDesc.key.substring(macroDesc.key.lastIndexOf(".") + 1).toUpperCase().trim());
            stringBuffer.append(" ");
            stringBuffer.append(macroDesc.name.trim());
            stringBuffer.append("]");
            int n = macroDesc.description.codePointAt(0) == 10 ? 1 : 0;
            stringBuffer.append("\n");
            stringBuffer.append(macroDesc.description.substring(n));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void saveToFile(String string, String string2) throws FileNotFoundException {
        try {
            PrintWriter printWriter = new PrintWriter(string, "UTF8");
            printWriter.print(string2);
            printWriter.flush();
            printWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public static void save(Map<String, MacroDesc> map, String string, String string2, String string3) {
        try {
            LibUtils.saveToFile(string + ".fcl", LibUtils.prepareText(LibUtils.getLibrary(map, string3), string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public static String getLibDir() throws FileNotFoundException {
        Preferences preferences = Preferences.userNodeForPackage(FidoMain.class);
        Object object = preferences.get("DIR_LIBS", "");
        if (object == null || ((String)object).length() == 0) {
            throw new FileNotFoundException();
        }
        if (!((String)object).endsWith(System.getProperty("file.separator"))) {
            object = (String)object + System.getProperty("file.separator");
        }
        return object;
    }

    public static String getLibPath(String string) throws FileNotFoundException {
        return LibUtils.getLibDir() + string.trim();
    }

    public static void deleteLib(String string) throws FileNotFoundException, IOException {
        File file = new File(LibUtils.getLibDir() + string + ".fcl");
        if (!file.delete()) {
            throw new IOException("Can not delete library.");
        }
    }

    public static List<File> getLibs() throws FileNotFoundException {
        File file = new File(LibUtils.getLibDir());
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!file.exists()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return arrayList;
        }
        for (File file2 : fileArray) {
            if (!file2.getName().toLowerCase().endsWith(".fcl")) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    public static boolean isStdLib(MacroDesc macroDesc) {
        String string = macroDesc.library;
        String string2 = macroDesc.filename;
        if (string == null) {
            return false;
        }
        boolean bl = false;
        int n = -1;
        boolean bl2 = true;
        n = macroDesc.key.indexOf(".");
        if (n < 0) {
            bl = true;
        } else {
            String string3 = macroDesc.key.substring(0, n);
            if (bl2 && "pcb".equals(string3)) {
                bl = true;
            } else if (bl2 && "ihram".equals(string3)) {
                bl = true;
            } else if (bl2 && "elettrotecnica".equals(string3)) {
                bl = true;
            } else if (bl2 && "ey_libraries".equals(string3)) {
                bl = true;
            }
        }
        return bl;
    }

    public static void renameGroup(Map<String, MacroDesc> map, String string, String string2, String string3) throws FileNotFoundException {
        String string4 = "";
        for (MacroDesc macroDesc : map.values()) {
            if (!macroDesc.category.equalsIgnoreCase(string2) || !macroDesc.library.trim().equalsIgnoreCase(string.trim())) continue;
            macroDesc.category = string3;
            string4 = macroDesc.filename;
        }
        if ("".equals(string4)) {
            return;
        }
        LibUtils.save(map, LibUtils.getLibPath(string), string.trim(), string4);
    }

    public static boolean checkKey(Map<String, MacroDesc> map, String string, String string2) {
        for (MacroDesc macroDesc : map.values()) {
            if (!macroDesc.library.equalsIgnoreCase(string) || !macroDesc.key.equalsIgnoreCase(string2.trim())) continue;
            return true;
        }
        return string2.contains("]");
    }

    public static boolean checkLibrary(String string) {
        if (string == null) {
            return false;
        }
        return string.contains("[") || string.contains(".") || string.contains("/") || string.contains("\\") || string.contains("~") || string.contains("&") || string.contains(",") || string.contains(";") || string.contains("]") || string.contains("\"");
    }

    public static void deleteGroup(Map<String, MacroDesc> map, String string, String string2) throws FileNotFoundException {
        TreeMap<String, MacroDesc> treeMap = new TreeMap<String, MacroDesc>();
        treeMap.putAll(map);
        String string3 = "";
        for (Map.Entry entry : treeMap.entrySet()) {
            MacroDesc macroDesc = (MacroDesc)entry.getValue();
            if (!macroDesc.library.trim().equalsIgnoreCase(string) || !macroDesc.category.equalsIgnoreCase(string2)) continue;
            map.remove(macroDesc.key);
            string3 = macroDesc.filename;
        }
        if ("".equals(string3)) {
            return;
        }
        LibUtils.save(map, LibUtils.getLibPath(string), string, string3);
    }

    public static List<String> enumGroups(Map<String, MacroDesc> map, String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (MacroDesc macroDesc : map.values()) {
            if (linkedList.contains(macroDesc.category) || !string.trim().equalsIgnoreCase(macroDesc.filename.trim())) continue;
            linkedList.add(macroDesc.category);
        }
        return linkedList;
    }

    public static String getLibName(Map<String, MacroDesc> map, String string) {
        LinkedList linkedList = new LinkedList();
        for (MacroDesc macroDesc : map.values()) {
            if (linkedList.contains(macroDesc.category) || !string.trim().equalsIgnoreCase(macroDesc.filename.trim())) continue;
            return macroDesc.library;
        }
        return null;
    }

    public static void saveLibraryState(UndoActorListener undoActorListener) throws IOException {
        try {
            File file = File.createTempFile("fidocadj_", "");
            if (!file.delete()) {
                throw new IOException("saveLibraryState: Can not delete temp file.");
            }
            if (!file.mkdir()) {
                throw new IOException("saveLibraryState: Can not create temp directory.");
            }
            String string = LibUtils.getLibDir();
            String string2 = file.getAbsolutePath();
            File file2 = new File(string);
            File file3 = new File(string2);
            FileUtils.copyDirectoryNonRecursive(file2, file3, "fcl");
            if (undoActorListener != null) {
                undoActorListener.saveUndoLibrary(string2);
            }
        }
        catch (IOException iOException) {
            System.out.println("Cannot save the library status.");
        }
    }
}

