/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.globals;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

public final class FileUtils {
    private FileUtils() {
    }

    public static String readFile(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer(bufferedReader.readLine());
        stringBuffer.append("\n");
        while (string2 != null) {
            string2 = bufferedReader.readLine();
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists() && !file2.mkdir()) {
                throw new IOException("Can not create temp. directory.");
            }
            String[] stringArray = file.list();
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                FileUtils.copyDirectory(new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        } else {
            FileUtils.copyFile(file, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            return;
        }
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    public static void copyDirectoryNonRecursive(File file, File file2, String string) throws IOException {
        String string2 = string;
        if (file.isDirectory()) {
            if (!file2.exists() && !file2.mkdir()) {
                throw new IOException("Can not create temp. directory.");
            }
            string2 = string2.toLowerCase(new Locale("en"));
            String[] stringArray = file.list();
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].toLowerCase().contains(string2)) continue;
                FileUtils.copyFile(new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        }
    }

    public static boolean deleteDirectory(File file) throws IOException {
        File[] fileArray;
        if (file.exists() && null != (fileArray = file.listFiles())) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    FileUtils.deleteDirectory(fileArray[i]);
                    continue;
                }
                if (fileArray[i].delete()) continue;
                throw new IOException("Can not delete file" + fileArray[i]);
            }
        }
        return file.delete();
    }
}

