/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.geom;

import java.util.Stack;

public class MapCoordinates {
    private double xCenter = 0.0;
    private double yCenter = 0.0;
    private double xMagnitude = 1.0;
    private double yMagnitude = 1.0;
    private int orientation = 0;
    public boolean mirror;
    public boolean isMacro = false;
    private boolean snapActive = true;
    public static final double MIN_MAGNITUDE = 0.25;
    public static final double MAX_MAGNITUDE = 100.0;
    private double vx;
    private int ivx;
    private double vy;
    private int ivy;
    private int xMin;
    private int xMax;
    private int yMin;
    private int yMax;
    private int xGridStep = 5;
    private int yGridStep = 5;
    private final Stack<MapCoordinates> stack;

    public MapCoordinates() {
        this.resetMinMax();
        this.stack = new Stack();
    }

    public void setOrientation(int n) {
        this.orientation = n;
        if (this.orientation < 0) {
            this.orientation = 0;
        }
        if (this.orientation > 3) {
            this.orientation = 3;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean getMirror() {
        return this.mirror;
    }

    public void push() {
        MapCoordinates mapCoordinates = new MapCoordinates();
        mapCoordinates.xCenter = this.xCenter;
        mapCoordinates.yCenter = this.yCenter;
        mapCoordinates.xMagnitude = this.xMagnitude;
        mapCoordinates.yMagnitude = this.yMagnitude;
        mapCoordinates.orientation = this.orientation;
        mapCoordinates.mirror = this.mirror;
        mapCoordinates.isMacro = this.isMacro;
        mapCoordinates.snapActive = this.snapActive;
        mapCoordinates.xMin = this.xMin;
        mapCoordinates.xMax = this.xMax;
        mapCoordinates.yMin = this.yMin;
        mapCoordinates.yMax = this.yMax;
        mapCoordinates.xGridStep = this.xGridStep;
        mapCoordinates.yGridStep = this.yGridStep;
        this.stack.push(mapCoordinates);
    }

    public void pop() {
        if (this.stack.empty()) {
            System.out.println("Warning: I can not pop the coordinate state out of an empty stack!");
        } else {
            MapCoordinates mapCoordinates = this.stack.pop();
            this.xCenter = mapCoordinates.xCenter;
            this.yCenter = mapCoordinates.yCenter;
            this.xMagnitude = mapCoordinates.xMagnitude;
            this.yMagnitude = mapCoordinates.yMagnitude;
            this.orientation = mapCoordinates.orientation;
            this.mirror = mapCoordinates.mirror;
            this.isMacro = mapCoordinates.isMacro;
            this.snapActive = mapCoordinates.snapActive;
            this.xMin = mapCoordinates.xMin;
            this.xMax = mapCoordinates.xMax;
            this.yMin = mapCoordinates.yMin;
            this.yMax = mapCoordinates.yMax;
            this.xGridStep = mapCoordinates.xGridStep;
            this.yGridStep = mapCoordinates.yGridStep;
        }
    }

    public final void setSnap(boolean bl) {
        this.snapActive = bl;
    }

    public final boolean getSnap() {
        return this.snapActive;
    }

    public final void setXGridStep(int n) {
        if (n > 0) {
            this.xGridStep = n;
        }
    }

    public final void setYGridStep(int n) {
        if (n > 0) {
            this.yGridStep = n;
        }
    }

    public final int getXGridStep() {
        return this.xGridStep;
    }

    public final int getYGridStep() {
        return this.yGridStep;
    }

    public final double getXMagnitude() {
        return this.xMagnitude;
    }

    public final double getYMagnitude() {
        return this.yMagnitude;
    }

    public final void setXMagnitude(double d) {
        double d2 = d;
        if (Math.abs(d2) < 0.25) {
            d2 = 0.25;
        }
        if (Math.abs(d2) > 100.0) {
            d2 = 100.0;
        }
        this.xMagnitude = d2;
    }

    public final void setYMagnitude(double d) {
        double d2 = d;
        if (Math.abs(d2) < 0.25) {
            d2 = 0.25;
        }
        if (Math.abs(d2) > 100.0) {
            d2 = 100.0;
        }
        this.yMagnitude = d2;
    }

    public final void setXMagnitudeNoCheck(double d) {
        this.xMagnitude = d;
    }

    public final void setYMagnitudeNoCheck(double d) {
        this.yMagnitude = d;
    }

    public final double getXCenter() {
        return this.xCenter;
    }

    public final double getYCenter() {
        return this.yCenter;
    }

    public final void setXCenter(double d) {
        this.xCenter = d;
    }

    public final void setYCenter(double d) {
        this.yCenter = d;
    }

    public final void setMagnitudes(double d, double d2) {
        this.setXMagnitude(d);
        this.setYMagnitude(d2);
    }

    public final void setMagnitudesNoCheck(double d, double d2) {
        this.setXMagnitudeNoCheck(d);
        this.setYMagnitudeNoCheck(d2);
    }

    public final int getXMax() {
        return this.xMax;
    }

    public final int getYMax() {
        return this.yMax;
    }

    public final int getXMin() {
        return this.xMin;
    }

    public final int getYMin() {
        return this.yMin;
    }

    public final void resetMinMax() {
        this.yMin = Integer.MAX_VALUE;
        this.xMin = Integer.MAX_VALUE;
        this.yMax = Integer.MIN_VALUE;
        this.xMax = Integer.MIN_VALUE;
    }

    public final int mapX(double d, double d2) {
        return this.mapXi(d, d2, true);
    }

    public final int mapXi(double d, double d2, boolean bl) {
        this.ivx = (int)Math.round(this.mapXr(d, d2));
        if (bl) {
            if (this.ivx < this.xMin) {
                this.xMin = this.ivx;
            }
            if (this.ivx > this.xMax) {
                this.xMax = this.ivx;
            }
        }
        return this.ivx;
    }

    public final double mapXr(double d, double d2) {
        double d3 = d;
        double d4 = d2;
        if (this.isMacro) {
            d3 -= 100.0;
            d4 -= 100.0;
            if (this.mirror) {
                switch (this.orientation) {
                    case 0: {
                        this.vx = -d3 * this.xMagnitude;
                        break;
                    }
                    case 1: {
                        this.vx = d4 * this.yMagnitude;
                        break;
                    }
                    case 2: {
                        this.vx = d3 * this.xMagnitude;
                        break;
                    }
                    case 3: {
                        this.vx = -d4 * this.yMagnitude;
                        break;
                    }
                    default: {
                        this.vx = -d3 * this.xMagnitude;
                        break;
                    }
                }
            } else {
                switch (this.orientation) {
                    case 0: {
                        this.vx = d3 * this.xMagnitude;
                        break;
                    }
                    case 1: {
                        this.vx = -d4 * this.yMagnitude;
                        break;
                    }
                    case 2: {
                        this.vx = -d3 * this.xMagnitude;
                        break;
                    }
                    case 3: {
                        this.vx = d4 * this.yMagnitude;
                        break;
                    }
                    default: {
                        this.vx = d3 * this.xMagnitude;
                        break;
                    }
                }
            }
        } else {
            this.vx = d3 * this.xMagnitude;
        }
        return this.vx + this.xCenter;
    }

    public final int mapY(double d, double d2) {
        return this.mapYi(d, d2, true);
    }

    public final int mapYi(double d, double d2, boolean bl) {
        this.ivy = (int)Math.round(this.mapYr(d, d2));
        if (bl) {
            if (this.ivy < this.yMin) {
                this.yMin = this.ivy;
            }
            if (this.ivy > this.yMax) {
                this.yMax = this.ivy;
            }
        }
        return this.ivy;
    }

    public final double mapYr(double d, double d2) {
        double d3 = d;
        double d4 = d2;
        if (this.isMacro) {
            d3 -= 100.0;
            d4 -= 100.0;
            switch (this.orientation) {
                case 0: {
                    this.vy = d4 * this.yMagnitude;
                    break;
                }
                case 1: {
                    this.vy = d3 * this.xMagnitude;
                    break;
                }
                case 2: {
                    this.vy = -d4 * this.yMagnitude;
                    break;
                }
                case 3: {
                    this.vy = -d3 * this.xMagnitude;
                    break;
                }
                default: {
                    this.vy = 0.0;
                    break;
                }
            }
        } else {
            this.vy = d4 * this.yMagnitude;
        }
        return this.vy + this.yCenter;
    }

    public final void trackPoint(double d, double d2) {
        if (d2 < (double)this.yMin) {
            this.yMin = (int)d2;
        }
        if (d2 > (double)this.yMax) {
            this.yMax = (int)d2;
        }
        if (d < (double)this.xMin) {
            this.xMin = (int)d;
        }
        if (d > (double)this.xMax) {
            this.xMax = (int)d;
        }
    }

    public int unmapXnosnap(int n) {
        return (int)Math.round(((double)n - this.xCenter) / this.xMagnitude);
    }

    public int unmapYnosnap(int n) {
        return (int)Math.round(((double)n - this.yCenter) / this.yMagnitude);
    }

    public int unmapXsnap(int n) {
        int n2 = this.unmapXnosnap(n);
        if (this.snapActive) {
            n2 = (int)Math.round((double)n2 / (double)this.xGridStep);
            n2 *= this.xGridStep;
        }
        return n2;
    }

    public int unmapYsnap(int n) {
        int n2 = this.unmapYnosnap(n);
        if (this.snapActive) {
            n2 = (int)Math.round((double)n2 / (double)this.yGridStep);
            n2 *= this.yGridStep;
        }
        return n2;
    }

    public String toString() {
        Object object = "";
        object = (String)object + "[xCenter=" + this.xCenter;
        object = (String)object + "|yCenter=" + this.yCenter;
        object = (String)object + "|xMagnitude=" + this.xMagnitude;
        object = (String)object + "|yMagnitude=" + this.yMagnitude;
        object = (String)object + "|orientation=" + this.orientation;
        object = (String)object + "|mirror=" + this.mirror;
        object = (String)object + "|isMacro=" + this.isMacro;
        object = (String)object + "|snapActive=" + this.snapActive;
        object = (String)object + "|xMin=" + this.xMin;
        object = (String)object + "|xMax=" + this.xMax;
        object = (String)object + "|yMin=" + this.yMin;
        object = (String)object + "|yMax=" + this.yMax;
        object = (String)object + "|xGridStep=" + this.xGridStep;
        object = (String)object + "|yGridStep=" + this.yGridStep + "]";
        return object;
    }
}

