/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.geom;

public final class GeometricDistances {
    public static final int MIN_DISTANCE = 100;
    public static final int MAX_BEZIER_SEGMENTS = 10;
    private static int idx;
    private static int idy;
    private static int it;
    private static int ixmin;
    private static int ixmax;
    private static int iymin;
    private static int iymax;
    private static double dx;
    private static double dy;
    private static double t;
    private static double xmin;
    private static double ymin;
    private static double xmax;
    private static double ymax;
    private static int i;
    private static int j;
    private static boolean c;

    private GeometricDistances() {
    }

    public static double pointToPoint(double d, double d2, double d3, double d4) {
        if (Math.abs(d - d3) < 100.0 || Math.abs(d2 - d4) < 100.0) {
            return Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4));
        }
        return 100.0;
    }

    public static int pointToPoint(int n, int n2, int n3, int n4) {
        if (Math.abs(n - n3) < 100 || Math.abs(n2 - n4) < 100) {
            return (int)Math.sqrt((n - n3) * (n - n3) + (n2 - n4) * (n2 - n4));
        }
        return 100;
    }

    public static double pointToSegment(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d > d3) {
            xmin = d3;
            xmax = d;
        } else {
            xmin = d;
            xmax = d3;
        }
        if (d5 < xmin - 100.0 || d5 > xmax + 100.0) {
            return 100.0;
        }
        if (d2 > d4) {
            ymin = d4;
            ymax = d2;
        } else {
            ymin = d2;
            ymax = d4;
        }
        if (d6 < ymin - 100.0 || d6 > ymax + 100.0) {
            return 100.0;
        }
        dx = d3 - d;
        dy = d4 - d2;
        if (dx == 0.0 && dy == 0.0) {
            dx = d5 - d;
            dy = d6 - d4;
            return Math.sqrt(dx * dx + dy * dy);
        }
        t = ((d5 - d) * dx + (d6 - d2) * dy) / (dx * dx + dy * dy);
        if (t < 0.0) {
            dx = d5 - d;
            dy = d6 - d2;
        } else if (t > 1.0) {
            dx = d5 - d3;
            dy = d6 - d4;
        } else {
            dx = d5 - (d + t * dx);
            dy = d6 - (d2 + t * dy);
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static int pointToSegment(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n > n3) {
            ixmin = n3;
            ixmax = n;
        } else {
            ixmin = n;
            ixmax = n3;
        }
        if (n5 < ixmin - 100 || n5 > ixmax + 100) {
            return 100;
        }
        if (n2 > n4) {
            iymin = n4;
            iymax = n2;
        } else {
            iymin = n2;
            iymax = n4;
        }
        if (n6 < iymin - 100 || n6 > iymax + 100) {
            return 100;
        }
        if (n3 == n && n4 == n2) {
            idx = n5 - n;
            idy = n6 - n4;
            return (int)Math.sqrt(idx * idx + idy * idy);
        }
        idx = n3 - n;
        idy = n4 - n2;
        it = 1000 * ((n5 - n) * idx + (n6 - n2) * idy) / (idx * idx + idy * idy);
        if (it < 0) {
            idx = n5 - n;
            idy = n6 - n2;
        } else if (it > 1000) {
            idx = n5 - n3;
            idy = n6 - n4;
        } else {
            idx = n5 - (n + it * idx / 1000);
            idy = n6 - (n2 + it * idy / 1000);
        }
        return (int)Math.sqrt(idx * idx + idy * idy);
    }

    public static boolean pointInPolygon(int[] nArray, int[] nArray2, int n, double d, double d2) {
        c = false;
        i = 0;
        j = n - 1;
        while (i < n) {
            if (((double)nArray2[i] <= d2 && d2 < (double)nArray2[j] || (double)nArray2[j] <= d2 && d2 < (double)nArray2[i]) && d < (double)(nArray[j] - nArray[i]) * (d2 - (double)nArray2[i]) / (double)(nArray2[j] - nArray2[i]) + (double)nArray[i]) {
                c = !c;
            }
            j = i;
            j = i++;
        }
        return c;
    }

    public static boolean pointInEllipse(double d, double d2, double d3, double d4, double d5, double d6) {
        dx = Math.abs(d5 - (d + d3 / 2.0));
        dy = Math.abs(d6 - (d2 + d4 / 2.0));
        if (dx > d3 / 2.0 || dy > d4 / 2.0) {
            return false;
        }
        return 4.0 * dx * dx / d3 / d3 + 4.0 * dy * dy / d4 / d4 < 1.0;
    }

    public static boolean pointInEllipse(int n, int n2, int n3, int n4, int n5, int n6) {
        return GeometricDistances.pointInEllipse((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public static double pointToEllipse(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.abs(d5 - (d + d3 / 2.0));
        double d8 = Math.abs(d6 - (d2 + d4 / 2.0));
        if (d3 == 0.0) {
            return GeometricDistances.pointToSegment(d, d2, d, d2 + d4, d5, d6);
        }
        if (d4 == 0.0) {
            return GeometricDistances.pointToSegment(d, d2, d + d3, d2, d5, d6);
        }
        double d9 = (d7 * d7 / d3 / d3 + d8 * d8 / d4 / d4) * 4.0;
        return Math.abs(d9 - 1.0) * Math.min(d3, d4) / 4.0;
    }

    public static int pointToEllipse(int n, int n2, int n3, int n4, int n5, int n6) {
        return (int)Math.round(GeometricDistances.pointToEllipse((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6));
    }

    public static boolean pointInRectangle(double d, double d2, double d3, double d4, double d5, double d6) {
        return !(d > d5 || d5 > d + d3 || d2 > d6 || d6 > d2 + d4);
    }

    public static boolean pointInRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        return n <= n5 && n5 <= n + n3 && n2 <= n6 && n6 <= n2 + n4;
    }

    public static double pointToRectangle(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = GeometricDistances.pointToSegment(d, d2, d + d3, d2, d5, d6);
        double d8 = GeometricDistances.pointToSegment(d + d3, d2, d + d3, d2 + d4, d5, d6);
        double d9 = GeometricDistances.pointToSegment(d + d3, d2 + d4, d, d2 + d4, d5, d6);
        double d10 = GeometricDistances.pointToSegment(d, d2 + d4, d, d2, d5, d6);
        return Math.min(Math.min(d7, d8), Math.min(d9, d10));
    }

    public static int pointToRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = GeometricDistances.pointToSegment(n, n2, n + n3, n2, n5, n6);
        int n8 = GeometricDistances.pointToSegment(n + n3, n2, n + n3, n2 + n4, n5, n6);
        int n9 = GeometricDistances.pointToSegment(n + n3, n2 + n4, n, n2 + n4, n5, n6);
        int n10 = GeometricDistances.pointToSegment(n, n2 + n4, n, n2, n5, n6);
        return Math.min(Math.min(n7, n8), Math.min(n9, n10));
    }

    public static int pointToBezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11 = Integer.MAX_VALUE;
        i = 0;
        int[] nArray = new int[11];
        int[] nArray2 = new int[11];
        double d = 0.1;
        for (double d2 = 0.0; d2 < 1.0; d2 += d) {
            double d3 = 1.0 - d2;
            double d4 = d3 * d3 * d3;
            double d5 = 3.0 * d2 * d3 * d3;
            double d6 = 3.0 * d2 * d2 * d3;
            double d7 = d2 * d2 * d2;
            nArray[GeometricDistances.i] = (int)((double)n * d4 + (double)n3 * d5 + (double)n5 * d6 + (double)n7 * d7);
            nArray2[GeometricDistances.i] = (int)((double)n2 * d4 + (double)n4 * d5 + (double)n6 * d6 + (double)n8 * d7);
            ++i;
        }
        for (j = 0; j < 10; ++j) {
            n11 = Math.min(n11, GeometricDistances.pointToSegment(nArray[j], nArray2[j], nArray[j + 1], nArray2[j + 1], n9, n10));
        }
        return n11;
    }
}

