/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.geom;

import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.circuit.views.Drawing;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.graphic.nil.GraphicsNull;

public final class DrawingSize {
    private DrawingSize() {
    }

    public static DimensionG getImageSize(DrawingModel drawingModel, double d, boolean bl, PointG pointG) {
        int n;
        int n2;
        MapCoordinates mapCoordinates = new MapCoordinates();
        mapCoordinates.setMagnitudes(d, d);
        mapCoordinates.setXCenter(0.0);
        mapCoordinates.setYCenter(0.0);
        drawingModel.setChanged(true);
        Drawing drawing = new Drawing(drawingModel);
        drawing.draw(new GraphicsNull(), mapCoordinates);
        drawingModel.imgCanvas.trackExtremePoints(mapCoordinates);
        drawingModel.setChanged(true);
        if (bl) {
            n2 = mapCoordinates.getXMax() - mapCoordinates.getXMin();
            n = mapCoordinates.getYMax() - mapCoordinates.getYMin();
        } else {
            n2 = mapCoordinates.getXMax();
            n = mapCoordinates.getYMax();
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n <= 0) {
            n = 1;
        }
        if (mapCoordinates.getXMax() >= mapCoordinates.getXMin() && mapCoordinates.getYMax() >= mapCoordinates.getYMin()) {
            pointG.x = mapCoordinates.getXMin();
            pointG.y = mapCoordinates.getYMin();
        } else {
            pointG.x = 0;
            pointG.y = 0;
        }
        return new DimensionG(n2, n);
    }

    public static PointG getImageOrigin(DrawingModel drawingModel, double d) {
        int n;
        int n2;
        drawingModel.setChanged(true);
        MapCoordinates mapCoordinates = new MapCoordinates();
        mapCoordinates.setMagnitudes(d, d);
        mapCoordinates.setXCenter(0.0);
        mapCoordinates.setYCenter(0.0);
        Drawing drawing = new Drawing(drawingModel);
        drawingModel.imgCanvas.trackExtremePoints(mapCoordinates);
        drawing.draw(new GraphicsNull(), mapCoordinates);
        drawingModel.setChanged(true);
        if (mapCoordinates.getXMax() >= mapCoordinates.getXMin() && mapCoordinates.getYMax() >= mapCoordinates.getYMin()) {
            n2 = mapCoordinates.getXMin();
            n = mapCoordinates.getYMin();
        } else {
            n2 = 0;
            n = 0;
        }
        return new PointG(n2, n);
    }

    public static MapCoordinates calculateZoomToFit(DrawingModel drawingModel, int n, int n2, boolean bl) {
        double d;
        double d2;
        PointG pointG = new PointG(0, 0);
        MapCoordinates mapCoordinates = new MapCoordinates();
        DimensionG dimensionG = DrawingSize.getImageSize(drawingModel, 1.0, bl, pointG);
        double d3 = dimensionG.width + 1;
        double d4 = dimensionG.height + 1;
        if (!bl) {
            pointG = new PointG(0, 0);
        }
        double d5 = (d2 = 1.0 / (d3 / (double)n)) > (d = 1.0 / (d4 / (double)n2)) ? d : d2;
        if ((d5 = (double)Math.round(d5 * 100.0) / 100.0) < 0.25) {
            d5 = 0.25;
        }
        mapCoordinates.setMagnitudesNoCheck(d5, d5);
        d5 = mapCoordinates.getYMagnitude();
        mapCoordinates.setXCenter((double)pointG.x * d5);
        mapCoordinates.setYCenter((double)pointG.y * d5);
        return mapCoordinates;
    }
}

