/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.export.PointPr;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.ColorInterface;
import net.sourceforge.fidocadj.graphic.DecoratedText;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.graphic.PointDouble;
import net.sourceforge.fidocadj.graphic.TextInterface;
import net.sourceforge.fidocadj.layers.LayerDesc;

public class ExportSVG
implements ExportInterface,
TextInterface {
    private final OutputStreamWriter fstream;
    private BufferedWriter out;
    private Vector layerV;
    private ColorInterface c;
    private double strokeWidth;
    private String[] sDash;
    private float dashPhase;
    private float currentPhase = -1.0f;
    private float currentFontSize = 0.0f;
    private DecoratedText dt;
    private String fontname;
    private String bold = "";
    private float textx;
    private float texty;
    private boolean isItalic;
    private boolean isBold;
    private final GraphicsInterface gi;

    @Override
    public void setDashUnit(double d) {
        this.sDash = new String[5];
        this.sDash[0] = "";
        for (int i = 1; i < 5; ++i) {
            Object object = new String();
            for (int j = 0; j < Globals.dash[i].length; ++j) {
                object = (String)object + Globals.dash[i][j] * (float)d / 2.0f;
                if (j >= Globals.dash[i].length - 1) continue;
                object = (String)object + ",";
            }
            this.sDash[i] = object;
        }
    }

    @Override
    public void setDashPhase(float f) {
        this.dashPhase = f;
    }

    private double cLe(double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }

    public ExportSVG(File file, GraphicsInterface graphicsInterface) throws IOException {
        this.gi = graphicsInterface;
        this.fstream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8");
        this.dt = new DecoratedText(this);
    }

    @Override
    public void exportStart(DimensionG dimensionG, Vector<LayerDesc> vector, int n) throws IOException {
        this.layerV = vector;
        this.out = new BufferedWriter(this.fstream);
        int n2 = dimensionG.width;
        int n3 = dimensionG.height;
        this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?> \n<!DOCTYPE svg PUBLIC \"-//W3C//Dtd SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/Dtd/svg11.dtd\">\n<svg width=\"" + this.cLe(n2) + "\" height=\"" + this.cLe(n3) + "\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n<!-- Created by FidoCadJ ver. 0.24.8, export filter by Davide Bucci -->\n");
    }

    @Override
    public void exportEnd() throws IOException {
        this.out.write("</svg>");
        this.out.close();
    }

    @Override
    public void exportAdvText(int n, int n2, int n3, int n4, String string, boolean bl, boolean bl2, boolean bl3, int n5, int n6, String string2) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n6);
        this.c = layerDesc.getColor();
        this.isItalic = bl3;
        this.isBold = bl;
        this.fontname = string;
        this.out.write("<g transform=\"translate(" + this.cLe(n) + "," + this.cLe(n2) + ")");
        double d = (double)n3 / 22.0 / (double)n4 * 38.0;
        this.setFontSize(n4);
        if (n5 != 0) {
            double d2 = bl2 ? (double)n5 : (double)(-n5);
            this.out.write(" rotate(" + d2 + ") ");
        }
        if (bl2) {
            d = -d;
        }
        this.out.write(" scale(" + d + ",1) ");
        this.out.write("\">");
        this.textx = n;
        this.texty = n2;
        this.dt.drawString(string2, n, n2);
        this.out.write("</g>\n");
    }

    @Override
    public void exportBezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, int n10, int n11, int n12, int n13, double d) throws IOException {
        PointPr pointPr;
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n9);
        this.c = layerDesc.getColor();
        this.strokeWidth = d;
        if (bl) {
            pointPr = this.exportArrow(n, n2, n3, n4, n11, n12, n10);
            if (n11 > 0) {
                n = (int)Math.round(pointPr.x);
                n2 = (int)Math.round(pointPr.y);
            }
        }
        if (bl2) {
            pointPr = this.exportArrow(n7, n8, n5, n6, n11, n12, n10);
            if (n11 > 0) {
                n7 = (int)Math.round(pointPr.x);
                n8 = (int)Math.round(pointPr.y);
            }
        }
        this.out.write("<path d=\"M " + this.cLe(n) + "," + this.cLe(n2) + " C " + this.cLe(n3) + "," + this.cLe(n4) + " " + this.cLe(n5) + "," + this.cLe(n6) + " " + this.cLe(n7) + "," + this.cLe(n8) + "\" ");
        this.checkColorAndWidth("fill=\"none\"", n13);
    }

    @Override
    public void exportConnection(int n, int n2, int n3, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n3);
        this.c = layerDesc.getColor();
        this.strokeWidth = this.cLe(0.33);
        this.out.write("<circle cx=\"" + this.cLe(n) + "\" cy=\"" + this.cLe(n2) + "\" r=\"" + this.cLe(d / 2.0) + "\" style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + ";stroke-width:" + this.strokeWidth + "\" fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"/>\n");
    }

    @Override
    public void exportLine(double d, double d2, double d3, double d4, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, double d5) throws IOException {
        PointPr pointPr;
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n);
        this.c = layerDesc.getColor();
        this.strokeWidth = d5;
        double d6 = d;
        double d7 = d2;
        double d8 = d3;
        double d9 = d4;
        if (bl) {
            pointPr = this.exportArrow(d, d2, d3, d4, n3, n4, n2);
            if (n3 > 0) {
                d6 = pointPr.x;
                d7 = pointPr.y;
            }
        }
        if (bl2) {
            pointPr = this.exportArrow(d3, d4, d, d2, n3, n4, n2);
            if (n3 > 0) {
                d8 = pointPr.x;
                d9 = pointPr.y;
            }
        }
        this.out.write("<line x1=\"" + this.cLe(d6) + "\" y1=\"" + this.cLe(d7) + "\" x2=\"" + this.cLe(d8) + "\" y2=\"" + this.cLe(d9) + "\" ");
        this.checkColorAndWidth("fill=\"none\"", n5);
    }

    public boolean exportMacro(int n, int n2, boolean bl, int n3, String string, String string2, String string3, int n4, int n5, String string4, int n6, int n7, String string5, int n8, Map map) throws IOException {
        return false;
    }

    @Override
    public void exportOval(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n5);
        this.c = layerDesc.getColor();
        Object object = "";
        this.strokeWidth = d;
        object = bl ? "fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"" : "fill=\"none\"";
        this.out.write("<ellipse cx=\"" + this.cLe((double)(n + n3) / 2.0) + "\" cy=\"" + this.cLe((double)(n2 + n4) / 2.0) + "\" rx=\"" + this.cLe((double)Math.abs(n3 - n) / 2.0) + "\" ry=\"" + this.cLe((double)Math.abs(n4 - n2) / 2.0) + "\" ");
        this.checkColorAndWidth((String)object, n6);
    }

    @Override
    public void exportPCBLine(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n6);
        this.c = layerDesc.getColor();
        this.out.write("<line x1=\"" + this.cLe(n) + "\" y1=\"" + this.cLe(n2) + "\" x2=\"" + this.cLe(n3) + "\" y2=\"" + this.cLe(n4) + "\" style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + ";stroke-linejoin:round;stroke-linecap:round;stroke-width:" + n5 + "\"/>\n");
    }

    @Override
    public void exportPCBPad(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) throws IOException {
        this.strokeWidth = 0.33;
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n7);
        this.c = layerDesc.getColor();
        if (bl) {
            this.out.write("<circle cx=\"" + this.cLe(n) + "\" cy=\"" + this.cLe(n2) + "\" r=\"" + this.cLe((double)n6 / 2.0) + "\" style=\"stroke:white;stroke-width:" + this.strokeWidth + "\" fill=\"white\"/>\n");
        } else {
            switch (n3) {
                case 1: {
                    double d = this.cLe((double)n - (double)n4 / 2.0);
                    double d2 = this.cLe((double)n2 - (double)n5 / 2.0);
                    this.out.write("<rect x=\"" + d + "\" y=\"" + d2 + "\" rx=\"0\" ry=\"0\" width=\"" + this.cLe(n4) + "\" height=\"" + this.cLe(n5) + "\" style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + ";stroke-width:" + this.strokeWidth + "\" fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"/>\n");
                    break;
                }
                case 2: {
                    double d = this.cLe((double)n - (double)n4 / 2.0);
                    double d3 = this.cLe((double)n2 - (double)n5 / 2.0);
                    double d4 = this.cLe(2.5);
                    this.out.write("<rect x=\"" + d + "\" y=\"" + d3 + "\" rx=\"" + d4 + "\" ry=\"" + d4 + "\" width=\"" + this.cLe(n4) + "\" height=\"" + this.cLe(n5) + "\" style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + ";stroke-width:" + this.strokeWidth + "\" fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"/>\n");
                    break;
                }
                default: {
                    this.out.write("<ellipse cx=\"" + this.cLe(n) + "\" cy=\"" + this.cLe(n2) + "\" rx=\"" + this.cLe((double)n4 / 2.0) + "\" ry=\"" + this.cLe((double)n5 / 2.0) + "\" style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + ";stroke-width:" + this.cLe(this.strokeWidth) + "\" fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"/>\n");
                }
            }
        }
    }

    @Override
    public void exportPolygon(PointDouble[] pointDoubleArray, int n, boolean bl, int n2, int n3, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n2);
        this.c = layerDesc.getColor();
        Object object = "";
        this.strokeWidth = d;
        object = bl ? "fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"" : "fill=\"none\"";
        this.out.write("<polygon points=\"");
        for (int i = 0; i < n; ++i) {
            this.out.write(this.cLe(pointDoubleArray[i].x) + "," + this.cLe(pointDoubleArray[i].y) + " ");
        }
        this.out.write("\" ");
        this.checkColorAndWidth((String)object, n3);
    }

    @Override
    public boolean exportCurve(PointDouble[] pointDoubleArray, int n, boolean bl, boolean bl2, int n2, boolean bl3, boolean bl4, int n3, int n4, int n5, int n6, double d) throws IOException {
        return false;
    }

    @Override
    public void exportRectangle(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        this.strokeWidth = d;
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n5);
        this.c = layerDesc.getColor();
        Object object = "";
        object = bl ? "fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"" : "fill=\"none\"";
        this.out.write("<rect x=\"" + this.cLe(Math.min(n, n3)) + "\" y=\"" + this.cLe(Math.min(n2, n4)) + "\" rx=\"0\" ry=\"0\" width=\"" + this.cLe(Math.abs(n3 - n)) + "\" height=\"" + this.cLe(Math.abs(n4 - n2)) + "\" ");
        this.checkColorAndWidth((String)object, n6);
    }

    private String convertToHex2(int n) {
        Object object = Integer.toHexString(n);
        if (((String)object).length() == 1) {
            object = "0" + (String)object;
        }
        return object;
    }

    private void checkColorAndWidth(String string, int n) throws IOException {
        this.out.write("style=\"stroke:#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()));
        if (n > 0) {
            this.out.write(";stroke-dasharray: " + this.sDash[n]);
        }
        if (this.currentPhase != this.dashPhase) {
            this.currentPhase = this.dashPhase;
            this.out.write(";stroke-dashoffset: " + this.dashPhase);
        }
        this.out.write(";stroke-width:" + this.strokeWidth + ";fill-rule: evenodd;\" " + string + "/>\n");
    }

    @Override
    public PointPr exportArrow(double d, double d2, double d3, double d4, double d5, double d6, int n) throws IOException {
        double d7 = d == d3 ? 1.5707963267948966 + (d2 - d4 < 0.0 ? 0.0 : Math.PI) : Math.atan((d2 - d4) / (d - d3));
        double d8 = d - d5 * Math.cos(d7 += d - d3 > 0.0 ? 0.0 : Math.PI);
        double d9 = d2 - d5 * Math.sin(d7);
        double d10 = d8 - d6 * Math.sin(d7);
        double d11 = d9 + d6 * Math.cos(d7);
        double d12 = d8 + d6 * Math.sin(d7);
        double d13 = d9 - d6 * Math.cos(d7);
        this.out.write("<polygon points=\"");
        this.out.write(Globals.roundTo(d) + "," + Globals.roundTo(d2) + " ");
        this.out.write(Globals.roundTo(d10) + "," + Globals.roundTo(d11) + " ");
        this.out.write(Globals.roundTo(d12) + "," + Globals.roundTo(d13) + "\" ");
        Object object = (n & 2) == 0 ? "fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\"" : "fill=\"none\"";
        this.checkColorAndWidth((String)object, 0);
        if ((n & 1) != 0) {
            double d14 = d - d6 * Math.sin(d7);
            double d15 = d2 + d6 * Math.cos(d7);
            double d16 = d + d6 * Math.sin(d7);
            double d17 = d2 - d6 * Math.cos(d7);
            this.out.write("<line x1=\"" + this.cLe(d14) + "\" y1=\"" + this.cLe(d15) + "\" x2=\"" + this.cLe(d16) + "\" y2=\"" + this.cLe(d17) + "\" ");
            this.checkColorAndWidth("fill=\"none\"", 0);
        }
        return new PointPr(d8, d9);
    }

    @Override
    public double getFontSize() {
        return this.currentFontSize;
    }

    @Override
    public void setFontSize(double d) {
        this.currentFontSize = (float)d;
    }

    @Override
    public int getStringWidth(String string) {
        this.gi.setFont(this.fontname, this.currentFontSize);
        return this.gi.getStringWidth(string);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        try {
            this.out.write("<text x=\"" + ((float)n - this.textx) + "\" y=\"" + this.cLe(this.currentFontSize + (float)n2 - this.texty) + "\" font-family=\"" + this.fontname + "\" font-size=\"" + this.cLe(this.currentFontSize) + "\" font-style=\"" + (this.isItalic ? "italic" : "") + "\" font-weigth=\"" + (this.isBold ? "bold" : "") + "\" fill=\"#" + this.convertToHex2(this.c.getRed()) + this.convertToHex2(this.c.getGreen()) + this.convertToHex2(this.c.getBlue()) + "\">");
            String string2 = string.replace("&", "&amp;");
            string2 = string2.replace("<", "&lt;");
            string2 = string2.replace(">", "&gt;");
            string2 = string2.replace("\"", "&quot;");
            string2 = string2.replace("'", "&apos;");
            this.out.write(string2);
            this.out.write("</text>\n");
        }
        catch (IOException iOException) {
            System.err.println("Can not write to file in SVG export.");
        }
    }
}

