/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.export.PointPr;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.ColorInterface;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointDouble;
import net.sourceforge.fidocadj.layers.LayerDesc;

public class ExportPGF
implements ExportInterface {
    private final FileWriter fstream;
    private BufferedWriter out;
    private Vector layerV;
    private ColorInterface actualColor = null;
    private int currentDash;
    private double actualWidth;
    private float dashPhase;
    private float currentPhase = -1.0f;
    private String[] sDash;

    @Override
    public void setDashUnit(double d) {
        this.sDash = new String[5];
        this.sDash[0] = "";
        for (int i = 1; i < 5; ++i) {
            Object object = new String();
            for (int j = 0; j < Globals.dash[i].length; ++j) {
                object = (String)object + Globals.dash[i][j] * (float)d / 2.0f;
                if (j >= Globals.dash[i].length - 1) continue;
                object = (String)object + "pt}{";
            }
            this.sDash[i] = "{" + (String)object + "pt}";
        }
    }

    @Override
    public void setDashPhase(float f) {
        this.dashPhase = f;
    }

    public ExportPGF(File file) throws IOException {
        this.fstream = new FileWriter(file);
    }

    @Override
    public void exportStart(DimensionG dimensionG, Vector<LayerDesc> vector, int n) throws IOException {
        this.layerV = vector;
        this.out = new BufferedWriter(this.fstream);
        int n2 = dimensionG.width;
        int n3 = dimensionG.height;
        this.out.write("\\begin{pgfpicture}{0cm}{0cm}{" + n2 + "pt}{" + n3 + "pt}\n% Created by FidoCadJ ver. 0.24.8, export filter by Davide Bucci\n");
        this.out.write("\\pgfsetxvec{\\pgfpoint{1pt}{0pt}}\n");
        this.out.write("\\pgfsetyvec{\\pgfpoint{0pt}{1pt}}\n");
        this.out.write("\\pgfsetroundjoin \n\\pgfsetroundcap\n");
        this.out.write("\\pgftranslateto{\\pgfxy(0," + n3 + ")}\n");
        this.out.write("\\begin{pgfmagnify}{1}{-1}\n");
        this.out.write("% Layer color definitions\n");
        for (int i = 0; i < this.layerV.size(); ++i) {
            LayerDesc layerDesc = (LayerDesc)this.layerV.get(i);
            ColorInterface colorInterface = layerDesc.getColor();
            this.out.write("\\definecolor{layer" + i + "}{rgb}{" + (double)Math.round(100.0 * (double)colorInterface.getRed() / 255.0) / 100.0 + "," + (double)Math.round(100.0 * (double)colorInterface.getGreen() / 255.0) / 100.0 + "," + (double)Math.round(100.0 * (double)colorInterface.getBlue() / 255.0) / 100.0 + "}\n");
        }
        this.out.write("% End of color definitions\n");
        this.actualColor = null;
    }

    @Override
    public void exportEnd() throws IOException {
        this.out.write("\\end{pgfmagnify}\n");
        this.out.write("\\end{pgfpicture}");
        this.out.close();
    }

    @Override
    public void exportAdvText(int n, int n2, int n3, int n4, String string, boolean bl, boolean bl2, boolean bl3, int n5, int n6, String string2) throws IOException {
        this.registerColorSize(n6, -1.0);
        this.out.write("\\begin{pgfmagnify}{1}{-1}\n");
        this.out.write("\\pgfputat{\\pgfxy(" + n + "," + -n2 + ")}{\\pgfbox[left,top]{");
        this.out.write(string2);
        this.out.write("}}\n");
        this.out.write("\\end{pgfmagnify}\n");
    }

    @Override
    public void exportBezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, int n10, int n11, int n12, int n13, double d) throws IOException {
        PointPr pointPr;
        this.registerColorSize(n9, d);
        this.registerDash(n13);
        if (bl) {
            pointPr = this.exportArrow(n, n2, n3, n4, n11, n12, n10);
            if (n11 > 0) {
                n = (int)Math.round(pointPr.x);
                n2 = (int)Math.round(pointPr.y);
            }
        }
        if (bl2) {
            pointPr = this.exportArrow(n7, n8, n5, n6, n11, n12, n10);
            if (n11 > 0) {
                n7 = (int)Math.round(pointPr.x);
                n8 = (int)Math.round(pointPr.y);
            }
        }
        this.out.write("\\pgfmoveto{\\pgfxy(" + n + "," + n2 + ")} \n\\pgfcurveto{\\pgfxy(" + n3 + "," + n4 + ")}{\\pgfxy(" + n5 + "," + n6 + ")}{\\pgfxy(" + n7 + "," + n8 + ")}\n\\pgfstroke\n");
    }

    @Override
    public void exportConnection(int n, int n2, int n3, double d) throws IOException {
        this.registerColorSize(n3, 0.33);
        this.out.write("\\pgfcircle[fill]{\\pgfxy(" + n + "," + n2 + ")}{" + d / 2.0 + "pt}");
    }

    @Override
    public void exportLine(double d, double d2, double d3, double d4, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, double d5) throws IOException {
        PointPr pointPr;
        this.registerColorSize(n, d5);
        this.registerDash(n5);
        double d6 = d;
        double d7 = d2;
        double d8 = d3;
        double d9 = d4;
        if (bl) {
            pointPr = this.exportArrow(d, d2, d3, d4, n3, n4, n2);
            if (n3 > 0) {
                d6 = pointPr.x;
                d7 = pointPr.y;
            }
        }
        if (bl2) {
            pointPr = this.exportArrow(d3, d4, d, d2, n3, n4, n2);
            if (n3 > 0) {
                d8 = pointPr.x;
                d9 = pointPr.y;
            }
        }
        this.out.write("\\pgfline{\\pgfxy(" + d6 + "," + d7 + ")}{\\pgfxy(" + d8 + "," + d9 + ")}\n");
    }

    @Override
    public PointPr exportArrow(double d, double d2, double d3, double d4, double d5, double d6, int n) throws IOException {
        double d7 = d == d3 ? 1.5707963267948966 + (d2 - d4 < 0.0 ? 0.0 : Math.PI) : Math.atan((d2 - d4) / (d - d3));
        double d8 = d - d5 * Math.cos(d7 += d - d3 > 0.0 ? 0.0 : Math.PI);
        double d9 = d2 - d5 * Math.sin(d7);
        double d10 = d8 - d6 * Math.sin(d7);
        double d11 = d9 + d6 * Math.cos(d7);
        double d12 = d8 + d6 * Math.sin(d7);
        double d13 = d9 - d6 * Math.cos(d7);
        this.out.write("\\pgfmoveto{\\pgfxy(" + d + "," + d2 + ")}\n");
        this.out.write("\\pgflineto{\\pgfxy(" + d10 + "," + d11 + ")}\n");
        this.out.write("\\pgflineto{\\pgfxy(" + d12 + "," + d13 + ")}\n");
        this.out.write("\\pgfclosepath \n");
        if ((n & 2) == 0) {
            this.out.write("\\pgffill \n");
        } else {
            this.out.write("\\pgfqstroke \n");
        }
        if ((n & 1) != 0) {
            double d14 = d - d6 * Math.sin(d7);
            double d15 = d2 + d6 * Math.cos(d7);
            double d16 = d + d6 * Math.sin(d7);
            double d17 = d2 - d6 * Math.cos(d7);
            this.out.write("\\pgfline{\\pgfxy(" + d14 + "," + d15 + ")}{\\pgfxy(" + d16 + "," + d17 + ")}\n");
        }
        return new PointPr(d8, d9);
    }

    public boolean exportMacro(int n, int n2, boolean bl, int n3, String string, String string2, String string3, int n4, int n5, String string4, int n6, int n7, String string5, int n8, Map map) throws IOException {
        return false;
    }

    @Override
    public void exportOval(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        this.registerColorSize(n5, d);
        this.registerDash(n6);
        this.out.write("\\pgfellipse[" + (bl ? "fillstroke" : "stroke") + "]{\\pgfxy(" + (double)(n + n3) / 2.0 + "," + (double)(n2 + n4) / 2.0 + ")}{\\pgfxy(" + (double)Math.abs(n3 - n) / 2.0 + ",0)}{\\pgfxy(0," + (double)Math.abs(n4 - n2) / 2.0 + ")}\n");
    }

    @Override
    public void exportPCBLine(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        this.registerColorSize(n6, n5);
        this.registerDash(0);
        this.out.write("\\pgfline{\\pgfxy(" + n + "," + n2 + ")}{\\pgfxy(" + n3 + "," + n4 + ")}\n");
    }

    @Override
    public void exportPCBPad(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) throws IOException {
        if (bl) {
            if (!this.actualColor.equals(this.actualColor.white())) {
                this.actualColor = this.actualColor.white();
                this.out.write("\\color{white}\n");
            }
            this.out.write("\\pgfellipse[fillstroke]{\\pgfxy(" + n + "," + n2 + ")}{\\pgfxy(" + n6 / 2 + ",0)}{\\pgfxy(0," + n6 / 2 + ")}\n");
        } else {
            this.registerColorSize(n7, 0.33);
            switch (n3) {
                case 1: {
                    double d = (double)n - (double)n4 / 2.0;
                    double d2 = (double)n2 - (double)n5 / 2.0;
                    this.out.write("\\pgfrect[fillstroke]{\\pgfxy(" + d + "," + d2 + ")}{\\pgfxy(" + n4 + "," + n5 + ")}\n");
                    break;
                }
                case 2: {
                    double d = (double)n - (double)n4 / 2.0;
                    double d3 = (double)n2 - (double)n5 / 2.0;
                    this.out.write("\\pgfrect[fillstroke]{\\pgfxy(" + d + "," + d3 + ")}{\\pgfxy(" + n4 + "," + n5 + ")}\n");
                    break;
                }
                default: {
                    this.out.write("\\pgfellipse[fillstroke]{\\pgfxy(" + n + "," + n2 + ")}{\\pgfxy(" + (double)n4 / 2.0 + ",0)}{\\pgfxy(0," + (double)n5 / 2.0 + ")}\n");
                }
            }
        }
    }

    @Override
    public void exportPolygon(PointDouble[] pointDoubleArray, int n, boolean bl, int n2, int n3, double d) throws IOException {
        this.registerColorSize(n2, d);
        this.registerDash(n3);
        String string = "";
        this.out.write("\\pgfmoveto{\\pgfxy(" + pointDoubleArray[0].x + "," + pointDoubleArray[0].y + ")}\n");
        for (int i = 1; i < n; ++i) {
            this.out.write("\\pgflineto{\\pgfxy(" + pointDoubleArray[i].x + "," + pointDoubleArray[i].y + ")}\n");
        }
        this.out.write("\\pgfclosepath \n");
        if (bl) {
            this.out.write("\\pgffill \n");
        } else {
            this.out.write("\\pgfqstroke \n");
        }
    }

    @Override
    public boolean exportCurve(PointDouble[] pointDoubleArray, int n, boolean bl, boolean bl2, int n2, boolean bl3, boolean bl4, int n3, int n4, int n5, int n6, double d) throws IOException {
        return false;
    }

    @Override
    public void exportRectangle(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        this.registerColorSize(n5, d);
        this.registerDash(n6);
        this.out.write("\\pgfmoveto{\\pgfxy(" + n + "," + n2 + ")}\n");
        this.out.write("\\pgflineto{\\pgfxy(" + n3 + "," + n2 + ")}\n");
        this.out.write("\\pgflineto{\\pgfxy(" + n3 + "," + n4 + ")}\n");
        this.out.write("\\pgflineto{\\pgfxy(" + n + "," + n4 + ")}\n");
        this.out.write("\\pgfclosepath \n");
        if (bl) {
            this.out.write("\\pgffill \n");
        } else {
            this.out.write("\\pgfqstroke \n");
        }
    }

    private void registerColorSize(int n, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n);
        ColorInterface colorInterface = layerDesc.getColor();
        if (!colorInterface.equals(this.actualColor)) {
            this.actualColor = colorInterface;
            this.out.write("\\color{layer" + n + "}\n");
        }
        if (d > 0.0 && this.actualWidth != d) {
            this.out.write("\\pgfsetlinewidth{" + d + "pt}\n");
            this.actualWidth = d;
        }
    }

    private void registerDash(int n) throws IOException {
        if (this.currentDash != n || this.currentPhase != this.dashPhase) {
            this.currentDash = n;
            this.currentPhase = this.dashPhase;
            if (n == 0) {
                this.out.write("\\pgfsetdash{}{0pt}\n");
            } else {
                this.out.write("\\pgfsetdash{" + this.sDash[n] + "}{" + this.dashPhase + "pt}\n");
            }
        }
    }
}

