/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.export;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.export.PointPr;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.ColorInterface;
import net.sourceforge.fidocadj.graphic.DecoratedText;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.graphic.PointDouble;
import net.sourceforge.fidocadj.graphic.TextInterface;
import net.sourceforge.fidocadj.layers.LayerDesc;

public class ExportPDF
implements ExportInterface,
TextInterface {
    private final File temp;
    private final OutputStreamWriter fstream;
    private final OutputStreamWriter fstreamt;
    private BufferedWriter out;
    private BufferedWriter outt;
    private boolean fontWarning;
    private String userfont;
    private float dashPhase;
    private float currentPhase = -1.0f;
    private float currentFontSize = 0.0f;
    private DecoratedText dt;
    private String currentFont;
    private float textx;
    private float texty;
    private final GraphicsInterface gi;
    private Map<Integer, String> unicodeToGlyph;
    private Map<Integer, Integer> uncodeCharsNeeded;
    private int unicodeCharIndex;
    private String head;
    private String[] obj_PDF;
    private static final int numOfObjects = 20;
    private String closeObject;
    private long fileLength;
    private Vector layerV;
    private ColorInterface actualColor;
    private double actualWidth;
    private int currentDash;
    static final String encoding = "UTF8";
    private String[] sDash;

    @Override
    public void setDashUnit(double d) {
        this.sDash = new String[5];
        this.sDash[0] = "";
        for (int i = 1; i < 5; ++i) {
            Object object = new String();
            for (int j = 0; j < Globals.dash[i].length; ++j) {
                object = (String)object + Globals.dash[i][j] * (float)d / 2.0f;
                if (j >= Globals.dash[i].length - 1) continue;
                object = (String)object + " ";
            }
            this.sDash[i] = "[" + (String)object + "]";
        }
    }

    @Override
    public void setDashPhase(float f) {
        this.dashPhase = f;
    }

    public ExportPDF(File file, GraphicsInterface graphicsInterface) throws IOException {
        this.gi = graphicsInterface;
        this.dashPhase = 0.0f;
        this.fstream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        this.temp = File.createTempFile("real", ".howto");
        this.temp.deleteOnExit();
        this.fstreamt = new OutputStreamWriter((OutputStream)new FileOutputStream(this.temp), encoding);
        this.obj_PDF = new String[20];
        this.dt = new DecoratedText(this);
    }

    @Override
    public void exportStart(DimensionG dimensionG, Vector<LayerDesc> vector, int n) throws IOException {
        this.initGlyphList();
        this.layerV = vector;
        this.out = new BufferedWriter(this.fstream);
        this.fontWarning = false;
        this.outt = new BufferedWriter(this.fstreamt);
        int n2 = dimensionG.width;
        int n3 = dimensionG.height;
        double d = 2.7777777777777777;
        int n4 = 5;
        this.head = "%PDF-1.4\n";
        this.obj_PDF[5] = "5 0 obj\n  <</Kids [4 0 R ]\n    /Count 1\n    /Type /Pages\n    /MediaBox [ 0 0  " + (int)((double)dimensionG.width / d + 1.0 + (double)n4) + " " + (int)((double)dimensionG.height / d + 1.0 + (double)n4) + " ]\n  >> endobj\n";
        this.actualColor = null;
        this.actualWidth = -1.0;
        this.outt.write("   1 0 0 1 0 " + ((double)dimensionG.height / d + (double)n4) + "  cm\n");
        this.outt.write("  " + 1.0 / d + " 0  0 " + -1.0 / d + " 0 0  cm\n");
        this.outt.write("1 J\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGlyphList() throws IOException {
        this.unicodeToGlyph = new HashMap<Integer, String>(5000);
        this.uncodeCharsNeeded = new HashMap<Integer, Integer>(128);
        this.unicodeCharIndex = 127;
        try (BufferedReader bufferedReader = null;){
            InputStreamReader inputStreamReader = new InputStreamReader(this.getClass().getResourceAsStream("glyphlist.txt"), encoding);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            while (string != null) {
                if (!string.startsWith("#")) {
                    int n = string.indexOf(59);
                    int n2 = string.indexOf(32);
                    String string2 = string.substring(0, n);
                    String string3 = n2 < 0 ? string.substring(n + 1) : string.substring(n + 1, n2);
                    Integer n3 = Integer.decode("0x" + string3);
                    this.unicodeToGlyph.put(n3, string2);
                }
                string = bufferedReader.readLine();
            }
        }
    }

    @Override
    public void exportEnd() throws IOException {
        this.outt.close();
        this.fileLength = this.temp.length();
        this.writeFontDescription();
        this.obj_PDF[8] = "8 0 obj\n  <<\n    /Length " + this.fileLength + "\n  >>\n  stream\n";
        this.out.write(this.head + this.obj_PDF[5] + this.obj_PDF[6] + this.obj_PDF[7] + this.obj_PDF[8]);
        this.obj_PDF[4] = "4 0 obj\n<< \n  /Type /Page\n  /Parent 5 0 R\n  /Resources <<\n  /Font <<\n  /F1 6 0 R\n  /F2 7 0 R\n  /F3 9 0 R\n  /F4 10 0 R\n  /F5 11 0 R\n  /F6 12 0 R\n  /F7 13 0 R\n  /F8 14 0 R\n  /F9 15 0 R\n>>\n/ProcSet 2 0 R\n>>\n  /Contents 8 0 R\n>>\nendobj\n";
        this.obj_PDF[2] = "2 0 obj\n[ /PDF /Text  ]\nendobj\n";
        this.obj_PDF[1] = "1 0 obj\n<<\n  /Creator (FidoCadJ0.24.8, PDF export filter by Davide Bucci)\n  /Author (" + System.getProperty("user.name") + ")\n  /Producer (FidoCadJ)\n>>\nendobj\n";
        this.obj_PDF[3] = "3 0 obj\n<<\n  /Pages 5 0 R\n  /Type /Catalog\n>>\nendobj\n";
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.temp), encoding));){
            String string = bufferedReader.readLine();
            while (string != null) {
                this.out.write(string + "\n");
                string = bufferedReader.readLine();
            }
        }
        this.closeObject = "endstream\nendobj\n";
        this.out.write(this.closeObject + this.obj_PDF[4] + this.obj_PDF[2] + this.obj_PDF[1] + this.obj_PDF[3] + this.obj_PDF[9] + this.obj_PDF[10] + this.obj_PDF[11] + this.obj_PDF[12] + this.obj_PDF[13] + this.obj_PDF[14] + this.obj_PDF[15] + this.obj_PDF[16]);
        this.writeCrossReferenceTable();
        this.out.close();
        if (this.fontWarning) {
            if (GraphicsEnvironment.isHeadless()) {
                System.err.println("Some fonts were not available!");
            } else {
                JOptionPane.showMessageDialog(null, Globals.messages.getString("PDF_Font_error"));
            }
        }
    }

    private void writeFontDescription() throws IOException {
        this.obj_PDF[6] = "6 0 obj\n  <<   /Type /Font\n    /Subtype /Type1\n    /BaseFont /Courier\n" + this.calcWidthsIndex("Courier") + "    /Encoding 16 0 R\n  >> endobj\n";
        this.obj_PDF[7] = "7 0 obj\n  <<   /Type /Font\n    /Subtype /Type1\n    /BaseFont /Courier-Bold\n" + this.calcWidthsIndex("Courier-Bold") + "    /Encoding  16 0 R\n  >> endobj\n";
        this.obj_PDF[9] = "9 0 obj\n  <<   /Type /Font\n    /Subtype /Type1\n    /BaseFont /Times-Roman\n" + this.calcWidthsIndex("Times-Roman") + "    /Encoding  16 0 R\n  >> endobj\n";
        this.obj_PDF[10] = "10 0 obj\n  <<   /Type /Font\n    /Subtype /Type1\n    /BaseFont /Times-Bold\n" + this.calcWidthsIndex("Times-Bold") + "    /Encoding  16 0 R\n  >> endobj\n";
        this.obj_PDF[11] = "11 0 obj\n  <<   /Type /Font\n    /Subtype /Type1\n    /BaseFont /Helvetica\n" + this.calcWidthsIndex("Helvetica") + "    /Encoding  16 0 R\n  >> endobj\n";
        this.obj_PDF[12] = "12 0 obj\n  <<   /Type /Font\n    /Subtype /Type1\n    /BaseFont /Helvetica-Bold\n" + this.calcWidthsIndex("Helvetica-Bold") + "    /Encoding  16 0 R\n  >> endobj\n";
        this.obj_PDF[13] = "13 0 obj\n  <<   /Type /Font\n    /Subtype /Type1\n    /BaseFont /Symbol\n" + this.calcWidthsIndex("Symbol") + "    /Encoding  16 0 R\n  >> endobj\n";
        this.obj_PDF[14] = "14 0 obj\n  <<   /Type /Font\n    /Subtype /Type1\n" + this.calcWidthsIndex("Symbol") + "    /BaseFont /Symbol\n    /Encoding  16 0 R\n  >> endobj\n";
        this.obj_PDF[15] = "15 0 obj\n  <<   /Type /Font\n    /Subtype /Type1\n" + this.calcWidthsIndex(this.userfont) + "    /BaseFont /" + this.userfont + "\n    /Encoding  16 0 R\n  >> endobj\n";
        this.obj_PDF[16] = "16 0 obj\n   <<  /Type /Encoding\n    /BaseEncoding /WinAnsiEncoding\n    /Differences [";
        for (Integer n : this.uncodeCharsNeeded.keySet()) {
            String string = this.unicodeToGlyph.get(this.uncodeCharsNeeded.get(n));
            this.obj_PDF[16] = this.obj_PDF[16] + n + "/" + this.unicodeToGlyph.get(this.uncodeCharsNeeded.get(n)) + " ";
        }
        this.obj_PDF[16] = this.obj_PDF[16] + "]\n  >> endobj\n";
    }

    private String calcWidthsIndex(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        this.gi.setFont(string, 24.0);
        int n2 = this.gi.getStringWidth("M");
        stringBuilder.append("    /FirstChar 32\n");
        stringBuilder.append("    /LastChar ");
        stringBuilder.append(this.unicodeCharIndex);
        stringBuilder.append("\n");
        stringBuilder.append("    /Widths [");
        int n3 = 900;
        for (int i = 32; i < 128; ++i) {
            n = n3 * this.gi.getStringWidth("" + (char)i) / n2;
            stringBuilder.append(n);
            stringBuilder.append(" ");
        }
        for (Integer n4 : this.uncodeCharsNeeded.keySet()) {
            n = n3 * this.gi.getStringWidth("" + (char)this.uncodeCharsNeeded.get(n4).intValue()) / n2;
            stringBuilder.append(n);
            stringBuilder.append(" ");
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }

    private void writeCrossReferenceTable() throws IOException {
        this.out.write("xref \n0 15\n0000000000 65535 f \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length()) + " 00000 n \n" + this.addLeadZeros(this.head.length()) + " 00000 n \n" + this.addLeadZeros(this.head.length() + this.obj_PDF[5].length()) + " 00000 n \n" + this.addLeadZeros(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length()) + " 00000 n \n" + this.addLeadZeros(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length() + (long)this.obj_PDF[11].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length() + (long)this.obj_PDF[11].length() + (long)this.obj_PDF[12].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length() + (long)this.obj_PDF[11].length() + (long)this.obj_PDF[12].length() + (long)this.obj_PDF[13].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length() + (long)this.obj_PDF[11].length() + (long)this.obj_PDF[12].length() + (long)this.obj_PDF[13].length() + (long)this.obj_PDF[14].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length() + (long)this.obj_PDF[11].length() + (long)this.obj_PDF[12].length() + (long)this.obj_PDF[13].length() + (long)this.obj_PDF[14].length() + (long)this.obj_PDF[15].length()) + " 00000 n \n");
        this.out.write("trailer\n<<\n  /Size 16\n  /Root 3 0 R\n  /Info 1 0 R\n>>\nstartxref\n" + ((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length() + (long)this.obj_PDF[11].length() + (long)this.obj_PDF[12].length() + (long)this.obj_PDF[13].length() + (long)this.obj_PDF[14].length() + (long)this.obj_PDF[15].length() + (long)this.obj_PDF[16].length()) + "\n%%EOF");
    }

    @Override
    public void exportAdvText(int n, int n2, int n3, int n4, String string, boolean bl, boolean bl2, boolean bl3, int n5, int n6, String string2) throws IOException {
        double d;
        String string3 = string2;
        if ("".equals(string3)) {
            return;
        }
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n6);
        ColorInterface colorInterface = layerDesc.getColor();
        String string4 = "";
        this.checkColorAndWidth(colorInterface, 0.33);
        this.outt.write("BT\n");
        int n7 = (int)((double)n3 * 12.0 / 7.0 + 0.5);
        if ("Courier".equals(string) || "Courier New".equals(string)) {
            this.currentFont = bl ? "/F2" : "/F1";
        } else if ("Times".equals(string) || "Times New Roman".equals(string) || "Times Roman".equals(string)) {
            this.currentFont = bl ? "/F4" : "/F3";
        } else if ("Helvetica".equals(string) || "Arial".equals(string)) {
            this.currentFont = bl ? "/F6" : "/F5";
        } else if ("Symbol".equals(string)) {
            this.currentFont = bl ? "/F8" : "/F7";
        } else {
            this.fontWarning = true;
            this.userfont = string;
            this.currentFont = "/F9";
        }
        this.outt.write(this.currentFont + " " + n7 + " Tf\n");
        this.currentFontSize = n7;
        this.outt.write("q\n");
        this.outt.write("  1 0 0 1 " + Globals.roundTo(n) + " " + Globals.roundTo(n2) + " cm\n");
        this.textx = n;
        this.texty = n2;
        if (n5 != 0) {
            d = (double)(bl2 ? n5 : -n5) / 180.0 * Math.PI;
            this.outt.write("  " + Globals.roundTo(Math.cos(d)) + " " + Globals.roundTo(Math.sin(d)) + " " + Globals.roundTo(-Math.sin(d)) + " " + Globals.roundTo(Math.cos(d)) + " 0 0 cm\n");
        }
        if (bl2) {
            this.outt.write("  -1 0 0 -1 0 0 cm\n");
        } else {
            this.outt.write("  1 0 0 -1 0 0 cm\n");
        }
        d = n4 / n3 == 1 ? 1.0 : (double)n4 / (double)n3 * 22.0 / 40.0;
        this.outt.write("  1 0 0 " + Globals.roundTo(d) + " 0 " + (double)(-n7) * d * 0.8 + " cm\n");
        this.dt.drawString(string3, n, n2);
        this.outt.write("Q\nET\n");
    }

    @Override
    public void exportBezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, int n10, int n11, int n12, int n13, double d) throws IOException {
        PointPr pointPr;
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n9);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, d);
        this.registerDash(n13);
        if (bl) {
            pointPr = this.exportArrow(n, n2, n3, n4, n11, n12, n10);
            if (n11 > 0) {
                n = (int)Math.round(pointPr.x);
                n2 = (int)Math.round(pointPr.y);
            }
        }
        if (bl2) {
            pointPr = this.exportArrow(n7, n8, n5, n6, n11, n12, n10);
            if (n11 > 0) {
                n7 = (int)Math.round(pointPr.x);
                n8 = (int)Math.round(pointPr.y);
            }
        }
        this.outt.write(n + " " + n2 + " m \n");
        this.outt.write(n3 + " " + n4 + " " + n5 + " " + n6 + " " + n7 + " " + n8 + " c S\n");
    }

    @Override
    public void exportConnection(int n, int n2, int n3, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n3);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, 0.33);
        this.ellipse((double)n - d / 2.0, (double)n2 - d / 2.0, (double)n + d / 2.0, (double)n2 + d / 2.0, true);
    }

    @Override
    public void exportLine(double d, double d2, double d3, double d4, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, double d5) throws IOException {
        PointPr pointPr;
        double d6 = d;
        double d7 = d2;
        double d8 = d3;
        double d9 = d4;
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, d5);
        this.registerDash(n5);
        if (bl) {
            pointPr = this.exportArrow(d, d2, d3, d4, n3, n4, n2);
            if (n3 > 0) {
                d6 = pointPr.x;
                d7 = pointPr.y;
            }
        }
        if (bl2) {
            pointPr = this.exportArrow(d3, d4, d, d2, n3, n4, n2);
            if (n3 > 0) {
                d8 = pointPr.x;
                d9 = pointPr.y;
            }
        }
        this.outt.write("  " + d6 + " " + d7 + " m " + d8 + " " + d9 + " l S\n");
    }

    public boolean exportMacro(int n, int n2, boolean bl, int n3, String string, String string2, String string3, int n4, int n5, String string4, int n6, int n7, String string5, int n8, Map map) throws IOException {
        return false;
    }

    @Override
    public void exportOval(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n5);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, d);
        this.registerDash(n6);
        this.ellipse(n, n2, n3, n4, bl);
    }

    @Override
    public void exportPCBLine(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n6);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, n5);
        this.registerDash(0);
        this.outt.write("  " + n + " " + n2 + " m " + n3 + " " + n4 + " l S\n");
    }

    @Override
    public void exportPCBPad(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n7);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, 0.33);
        if (!bl) {
            switch (n3) {
                case 2: {
                    this.roundRect((double)n - (double)n4 / 2.0, (double)n2 - (double)n5 / 2.0, n4, n5, 4.0, true);
                    break;
                }
                case 1: {
                    double d = (double)n - (double)n4 / 2.0;
                    double d2 = (double)n2 - (double)n5 / 2.0;
                    this.outt.write(d + " " + d2 + " m\n");
                    this.outt.write(d + (double)n4 + " " + d2 + " l\n");
                    this.outt.write(d + (double)n4 + " " + (d2 + (double)n5) + " l\n");
                    this.outt.write(d + " " + (d2 + (double)n5) + " l\n");
                    this.outt.write("B\n");
                    break;
                }
                default: {
                    this.ellipse((double)n - (double)n4 / 2.0, (double)n2 - (double)n5 / 2.0, (double)n + (double)n4 / 2.0, (double)n2 + (double)n5 / 2.0, true);
                    this.outt.write("f\n");
                }
            }
        }
        this.checkColorAndWidth(colorInterface.white(), 0.33);
        this.ellipse((double)n - (double)n6 / 2.0, (double)n2 - (double)n6 / 2.0, (double)n + (double)n6 / 2.0, (double)n2 + (double)n6 / 2.0, true);
        this.outt.write("f\n");
    }

    @Override
    public void exportPolygon(PointDouble[] pointDoubleArray, int n, boolean bl, int n2, int n3, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n2);
        ColorInterface colorInterface = layerDesc.getColor();
        String string = "";
        if (n < 1) {
            return;
        }
        this.checkColorAndWidth(colorInterface, d);
        this.registerDash(n3);
        this.outt.write("  " + pointDoubleArray[0].x + " " + pointDoubleArray[0].y + " m\n");
        for (int i = 1; i < n; ++i) {
            this.outt.write("  " + pointDoubleArray[i].x + " " + pointDoubleArray[i].y + " l\n");
        }
        if (bl) {
            this.outt.write("  f*\n");
        } else {
            this.outt.write("  s\n");
        }
    }

    @Override
    public boolean exportCurve(PointDouble[] pointDoubleArray, int n, boolean bl, boolean bl2, int n2, boolean bl3, boolean bl4, int n3, int n4, int n5, int n6, double d) throws IOException {
        return false;
    }

    @Override
    public void exportRectangle(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n5);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, d);
        this.registerDash(n6);
        this.outt.write("  " + n + " " + n2 + " m\n");
        this.outt.write("  " + n3 + " " + n2 + " l\n");
        this.outt.write("  " + n3 + " " + n4 + " l\n");
        this.outt.write("  " + n + " " + n4 + " l\n");
        if (bl) {
            this.outt.write("f\n");
        } else {
            this.outt.write("s\n");
        }
    }

    private void roundRect(double d, double d2, double d3, double d4, double d5, boolean bl) throws IOException {
        this.outt.write(d + d5 + " " + d2 + " m\n");
        this.outt.write(d + d3 - d5 + " " + d2 + " l\n");
        this.outt.write(d + d3 + " " + d2 + " " + (d + d3) + " " + (d2 + d5) + " y\n");
        this.outt.write(d + d3 + " " + (d2 + d4 - d5) + " l\n");
        this.outt.write(d + d3 + " " + (d2 + d4) + " " + (d + d3 - d5) + " " + (d2 + d4) + " y\n");
        this.outt.write(d + d5 + " " + (d2 + d4) + " l\n");
        this.outt.write(d + " " + (d2 + d4) + " " + d + " " + (d2 + d4 - d5) + " y\n");
        this.outt.write(d + " " + (d2 + d5) + " l\n");
        this.outt.write(d + " " + d2 + " " + (d + d5) + " " + d2 + " y \n");
        this.outt.write("  " + (bl ? "f\n" : "s\n"));
    }

    private void ellipse(double d, double d2, double d3, double d4, boolean bl) throws IOException {
        double d5 = (d + d3) / 2.0;
        double d6 = (d2 + d4) / 2.0;
        double d7 = Math.abs(d3 - d) / 2.0;
        double d8 = Math.abs(d4 - d2) / 2.0;
        this.outt.write("  " + Globals.roundTo(d5 + d7) + " " + Globals.roundTo(d6) + " m\n");
        for (int i = 0; i < 32; ++i) {
            double d9 = Math.PI * 2 * (double)i / 32.0;
            double d10 = d5 + d7 * Math.cos(d9);
            double d11 = d6 + d8 * Math.sin(d9);
            double d12 = d5 + 1.02 * d7 * Math.cos(d9 += 0.06544984694978735);
            double d13 = d6 + 1.02 * d8 * Math.sin(d9);
            double d14 = d5 + 1.01 * d7 * Math.cos(d9 += 0.06544984694978735);
            double d15 = d6 + 1.01 * d8 * Math.sin(d9);
            double d16 = d5 + d7 * Math.cos(d9 += 0.06544984694978735);
            double d17 = d6 + d8 * Math.sin(d9);
            this.outt.write(Globals.roundTo(d14) + " " + Globals.roundTo(d15) + " " + Globals.roundTo(d16) + " " + Globals.roundTo(d17) + " y\n");
        }
        this.outt.write("  " + (bl ? "f\n" : "s\n"));
    }

    private String addLeadZeros(long l) {
        String string = "" + l;
        while (string.length() < 10) {
            string = "0" + string;
        }
        return string;
    }

    private void checkColorAndWidth(ColorInterface colorInterface, double d) throws IOException {
        if (!colorInterface.equals(this.actualColor)) {
            this.outt.write("  " + Globals.roundTo((double)colorInterface.getRed() / 255.0) + " " + Globals.roundTo((double)colorInterface.getGreen() / 255.0) + " " + Globals.roundTo((double)colorInterface.getBlue() / 255.0) + " rg\n");
            this.outt.write("  " + Globals.roundTo((double)colorInterface.getRed() / 255.0) + " " + Globals.roundTo((double)colorInterface.getGreen() / 255.0) + " " + Globals.roundTo((double)colorInterface.getBlue() / 255.0) + " RG\n");
            this.actualColor = colorInterface;
        }
        if (d != this.actualWidth) {
            this.outt.write("  " + d + " w\n");
            this.actualWidth = d;
        }
    }

    private void registerDash(int n) throws IOException {
        if (this.currentDash != n || this.currentPhase != this.dashPhase) {
            this.currentDash = n;
            this.currentPhase = this.dashPhase;
            if (n == 0) {
                this.outt.write("[] 0 d\n");
            } else {
                this.outt.write(this.sDash[n] + " " + this.dashPhase + " d\n");
            }
        }
    }

    @Override
    public PointPr exportArrow(double d, double d2, double d3, double d4, double d5, double d6, int n) throws IOException {
        double d7 = d == d3 ? 1.5707963267948966 + (d2 - d4 < 0.0 ? 0.0 : Math.PI) : Math.atan((d2 - d4) / (d - d3));
        double d8 = d - d5 * Math.cos(d7 += d - d3 > 0.0 ? 0.0 : Math.PI);
        double d9 = d2 - d5 * Math.sin(d7);
        double d10 = d8 - d6 * Math.sin(d7);
        double d11 = d9 + d6 * Math.cos(d7);
        double d12 = d8 + d6 * Math.sin(d7);
        double d13 = d9 - d6 * Math.cos(d7);
        this.outt.write(Globals.roundTo(d) + " " + Globals.roundTo(d2) + " m\n");
        this.outt.write(Globals.roundTo(d10) + " " + Globals.roundTo(d11) + " l\n");
        this.outt.write(Globals.roundTo(d12) + " " + Globals.roundTo(d13) + " l\n");
        if ((n & 2) == 0) {
            this.outt.write("  f*\n");
        } else {
            this.outt.write("  s\n");
        }
        if ((n & 1) != 0) {
            double d14 = d - d6 * Math.sin(d7);
            double d15 = d2 + d6 * Math.cos(d7);
            double d16 = d + d6 * Math.sin(d7);
            double d17 = d2 - d6 * Math.cos(d7);
            this.outt.write(Globals.roundTo(d14) + " " + Globals.roundTo(d15) + " m\n" + Globals.roundTo(d16) + " " + Globals.roundTo(d17) + " l s\n");
        }
        return new PointPr(d8, d9);
    }

    @Override
    public double getFontSize() {
        return this.currentFontSize;
    }

    @Override
    public void setFontSize(double d) {
        this.currentFontSize = (float)d;
        try {
            this.outt.write(this.currentFont + " " + this.currentFontSize + " Tf\n");
        }
        catch (IOException iOException) {
            System.err.println("Can not write to file in PDF export.");
        }
    }

    @Override
    public int getStringWidth(String string) {
        return 0;
    }

    @Override
    public void drawString(String string, int n, int n2) {
        try {
            this.outt.write("  1 0 0 1 " + Globals.roundTo(this.textx - (float)n) + " " + Globals.roundTo(this.texty - (float)n2) + " cm\n");
            this.texty = n2;
            this.outt.write(" <");
            for (int i = 0; i < string.length(); ++i) {
                int n3 = string.charAt(i);
                if (n3 > 127) {
                    if (this.uncodeCharsNeeded.containsKey(n3)) {
                        n3 = this.uncodeCharsNeeded.get(n3);
                    } else {
                        ++this.unicodeCharIndex;
                        if (this.unicodeCharIndex < 256) {
                            this.uncodeCharsNeeded.put(this.unicodeCharIndex, n3);
                            n3 = this.unicodeCharIndex;
                        } else {
                            System.err.println("Too many Unicode chars! The present version of the PDF export filter handles up to 128 different Unicode chars in one file.");
                        }
                    }
                }
                this.outt.write(Integer.toHexString(n3));
                this.outt.write(" ");
            }
            this.outt.write("> Tj\n");
        }
        catch (IOException iOException) {
            System.err.println("Can not write to file in EPS export.");
        }
    }
}

