/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.export;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.export.PointPr;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointDouble;
import net.sourceforge.fidocadj.layers.LayerDesc;
import net.sourceforge.fidocadj.primitives.MacroDesc;

public class ExportPCBRND
implements ExportInterface {
    private final FileWriter fstream;
    private BufferedWriter out;
    private DimensionG dim;
    private String macroList = "";
    private String junctionList = "";
    private static ArrayList<String> viaList = new ArrayList();
    private static ArrayList<String> pinList = new ArrayList();
    private static ArrayList<String> footprints = new ArrayList();
    private static ArrayList<String> fpList = new ArrayList();
    private static ArrayList<String> layerEls1 = new ArrayList();
    private static ArrayList<String> layerEls2 = new ArrayList();
    private static ArrayList<String> layerEls3 = new ArrayList();
    private static ArrayList<String> layerEls4 = new ArrayList();
    private static ArrayList<String> layerEls5 = new ArrayList();
    private static ArrayList<String> layerEls6 = new ArrayList();
    private static ArrayList<String> layerEls7 = new ArrayList();
    private static ArrayList<String> layerEls8 = new ArrayList();
    private static ArrayList<String> layerEls9 = new ArrayList();
    private static ArrayList<String> layerEls10 = new ArrayList();
    private static ArrayList<String> layerEls11 = new ArrayList();
    private static ArrayList<String> layerEls12 = new ArrayList();
    private static ArrayList<String> layerEls13 = new ArrayList();
    private static ArrayList<String> layerEls14 = new ArrayList();
    private static ArrayList<String> layerEls15 = new ArrayList();
    private static ArrayList<String> layerEls16 = new ArrayList();
    static final double text_stretch = 0.73;
    static final String EagleFidoLib = "FidoCadJLIB";
    static final String ExportFormatString = "####.####";
    static double res = 0.05;
    static boolean exportMacros = false;
    static boolean exportingMacro = false;
    static String fpPrefix = "";
    static String currentMacro = "";
    int macroX = 0;
    int macroY = 0;
    int macroRot = 0;
    static String previousMacro = "";
    static boolean newMacro = false;
    long defaultClearance = 1000L;
    long minExportedLineThickness = 1000L;
    int bezierSegments = 11;

    public ExportPCBRND(File file) throws IOException {
        this.fstream = new FileWriter(file);
    }

    @Override
    public void setDashUnit(double d) {
    }

    @Override
    public void setDashPhase(float f) {
    }

    @Override
    public void exportStart(DimensionG dimensionG, Vector<LayerDesc> vector, int n) throws IOException {
        this.dim = dimensionG;
        this.out = new BufferedWriter(this.fstream);
        this.macroList = "";
        this.junctionList = "";
        this.gEDALayoutHeader();
    }

    @Override
    public void exportEnd() throws IOException {
        this.writeFootprints();
        this.writeVias();
        this.writePins();
        this.writeLayers();
        this.out.close();
    }

    @Override
    public void exportAdvText(int n, int n2, int n3, int n4, String string, boolean bl, boolean bl2, boolean bl3, int n5, int n6, String string2) throws IOException {
        String string3 = this.fidoTextToPCBText(n, n2, string2, n4, n5);
        this.pushElement(string3, n6);
    }

    @Override
    public void exportBezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, int n10, int n11, int n12, int n13, double d) throws IOException {
        PointDouble[] pointDoubleArray = this.cubicBezierToVector(n, n2, n3, n4, n5, n6, n7, n8, this.bezierSegments);
        String string = this.fidoPolylineToPCBLines(pointDoubleArray, pointDoubleArray.length, d);
        this.pushElement(string, n9);
    }

    @Override
    public void exportConnection(int n, int n2, int n3, double d) throws IOException {
        this.junctionList = this.junctionList + "Junction (" + this.een((double)n * res) + " " + this.een((double)(this.dim.height - n2) * res) + ");\n";
    }

    @Override
    public void exportLine(double d, double d2, double d3, double d4, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, double d5) throws IOException {
        String string = this.fidoLineToPCBLine(d, d2, d3, d4, d5);
        this.pushElement(string, n);
    }

    @Override
    public boolean exportMacro(int n, int n2, boolean bl, int n3, String string, String string2, String string3, int n4, int n5, String string4, int n6, int n7, String string5, int n8, Map<String, MacroDesc> map) throws IOException {
        currentMacro = "macroName=" + string + "-x=" + n + "-y=" + n2 + "-rot=" + n3 + "-mirror=" + bl;
        if (this.footprintUnique((String)currentMacro)) {
            this.macroX = n;
            this.macroY = n2;
            String string6 = this.gEDAElementHeader(currentMacro, this.macroX, this.macroY);
            String string7 = this.parseMacro(string2, this.macroX, this.macroY, n3);
            String string8 = this.gEDAElementFooter();
            if (!"".equals(string7)) {
                this.pushFootprint(string6 + string7 + string8, string);
            }
        }
        return true;
    }

    @Override
    public void exportOval(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        int n7 = n3 - n;
        int n8 = n4 - n2;
        double d2 = (n + n3) / 2;
        double d3 = (n2 + n4) / 2;
        String string = "";
        if (n7 < 0) {
            n7 = -n7;
        }
        if (n8 < 0) {
            n8 = -n8;
        }
        if (n7 == n8) {
            string = this.fidoArcToPCBArc(d2, d3, n7, d, bl);
        } else {
            int n9 = 22;
            double d4 = Math.PI * 2 / (double)n9;
            double d5 = 0.0;
            PointDouble[] pointDoubleArray = new PointDouble[n9 + 1];
            PointDouble pointDouble = new PointDouble();
            pointDouble.x = d2 + (double)n7 / 2.0;
            pointDouble.y = d3;
            pointDoubleArray[0] = pointDouble;
            PointDouble pointDouble2 = new PointDouble();
            pointDouble2.x = pointDoubleArray[0].x;
            pointDouble2.y = pointDoubleArray[0].y;
            pointDoubleArray[n9] = pointDouble2;
            for (int i = 1; i < n9; ++i) {
                PointDouble pointDouble3 = new PointDouble();
                pointDouble3.x += d2 + Math.cos(d5 += d4) * (double)n7 / 2.0;
                pointDouble3.y += d3 + Math.sin(d5) * (double)n8 / 2.0;
                pointDoubleArray[i] = pointDouble3;
            }
            string = this.fidoPolyToPCBPoly(pointDoubleArray, n9, d, bl);
        }
        this.pushElement(string, n5);
    }

    @Override
    public void exportPCBLine(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        String string = "";
        string = this.fidoLineToPCBLine(n, n2, n3, n4, (double)n5);
        this.pushElement(string, n6);
    }

    @Override
    public void exportPCBPad(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) throws IOException {
        Object object = "";
        int n8 = n4;
        if (n5 > n4) {
            n8 = n5;
        }
        if (bl) {
            object = "\tVia[" + this.coordToPCB(n) + " " + this.coordToPCB(n2) + " " + this.coordToPCB(n8) + " " + (this.coordToPCB(n8) + 100L) + " " + (this.coordToPCB(n8) + 100L) + " " + this.coordToPCB(n6) + " \"\" \"hole\"]\n";
        } else {
            switch (n3) {
                case 1: {
                    object = "\tVia[" + this.coordToPCB(n) + " " + this.coordToPCB(n2) + " " + this.coordToPCB(n8) + " " + (this.coordToPCB(n8) + 100L) + " " + (this.coordToPCB(n8) + 100L) + " " + this.coordToPCB(n6) + " \"\" \"square\"]\n";
                    break;
                }
                case 2: {
                    object = "\tVia[" + this.coordToPCB(n) + " " + this.coordToPCB(n2) + " " + this.coordToPCB(n8) + " " + (this.coordToPCB(n8) + 100L) + " " + (this.coordToPCB(n8) + 100L) + " " + this.coordToPCB(n6) + " \"\" \"square,shape(17)\"]\n";
                    break;
                }
                case 0: {
                    object = "\tVia[" + this.coordToPCB(n) + " " + this.coordToPCB(n2) + " " + this.coordToPCB(n8) + " " + (this.coordToPCB(n8) + 100L) + " " + (this.coordToPCB(n8) + 100L) + " " + this.coordToPCB(n6) + " \"\" \"\"]\n";
                    break;
                }
            }
            this.out.write((String)object);
            this.out.write("# Oval and rect pad export approximated\n");
        }
    }

    @Override
    public void exportPolygon(PointDouble[] pointDoubleArray, int n, boolean bl, int n2, int n3, double d) throws IOException {
        String string = this.fidoPolyToPCBPoly(pointDoubleArray, n, d, bl);
        this.pushElement(string, n2);
    }

    @Override
    public void exportRectangle(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        String string = "";
        string = bl ? this.fidoRectToPCBPoly(n, n2, n3, n4) : this.fidoRectToPCBLines(n, n2, n3, n4, d);
        this.pushElement(string, n5);
    }

    @Override
    public boolean exportCurve(PointDouble[] pointDoubleArray, int n, boolean bl, boolean bl2, int n2, boolean bl3, boolean bl4, int n3, int n4, int n5, int n6, double d) throws IOException {
        if (n == 0) {
            System.out.println("Ignoring empty cubic spline definition.");
            return true;
        }
        if (n == 2) {
            String string = "";
            string = this.fidoLineToPCBLine(pointDoubleArray[0].x, pointDoubleArray[0].y, pointDoubleArray[1].x, pointDoubleArray[1].y, d);
            this.pushElement(string, n2);
            return true;
        }
        return false;
    }

    @Override
    public PointPr exportArrow(double d, double d2, double d3, double d4, double d5, double d6, int n) throws IOException {
        return new PointPr();
    }

    private String een(double d) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat(ExportFormatString, decimalFormatSymbols);
        return decimalFormat.format(d);
    }

    private void gEDALayoutHeader() throws IOException {
        this.out.write("# release: pcb 20110918\n\n");
        this.out.write("# To read pcb files, the pcb version (or the git source date) must be >= the file version\n");
        this.out.write("FileVersion[20070407]\n\n");
        this.out.write("PCB[\"\" 600000 500000]\n\n");
        this.out.write("Grid[500.0 0 0 1]\n");
        this.out.write("Cursor[2500 62500 0.000000]\n");
        this.out.write("PolyArea[3100.006200]\n");
        this.out.write("Thermal[0.500000]\n");
        this.out.write("DRC[1200 900 1000 700 1500 1000]\n");
        this.out.write("Flags(\"nameonpcb,clearnew,snappin\")\n");
        this.out.write("Groups(\"1,s:2,c:3:4:5:6:7:8:9:10:11:12:13:14\")\n");
        this.out.write("Styles[\"Signal,1000,7874,3150,2000:Power,2000,8661,3937,2000:Fat,8000,13780,4724,2500:Sig-tight,1000,6400,3150,1200\"]\n\n");
        this.out.write("Attribute(\"PCB::grid::unit\" \"mil\")\n");
        this.out.write("# Created by FidoCadJ 0.24.8 by Erich Heinzle, based on code by Davide Bucci.\n");
    }

    private String gEDAElementHeader(String string, int n, int n2) {
        return "Element[\"\" \"" + string + "\" \"\" \"\" " + this.coordToPCB(n) + " " + this.coordToPCB(n2) + " -2500 -1500 0 100 \"\"]\n(\n";
    }

    private int sToInt(String string) {
        return Integer.parseInt(string);
    }

    private String parseMacro(String string, int n, int n2, int n3) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 1;
        Object object = "";
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            int n5;
            String[] stringArray = ((String)arrayList.get(i)).split(" ");
            if (stringArray.length < 5) continue;
            if (stringArray[0].equals("LI") && stringArray[5].equals("3")) {
                object = (String)object + this.fidoLineToPCBLineElement(this.sToInt(stringArray[1]) - 100, this.sToInt(stringArray[2]) - 100, this.sToInt(stringArray[3]) - 100, this.sToInt(stringArray[4]) - 100, 2);
                continue;
            }
            if (stringArray[0].equals("EP") && stringArray[5].equals("3")) {
                int n6;
                n5 = this.sToInt(stringArray[3]) - this.sToInt(stringArray[1]);
                if (n5 < 0) {
                    n5 = -n5;
                }
                if ((n6 = this.sToInt(stringArray[4]) - this.sToInt(stringArray[2])) < 0) {
                    n6 = -n6;
                }
                if (n5 != n6) continue;
                double d = (this.sToInt(stringArray[3]) + this.sToInt(stringArray[1])) / 2;
                double d2 = (this.sToInt(stringArray[4]) + this.sToInt(stringArray[2])) / 2;
                object = (String)object + this.fidoArcToPCBArcElement(d - 100.0, d2 - 100.0, n5, 2.0, true);
                continue;
            }
            if (stringArray[0].equals("EV") && stringArray[5].equals("3")) {
                int n7;
                n5 = this.sToInt(stringArray[3]) - this.sToInt(stringArray[1]);
                if (n5 < 0) {
                    n5 = -n5;
                }
                if ((n7 = this.sToInt(stringArray[4]) - this.sToInt(stringArray[2])) < 0) {
                    n7 = -n7;
                }
                if (n5 != n7) continue;
                double d = (this.sToInt(stringArray[3]) + this.sToInt(stringArray[1])) / 2;
                double d3 = (this.sToInt(stringArray[4]) + this.sToInt(stringArray[2])) / 2;
                System.out.println("Processing empty FP ellipse");
                object = (String)object + this.fidoArcToPCBArcElement(d - 100.0, d3 - 100.0, n5, 2.0, false);
                continue;
            }
            if (stringArray[0].equals("RP") && !stringArray[5].equals("0")) {
                object = (String)object + this.fidoRectToPCBPadElement(this.sToInt(stringArray[1]) - 100, this.sToInt(stringArray[2]) - 100, this.sToInt(stringArray[3]) - 100, this.sToInt(stringArray[4]) - 100, this.sToInt(stringArray[5]), n4);
                ++n4;
                continue;
            }
            if (stringArray[0].equals("RV") && stringArray[5].equals("3")) {
                object = (String)object + this.fidoRectToPCBLineElements(this.sToInt(stringArray[1]) - 100, this.sToInt(stringArray[2]) - 100, this.sToInt(stringArray[3]) - 100, this.sToInt(stringArray[4]) - 100, (double)this.sToInt(stringArray[5]));
                continue;
            }
            if (stringArray[0].equals("PA")) {
                object = (String)object + this.fidoPadToPCBPinElement(this.sToInt(stringArray[1]) - 100, this.sToInt(stringArray[2]) - 100, this.sToInt(stringArray[3]), this.sToInt(stringArray[4]), this.sToInt(stringArray[5]), this.sToInt(stringArray[6]), this.sToInt(stringArray[7]), n4);
                ++n4;
                continue;
            }
            if (stringArray[0].equals("PV")) {
                n5 = 0;
                if (stringArray.length % 2 == 0) {
                    n5 = (stringArray.length - 2) / 2;
                }
                PointDouble[] pointDoubleArray = new PointDouble[n5];
                for (int j = 0; j < 2 * n5; j += 2) {
                    PointDouble pointDouble = new PointDouble();
                    pointDouble.x = Double.parseDouble(stringArray[j + 1]) - 100.0;
                    pointDouble.y = Double.parseDouble(stringArray[j + 2]) - 100.0;
                    pointDoubleArray[j / 2] = pointDouble;
                }
                object = (String)object + this.fidoPolylineToPCBLineElements(pointDoubleArray, n5, 2.0);
                continue;
            }
            if (stringArray[0].equals("BE") && !stringArray[9].equals("0")) {
                n5 = this.sToInt(stringArray[1]) - 100;
                int n8 = this.sToInt(stringArray[2]) - 100;
                int n9 = this.sToInt(stringArray[3]) - 100;
                int n10 = this.sToInt(stringArray[4]) - 100;
                int n11 = this.sToInt(stringArray[5]) - 100;
                int n12 = this.sToInt(stringArray[6]) - 100;
                int n13 = this.sToInt(stringArray[7]) - 100;
                int n14 = this.sToInt(stringArray[8]) - 100;
                int n15 = 10;
                PointDouble[] pointDoubleArray = new PointDouble[n15];
                pointDoubleArray = this.cubicBezierToVector(n5, n8, n9, n10, n11, n12, n13, n14, n15 - 1);
                object = (String)object + this.fidoPolylineToPCBLineElements(pointDoubleArray, n15, 2.0);
                continue;
            }
            if (stringArray[0].equals("TY")) continue;
            System.out.println("# Unsure what to do with: " + stringArray[0] + " in macro.");
        }
        return object;
    }

    private String gEDAElementFooter() {
        return ")\n";
    }

    private PointDouble[] cubicBezierToVector(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = n3 - n;
        int n11 = n4 - n2;
        int n12 = n5 - n3;
        int n13 = n6 - n4;
        int n14 = n7 - n5;
        int n15 = n8 - n6;
        int n16 = n9;
        double d = 1.0 / (double)n16;
        double d2 = (double)n10 * d;
        double d3 = (double)n11 * d;
        double d4 = (double)n12 * d;
        double d5 = (double)n13 * d;
        double d6 = (double)n14 * d;
        double d7 = (double)n15 * d;
        double d8 = n;
        double d9 = n2;
        double d10 = n3;
        double d11 = n4;
        double d12 = n5;
        double d13 = n6;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        PointDouble[] pointDoubleArray = new PointDouble[n16 + 1];
        PointDouble pointDouble = new PointDouble();
        pointDouble.x = n;
        pointDouble.y = n2;
        pointDoubleArray[0] = pointDouble;
        PointDouble pointDouble2 = new PointDouble();
        pointDouble2.x = n7;
        pointDouble2.y = n8;
        pointDoubleArray[n16] = pointDouble2;
        double d18 = 0.0;
        for (int i = 1; i < n16; ++i) {
            d18 = 1.0 * (double)i / (double)n16;
            d14 = d8 + d18 * ((d10 += d4) - (d8 += d2));
            d15 = (d9 += d3) + d18 * ((d11 += d5) - d9);
            d16 = d10 + d18 * ((d12 += d6) - d10);
            d17 = d11 + d18 * ((d13 += d7) - d11);
            PointDouble pointDouble3 = new PointDouble();
            pointDouble3.x = d14 + d18 * (d16 - d14);
            pointDouble3.y = d15 + d18 * (d17 - d15);
            pointDoubleArray[i] = pointDouble3;
        }
        return pointDoubleArray;
    }

    private String fidoLineToPCBLine(double d, double d2, double d3, double d4, double d5) {
        long l = this.coordToPCB(d5);
        if (l < this.minExportedLineThickness) {
            l = 1000L;
        }
        return "\tLine[" + this.coordToPCB(d) + " " + this.coordToPCB(d2) + " " + this.coordToPCB(d3) + " " + this.coordToPCB(d4) + " " + l + " " + this.defaultClearance + " \"clearline\"]\n";
    }

    private String fidoLineToPCBLine(int n, int n2, int n3, int n4, double d) {
        return this.fidoLineToPCBLine((double)n, (double)n2, (double)n3, (double)n4, d);
    }

    private String fidoLineToPCBLine(PointDouble pointDouble, PointDouble pointDouble2, double d) {
        return this.fidoLineToPCBLine(pointDouble.x, pointDouble.y, pointDouble2.x, pointDouble2.y, d);
    }

    private String fidoLineToPCBLineElement(int n, int n2, int n3, int n4, int n5) {
        return this.fidoLineToPCBLineElement((double)n, (double)n2, (double)n3, (double)n4, (double)n5);
    }

    private String fidoLineToPCBLineElement(double d, double d2, double d3, double d4, double d5) {
        long l = this.coordToPCB(d5);
        if (l < this.minExportedLineThickness) {
            l = 1000L;
        }
        return "\tElementLine[" + this.coordToPCB(d) + " " + this.coordToPCB(d2) + " " + this.coordToPCB(d3) + " " + this.coordToPCB(d4) + " " + l + "]\n";
    }

    private String fidoLineToPCBLineElement(PointDouble pointDouble, PointDouble pointDouble2, int n) {
        return this.fidoLineToPCBLineElement(pointDouble.x, pointDouble.y, pointDouble2.x, pointDouble2.y, (double)n);
    }

    private String fidoPolylineToPCBLineElements(PointDouble[] pointDoubleArray, int n, double d) {
        Object object = "";
        for (int i = 0; i < n - 1; ++i) {
            object = (String)object + this.fidoLineToPCBLineElement(pointDoubleArray[i].x, pointDoubleArray[i].y, pointDoubleArray[i + 1].x, pointDoubleArray[i + 1].y, d);
        }
        return object;
    }

    private String fidoRectToPCBLineElements(int n, int n2, int n3, int n4, double d) {
        return this.fidoRectToPCBLineElements((double)n, (double)n2, (double)n3, (double)n4, d);
    }

    private String fidoRectToPCBLineElements(double d, double d2, double d3, double d4, double d5) {
        return this.fidoLineToPCBLineElement(d, d2, d, d4, d5) + this.fidoLineToPCBLineElement(d, d4, d3, d4, d5) + this.fidoLineToPCBLineElement(d3, d4, d3, d2, d5) + this.fidoLineToPCBLineElement(d3, d2, d, d2, d5);
    }

    private String fidoArcToPCBArc(double d, double d2, int n, double d3, boolean bl) {
        Object object = "";
        long l = this.coordToPCB(d3);
        if (l < this.minExportedLineThickness) {
            l = 1000L;
        }
        object = bl ? "\tArc[" + this.coordToPCB(d) + " " + this.coordToPCB(d2) + " " + this.coordToPCB(n) / 4L + " " + this.coordToPCB(n) / 4L + " " + this.coordToPCB(n) / 2L + " " + this.defaultClearance + " 0 360 \"clearline\"]\n" : "\tArc[" + this.coordToPCB(d) + " " + this.coordToPCB(d2) + " " + this.coordToPCB(n) / 2L + " " + this.coordToPCB(n) / 2L + " " + l + " " + this.defaultClearance + " 0 360 \"clearline\"]\n";
        return object;
    }

    private String fidoArcToPCBArc(PointDouble pointDouble, int n, double d, boolean bl) {
        return this.fidoArcToPCBArc(pointDouble.x, pointDouble.y, n, d, bl);
    }

    private String fidoArcToPCBArcElement(double d, double d2, int n, double d3, boolean bl) {
        Object object = "";
        long l = this.coordToPCB(d3);
        if (l < this.minExportedLineThickness) {
            l = 1000L;
        }
        object = bl ? "\tElementArc[" + this.coordToPCB(d) + " " + this.coordToPCB(d2) + " " + this.coordToPCB(n) / 4L + " " + this.coordToPCB(n) / 4L + " 0 360 " + this.coordToPCB(n) / 2L + "]\n" : "\tElementArc[" + this.coordToPCB(d) + " " + this.coordToPCB(d2) + " " + this.coordToPCB(n) / 2L + " " + this.coordToPCB(n) / 2L + " 0 360 " + l + " ]\n";
        return object;
    }

    private String fidoArcToPCBArcElement(int n, int n2, int n3, double d, boolean bl) {
        return this.fidoArcToPCBArcElement((double)n, (double)n2, n3, d, bl);
    }

    private String fidoArcToPCBArcElement(PointDouble pointDouble, int n, int n2, boolean bl) {
        return this.fidoArcToPCBArcElement(pointDouble.x, pointDouble.y, n, (double)n2, bl);
    }

    private String fidoRectToPCBPadElement(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.fidoRectToPCBPadElement((double)n, (double)n2, (double)n3, (double)n4, n5, n6);
    }

    private String fidoRectToPCBPadElement(double d, double d2, double d3, double d4, int n, int n2) {
        int n3 = 2;
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = d5 / 2.0 + d;
        double d8 = d6 / 2.0 + d2;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        if (d6 < 0.0) {
            d6 = -d6;
        }
        if (d5 < 0.0) {
            d5 = -d5;
        }
        double d13 = d6;
        if (d6 > d5) {
            d13 = d5;
            d9 = d11 = d7;
            d10 = d8 + (d6 - d13) / 2.0;
            d12 = d8 - (d6 - d13) / 2.0;
        } else {
            d10 = d12 = d8;
            d9 = d7 + (d5 - d13) / 2.0;
            d11 = d7 - (d5 - d13) / 2.0;
        }
        String string = "square";
        if (n3 == 1) {
            string = "square,onsolder";
        }
        if (n != 3) {
            return "\tPad[" + this.coordToPCB(d9) + " " + this.coordToPCB(d10) + " " + this.coordToPCB(d11) + " " + this.coordToPCB(d12) + " " + this.coordToPCB(d13) + " " + this.defaultClearance + " " + (this.coordToPCB(d13) + 600L) + " \"" + n2 + "\" \"" + n2 + "\" \"" + string + "\"]\n";
        }
        return "\tElementLine[" + this.coordToPCB(d9) + " " + this.coordToPCB(d10) + " " + this.coordToPCB(d11) + " " + this.coordToPCB(d12) + " " + this.coordToPCB(d13) + "]\n";
    }

    private String fidoPadToPCBPinElement(double d, double d2, double d3, double d4, int n, int n2, int n3, int n4) {
        double d5 = d3;
        if (d3 > d4) {
            d5 = d4;
        }
        String string = "";
        String string2 = "\tPin[" + this.coordToPCB(d) + " " + this.coordToPCB(d2) + " " + this.coordToPCB(d5) + " " + this.defaultClearance + " " + (this.coordToPCB(d5) + 600L) + " " + this.coordToPCB(n) + " \"" + n4 + "\" \"" + n4 + "\" \"" + string + "\"]\n";
        if (n2 > 0) {
            double d6 = d - d3 / 2.0;
            double d7 = d + d3 / 2.0;
            double d8 = d2 - d4 / 2.0;
            double d9 = d2 + d4 / 2.0;
            string2 = string2 + this.fidoRectToPCBPadElement(d6, d8, d7, d9, 1, n4);
            string2 = string2 + this.fidoRectToPCBPadElement(d6, d8, d7, d9, 2, n4);
        }
        return string2;
    }

    private String fidoPadToPCBPinElement(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return this.fidoPadToPCBPinElement((double)n, (double)n2, (double)n3, (double)n4, n5, n6, n7, n8);
    }

    private String fidoPadToPCBPinElement(PointDouble pointDouble, int n, int n2, int n3, int n4, int n5, int n6) {
        return this.fidoPadToPCBPinElement(pointDouble.x, pointDouble.y, (double)n, (double)n2, n3, n4, n5, n6);
    }

    private String fidoTextToPCBText(double d, double d2, String string, int n, int n2) {
        long l = 200L * this.coordToPCB(n) / 5789L;
        int n3 = 0;
        if (n2 > 45 && n2 <= 135) {
            n3 = 1;
        } else if (n2 > 135 && n2 <= 225) {
            n3 = 2;
        } else if (n2 > 225 && n2 <= 315) {
            n3 = 3;
        }
        return "\tText[" + this.coordToPCB(d) + " " + this.coordToPCB(d2) + " " + n3 + " " + l + " \"" + string + "\" \"clearline\"]\n";
    }

    private String fidoTextToPCBText(int n, int n2, String string, int n3, int n4) {
        return this.fidoTextToPCBText((double)n, (double)n2, string, n3, n4);
    }

    private String fidoTextToPCBText(PointDouble pointDouble, String string, int n, int n2) {
        return this.fidoTextToPCBText(pointDouble.x, pointDouble.y, string, n, n2);
    }

    private String fidoPolyToPCBPoly(PointDouble[] pointDoubleArray, int n, double d, boolean bl) {
        Object object = "";
        if (bl) {
            object = "\tPolygon(\"clearpoly\")\n\t(\n\t\t";
            for (int i = 0; i < n; ++i) {
                object = i < n - 1 ? (String)object + "[" + this.fidoCoordToPCB(pointDoubleArray[i].x) + " " + this.fidoCoordToPCB(pointDoubleArray[i].y) + "] " : (String)object + "[" + this.fidoCoordToPCB(pointDoubleArray[i].x) + " " + this.fidoCoordToPCB(pointDoubleArray[i].y) + "]\n)\n";
            }
        } else {
            object = this.fidoPolylineToPCBLines(pointDoubleArray, n, d);
            object = (String)object + this.fidoLineToPCBLine(pointDoubleArray[n - 1].x, pointDoubleArray[n - 1].y, pointDoubleArray[0].x, pointDoubleArray[0].y, d);
        }
        return object;
    }

    private String fidoPolylineToPCBLines(PointDouble[] pointDoubleArray, int n, double d) {
        Object object = "";
        for (int i = 0; i < n - 1; ++i) {
            object = (String)object + this.fidoLineToPCBLine(pointDoubleArray[i].x, pointDoubleArray[i].y, pointDoubleArray[i + 1].x, pointDoubleArray[i + 1].y, d);
        }
        return object;
    }

    private String fidoRectToPCBPoly(int n, int n2, int n3, int n4) {
        return "\tPolygon(\"clearpoly\")\n\t(\n\t\t[" + this.coordToPCB(n) + " " + this.fidoCoordToPCB(n2) + "] [" + this.fidoCoordToPCB(n) + " " + this.fidoCoordToPCB(n4) + "] [" + this.fidoCoordToPCB(n3) + " " + this.fidoCoordToPCB(n4) + "] [" + this.fidoCoordToPCB(n3) + " " + this.fidoCoordToPCB(n2) + "]\n\t)\n";
    }

    private String fidoRectToPCBLines(int n, int n2, int n3, int n4, double d) {
        return this.fidoLineToPCBLine(n, n2, n, n4, d) + this.fidoLineToPCBLine(n, n4, n3, n4, d) + this.fidoLineToPCBLine(n3, n4, n3, n2, d) + this.fidoLineToPCBLine(n3, n2, n, n2, d);
    }

    private String fidoPadToPCBVia(double d, double d2, int n, int n2) {
        return "#FidoPadToPCBVia stub\n";
    }

    private String fidoPadToPCBVia(int n, int n2, int n3, int n4) {
        return this.fidoPadToPCBVia((double)n, (double)n2, n3, n4);
    }

    private String fidoPadToPCBVia(PointDouble pointDouble, int n, int n2) {
        return this.fidoPadToPCBVia(pointDouble.x, pointDouble.y, n, n2);
    }

    private long fidoCoordToPCB(int n) {
        return 500 * n;
    }

    private long fidoCoordToPCB(double d) {
        return (long)(500.0 * d);
    }

    private long coordToPCB(int n) {
        return 500 * n;
    }

    private long coordToPCB(double d) {
        return (long)(500.0 * d);
    }

    private void createPinAsSquareElement(int n, int n2, int n3, int n4) {
        String string = "Element[\"\" \"\" \"\" \"\" " + this.coordToPCB(n) + " " + this.coordToPCB(n2) + " 0 0 0 100 \"\"]\n(\n\tPin[0 0 " + this.coordToPCB(n3) + " " + (this.coordToPCB(n3) + 600L) + " " + this.coordToPCB(n4) + "\"\" \"1\" \"square\"]\n)\n";
        pinList.add(string);
    }

    private void createPinAsRoundElement(int n, int n2, int n3, int n4) {
        String string = "Element[\"\" \"\" \"\" \"\" " + this.coordToPCB(n) + " " + this.coordToPCB(n2) + " 0 0 0 100 \"\"]\n(\n\tPin[0 0 " + this.coordToPCB(n3) + " " + (this.coordToPCB(n3) + 600L) + " " + this.coordToPCB(n4) + "\"\" \"1\" \"\"]\n)\n";
        pinList.add(string);
    }

    private boolean footprintUnique(String string) {
        boolean bl = false;
        for (String string2 : fpList) {
            if (!string2.equals(string)) continue;
            bl = true;
        }
        return !bl;
    }

    private void pushFootprint(String string, String string2) {
        fpList.add(string2);
        footprints.add(string);
    }

    private void pushElement(String string, int n) {
        switch (n) {
            case 0: {
                layerEls15.add(string);
                break;
            }
            case 1: {
                layerEls1.add(string);
                break;
            }
            case 2: {
                layerEls2.add(string);
                break;
            }
            case 3: {
                layerEls16.add(string);
                break;
            }
            case 4: {
                layerEls3.add(string);
                break;
            }
            case 5: {
                layerEls4.add(string);
                break;
            }
            case 6: {
                layerEls5.add(string);
                break;
            }
            case 7: {
                layerEls6.add(string);
                break;
            }
            case 8: {
                layerEls7.add(string);
                break;
            }
            case 9: {
                layerEls8.add(string);
                break;
            }
            case 10: {
                layerEls9.add(string);
                break;
            }
            case 11: {
                layerEls10.add(string);
                break;
            }
            case 12: {
                layerEls11.add(string);
                break;
            }
            case 13: {
                layerEls12.add(string);
                break;
            }
            case 14: {
                layerEls13.add(string);
                break;
            }
            case 15: {
                layerEls14.add(string);
                break;
            }
        }
    }

    private void writeElements(ArrayList<String> arrayList) throws IOException {
        for (String string : arrayList) {
            this.out.write(string);
        }
        arrayList.clear();
    }

    private void writeFootprints() throws IOException {
        this.writeElements(footprints);
    }

    private void writeVias() throws IOException {
        this.writeElements(viaList);
    }

    private void writePins() throws IOException {
        this.writeElements(pinList);
    }

    private void writeLayers() throws IOException {
        block18: for (int i = 0; i < 16; ++i) {
            switch (i) {
                case 0: {
                    this.out.write("Layer(1 \"B.Cu\")\n(\n");
                    this.writeElements(layerEls1);
                    this.out.write(")\n");
                    continue block18;
                }
                case 1: {
                    this.out.write("Layer(2 \"F.Cu\")\n(\n");
                    this.writeElements(layerEls2);
                    this.out.write(")\n");
                    continue block18;
                }
                case 2: {
                    this.out.write("Layer(3 \"Inner1.Cu\")\n(\n");
                    this.writeElements(layerEls3);
                    this.out.write(")\n");
                    continue block18;
                }
                case 3: {
                    this.out.write("Layer(4 \"Inner2.Cu\")\n(\n");
                    this.writeElements(layerEls4);
                    this.out.write(")\n");
                    continue block18;
                }
                case 4: {
                    this.out.write("Layer(5 \"Inner3.Cu\")\n(\n");
                    this.writeElements(layerEls5);
                    this.out.write(")\n");
                    continue block18;
                }
                case 5: {
                    this.out.write("Layer(6 \"Inner4.Cu\")\n(\n");
                    this.writeElements(layerEls6);
                    this.out.write(")\n");
                    continue block18;
                }
                case 6: {
                    this.out.write("Layer(7 \"Inner5.Cu\")\n(\n");
                    this.writeElements(layerEls7);
                    this.out.write(")\n");
                    continue block18;
                }
                case 7: {
                    this.out.write("Layer(8 \"Inner6.Cu\")\n(\n");
                    this.writeElements(layerEls8);
                    this.out.write(")\n");
                    continue block18;
                }
                case 8: {
                    this.out.write("Layer(9 \"Inner7.Cu\")\n(\n");
                    this.writeElements(layerEls9);
                    this.out.write(")\n");
                    continue block18;
                }
                case 9: {
                    this.out.write("Layer(10 \"Inner8.Cu\")\n(\n");
                    this.writeElements(layerEls10);
                    this.out.write(")\n");
                    continue block18;
                }
                case 10: {
                    this.out.write("Layer(11 \"Inner9.Cu\")\n(\n");
                    this.writeElements(layerEls11);
                    this.out.write(")\n");
                    continue block18;
                }
                case 11: {
                    this.out.write("Layer(12 \"Inner10.Cu\")\n(\n");
                    this.writeElements(layerEls12);
                    this.out.write(")\n");
                    continue block18;
                }
                case 12: {
                    this.out.write("Layer(13 \"Inner11.Cu\")\n(\n");
                    this.writeElements(layerEls13);
                    this.out.write(")\n");
                    continue block18;
                }
                case 13: {
                    this.out.write("Layer(14 \"Inner12.Cu\")\n(\n");
                    this.writeElements(layerEls14);
                    this.out.write(")\n");
                    continue block18;
                }
                case 14: {
                    this.out.write("Layer(15 \"B.SilkS\")\n(\n");
                    this.writeElements(layerEls15);
                    this.out.write(")\n");
                    continue block18;
                }
                case 15: {
                    this.out.write("Layer(16 \"F.SilkS\")\n(\n");
                    this.writeElements(layerEls16);
                    this.out.write(")\n");
                    continue block18;
                }
                default: {
                    System.out.println("Unknown layer number for layer out: " + i);
                }
            }
        }
    }
}

