/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.export;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.circuit.views.Drawing;
import net.sourceforge.fidocadj.circuit.views.Export;
import net.sourceforge.fidocadj.export.ExportEPS;
import net.sourceforge.fidocadj.export.ExportEagle;
import net.sourceforge.fidocadj.export.ExportFidoCad;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.export.ExportPCBRND;
import net.sourceforge.fidocadj.export.ExportPDF;
import net.sourceforge.fidocadj.export.ExportPGF;
import net.sourceforge.fidocadj.export.ExportSVG;
import net.sourceforge.fidocadj.geom.DrawingSize;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.graphic.nil.GraphicsNull;
import net.sourceforge.fidocadj.graphic.swing.ColorSwing;
import net.sourceforge.fidocadj.graphic.swing.Graphics2DSwing;
import net.sourceforge.fidocadj.layers.LayerDesc;

public final class ExportGraphic {
    private ExportGraphic() {
    }

    public static void export(File file, DrawingModel drawingModel, String string, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws IOException {
        ExportGraphic.exportSizeP(file, drawingModel, string, 0, 0, d, false, bl, bl2, bl3, bl4, bl5);
    }

    public static void exportSize(File file, DrawingModel drawingModel, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws IOException {
        ExportGraphic.exportSizeP(file, drawingModel, string, n, n2, 1.0, true, bl, bl2, bl3, bl4, bl5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportSizeP(File file, DrawingModel drawingModel, String string, int n, int n2, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws IOException {
        Object object;
        int n3 = n;
        int n4 = n2;
        double d2 = d;
        MapCoordinates mapCoordinates = new MapCoordinates();
        new SelectionActions(drawingModel).setSelectionAll(false);
        PointG pointG = new PointG(0, 0);
        DimensionG dimensionG = DrawingSize.getImageSize(drawingModel, 1.0, true, pointG);
        if (bl) {
            dimensionG.width += 6;
            dimensionG.height += 6;
            d2 = Math.min((double)n3 / (double)dimensionG.width, (double)n4 / (double)dimensionG.height);
        } else {
            n3 = (int)((double)(dimensionG.width + 6) * d2);
            n4 = (int)((double)(dimensionG.height + 6) * d2);
        }
        pointG.x = (int)((double)pointG.x * d2);
        pointG.y = (int)((double)pointG.y * d2);
        pointG.x = (int)((double)pointG.x - 6.0 * d2 / 2.0);
        pointG.y = (int)((double)pointG.y - 6.0 * d2 / 2.0);
        Vector<LayerDesc> vector = drawingModel.getLayers();
        if (bl3) {
            object = new Vector<LayerDesc>();
            for (int i = 0; i < 16; ++i) {
                ((Vector)object).add((LayerDesc)new LayerDesc(new ColorSwing().black(), vector.get(i).getVisible(), "B/W", vector.get(i).getAlpha()));
            }
            drawingModel.setLayers((Vector<LayerDesc>)object);
        }
        mapCoordinates.setMagnitudes(d2, d2);
        if (bl5 && !"pcb".equals(string)) {
            mapCoordinates.setXCenter(-pointG.x);
            mapCoordinates.setYCenter(-pointG.y);
        }
        if ("png".equals(string) || "jpg".equals(string)) {
            try {
                BufferedImage bufferedImage = new BufferedImage(n3, n4, 1);
                object = bufferedImage.createGraphics();
                if (bl2) {
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                ((Graphics)object).setColor(Color.white);
                ((Graphics)object).fillRect(0, 0, n3, n4);
                Drawing drawing = new Drawing(drawingModel);
                Graphics2DSwing graphics2DSwing = new Graphics2DSwing((Graphics2D)object);
                graphics2DSwing.setZoom(mapCoordinates.getXMagnitude());
                drawing.draw(graphics2DSwing, mapCoordinates);
                ImageIO.write((RenderedImage)bufferedImage, string, file);
                ((Graphics)object).dispose();
            }
            finally {
                drawingModel.setLayers(vector);
            }
        } else {
            ExportGraphic.exportVectorFormats(drawingModel, string, file, mapCoordinates, bl4, bl6);
        }
        drawingModel.setLayers(vector);
    }

    private static String addIndexInFilename(String string, int n) {
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return string + "_" + n;
        }
        return string.substring(0, n2) + "_" + n + "." + string.substring(n2 + 1);
    }

    private static ExportInterface createExportInterface(String string, File file, boolean bl) throws IOException {
        ExportInterface exportInterface;
        if ("eps".equals(string)) {
            exportInterface = new ExportEPS(file);
        } else if ("pgf".equals(string)) {
            exportInterface = new ExportPGF(file);
        } else if ("pdf".equals(string)) {
            exportInterface = new ExportPDF(file, new GraphicsNull());
        } else if ("scr".equals(string)) {
            exportInterface = new ExportEagle(file);
        } else if ("pcb".equals(string)) {
            exportInterface = new ExportPCBRND(file);
        } else if ("fcd".equals(string)) {
            ExportFidoCad exportFidoCad = new ExportFidoCad(file);
            exportFidoCad.setSplitStandardMacros(false);
            exportFidoCad.setExtensions(bl);
            exportInterface = exportFidoCad;
        } else if ("fcda".equals(string)) {
            ExportFidoCad exportFidoCad = new ExportFidoCad(file);
            exportFidoCad.setSplitStandardMacros(true);
            exportFidoCad.setExtensions(bl);
            exportInterface = exportFidoCad;
        } else if ("svg".equals(string)) {
            exportInterface = new ExportSVG(file, new GraphicsNull());
        } else {
            IOException iOException = new IOException("Wrong file format");
            throw iOException;
        }
        return exportInterface;
    }

    private static void exportVectorFormats(DrawingModel drawingModel, String string, File file, MapCoordinates mapCoordinates, boolean bl, boolean bl2) throws IOException {
        System.out.println("SplitLayer: " + bl2);
        if (bl2) {
            for (int i = 0; i < 16 && drawingModel.containsLayer(i); ++i) {
                File file2 = new File(ExportGraphic.addIndexInFilename(file.toString(), i));
                ExportInterface exportInterface = ExportGraphic.createExportInterface(string, file2, bl);
                Export export = new Export(drawingModel);
                drawingModel.setDrawOnlyLayer(-1);
                export.exportHeader(exportInterface, mapCoordinates);
                drawingModel.setDrawOnlyLayer(i);
                export.exportDrawing(exportInterface, false, mapCoordinates);
                exportInterface.exportEnd();
            }
            drawingModel.setDrawOnlyLayer(-1);
        } else {
            ExportInterface exportInterface = ExportGraphic.createExportInterface(string, file, bl);
            Export export = new Export(drawingModel);
            export.exportHeader(exportInterface, mapCoordinates);
            export.exportDrawing(exportInterface, false, mapCoordinates);
            exportInterface.exportEnd();
        }
    }
}

