/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.export.PointPr;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointDouble;
import net.sourceforge.fidocadj.layers.LayerDesc;
import net.sourceforge.fidocadj.primitives.MacroDesc;
import net.sourceforge.fidocadj.primitives.PrimitiveAdvText;
import net.sourceforge.fidocadj.primitives.PrimitiveBezier;
import net.sourceforge.fidocadj.primitives.PrimitiveComplexCurve;
import net.sourceforge.fidocadj.primitives.PrimitiveConnection;
import net.sourceforge.fidocadj.primitives.PrimitiveLine;
import net.sourceforge.fidocadj.primitives.PrimitiveMacro;
import net.sourceforge.fidocadj.primitives.PrimitiveOval;
import net.sourceforge.fidocadj.primitives.PrimitivePCBLine;
import net.sourceforge.fidocadj.primitives.PrimitivePCBPad;
import net.sourceforge.fidocadj.primitives.PrimitivePolygon;
import net.sourceforge.fidocadj.primitives.PrimitiveRectangle;

public class ExportFidoCad
implements ExportInterface {
    private final BufferedWriter out;
    private Vector<LayerDesc> layerV;
    private boolean extensions = true;
    private boolean splitStandardMacros = false;
    private String textFont = "Courier New";
    private int textFontSize = 3;

    @Override
    public void setDashUnit(double d) {
    }

    @Override
    public void setDashPhase(float f) {
    }

    public void setMacroFont(String string, int n) {
        this.textFont = string;
        this.textFontSize = n;
    }

    public void setSplitStandardMacros(boolean bl) {
        this.splitStandardMacros = bl;
    }

    private int cLe(double d) {
        return (int)d;
    }

    public ExportFidoCad(File file) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8");
        this.out = new BufferedWriter(outputStreamWriter);
    }

    public void setExtensions(boolean bl) {
        this.extensions = bl;
    }

    @Override
    public void exportStart(DimensionG dimensionG, Vector<LayerDesc> vector, int n) throws IOException {
        this.layerV = vector;
        int n2 = dimensionG.width;
        int n3 = dimensionG.height;
        this.out.write("[FIDOCAD]\n");
        DrawingModel drawingModel = new DrawingModel();
        ParserActions parserActions = new ParserActions(drawingModel);
        drawingModel.setLayers(vector);
        this.out.write(new String(parserActions.registerConfiguration(this.extensions)));
    }

    @Override
    public void exportEnd() throws IOException {
        this.out.close();
    }

    @Override
    public void exportAdvText(int n, int n2, int n3, int n4, String string, boolean bl, boolean bl2, boolean bl3, int n5, int n6, String string2) throws IOException {
        int n7 = 0;
        if (bl) {
            ++n7;
        }
        if (bl3) {
            n7 += 2;
        }
        if (bl2) {
            n7 += 4;
        }
        this.out.write(new PrimitiveAdvText(this.cLe(n), this.cLe(n2), this.cLe(n3), this.cLe(n4), string, n5, n7, string2, n6).toString(this.extensions));
    }

    @Override
    public void exportBezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, int n10, int n11, int n12, int n13, double d) throws IOException {
        this.out.write(new PrimitiveBezier(this.cLe(n), this.cLe(n2), this.cLe(n3), this.cLe(n4), this.cLe(n5), this.cLe(n6), this.cLe(n7), this.cLe(n8), n9, bl, bl2, n10, this.cLe(n11), this.cLe(n12), n13, this.textFont, this.textFontSize).toString(this.extensions));
    }

    @Override
    public void exportConnection(int n, int n2, int n3, double d) throws IOException {
        this.out.write(new PrimitiveConnection(this.cLe(n), this.cLe(n2), n3, this.textFont, this.textFontSize).toString(this.extensions));
    }

    @Override
    public void exportLine(double d, double d2, double d3, double d4, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, double d5) throws IOException {
        this.out.write(new PrimitiveLine(this.cLe(d), this.cLe(d2), this.cLe(d3), this.cLe(d4), n, bl, bl2, n2, this.cLe(n3), this.cLe(n4), n5, this.textFont, this.textFontSize).toString(this.extensions));
    }

    @Override
    public boolean exportMacro(int n, int n2, boolean bl, int n3, String string, String string2, String string3, int n4, int n5, String string4, int n6, int n7, String string5, int n8, Map<String, MacroDesc> map) throws IOException {
        if (this.splitStandardMacros) {
            return false;
        }
        boolean bl2 = false;
        int n9 = -1;
        n9 = string.indexOf(".");
        if (n9 < 0) {
            bl2 = true;
        } else {
            String string6 = string.substring(0, n9);
            if (this.extensions && "pcb".equals(string6)) {
                bl2 = true;
            } else if (this.extensions && "ihram".equals(string6)) {
                bl2 = true;
            } else if (this.extensions && "elettrotecnica".equals(string6)) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.out.write(new PrimitiveMacro(map, this.layerV, this.cLe(n), this.cLe(n2), string, string3, this.cLe(n4), this.cLe(n5), string4, this.cLe(n6), this.cLe(n7), string5, this.cLe(n8), n3 / 90, bl).toString(this.extensions));
            return true;
        }
        return false;
    }

    @Override
    public void exportOval(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        this.out.write(new PrimitiveOval(this.cLe(n), this.cLe(n2), this.cLe(n3), this.cLe(n4), bl, n5, n6, this.textFont, this.textFontSize).toString(this.extensions));
    }

    @Override
    public void exportPCBLine(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        this.out.write(new PrimitivePCBLine(this.cLe(n), this.cLe(n2), this.cLe(n3), this.cLe(n4), this.cLe(n5), this.cLe(n6), this.textFont, this.textFontSize).toString(this.extensions));
    }

    @Override
    public void exportPCBPad(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) throws IOException {
        if (!bl) {
            this.out.write(new PrimitivePCBPad(this.cLe(n), this.cLe(n2), this.cLe(n4), this.cLe(n5), this.cLe(n6), n3, n7, this.textFont, this.textFontSize).toString(this.extensions));
        }
    }

    @Override
    public void exportPolygon(PointDouble[] pointDoubleArray, int n, boolean bl, int n2, int n3, double d) throws IOException {
        PrimitivePolygon primitivePolygon = new PrimitivePolygon(bl, n2, n3, this.textFont, this.textFontSize);
        for (int i = 0; i < n; ++i) {
            primitivePolygon.addPoint(this.cLe(pointDoubleArray[i].x), this.cLe(pointDoubleArray[i].y));
        }
        this.out.write(primitivePolygon.toString(this.extensions));
    }

    @Override
    public boolean exportCurve(PointDouble[] pointDoubleArray, int n, boolean bl, boolean bl2, int n2, boolean bl3, boolean bl4, int n3, int n4, int n5, int n6, double d) throws IOException {
        PrimitiveComplexCurve primitiveComplexCurve = new PrimitiveComplexCurve(bl, bl2, n2, bl3, bl4, n3, this.cLe(n4), this.cLe(n5), n6, this.textFont, this.textFontSize);
        for (int i = 0; i < n; ++i) {
            primitiveComplexCurve.addPoint(this.cLe(pointDoubleArray[i].x), this.cLe(pointDoubleArray[i].y));
        }
        this.out.write(primitiveComplexCurve.toString(this.extensions));
        return true;
    }

    @Override
    public void exportRectangle(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        this.out.write(new PrimitiveRectangle(this.cLe(n), this.cLe(n2), this.cLe(n3), this.cLe(n4), bl, n5, n6, this.textFont, this.textFontSize).toString(this.extensions));
    }

    @Override
    public PointPr exportArrow(double d, double d2, double d3, double d4, double d5, double d6, int n) throws IOException {
        return new PointPr();
    }
}

