/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.export.PointPr;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointDouble;
import net.sourceforge.fidocadj.layers.LayerDesc;
import net.sourceforge.fidocadj.primitives.MacroDesc;

public class ExportEagle
implements ExportInterface {
    private final FileWriter fstream;
    private BufferedWriter out;
    private DimensionG dim;
    private int oldtextsize;
    private String macroList = "";
    private String junctionList = "";
    static final double text_stretch = 0.73;
    static final String EagleFidoLib = "FidoCadJLIB";
    static final String ExportFormatString = "####.####";
    static double res = 0.05;

    public ExportEagle(File file) throws IOException {
        this.fstream = new FileWriter(file);
    }

    @Override
    public void setDashUnit(double d) {
    }

    @Override
    public void setDashPhase(float f) {
    }

    @Override
    public void exportStart(DimensionG dimensionG, Vector<LayerDesc> vector, int n) throws IOException {
        this.dim = dimensionG;
        this.out = new BufferedWriter(this.fstream);
        this.oldtextsize = -1;
        this.macroList = "";
        this.junctionList = "";
        this.out.write("# Created by FidoCadJ 0.24.8 by Davide Bucci\n");
        this.out.write("Set Wire_Bend 2; \n");
        this.out.write("Grid inch " + this.een((double)n * res) + ";\n");
        this.out.write("Change font fixed;\n");
        this.out.write("Set auto_junction off;\n");
    }

    @Override
    public void exportEnd() throws IOException {
        this.out.write(this.macroList);
        this.out.write(this.junctionList);
        this.out.write("Window Fit; \n");
        this.out.close();
    }

    @Override
    public void exportAdvText(int n, int n2, int n3, int n4, String string, boolean bl, boolean bl2, boolean bl3, int n5, int n6, String string2) throws IOException {
        String string3 = "";
        if (bl2) {
            string3 = "M";
        }
        if (this.oldtextsize != n4) {
            this.out.write("Change size " + (double)n4 * res * 0.73 + "\n");
        }
        this.oldtextsize = n4;
        this.out.write("Text " + string2 + " " + string3 + "R" + -n5 + " (" + this.een((double)n * res) + " " + this.een((double)(this.dim.height - n2) * res) + ");\n");
    }

    @Override
    public void exportBezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, int n10, int n11, int n12, int n13, double d) throws IOException {
        this.out.write("# B\u00e9zier export not implemented yet\n");
    }

    @Override
    public void exportConnection(int n, int n2, int n3, double d) throws IOException {
        this.junctionList = this.junctionList + "Junction (" + this.een((double)n * res) + " " + this.een((double)(this.dim.height - n2) * res) + ");\n";
    }

    @Override
    public void exportLine(double d, double d2, double d3, double d4, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, double d5) throws IOException {
        this.out.write("Net (" + this.een(d * res) + " " + this.een(((double)this.dim.height - d2) * res) + ") (" + this.een(d3 * res) + " " + this.een(((double)this.dim.height - d4) * res) + ");\n");
    }

    @Override
    public boolean exportMacro(int n, int n2, boolean bl, int n3, String string, String string2, String string3, int n4, int n5, String string4, int n6, int n7, String string5, int n8, Map<String, MacroDesc> map) throws IOException {
        String string6 = "";
        if (bl) {
            string6 = "M";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(" ", "_");
        String string7 = Globals.substituteBizarreChars(string3, hashMap);
        this.macroList = this.macroList + "Add " + string + "@FidoCadJLIB " + string7 + " " + string6 + "R" + -n3 + " (" + this.een((double)n * res) + " " + this.een((double)(this.dim.height - n2) * res) + ");\n";
        this.macroList = this.macroList + "Value " + string7 + " " + string4 + ";\n";
        return true;
    }

    @Override
    public void exportOval(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        String string = "";
        this.out.write("# Circle export not fully implemented\n");
        this.out.write("Circle (" + this.een((double)n * res) + " " + this.een((double)(this.dim.height - n2) * res) + ") (" + this.een((double)(n3 - n) * res) + " " + this.een((double)(n4 - n2) * res) + ");");
    }

    @Override
    public void exportPCBLine(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        this.out.write("# PCBLine export not implemented yet\n");
    }

    @Override
    public void exportPCBPad(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) throws IOException {
        if (!bl) {
            switch (n3) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
        this.out.write("# PCBpad export not implemented yet\n");
    }

    @Override
    public void exportPolygon(PointDouble[] pointDoubleArray, int n, boolean bl, int n2, int n3, double d) throws IOException {
        String string = "";
        this.out.write("# Polygon export not implemented yet\n");
    }

    @Override
    public void exportRectangle(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        this.out.write("Layer 94;\n");
        if (bl) {
            this.out.write("Rect (" + this.een((double)n * res) + " " + this.een((double)(this.dim.height - n2) * res) + ") (" + this.een((double)n3 * res) + " " + this.een((double)(this.dim.height - n4) * res) + ");\n");
        } else {
            this.out.write("Set Wire_Bend 0;\n");
            this.out.write("Wire (" + this.een((double)n * res) + " " + this.een((double)(this.dim.height - n2) * res) + ") (" + this.een((double)n3 * res) + " " + this.een((double)(this.dim.height - n4) * res) + ");\n");
            this.out.write("Wire (" + this.een((double)n3 * res) + " " + this.een((double)(this.dim.height - n4) * res) + ") (" + this.een((double)n * res) + " " + this.een((double)(this.dim.height - n2) * res) + ");\n");
            this.out.write("Set Wire_Bend 2;\n");
        }
        this.out.write("Layer 91;\n");
    }

    @Override
    public boolean exportCurve(PointDouble[] pointDoubleArray, int n, boolean bl, boolean bl2, int n2, boolean bl3, boolean bl4, int n3, int n4, int n5, int n6, double d) throws IOException {
        return false;
    }

    @Override
    public PointPr exportArrow(double d, double d2, double d3, double d4, double d5, double d6, int n) throws IOException {
        return new PointPr();
    }

    private String een(double d) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat(ExportFormatString, decimalFormatSymbols);
        return decimalFormat.format(d);
    }
}

