/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.export.PointPr;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.ColorInterface;
import net.sourceforge.fidocadj.graphic.DecoratedText;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointDouble;
import net.sourceforge.fidocadj.graphic.TextInterface;
import net.sourceforge.fidocadj.layers.LayerDesc;
import net.sourceforge.fidocadj.primitives.MacroDesc;

public class ExportEPS
implements ExportInterface,
TextInterface {
    private final FileWriter fstream;
    private BufferedWriter out;
    private Vector layerV;
    private double actualWidth;
    private ColorInterface actualColor;
    private int currentDash;
    private float dashPhase;
    private float currentPhase = -1.0f;
    private float currentFontSize = 0.0f;
    private DecoratedText dt;
    private String fontname;
    private String bold = "";
    private float textx;
    private float texty;
    static final int PREC = 3;
    private String[] sDash;

    @Override
    public void setDashUnit(double d) {
        this.sDash = new String[5];
        this.sDash[0] = "";
        for (int i = 1; i < 5; ++i) {
            Object object = new String();
            for (int j = 0; j < Globals.dash[i].length; ++j) {
                object = (String)object + Globals.dash[i][j] * (float)d / 2.0f;
                if (j >= Globals.dash[i].length - 1) continue;
                object = (String)object + " ";
            }
            this.sDash[i] = "[" + (String)object + "]";
        }
    }

    @Override
    public void setDashPhase(float f) {
        this.dashPhase = f;
    }

    public ExportEPS(File file) throws IOException {
        this.fstream = new FileWriter(file);
        this.dt = new DecoratedText(this);
    }

    @Override
    public void exportStart(DimensionG dimensionG, Vector<LayerDesc> vector, int n) throws IOException {
        this.layerV = vector;
        this.out = new BufferedWriter(this.fstream);
        int n2 = dimensionG.width;
        int n3 = dimensionG.height;
        double d = 2.7777777777777777;
        this.out.write("%!PS-Adobe-3.0 EPSF-3.0\n");
        this.out.write("%%Pages: 0\n");
        this.out.write("%%BoundingBox: -1 -1 " + (int)((double)dimensionG.width / d + 1.0) + " " + (int)((double)dimensionG.height / d + 1.0) + "\n");
        this.out.write("%%Creator: FidoCadJ 0.24.8, EPS export filter by Davide Bucci\n");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", new Locale("en"));
        Date date = new Date();
        this.out.write("%%CreationDate: " + simpleDateFormat.format(date) + "\n");
        this.out.write("%%EndComments\n");
        this.out.write("/ellipsedict 8 dict def\nellipsedict /mtrx matrix put\n/ellipse\n   { ellipsedict begin\n     /endangle exch def\n     /startangle exch def\n     /yrad exch def\n     /xrad exch def\n     /y exch def\n     /x exch def\n     /savematrix mtrx currentmatrix def\n     x y translate\n     xrad yrad scale\n     0 0 1 startangle endangle arc\n     savematrix setmatrix\n     end\n   } def\n");
        this.out.write("0 " + (double)dimensionG.height / d + " translate\n");
        this.out.write(1.0 / d + " " + -1.0 / d + " scale\n");
    }

    @Override
    public void exportEnd() throws IOException {
        this.out.write("%%EOF\n");
        this.out.close();
    }

    @Override
    public void exportAdvText(int n, int n2, int n3, int n4, String string, boolean bl, boolean bl2, boolean bl3, int n5, int n6, String string2) throws IOException {
        String string3 = string2;
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n6);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, -1.0);
        this.currentFontSize = (int)((double)(n3 * 12) / 7.0 + 0.5);
        this.fontname = string;
        this.bold = bl ? "-Bold" : "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(" ", "-");
        this.fontname = Globals.substituteBizarreChars(this.fontname, hashMap);
        this.out.write("/" + this.fontname + this.bold + " findfont\n" + (int)this.currentFontSize + " scalefont\nsetfont\n");
        this.out.write("newpath\n");
        this.out.write(n + " " + n2 + " moveto\n");
        this.textx = n;
        this.texty = n2;
        this.out.write("gsave\n");
        if (n5 != 0) {
            this.out.write("  " + (bl2 ? n5 : -n5) + " rotate\n");
        }
        if (bl2) {
            this.out.write("  -1 -1 scale\n");
        } else {
            this.out.write("  1 -1 scale\n");
        }
        double d = n4 / n3 == 1 ? 1.0 : (double)n4 / (double)n3 * 22.0 / 40.0;
        this.out.write("  1 " + d + " scale\n");
        this.out.write("  0 " + (double)(-this.currentFontSize) * 0.8 + " rmoveto\n");
        this.checkColorAndWidth(colorInterface, 0.33);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("(", "\\050");
        hashMap2.put(")", "\\051");
        string3 = Globals.substituteBizarreChars(string3, hashMap2);
        this.dt.drawString(string3, n, n2);
        this.out.write("grestore\n");
    }

    @Override
    public void exportBezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, int n10, int n11, int n12, int n13, double d) throws IOException {
        PointPr pointPr;
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n9);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, d);
        this.registerDash(n13);
        if (bl) {
            pointPr = this.exportArrow(n, n2, n3, n4, n11, n12, n10);
            if (n11 > 0) {
                n = (int)Math.round(pointPr.x);
                n2 = (int)Math.round(pointPr.y);
            }
        }
        if (bl2) {
            pointPr = this.exportArrow(n7, n8, n5, n6, n11, n12, n10);
            if (n11 > 0) {
                n7 = (int)Math.round(pointPr.x);
                n8 = (int)Math.round(pointPr.y);
            }
        }
        this.out.write(n + " " + n2 + " moveto \n");
        this.out.write(n3 + " " + n4 + " " + n5 + " " + n6 + " " + n7 + " " + n8 + " curveto stroke\n");
    }

    @Override
    public void exportConnection(int n, int n2, int n3, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n3);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, 0.33);
        this.out.write("newpath\n");
        this.out.write(n + " " + n2 + " " + d / 2.0 + " " + d / 2.0 + " 0 360 ellipse\n");
        this.out.write("fill\n");
    }

    @Override
    public void exportLine(double d, double d2, double d3, double d4, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, double d5) throws IOException {
        PointPr pointPr;
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, d5);
        this.registerDash(n5);
        double d6 = d;
        double d7 = d2;
        double d8 = d3;
        double d9 = d4;
        if (bl) {
            pointPr = this.exportArrow(d, d2, d3, d4, n3, n4, n2);
            if (n3 > 0) {
                d6 = pointPr.x;
                d7 = pointPr.y;
            }
        }
        if (bl2) {
            pointPr = this.exportArrow(d3, d4, d, d2, n3, n4, n2);
            if (n3 > 0) {
                d8 = pointPr.x;
                d9 = pointPr.y;
            }
        }
        this.out.write(d6 + " " + d7 + " moveto " + d8 + " " + d9 + " lineto stroke\n");
    }

    @Override
    public PointPr exportArrow(double d, double d2, double d3, double d4, double d5, double d6, int n) throws IOException {
        double d7 = d == d3 ? 1.5707963267948966 + (d2 - d4 < 0.0 ? 0.0 : Math.PI) : Math.atan((d2 - d4) / (d - d3));
        double d8 = d - d5 * Math.cos(d7 += d - d3 > 0.0 ? 0.0 : Math.PI);
        double d9 = d2 - d5 * Math.sin(d7);
        double d10 = d8 - d6 * Math.sin(d7);
        double d11 = d9 + d6 * Math.cos(d7);
        double d12 = d8 + d6 * Math.sin(d7);
        double d13 = d9 - d6 * Math.cos(d7);
        this.out.write("newpath\n");
        this.out.write(Globals.roundTo(d) + " " + Globals.roundTo(d2) + " moveto\n");
        this.out.write(Globals.roundTo(d10) + " " + Globals.roundTo(d11) + " lineto\n");
        this.out.write(Globals.roundTo(d12) + " " + Globals.roundTo(d13) + " lineto\n");
        this.out.write("closepath\n");
        if ((n & 2) == 0) {
            this.out.write("fill \n");
        } else {
            this.out.write("stroke \n");
        }
        if ((n & 1) != 0) {
            double d14 = d - d6 * Math.sin(d7);
            double d15 = d2 + d6 * Math.cos(d7);
            double d16 = d + d6 * Math.sin(d7);
            double d17 = d2 - d6 * Math.cos(d7);
            this.out.write(Globals.roundTo(d14) + " " + Globals.roundTo(d15) + " moveto\n" + Globals.roundTo(d16) + " " + Globals.roundTo(d17) + " lineto\nstroke\n");
        }
        return new PointPr(d8, d9);
    }

    @Override
    public boolean exportMacro(int n, int n2, boolean bl, int n3, String string, String string2, String string3, int n4, int n5, String string4, int n6, int n7, String string5, int n8, Map<String, MacroDesc> map) throws IOException {
        return false;
    }

    @Override
    public void exportOval(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n5);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, d);
        this.registerDash(n6);
        this.out.write("newpath\n");
        this.out.write((double)(n + n3) / 2.0 + " " + (double)(n2 + n4) / 2.0 + " " + (double)Math.abs(n3 - n) / 2.0 + " " + (double)Math.abs(n4 - n2) / 2.0 + " 0 360 ellipse\n");
        if (bl) {
            this.out.write("fill\n");
        } else {
            this.out.write("stroke\n");
        }
    }

    @Override
    public void exportPCBLine(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n6);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, n5);
        this.registerDash(0);
        this.out.write("1 setlinecap\n");
        this.out.write(n + " " + n2 + " moveto " + n3 + " " + n4 + " lineto stroke\n");
    }

    @Override
    public void exportPCBPad(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n7);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, 0.33);
        if (!bl) {
            switch (n3) {
                case 2: {
                    this.roundRect((double)n - (double)n4 / 2.0, (double)n2 - (double)n5 / 2.0, n4, n5, 4.0, true);
                    break;
                }
                case 1: {
                    double d = (double)n - (double)n4 / 2.0;
                    double d2 = (double)n2 - (double)n5 / 2.0;
                    this.out.write("newpath\n");
                    this.out.write(d + " " + d2 + " moveto\n");
                    this.out.write(d + (double)n4 + " " + d2 + " lineto\n");
                    this.out.write(d + (double)n4 + " " + (d2 + (double)n5) + " lineto\n");
                    this.out.write(d + " " + (d2 + (double)n5) + " lineto\n");
                    this.out.write("closepath\n");
                    this.out.write("fill\n");
                    break;
                }
                default: {
                    this.out.write("newpath\n");
                    this.out.write(n + " " + n2 + " " + (double)n4 / 2.0 + " " + (double)n5 / 2.0 + " 0 360 ellipse\n");
                    this.out.write("fill\n");
                }
            }
        }
        this.checkColorAndWidth(colorInterface.white(), 0.33);
        this.out.write("newpath\n");
        this.out.write(n + " " + n2 + " " + (double)n6 / 2.0 + " " + (double)n6 / 2.0 + " 0 360 ellipse\n");
        this.out.write("fill\n");
    }

    @Override
    public void exportPolygon(PointDouble[] pointDoubleArray, int n, boolean bl, int n2, int n3, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n2);
        ColorInterface colorInterface = layerDesc.getColor();
        String string = "";
        if (n < 1) {
            return;
        }
        this.checkColorAndWidth(colorInterface, d);
        this.registerDash(n3);
        this.out.write("newpath\n");
        this.out.write(pointDoubleArray[0].x + " " + pointDoubleArray[0].y + " moveto\n");
        for (int i = 1; i < n; ++i) {
            this.out.write(pointDoubleArray[i].x + " " + pointDoubleArray[i].y + " lineto\n");
        }
        this.out.write("closepath\n");
        if (bl) {
            this.out.write("fill\n");
        } else {
            this.out.write("stroke\n");
        }
    }

    @Override
    public boolean exportCurve(PointDouble[] pointDoubleArray, int n, boolean bl, boolean bl2, int n2, boolean bl3, boolean bl4, int n3, int n4, int n5, int n6, double d) throws IOException {
        return false;
    }

    @Override
    public void exportRectangle(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) throws IOException {
        LayerDesc layerDesc = (LayerDesc)this.layerV.get(n5);
        ColorInterface colorInterface = layerDesc.getColor();
        this.checkColorAndWidth(colorInterface, d);
        this.registerDash(n6);
        this.out.write("newpath\n");
        this.out.write(Globals.roundTo(n, 3) + " " + Globals.roundTo(n2, 3) + " moveto\n");
        this.out.write(Globals.roundTo(n3, 3) + " " + Globals.roundTo(n2, 3) + " lineto\n");
        this.out.write(Globals.roundTo(n3, 3) + " " + Globals.roundTo(n4, 3) + " lineto\n");
        this.out.write(Globals.roundTo(n, 3) + " " + Globals.roundTo(n4, 3) + " lineto\n");
        this.out.write("closepath\n");
        if (bl) {
            this.out.write("fill\n");
        } else {
            this.out.write("stroke\n");
        }
    }

    private void roundRect(double d, double d2, double d3, double d4, double d5, boolean bl) throws IOException {
        this.out.write(d + d5 + " " + d2 + " moveto\n");
        this.out.write(d + d3 - d5 + " " + d2 + " lineto\n");
        this.out.write(d + d3 + " " + d2 + " " + (d + d3) + " " + d2 + " " + (d + d3) + " " + (d2 + d5) + " curveto\n");
        this.out.write(d + d3 + " " + (d2 + d4 - d5) + " lineto\n");
        this.out.write(d + d3 + " " + (d2 + d4) + " " + (d + d3) + " " + (d2 + d4) + " " + (d + d3 - d5) + " " + (d2 + d4) + " curveto\n");
        this.out.write(d + d5 + " " + (d2 + d4) + " lineto\n");
        this.out.write(d + " " + (d2 + d4) + " " + d + " " + (d2 + d4) + " " + d + " " + (d2 + d4 - d5) + " curveto\n");
        this.out.write(d + " " + (d2 + d5) + " lineto\n");
        this.out.write(d + " " + d2 + " " + d + " " + d2 + " " + (d + d5) + " " + d2 + " curveto\n");
        this.out.write("  " + (bl ? "fill\n" : "stroke\n"));
    }

    private void checkColorAndWidth(ColorInterface colorInterface, double d) throws IOException {
        if (!colorInterface.equals(this.actualColor)) {
            this.out.write("  " + Globals.roundTo((double)colorInterface.getRed() / 255.0) + " " + Globals.roundTo((double)colorInterface.getGreen() / 255.0) + " " + Globals.roundTo((double)colorInterface.getBlue() / 255.0) + " setrgbcolor\n");
            this.actualColor = colorInterface;
        }
        if (d > 0.0 && d != this.actualWidth) {
            this.out.write("  " + d + " setlinewidth\n");
            this.actualWidth = d;
        }
    }

    private void registerDash(int n) throws IOException {
        if (this.currentDash != n || this.currentPhase != this.dashPhase) {
            this.currentDash = n;
            this.currentPhase = this.dashPhase;
            if (n == 0) {
                this.out.write("[] 0 setdash\n");
            } else {
                this.out.write(this.sDash[n] + " " + this.dashPhase + " setdash\n");
            }
        }
    }

    @Override
    public double getFontSize() {
        return this.currentFontSize;
    }

    @Override
    public void setFontSize(double d) {
        this.currentFontSize = (float)d;
        try {
            this.out.write("/" + this.fontname + this.bold + " findfont\n" + (int)this.currentFontSize + " scalefont\nsetfont\n");
        }
        catch (IOException iOException) {
            System.err.println("Can not write to file in EPS export.");
        }
    }

    @Override
    public int getStringWidth(String string) {
        return 0;
    }

    @Override
    public void drawString(String string, int n, int n2) {
        try {
            this.out.write(this.textx - (float)n + " " + (this.texty - (float)n2) + " rmoveto\n");
            this.texty = n2;
            this.out.write("  (" + string + ") show\n");
        }
        catch (IOException iOException) {
            System.err.println("Can not write to file in EPS export.");
        }
    }
}

