/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.BorderFactory;
import net.sourceforge.fidocadj.PrintTools;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.dialogs.print.DialogPrint;

public class PrintPreview
extends CircuitPanel
implements ComponentListener {
    private final PageFormat pageDescription;
    private double topMargin;
    private double bottomMargin;
    private double leftMargin;
    private double rightMargin;
    private BufferedImage pageImage;
    private final PrintTools printObject;
    private final DialogPrint dialog;
    private int currentPage;
    private double oldBaseline;

    public PrintPreview(boolean bl, PageFormat pageFormat, DialogPrint dialogPrint) {
        super(bl);
        this.pageDescription = pageFormat;
        this.currentPage = 0;
        this.dialog = dialogPrint;
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setGridVisibility(false);
        this.addComponentListener(this);
        int n = 200;
        int n2 = 320;
        this.pageImage = new BufferedImage(n, n2, 1);
        this.printObject = new PrintTools();
        this.printObject.associateToCircuitPanel(this);
        this.printObject.setShowMargins(true);
        Graphics2D graphics2D = this.pageImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.scale(0.00625, 0.00625);
        try {
            this.printObject.print(graphics2D, this.pageDescription, 0);
        }
        catch (PrinterException printerException) {
            System.err.println("Some problem here!");
        }
    }

    public void setMargins(double d, double d2, double d3, double d4) {
        this.topMargin = d;
        this.bottomMargin = d2;
        this.leftMargin = d3;
        this.rightMargin = d4;
    }

    public int setCurrentPage(int n) {
        this.pageImage = new BufferedImage(10, 10, 1);
        Graphics2D graphics2D = this.pageImage.createGraphics();
        try {
            this.currentPage = this.printObject.print(graphics2D, this.pageDescription, n) == 0 ? n : 0;
        }
        catch (PrinterException printerException) {
            this.currentPage = 0;
        }
        return this.currentPage;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.getDrawingModel().setChanged(true);
        Color color = graphics.getColor();
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 4;
        int n2 = 4;
        double d = (double)this.getWidth() * 0.6;
        if (Math.abs(this.oldBaseline - d) > 100000.0) {
            this.updatePreview();
        }
        double d2 = this.pageDescription.getHeight() / this.pageDescription.getWidth();
        if (this.dialog.getLandscape()) {
            d = (double)this.getWidth() * 0.8;
            this.pageDescription.setOrientation(0);
        } else {
            this.pageDescription.setOrientation(1);
        }
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(Color.gray.darker());
        graphics2D.fillRect((int)Math.round((double)this.getWidth() / 2.0 - d / 2.0) + n, (int)Math.round((double)this.getHeight() / 2.0 - d * d2 / 2.0) + n2, (int)Math.round(d), (int)Math.round(d * d2));
        graphics2D.drawImage((Image)this.pageImage, (int)Math.round((double)this.getWidth() / 2.0 - d / 2.0), (int)Math.round((double)this.getHeight() / 2.0 - d * d2 / 2.0), null);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect((int)Math.round((double)this.getWidth() / 2.0 - d / 2.0), (int)Math.round((double)this.getHeight() / 2.0 - d * d2 / 2.0), (int)Math.round(d) - 1, (int)Math.round(d * d2));
        graphics2D.setColor(color);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.updatePreview();
    }

    public void updatePreview() {
        this.printObject.configurePrinting(this.dialog, this.pageDescription, false);
        double d = (double)this.getWidth() * 0.6;
        double d2 = this.pageDescription.getWidth();
        double d3 = this.pageDescription.getHeight();
        double d4 = d3 / d2;
        if (this.dialog.getLandscape()) {
            d = (double)this.getWidth() * 0.8;
            this.pageDescription.setOrientation(0);
        } else {
            this.pageDescription.setOrientation(1);
        }
        int n = (int)d;
        int n2 = (int)Math.round(d * d4);
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        this.pageImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = this.pageImage.createGraphics();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.scale((double)n / d2, (double)n2 / d3);
        try {
            this.printObject.setMargins(this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin);
            this.printObject.print(graphics2D, this.pageDescription, this.currentPage);
        }
        catch (PrinterException printerException) {
            System.err.println("Some problem here!");
        }
        graphics2D.setTransform(affineTransform);
        this.oldBaseline = d;
    }

    public int getTotalNumberOfPages() {
        int n = 0;
        this.pageImage = new BufferedImage(10, 10, 1);
        Graphics2D graphics2D = this.pageImage.createGraphics();
        try {
            while (this.printObject.print(graphics2D, this.pageDescription, n) == 0) {
                ++n;
            }
        }
        catch (PrinterException printerException) {
            System.err.println("Some problems when trying to print.");
        }
        return n;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

