/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs.print;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicArrowButton;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.dialogs.DialogUtil;
import net.sourceforge.fidocadj.dialogs.LayerCellRenderer;
import net.sourceforge.fidocadj.dialogs.mindimdialog.MinimumSizeDialog;
import net.sourceforge.fidocadj.dialogs.print.PrintPreview;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.layers.LayerDesc;

public class DialogPrint
extends MinimumSizeDialog {
    private final JCheckBox mirror_CB;
    private final JCheckBox fit_CB;
    private final JCheckBox bw_CB;
    private final JCheckBox landscape_CB;
    private final PrintPreview prp;
    private final JTextField tTopMargin;
    private final JTextField tBottomMargin;
    private final JTextField tLeftMargin;
    private final JTextField tRightMargin;
    private final JCheckBox onlyLayerCB;
    private final JLabel pageNum;
    private final JComboBox<LayerDesc> layerSel;
    private double maxHorisontalMargin;
    private double maxVerticalMargin;
    private boolean oldLandscapeState = false;
    private int currentLayerSelected = -1;
    private int numberOfPages = 0;
    private int currentPage = 0;
    private boolean print;

    public DialogPrint(JFrame jFrame, DrawingModel drawingModel, PageFormat pageFormat) {
        super(400, 350, jFrame, Globals.messages.getString("Print_dlg"), true);
        this.addComponentListener(this);
        this.print = false;
        this.getRootPane().putClientProperty("apple.awt.documentModalSheet", Boolean.TRUE);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        gridBagConstraints.insets.right = 30;
        JLabel jLabel = new JLabel("  ");
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        container.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel("  ");
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        container.add((Component)jLabel2, gridBagConstraints);
        this.prp = new PrintPreview(false, pageFormat, this);
        this.prp.add(Box.createVerticalStrut(256));
        this.prp.add(Box.createHorizontalStrut(256));
        this.prp.setDrawingModel(drawingModel);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        container.add((Component)this.prp, gridBagConstraints);
        final BasicArrowButton basicArrowButton = new BasicArrowButton(7);
        this.numberOfPages = this.prp.getTotalNumberOfPages();
        this.pageNum = new JLabel(this.currentPage + 1 + "/" + this.numberOfPages);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        container.add((Component)this.pageNum, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        container.add((Component)basicArrowButton, gridBagConstraints);
        basicArrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogPrint.this.currentPage > 0) {
                    --DialogPrint.this.currentPage;
                }
                DialogPrint.this.currentPage = DialogPrint.this.prp.setCurrentPage(DialogPrint.this.currentPage);
                DialogPrint.this.prp.updatePreview();
                DialogPrint.this.prp.repaint();
                DialogPrint.this.pageNum.setText(DialogPrint.this.currentPage + 1 + "/" + DialogPrint.this.numberOfPages);
            }
        });
        final BasicArrowButton basicArrowButton2 = new BasicArrowButton(3);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        container.add((Component)basicArrowButton2, gridBagConstraints);
        basicArrowButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogPrint.this.currentPage < DialogPrint.this.numberOfPages - 1) {
                    ++DialogPrint.this.currentPage;
                }
                DialogPrint.this.currentPage = DialogPrint.this.prp.setCurrentPage(DialogPrint.this.currentPage);
                DialogPrint.this.prp.updatePreview();
                DialogPrint.this.prp.repaint();
                DialogPrint.this.pageNum.setText(DialogPrint.this.currentPage + 1 + "/" + DialogPrint.this.numberOfPages);
            }
        });
        if (this.numberOfPages > 1) {
            basicArrowButton2.setEnabled(true);
            basicArrowButton.setEnabled(true);
        } else {
            basicArrowButton2.setEnabled(false);
            basicArrowButton.setEnabled(false);
        }
        JLabel jLabel3 = new JLabel(Globals.messages.getString("TopMargin"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        container.add((Component)jLabel3, gridBagConstraints);
        DocumentListener documentListener = new DocumentListener(){

            private void patata() {
                try {
                    double d = Double.parseDouble(DialogPrint.this.tTopMargin.getText());
                    double d2 = Double.parseDouble(DialogPrint.this.tBottomMargin.getText());
                    double d3 = Double.parseDouble(DialogPrint.this.tLeftMargin.getText());
                    double d4 = Double.parseDouble(DialogPrint.this.tRightMargin.getText());
                    DialogPrint.this.prp.setMargins(d, d2, d3, d4);
                    DialogPrint.this.numberOfPages = DialogPrint.this.prp.getTotalNumberOfPages();
                    DialogPrint.this.currentPage = DialogPrint.this.prp.setCurrentPage(DialogPrint.this.currentPage);
                    DialogPrint.this.prp.updatePreview();
                    DialogPrint.this.pageNum.setText(DialogPrint.this.currentPage + 1 + "/" + DialogPrint.this.numberOfPages);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                DialogPrint.this.prp.repaint();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.patata();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.patata();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.patata();
            }
        };
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DialogPrint.this.numberOfPages = DialogPrint.this.prp.getTotalNumberOfPages();
                if (DialogPrint.this.numberOfPages > 1) {
                    basicArrowButton2.setEnabled(true);
                    basicArrowButton.setEnabled(true);
                } else {
                    basicArrowButton2.setEnabled(false);
                    basicArrowButton.setEnabled(false);
                }
                DialogPrint.this.currentPage = DialogPrint.this.prp.setCurrentPage(DialogPrint.this.currentPage);
                DialogPrint.this.prp.updatePreview();
                DialogPrint.this.prp.repaint();
                DialogPrint.this.pageNum.setText(DialogPrint.this.currentPage + 1 + "/" + DialogPrint.this.numberOfPages);
            }
        };
        this.tTopMargin = new JTextField(10);
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        container.add((Component)this.tTopMargin, gridBagConstraints);
        this.tTopMargin.getDocument().addDocumentListener(documentListener);
        JLabel jLabel4 = new JLabel(Globals.messages.getString("BottomMargin"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)jLabel4, gridBagConstraints);
        this.tBottomMargin = new JTextField(10);
        Dimension dimension = this.tBottomMargin.getMinimumSize();
        dimension.width = 100;
        this.tBottomMargin.setMinimumSize(dimension);
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        container.add((Component)this.tBottomMargin, gridBagConstraints);
        this.tBottomMargin.getDocument().addDocumentListener(documentListener);
        JLabel jLabel5 = new JLabel(Globals.messages.getString("LeftMargin"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        container.add((Component)jLabel5, gridBagConstraints);
        this.tLeftMargin = new JTextField(10);
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        container.add((Component)this.tLeftMargin, gridBagConstraints);
        this.tLeftMargin.getDocument().addDocumentListener(documentListener);
        JLabel jLabel6 = new JLabel(Globals.messages.getString("RightMargin"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        container.add((Component)jLabel6, gridBagConstraints);
        this.tRightMargin = new JTextField(10);
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        container.add((Component)this.tRightMargin, gridBagConstraints);
        this.tRightMargin.getDocument().addDocumentListener(documentListener);
        this.onlyLayerCB = new JCheckBox(Globals.messages.getString("PrintOnlyLayer"));
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        container.add((Component)this.onlyLayerCB, gridBagConstraints);
        this.onlyLayerCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (DialogPrint.this.onlyLayerCB.isSelected()) {
                    if (DialogPrint.this.layerSel != null) {
                        DialogPrint.this.layerSel.setEnabled(true);
                        DialogPrint.this.currentLayerSelected = DialogPrint.this.layerSel.getSelectedIndex();
                    }
                } else {
                    DialogPrint.this.layerSel.setEnabled(false);
                }
                DialogPrint.this.prp.updatePreview();
                DialogPrint.this.prp.repaint();
            }
        });
        this.layerSel = new JComboBox<LayerDesc>(drawingModel.getLayers());
        this.layerSel.setRenderer(new LayerCellRenderer());
        this.layerSel.setEnabled(false);
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        container.add(this.layerSel, gridBagConstraints);
        this.layerSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogPrint.this.layerSel.getSelectedIndex() >= 0) {
                    DialogPrint.this.currentLayerSelected = DialogPrint.this.layerSel.getSelectedIndex();
                    if (DialogPrint.this.onlyLayerCB.isSelected()) {
                        DialogPrint.this.prp.updatePreview();
                        DialogPrint.this.prp.repaint();
                    }
                }
            }
        });
        this.mirror_CB = new JCheckBox(Globals.messages.getString("Mirror"));
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        container.add((Component)this.mirror_CB, gridBagConstraints);
        this.mirror_CB.addChangeListener(changeListener);
        this.fit_CB = new JCheckBox(Globals.messages.getString("FitPage"));
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        container.add((Component)this.fit_CB, gridBagConstraints);
        this.fit_CB.addChangeListener(changeListener);
        this.bw_CB = new JCheckBox(Globals.messages.getString("B_W"));
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        container.add((Component)this.bw_CB, gridBagConstraints);
        this.bw_CB.addChangeListener(changeListener);
        this.landscape_CB = new JCheckBox(Globals.messages.getString("Landscape"));
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        container.add((Component)this.landscape_CB, gridBagConstraints);
        this.landscape_CB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!DialogPrint.this.oldLandscapeState && DialogPrint.this.landscape_CB.isSelected()) {
                    String string = DialogPrint.this.tLeftMargin.getText();
                    DialogPrint.this.tLeftMargin.setText(DialogPrint.this.tBottomMargin.getText());
                    DialogPrint.this.tBottomMargin.setText(DialogPrint.this.tRightMargin.getText());
                    DialogPrint.this.tRightMargin.setText(DialogPrint.this.tTopMargin.getText());
                    DialogPrint.this.tTopMargin.setText(string);
                } else if (DialogPrint.this.oldLandscapeState && !DialogPrint.this.landscape_CB.isSelected()) {
                    String string = DialogPrint.this.tTopMargin.getText();
                    DialogPrint.this.tTopMargin.setText(DialogPrint.this.tRightMargin.getText());
                    DialogPrint.this.tRightMargin.setText(DialogPrint.this.tBottomMargin.getText());
                    DialogPrint.this.tBottomMargin.setText(DialogPrint.this.tLeftMargin.getText());
                    DialogPrint.this.tLeftMargin.setText(string);
                }
                DialogPrint.this.numberOfPages = DialogPrint.this.prp.getTotalNumberOfPages();
                DialogPrint.this.prp.updatePreview();
                DialogPrint.this.prp.repaint();
                DialogPrint.this.oldLandscapeState = DialogPrint.this.landscape_CB.isSelected();
            }
        });
        JButton jButton = new JButton(Globals.messages.getString("Ok_btn"));
        JButton jButton2 = new JButton(Globals.messages.getString("Cancel_btn"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        gridBagConstraints.anchor = 13;
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        jButton.setPreferredSize(jButton2.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            box.add(jButton);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton2);
        } else {
            box.add(jButton2);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton);
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogPrint.this.validateInput()) {
                    DialogPrint.this.print = true;
                    DialogPrint.this.setVisible(false);
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogPrint.this.print = false;
                DialogPrint.this.setVisible(false);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogPrint.this.setVisible(false);
            }
        };
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        container.add((Component)box, gridBagConstraints);
        DialogUtil.addCancelEscape(this, abstractAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(jButton);
    }

    public boolean getMirror() {
        return this.mirror_CB.isSelected();
    }

    public boolean getFit() {
        return this.fit_CB.isSelected();
    }

    public boolean getLandscape() {
        return this.landscape_CB.isSelected();
    }

    public int getSingleLayerToPrint() {
        if (!this.onlyLayerCB.isSelected()) {
            return -1;
        }
        return this.currentLayerSelected;
    }

    public boolean getBW() {
        return this.bw_CB.isSelected();
    }

    public void setMirror(boolean bl) {
        this.mirror_CB.setSelected(bl);
    }

    public void setFit(boolean bl) {
        this.fit_CB.setSelected(bl);
    }

    public void setLandscape(boolean bl) {
        this.landscape_CB.setSelected(bl);
        this.oldLandscapeState = bl;
    }

    public void setMargins(double d, double d2, double d3, double d4) {
        this.tTopMargin.setText(Globals.roundTo(d, 3));
        this.tBottomMargin.setText(Globals.roundTo(d2, 3));
        this.tLeftMargin.setText(Globals.roundTo(d3, 3));
        this.tRightMargin.setText(Globals.roundTo(d4, 3));
    }

    private boolean validateInput() {
        double d;
        double d2;
        double d3;
        double d4;
        try {
            d4 = Double.parseDouble(this.tTopMargin.getText());
            d3 = Double.parseDouble(this.tBottomMargin.getText());
            d2 = Double.parseDouble(this.tLeftMargin.getText());
            d = Double.parseDouble(this.tRightMargin.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, Globals.messages.getString("Format_invalid"), "", 1);
            return false;
        }
        if (d4 + d3 >= this.maxVerticalMargin || d2 + d >= this.maxHorisontalMargin) {
            JOptionPane.showMessageDialog(this, Globals.messages.getString("Margins_too_large"), "", 1);
            return false;
        }
        return true;
    }

    public void setMaxMargins(double d, double d2) {
        this.maxHorisontalMargin = d;
        this.maxVerticalMargin = d2;
    }

    public double getTMargin() {
        return Double.parseDouble(this.tTopMargin.getText());
    }

    public double getBMargin() {
        return Double.parseDouble(this.tBottomMargin.getText());
    }

    public double getLMargin() {
        return Double.parseDouble(this.tLeftMargin.getText());
    }

    public double getRMargin() {
        return Double.parseDouble(this.tRightMargin.getText());
    }

    public void setBW(boolean bl) {
        this.bw_CB.setSelected(bl);
    }

    public boolean shouldPrint() {
        return this.print;
    }
}

