/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.globals.Globals;

public class OriginCircuitPanel
extends CircuitPanel {
    final float[] dash1 = new float[]{2.0f};
    final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 1.0f, this.dash1, 1.0f);
    private int dx = 20;
    private int dy = 20;
    public int xl = 5;
    public int yl = 5;

    public int getDx() {
        return this.dx;
    }

    public int getDy() {
        return this.dy;
    }

    public void resetOrigin() {
        this.xl = this.getMapCoordinates().unmapXsnap(10);
        this.yl = this.getMapCoordinates().unmapYsnap(10);
        this.dx = this.getMapCoordinates().mapXi(this.xl, this.yl, false);
        this.dy = this.getMapCoordinates().mapYi(this.xl, this.yl, false);
    }

    public void setDx(int n) {
        if (n < 0 || n > this.getWidth()) {
            return;
        }
        this.dx = n;
    }

    public void setDy(int n) {
        if (n < 0 || n > this.getHeight()) {
            return;
        }
        this.dy = n;
    }

    public OriginCircuitPanel(boolean bl) {
        super(bl);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setColor(Color.red);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.dashed);
        graphics.drawLine(this.dx, 0, this.dx, this.getHeight());
        graphics.drawLine(0, this.dy, this.getWidth(), this.dy);
        Font font = new Font("Helvetica", 0, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getAscent();
        int n2 = n + fontMetrics.getDescent();
        graphics.drawString(Globals.messages.getString("Origin"), this.dx + 5, this.dy + n2 + 2);
        graphics.setColor(color);
        graphics2D.setStroke(stroke);
    }
}

