/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.metal.MetalIconFactory;
import net.sourceforge.fidocadj.globals.Globals;

public class LibraryPanel
extends JPanel
implements PropertyChangeListener {
    private static final int PREFERRED_PANEL_WIDTH = 250;
    private final JFileChooser fc;
    private final LibraryListModel listModel;

    public LibraryPanel(JFileChooser jFileChooser) {
        this.fc = jFileChooser;
        jFileChooser.addPropertyChangeListener(this);
        jFileChooser.setAccessory(this);
        this.listModel = new LibraryListModel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryPanel.this.initGUI();
            }
        });
        this.listModel.setDirectory(jFileChooser.getCurrentDirectory());
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(250, 1));
        if (Globals.messages == null) {
            this.add("North", new JLabel("Libraries in directory:"));
        } else {
            this.add("North", new JLabel(Globals.messages.getString("lib_in_dir")));
        }
        JList<LibraryDesc> jList = new JList<LibraryDesc>(this.listModel);
        jList.setCellRenderer(new ListCellRenderer<LibraryDesc>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends LibraryDesc> jList, LibraryDesc libraryDesc, int n, boolean bl, boolean bl2) {
                LibraryDesc libraryDesc2 = libraryDesc;
                Icon icon = MetalIconFactory.getTreeFloppyDriveIcon();
                SpaceIcon spaceIcon = new SpaceIcon(icon.getIconWidth(), icon.getIconHeight());
                Object object = libraryDesc2.libraryName == null ? "---" : "(" + libraryDesc2.libraryName + ")";
                JPanel jPanel = new JPanel();
                jPanel.setBorder(new EmptyBorder(2, 0, 3, 0));
                jPanel.setOpaque(false);
                jPanel.setLayout(new BorderLayout());
                jPanel.add("North", new JLabel(libraryDesc2.filename, icon, 2));
                jPanel.add("South", new JLabel((String)object, spaceIcon, 2));
                return jPanel;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.add("Center", jScrollPane);
        jList.setFocusable(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("SelectedFileChangedProperty")) {
            this.listModel.setDirectory(this.fc.getSelectedFile());
        }
        if (propertyChangeEvent.getPropertyName().equals("directoryChanged")) {
            this.listModel.setDirectory(this.fc.getCurrentDirectory());
        }
    }

    public static void main(String ... stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setPreferredSize(new Dimension(800, 400));
                new LibraryPanel(jFileChooser);
                jFileChooser.showOpenDialog(null);
            }
        });
    }

    public class LibraryListModel
    implements ListModel<LibraryDesc> {
        private final ArrayList<ListDataListener> listeners = new ArrayList();
        private final ArrayList<LibraryDesc> libraryList = new ArrayList();
        private File currentDir;

        LibraryListModel() {
        }

        public void setDirectory(File file) {
            this.currentDir = file;
            this.clearList();
            if (this.currentDir != null && this.currentDir.canRead() && this.currentDir.isDirectory()) {
                this.refreshList();
            }
            this.fireChanged();
        }

        private void refreshList() {
            File[] fileArray = this.currentDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().toLowerCase().matches("^.*\\.fcl$");
                }
            });
            if (fileArray == null) {
                return;
            }
            for (File file : fileArray) {
                LibraryDesc libraryDesc = new LibraryDesc();
                libraryDesc.filename = file.getName();
                libraryDesc.libraryName = this.getLibraryName(file);
                this.libraryList.add(libraryDesc);
            }
            Collections.sort(this.libraryList, new Comparator<LibraryDesc>(){

                @Override
                public int compare(LibraryDesc libraryDesc, LibraryDesc libraryDesc2) {
                    return libraryDesc.filename.compareTo(libraryDesc2.filename);
                }
            });
        }

        private void clearList() {
            this.libraryList.clear();
        }

        private void fireChanged() {
            for (ListDataListener listDataListener : this.listeners) {
                listDataListener.contentsChanged(new ListDataEvent(this, 0, 0, 0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getLibraryName(File file) {
            int n = -1;
            int n2 = 0;
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            String string = null;
            try {
                String string2;
                fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.matches("^\\[FIDOLIB .*\\]\\s*")) {
                        string2 = string2.trim();
                        string = string2.substring(9, string2.length() - 1);
                        break;
                    }
                    if (n != -1 && n <= n2) {
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                string = null;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (Exception exception) {
                    System.out.println("Problems while closing streams.");
                }
            }
            return string;
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            this.listeners.add(listDataListener);
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
            this.listeners.remove(listDataListener);
        }

        @Override
        public int getSize() {
            return this.libraryList.size();
        }

        @Override
        public LibraryDesc getElementAt(int n) {
            return this.libraryList.get(n);
        }
    }

    private class SpaceIcon
    implements Icon {
        private final int width;
        private final int height;

        SpaceIcon(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    private class LibraryDesc {
        public String filename;
        public String libraryName;

        private LibraryDesc() {
        }

        public String toString() {
            return String.format("%s (%s)", this.filename, this.libraryName);
        }
    }
}

