/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs;

import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public final class DialogUtil {
    private DialogUtil() {
    }

    public static void center(Window window) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point point = graphicsEnvironment.getCenterPoint();
        int n = window.getWidth();
        int n2 = window.getHeight();
        int n3 = point.x - n / 2;
        int n4 = point.y - n2 / 2;
        window.setBounds(n3, n4, n, n2);
        window.validate();
    }

    public static void center(Window window, double d, double d2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point point = graphicsEnvironment.getCenterPoint();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        int n = Math.max((int)((double)rectangle.width * d), Math.min(window.getWidth(), rectangle.width));
        int n2 = Math.max((int)((double)rectangle.height * d2), Math.min(window.getHeight(), rectangle.height));
        int n3 = point.x - n / 2;
        int n4 = point.y - n2 / 2;
        window.setBounds(n3, n4, n, n2);
        window.validate();
    }

    public static void center(Window window, double d, double d2, int n, int n2) {
        int n3;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point point = graphicsEnvironment.getCenterPoint();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        int n4 = Math.max((int)((double)rectangle.width * d), Math.min(window.getWidth(), rectangle.width));
        if (n4 < n) {
            n4 = n;
        }
        if ((n3 = Math.max((int)((double)rectangle.height * d2), Math.min(window.getHeight(), rectangle.height))) < n2) {
            n3 = n2;
        }
        int n5 = point.x - n4 / 2;
        int n6 = point.y - n3 / 2;
        window.setBounds(n5, n6, n4, n3);
        window.validate();
    }

    public static void addCancelEscape(JDialog jDialog, AbstractAction abstractAction) {
        String string = "CANCEL_ACTION_KEY";
        int n = 0;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, n, false);
        InputMap inputMap = jDialog.getRootPane().getInputMap(1);
        inputMap.put(keyStroke, string);
        jDialog.getRootPane().getActionMap().put(string, abstractAction);
    }

    public static GridBagConstraints createConst(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.fill = n8;
        gridBagConstraints.anchor = n7;
        gridBagConstraints.insets = insets;
        return gridBagConstraints;
    }
}

