/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.circuit.controllers.EditorActions;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.dialogs.DialogUtil;
import net.sourceforge.fidocadj.dialogs.OriginCircuitPanel;
import net.sourceforge.fidocadj.dialogs.mindimdialog.MinimumSizeDialog;
import net.sourceforge.fidocadj.geom.DrawingSize;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.globals.LibUtils;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.primitives.MacroDesc;

public class DialogSymbolize
extends MinimumSizeDialog {
    private final JPanel parent;
    private DrawingModel cp;
    private JComboBox<String> libFilename;
    private JTextField libName;
    private JTextField name;
    private JTextField key;
    private JComboBox<String> group;
    private JCheckBox snapToGrid;
    OriginCircuitPanel cpanel = new OriginCircuitPanel(false);

    public String getLibraryName() {
        String string = this.libName.getText();
        return string.trim();
    }

    public String getMacroName() {
        return this.name.getText();
    }

    public String getPrefix() {
        return this.libFilename.getEditor().getItem().toString();
    }

    public String getGroup() {
        return this.group.getEditor().getItem().toString();
    }

    private void enumLibs() {
        this.libFilename.removeAllItems();
        LinkedList<String> linkedList = new LinkedList<String>();
        Map<String, MacroDesc> map = this.cpanel.dmp.getLibrary();
        for (Map.Entry<String, MacroDesc> entry : map.entrySet()) {
            MacroDesc macroDesc = entry.getValue();
            if (linkedList.contains(macroDesc.filename) || LibUtils.isStdLib(macroDesc)) continue;
            this.libFilename.addItem(macroDesc.filename);
            linkedList.add(macroDesc.filename);
        }
        if (((DefaultComboBoxModel)this.libFilename.getModel()).getSize() == 0) {
            this.libFilename.addItem("user_lib");
        }
        this.libFilename.setEditable(true);
    }

    private JPanel createInterfacePanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(Globals.messages.getString("Library_file"));
        gridBagConstraints = DialogUtil.createConst(1, 0, 1, 1, 0, 0, 13, 0, new Insets(6, 0, 0, 0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.libFilename = new JComboBox();
        Object var5_5 = null;
        gridBagConstraints = DialogUtil.createConst(2, 0, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        jPanel.add(this.libFilename, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Globals.messages.getString("Library_name"));
        gridBagConstraints = DialogUtil.createConst(1, 1, 1, 1, 0, 0, 13, 0, new Insets(6, 0, 0, 0));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.libName = new JTextField();
        gridBagConstraints = DialogUtil.createConst(2, 1, 1, 1, 0, 0, 13, 1, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.libName, gridBagConstraints);
        MouseAdapter mouseAdapter = new MouseAdapter(){
            boolean grid = false;

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    this.grid = !this.grid;
                    DialogSymbolize.this.cpanel.setGridVisibility(this.grid);
                    DialogSymbolize.this.cpanel.repaint();
                } else {
                    this.mouseDragged(mouseEvent);
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (DialogSymbolize.this.snapToGrid.isSelected()) {
                    DialogSymbolize.this.cpanel.xl = DialogSymbolize.this.cpanel.getMapCoordinates().unmapXsnap(n);
                    DialogSymbolize.this.cpanel.yl = DialogSymbolize.this.cpanel.getMapCoordinates().unmapYsnap(n2);
                } else {
                    DialogSymbolize.this.cpanel.xl = DialogSymbolize.this.cpanel.getMapCoordinates().unmapXnosnap(n);
                    DialogSymbolize.this.cpanel.yl = DialogSymbolize.this.cpanel.getMapCoordinates().unmapYnosnap(n2);
                }
                n = DialogSymbolize.this.cpanel.getMapCoordinates().mapXi(DialogSymbolize.this.cpanel.xl, DialogSymbolize.this.cpanel.yl, false);
                n2 = DialogSymbolize.this.cpanel.getMapCoordinates().mapYi(DialogSymbolize.this.cpanel.xl, DialogSymbolize.this.cpanel.yl, false);
                DialogSymbolize.this.cpanel.setDx(n);
                DialogSymbolize.this.cpanel.setDy(n2);
                DialogSymbolize.this.cpanel.repaint();
            }
        };
        this.cpanel.addMouseListener(mouseAdapter);
        this.cpanel.addMouseMotionListener(mouseAdapter);
        this.cpanel.setSize(256, 256);
        this.cpanel.setPreferredSize(new Dimension(256, 256));
        this.cpanel.add(Box.createVerticalStrut(256));
        this.cpanel.add(Box.createHorizontalStrut(256));
        this.cpanel.dmp.setLayers(this.cp.getLayers());
        this.cpanel.dmp.setLibrary(this.cp.getLibrary());
        this.enumLibs();
        this.cpanel.antiAlias = true;
        this.cpanel.profileTime = false;
        MacroDesc macroDesc = this.buildMacro("temp", "temp", "temp", "temp", "temp", new Point(100, 100));
        this.cpanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.cpanel.getParserActions().addString(new StringBuffer(macroDesc.description), false);
        MapCoordinates mapCoordinates = DrawingSize.calculateZoomToFit(this.cpanel.dmp, this.cpanel.getSize().width * 80 / 100, this.cpanel.getSize().height * 80 / 100, true);
        mapCoordinates.setXCenter(-mapCoordinates.getXCenter() + 10.0);
        mapCoordinates.setYCenter(-mapCoordinates.getYCenter() + 10.0);
        this.cpanel.setMapCoordinates(mapCoordinates);
        this.cpanel.resetOrigin();
        gridBagConstraints = DialogUtil.createConst(3, 0, 8, 8, 100, 100, 10, 1, new Insets(6, 6, 6, 6));
        jPanel.add((Component)this.cpanel, gridBagConstraints);
        JLabel jLabel3 = new JLabel(Globals.messages.getString("Group"));
        gridBagConstraints = DialogUtil.createConst(1, 3, 1, 1, 0, 0, 13, 0, new Insets(6, 40, 0, 0));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.group = new JComboBox();
        this.listGroups();
        if (this.group.getItemCount() == 0) {
            this.group.addItem(Globals.messages.getString("Group").toLowerCase());
        }
        this.group.setEditable(true);
        this.libFilename.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DialogSymbolize.this.listGroups();
            }
        });
        this.libFilename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogSymbolize.this.listGroups();
            }
        });
        gridBagConstraints = DialogUtil.createConst(2, 3, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        jPanel.add(this.group, gridBagConstraints);
        JLabel jLabel4 = new JLabel(Globals.messages.getString("Name"));
        gridBagConstraints = DialogUtil.createConst(1, 4, 1, 1, 0, 0, 13, 0, new Insets(6, 40, 12, 0));
        jPanel.add((Component)jLabel4, gridBagConstraints);
        this.name = new JTextField();
        this.name.setText(Globals.messages.getString("Name").toLowerCase());
        gridBagConstraints = DialogUtil.createConst(2, 4, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 12, 0));
        jPanel.add((Component)this.name, gridBagConstraints);
        JLabel jLabel5 = new JLabel(Globals.messages.getString("Key"));
        gridBagConstraints = DialogUtil.createConst(1, 5, 1, 1, 0, 0, 13, 0, new Insets(6, 40, 12, 0));
        jPanel.add((Component)jLabel5, gridBagConstraints);
        this.key = new JTextField();
        long l = System.nanoTime();
        long l2 = 0L;
        int n = 0;
        while (l > 0L) {
            l2 ^= (l >>= n * 8) & 0xFFL;
            ++n;
        }
        gridBagConstraints = DialogUtil.createConst(2, 5, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 12, 0));
        jPanel.add((Component)this.key, gridBagConstraints);
        this.key.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.showValidity();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.showValidity();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.showValidity();
            }

            public void showValidity() {
                if (DialogSymbolize.this.isKeyInvalid()) {
                    DialogSymbolize.this.key.setBackground(Color.RED.darker());
                    DialogSymbolize.this.key.setForeground(Color.WHITE);
                } else {
                    Color color = UIManager.getColor("TextField.background");
                    Color color2 = UIManager.getColor("TextField.foreground");
                    if (color != null && color2 != null) {
                        DialogSymbolize.this.key.setBackground(color);
                        DialogSymbolize.this.key.setForeground(color2);
                    } else {
                        DialogSymbolize.this.key.setBackground(Color.GREEN.darker().darker());
                        DialogSymbolize.this.key.setForeground(Color.WHITE);
                    }
                }
            }
        });
        while (this.isKeyInvalid()) {
            this.key.setText(String.valueOf(l2++));
        }
        this.snapToGrid = new JCheckBox(Globals.messages.getString("SnapToGridOrigin"));
        gridBagConstraints = DialogUtil.createConst(2, 6, 1, 1, 0, 0, 17, 0, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.snapToGrid, gridBagConstraints);
        if (Globals.lastCLib != null) {
            this.libFilename.setSelectedItem(Globals.lastCLib);
        }
        if (Globals.lastCGrp != null) {
            this.group.setSelectedItem(Globals.lastCGrp);
        }
        this.libFilename.getEditor().selectAll();
        return jPanel;
    }

    private void listGroups() {
        List<String> list = LibUtils.enumGroups(this.cp.getLibrary(), this.libFilename.getEditor().getItem().toString());
        this.group.removeAllItems();
        for (String string : list) {
            this.group.addItem(string);
        }
        this.libName.setText(LibUtils.getLibName(this.cp.getLibrary(), this.libFilename.getEditor().getItem().toString()));
    }

    public DialogSymbolize(CircuitPanel circuitPanel, DrawingModel drawingModel) {
        super(350, 250, null, Globals.messages.getString("SaveSymbol"), true);
        this.parent = circuitPanel;
        this.addComponentListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = DialogUtil.createConst(2, 0, 1, 1, 100, 100, 17, 2, new Insets(12, 0, 0, 20));
        this.setCircuit(drawingModel);
        JPanel jPanel = this.createInterfacePanel();
        JButton jButton = new JButton(Globals.messages.getString("Ok_btn"));
        JButton jButton2 = new JButton(Globals.messages.getString("Cancel_btn"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        container.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        jButton.setPreferredSize(jButton2.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            box.add(jButton);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton2);
        } else {
            box.add(jButton2);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton);
        }
        container.add((Component)box, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogSymbolize.this.isKeyAbsent()) {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("InvKey"), Globals.messages.getString("Symbolize"), 0);
                    DialogSymbolize.this.key.requestFocus();
                    return;
                }
                if (DialogSymbolize.this.isKeyDuplicate()) {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("DupKey"), Globals.messages.getString("Symbolize"), 0);
                    DialogSymbolize.this.key.requestFocus();
                    return;
                }
                if (DialogSymbolize.this.isKeyContainingInvalidChars()) {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("SpaceKey"), Globals.messages.getString("Symbolize"), 0);
                    DialogSymbolize.this.key.requestFocus();
                    return;
                }
                Point point = new Point(200 - DialogSymbolize.this.cpanel.xl, 200 - DialogSymbolize.this.cpanel.yl);
                MacroDesc macroDesc = DialogSymbolize.this.buildMacro(DialogSymbolize.this.getMacroName().trim(), DialogSymbolize.this.key.getText().trim(), DialogSymbolize.this.getLibraryName().trim(), DialogSymbolize.this.getGroup().trim(), DialogSymbolize.this.getPrefix().trim(), point);
                DialogSymbolize.this.cp.getLibrary().put(macroDesc.key, macroDesc);
                try {
                    LibUtils.save(DialogSymbolize.this.cp.getLibrary(), LibUtils.getLibPath(DialogSymbolize.this.getPrefix()).trim(), DialogSymbolize.this.getLibraryName(), DialogSymbolize.this.getPrefix());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("DirNotFound"), Globals.messages.getString("Symbolize"), 0);
                }
                DialogSymbolize.this.setVisible(false);
                ((JFrame)Globals.activeWindow).repaint();
                DialogSymbolize.this.updateTreeLib();
                Globals.lastCLib = DialogSymbolize.this.getLibraryName();
                Globals.lastCGrp = DialogSymbolize.this.getGroup();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogSymbolize.this.setVisible(false);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogSymbolize.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, abstractAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(jButton);
    }

    private boolean isKeyDuplicate() {
        return LibUtils.checkKey(this.cp.getLibrary(), this.getPrefix().trim(), this.getPrefix().trim() + "." + this.key.getText().trim());
    }

    private boolean isKeyContainingInvalidChars() {
        return this.key.getText().contains(" ") || this.key.getText().contains(".");
    }

    private boolean isKeyAbsent() {
        return this.key.getText().length() < 1;
    }

    private boolean isKeyInvalid() {
        return this.isKeyAbsent() || this.isKeyContainingInvalidChars() || this.isKeyDuplicate();
    }

    protected MacroDesc buildMacro(String string, String string2, String string3, String string4, String string5, Point point) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        SelectionActions selectionActions = new SelectionActions(this.cp);
        EditorActions editorActions = new EditorActions(this.cp, selectionActions, null);
        if (selectionActions.getFirstSelectedPrimitive() == null) {
            return null;
        }
        DrawingModel drawingModel = new DrawingModel();
        try {
            drawingModel.setLibrary(this.cp.getLibrary());
            object = new ParserActions(drawingModel);
            for (GraphicPrimitive graphicPrimitive : this.cp.getPrimitiveVector()) {
                if (!graphicPrimitive.getSelected()) continue;
                ((ParserActions)object).addString(new StringBuffer(graphicPrimitive.toString(true)), true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (GraphicPrimitive graphicPrimitive : drawingModel.getPrimitiveVector()) {
            if (!graphicPrimitive.getSelected()) continue;
            graphicPrimitive.movePrimitive(point.x, point.y);
            stringBuilder.append(graphicPrimitive.toString(true));
        }
        this.parent.repaint();
        object = stringBuilder.toString();
        return new MacroDesc(string5 + "." + string2, string, (String)object, string4, string3, string5);
    }

    protected void updateTreeLib() {
        JFrame jFrame = (JFrame)Globals.activeWindow;
        ((AbstractButton)((Object)jFrame.getJMenuBar().getMenu(3).getSubElements()[0].getSubElements()[1])).doClick();
    }

    public void setCircuit(DrawingModel drawingModel) {
        this.cp = drawingModel;
    }
}

