/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.sourceforge.fidocadj.dialogs.DialogUtil;
import net.sourceforge.fidocadj.dialogs.LibraryPanel;
import net.sourceforge.fidocadj.dialogs.mindimdialog.MinimumSizeDialog;
import net.sourceforge.fidocadj.globals.Globals;

public class DialogOptions
extends MinimumSizeDialog {
    public double zoomValue;
    public boolean profileTime;
    public boolean antiAlias;
    public boolean textToolbar;
    public boolean smallIconsToolbar;
    public int gridSize;
    public boolean extStrict;
    public boolean shiftCP;
    public double stroke_size_straight_i;
    public double connectionSize_i;
    public String libDirectory;
    public int pcblinewidth_i;
    public int pcbpadwidth_i;
    public int pcbpadheight_i;
    public int pcbpadintw_i;
    public String macroFont;
    public int macroSize_i;
    private final JFrame parent;
    private JCheckBox antiAlias_CB;
    private JCheckBox profile_CB;
    private JCheckBox extStrict_CB;
    private JCheckBox shiftCP_CB;
    private JTextField gridWidth;
    private JTextField libD;
    private JCheckBox textToolbar_CB;
    private JCheckBox smallIconsToolbar_CB;
    private JTextField pcblinewidth;
    private JTextField pcbpadwidth;
    private JTextField pcbpadheight;
    private JTextField pcbpadintw;
    private JTextField connectionSize;
    private JTextField macroSize;
    private JTextField stroke_size_straight;
    private JCheckBox quaquaActive_CB;
    private JComboBox<String> comboFont;

    public DialogOptions(JFrame jFrame, double d, boolean bl, boolean bl2, int n, String string, boolean bl3, boolean bl4, int n2, int n3, int n4, int n5, boolean bl5, String string2, double d2, double d3, double d4, int n6, boolean bl6) {
        super(600, 450, jFrame, Globals.messages.getString("Cir_opt_t"), true);
        this.addComponentListener(this);
        this.shiftCP = bl6;
        this.parent = jFrame;
        this.zoomValue = d;
        this.profileTime = bl;
        this.antiAlias = bl2;
        this.gridSize = n;
        this.libDirectory = string;
        this.textToolbar = bl3;
        this.smallIconsToolbar = bl4;
        this.extStrict = bl5;
        this.macroFont = string2;
        this.pcblinewidth_i = n2;
        this.pcbpadwidth_i = n3;
        this.pcbpadheight_i = n4;
        this.pcbpadintw_i = n5;
        this.connectionSize_i = d4;
        this.macroSize_i = n6;
        this.stroke_size_straight_i = d2;
        this.setSize(600, 500);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(Globals.messages.getString("Restart"), this.createRestartPane());
        jTabbedPane.addTab(Globals.messages.getString("Drawing"), this.createDrawingOptPanel());
        jTabbedPane.addTab(Globals.messages.getString("PCBsizes"), this.createPCBsizePanel());
        jTabbedPane.addTab(Globals.messages.getString("FidoCad"), this.createExtensionsPanel());
        GridBagConstraints gridBagConstraints = DialogUtil.createConst(0, 0, 3, 1, 100, 100, 13, 1, new Insets(6, 20, 6, 20));
        container.add((Component)jTabbedPane, gridBagConstraints);
        JButton jButton = new JButton(Globals.messages.getString("Ok_btn"));
        JButton jButton2 = new JButton(Globals.messages.getString("Cancel_btn"));
        gridBagConstraints = DialogUtil.createConst(0, 1, 3, 1, 100, 100, 13, 1, new Insets(6, 20, 20, 20));
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        jButton.setPreferredSize(jButton2.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            box.add(jButton);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton2);
        } else {
            box.add(jButton2);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton);
        }
        container.add((Component)box, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                int n = -1;
                DialogOptions.this.shiftCP = DialogOptions.this.shiftCP_CB.isSelected();
                DialogOptions.this.antiAlias = DialogOptions.this.antiAlias_CB.isSelected();
                DialogOptions.this.profileTime = DialogOptions.this.profile_CB.isSelected();
                DialogOptions.this.textToolbar = DialogOptions.this.textToolbar_CB.isSelected();
                DialogOptions.this.smallIconsToolbar = DialogOptions.this.smallIconsToolbar_CB.isSelected();
                DialogOptions.this.extStrict = DialogOptions.this.extStrict_CB.isSelected();
                DialogOptions.this.macroFont = (String)DialogOptions.this.comboFont.getSelectedItem();
                int n2 = 0;
                boolean bl = false;
                try {
                    n2 = Integer.parseInt(DialogOptions.this.macroSize.getText().trim());
                    n = Integer.parseInt(DialogOptions.this.gridWidth.getText().trim());
                    DialogOptions.this.libDirectory = DialogOptions.this.libD.getText().trim();
                    DialogOptions.this.pcblinewidth_i = Integer.parseInt(DialogOptions.this.pcblinewidth.getText().trim());
                    DialogOptions.this.pcbpadwidth_i = Integer.parseInt(DialogOptions.this.pcbpadwidth.getText().trim());
                    DialogOptions.this.pcbpadheight_i = Integer.parseInt(DialogOptions.this.pcbpadheight.getText().trim());
                    DialogOptions.this.pcbpadintw_i = Integer.parseInt(DialogOptions.this.pcbpadintw.getText().trim());
                    DialogOptions.this.stroke_size_straight_i = Double.parseDouble(DialogOptions.this.stroke_size_straight.getText().trim());
                    DialogOptions.this.connectionSize_i = Double.parseDouble(DialogOptions.this.connectionSize.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    string = numberFormatException.getMessage();
                }
                if (n <= 0 || bl) {
                    JOptionPane.showMessageDialog(DialogOptions.this.parent, Globals.messages.getString("Format_invalid") + " (" + string + ")", "", 1);
                    return;
                }
                DialogOptions.this.gridSize = n;
                if (n2 <= 0 && !bl) {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("Font_size_invalid"), "", 1);
                    return;
                }
                DialogOptions.this.macroSize_i = n2;
                DialogOptions.this.setVisible(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogOptions.this.setVisible(false);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogOptions.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, abstractAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(jButton);
    }

    private JPanel createRestartPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(Globals.messages.getString("lib_dir"));
        gridBagConstraints = DialogUtil.createConst(0, 0, 1, 1, 100, 100, 17, 2, new Insets(20, 40, 6, 0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.libD = new JTextField(10);
        this.libD.setText(this.libDirectory);
        gridBagConstraints = DialogUtil.createConst(0, 1, 1, 1, 100, 100, 13, 2, new Insets(6, 40, 6, 20));
        jPanel.add((Component)this.libD, gridBagConstraints);
        JButton jButton = new JButton(Globals.messages.getString("Browse"));
        gridBagConstraints.insets = new Insets(0, 0, 0, 40);
        jButton.setOpaque(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                if (Globals.useNativeFileDialogs) {
                    FileDialog fileDialog = new FileDialog((Frame)DialogOptions.this.parent, Globals.messages.getString("Select_lib_directory"), 0);
                    fileDialog.setDirectory(DialogOptions.this.libD.getText());
                    System.setProperty("apple.awt.fileDialogForDirectories", "true");
                    fileDialog.setVisible(true);
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                    string = fileDialog.getDirectory() == null || fileDialog.getFile() == null ? null : new File(fileDialog.getDirectory(), fileDialog.getFile()).getPath();
                } else {
                    JFileChooser jFileChooser = new JFileChooser(new File(DialogOptions.this.libD.getText()).getPath());
                    jFileChooser.setDialogTitle(Globals.messages.getString("Select_lib_directory"));
                    jFileChooser.setFileSelectionMode(1);
                    LibraryPanel libraryPanel = new LibraryPanel(jFileChooser);
                    int n = jFileChooser.showOpenDialog(null);
                    string = n == 0 ? jFileChooser.getSelectedFile().getPath() : null;
                }
                if (string != null) {
                    DialogOptions.this.libD.setText(string);
                }
            }
        });
        JLabel jLabel2 = new JLabel(Globals.messages.getString("restart_info"));
        gridBagConstraints = DialogUtil.createConst(0, 3, 1, 1, 100, 100, 13, 2, new Insets(6, 40, 6, 0));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.textToolbar_CB = new JCheckBox(Globals.messages.getString("TextToolbar"));
        this.textToolbar_CB.setSelected(this.textToolbar);
        this.textToolbar_CB.setOpaque(false);
        gridBagConstraints = DialogUtil.createConst(0, 4, 1, 1, 100, 100, 13, 2, new Insets(6, 40, 6, 0));
        jPanel.add((Component)this.textToolbar_CB, gridBagConstraints);
        gridBagConstraints = DialogUtil.createConst(0, 5, 1, 1, 100, 100, 13, 2, new Insets(6, 40, 6, 20));
        this.smallIconsToolbar_CB = new JCheckBox(Globals.messages.getString("SmallIcons"));
        this.smallIconsToolbar_CB.setSelected(this.smallIconsToolbar);
        this.smallIconsToolbar_CB.setOpaque(false);
        gridBagConstraints = DialogUtil.createConst(0, 6, 1, 1, 100, 100, 13, 2, new Insets(6, 40, 20, 20));
        jPanel.add((Component)this.smallIconsToolbar_CB, gridBagConstraints);
        return jPanel;
    }

    private JPanel createDrawingOptPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setOpaque(false);
        this.profile_CB = new JCheckBox(Globals.messages.getString("Profile"));
        this.profile_CB.setOpaque(false);
        this.profile_CB.setSelected(this.profileTime);
        gridBagConstraints = DialogUtil.createConst(1, 1, 2, 1, 100, 100, 13, 2, new Insets(6, 6, 6, 20));
        JLabel jLabel = new JLabel(Globals.messages.getString("Grid_width"));
        gridBagConstraints = DialogUtil.createConst(0, 2, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.gridWidth = new JTextField(10);
        this.gridWidth.setText("" + this.gridSize);
        gridBagConstraints = DialogUtil.createConst(1, 2, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)this.gridWidth, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Globals.messages.getString("connection_size"));
        gridBagConstraints = DialogUtil.createConst(0, 8, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.connectionSize = new JTextField(10);
        this.connectionSize.setText("" + this.connectionSize_i);
        gridBagConstraints = DialogUtil.createConst(1, 8, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)this.connectionSize, gridBagConstraints);
        JLabel jLabel3 = new JLabel(Globals.messages.getString("stroke_size_straight"));
        gridBagConstraints = DialogUtil.createConst(0, 9, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.stroke_size_straight = new JTextField(10);
        this.stroke_size_straight.setText("" + this.stroke_size_straight_i);
        gridBagConstraints = DialogUtil.createConst(1, 9, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)this.stroke_size_straight, gridBagConstraints);
        JLabel jLabel4 = new JLabel(Globals.messages.getString("macrofont"));
        gridBagConstraints = DialogUtil.createConst(0, 11, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)jLabel4, gridBagConstraints);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        this.comboFont = new JComboBox();
        for (int i = 0; i < stringArray.length; ++i) {
            this.comboFont.addItem(stringArray[i]);
            if (!stringArray[i].equals(this.macroFont)) continue;
            this.comboFont.setSelectedIndex(i);
        }
        gridBagConstraints = DialogUtil.createConst(1, 11, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        jPanel.add(this.comboFont, gridBagConstraints);
        JLabel jLabel5 = new JLabel(Globals.messages.getString("macroSize"));
        gridBagConstraints = DialogUtil.createConst(0, 12, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)jLabel5, gridBagConstraints);
        this.macroSize = new JTextField(10);
        this.macroSize.setText("" + this.macroSize_i);
        gridBagConstraints = DialogUtil.createConst(1, 12, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)this.macroSize, gridBagConstraints);
        this.antiAlias_CB = new JCheckBox(Globals.messages.getString("Anti_al"));
        this.antiAlias_CB.setSelected(this.antiAlias);
        this.antiAlias_CB.setOpaque(false);
        gridBagConstraints = DialogUtil.createConst(1, 13, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 40));
        jPanel.add((Component)this.antiAlias_CB, gridBagConstraints);
        this.shiftCP_CB = new JCheckBox(Globals.messages.getString("Shift_cp"));
        this.shiftCP_CB.setSelected(this.shiftCP);
        this.shiftCP_CB.setOpaque(false);
        gridBagConstraints = DialogUtil.createConst(1, 14, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 40));
        jPanel.add((Component)this.shiftCP_CB, gridBagConstraints);
        return jPanel;
    }

    private JPanel createPCBsizePanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(Globals.messages.getString("pcbline_width"));
        gridBagConstraints = DialogUtil.createConst(0, 0, 1, 1, 100, 100, 13, 0, new Insets(0, 0, 0, 0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.pcblinewidth = new JTextField(10);
        this.pcblinewidth.setText("" + this.pcblinewidth_i);
        gridBagConstraints = DialogUtil.createConst(1, 0, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)this.pcblinewidth, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Globals.messages.getString("pcbpad_width"));
        gridBagConstraints = DialogUtil.createConst(0, 1, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.pcbpadwidth = new JTextField(10);
        this.pcbpadwidth.setText("" + this.pcbpadwidth_i);
        gridBagConstraints = DialogUtil.createConst(1, 1, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)this.pcbpadwidth, gridBagConstraints);
        JLabel jLabel3 = new JLabel(Globals.messages.getString("pcbpad_height"));
        gridBagConstraints = DialogUtil.createConst(0, 2, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.pcbpadheight = new JTextField(10);
        this.pcbpadheight.setText("" + this.pcbpadheight_i);
        gridBagConstraints = DialogUtil.createConst(1, 2, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)this.pcbpadheight, gridBagConstraints);
        JLabel jLabel4 = new JLabel(Globals.messages.getString("pcbpad_intw"));
        gridBagConstraints = DialogUtil.createConst(0, 3, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)jLabel4, gridBagConstraints);
        this.pcbpadintw = new JTextField(10);
        this.pcbpadintw.setText("" + this.pcbpadintw_i);
        gridBagConstraints = DialogUtil.createConst(1, 3, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        jPanel.add((Component)this.pcbpadintw, gridBagConstraints);
        return jPanel;
    }

    private JPanel createExtensionsPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setOpaque(false);
        this.extStrict_CB = new JCheckBox(Globals.messages.getString("strict_FC_comp"));
        this.extStrict_CB.setSelected(this.extStrict);
        this.extStrict_CB.setOpaque(false);
        gridBagConstraints = DialogUtil.createConst(0, 0, 2, 1, 100, 100, 17, 0, new Insets(6, 40, 6, 40));
        jPanel.add((Component)this.extStrict_CB, gridBagConstraints);
        return jPanel;
    }
}

