/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.sourceforge.fidocadj.dialogs.ActionDClick;
import net.sourceforge.fidocadj.dialogs.DialogEditLayer;
import net.sourceforge.fidocadj.dialogs.DialogUtil;
import net.sourceforge.fidocadj.dialogs.LayerCellRenderer;
import net.sourceforge.fidocadj.dialogs.mindimdialog.MinimumSizeDialog;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.layers.LayerDesc;

public class DialogLayer
extends MinimumSizeDialog
implements ComponentListener {
    private final Vector<LayerDesc> layers;
    public JList<LayerDesc> layerList;

    public DialogLayer(JFrame jFrame, Vector<LayerDesc> vector) {
        super(400, 350, jFrame, Globals.messages.getString("Layer_editor"), true);
        DialogUtil.center(this, 0.4, 0.4, 400, 350);
        this.addComponentListener(this);
        this.layers = vector;
        this.getRootPane().putClientProperty("apple.awt.documentModalSheet", Boolean.TRUE);
        GridBagLayout gridBagLayout = new GridBagLayout();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        this.layerList = new JList<LayerDesc>(new Vector<LayerDesc>(this.layers));
        JScrollPane jScrollPane = new JScrollPane(this.layerList);
        this.layerList.setCellRenderer(new LayerCellRenderer());
        GridBagConstraints gridBagConstraints = DialogUtil.createConst(0, 0, 1, 1, 100, 100, 13, 1, new Insets(20, 20, 6, 20));
        container.add((Component)jScrollPane, gridBagConstraints);
        JButton jButton = new JButton(Globals.messages.getString("Ok_btn"));
        JButton jButton2 = new JButton(Globals.messages.getString("Cancel_btn"));
        JButton jButton3 = new JButton(Globals.messages.getString("Edit"));
        Box box = Box.createHorizontalBox();
        box.add(jButton3);
        box.add(Box.createHorizontalGlue());
        jButton.setPreferredSize(jButton2.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            box.add(jButton);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton2);
        } else {
            box.add(jButton2);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton);
        }
        gridBagConstraints = DialogUtil.createConst(0, 1, 1, 1, 100, 0, 13, 2, new Insets(0, 20, 20, 20));
        container.add((Component)box, gridBagConstraints);
        this.layerList.addMouseListener(new ActionDClick(this));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogLayer.this.activateLayerEditor(DialogLayer.this.layerList.getSelectedIndex());
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogLayer.this.setVisible(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogLayer.this.setVisible(false);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogLayer.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, abstractAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(jButton);
    }

    public void activateLayerEditor(int n) {
        if (n >= 0) {
            DialogEditLayer dialogEditLayer = new DialogEditLayer(null, this.layers.get(this.layerList.getSelectedIndex()));
            dialogEditLayer.setVisible(true);
            if (dialogEditLayer.getActive()) {
                dialogEditLayer.acceptLayer();
                this.repaint();
            }
        } else {
            JOptionPane.showMessageDialog(null, Globals.messages.getString("Warning_select_layer"), Globals.messages.getString("Layer_editor"), 1, null);
        }
    }
}

