/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.dialogs.DialogUtil;
import net.sourceforge.fidocadj.dialogs.mindimdialog.MinimumSizeDialog;
import net.sourceforge.fidocadj.geom.DrawingSize;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointG;

public class DialogExport
extends MinimumSizeDialog
implements ActionListener {
    private final JFrame parent;
    private boolean export;
    private static final int PNG_INDEX = 0;
    private static final int JPG_INDEX = 1;
    private static final int SVG_INDEX = 2;
    private static final int EPS_INDEX = 3;
    private static final int PGF_INDEX = 4;
    private static final int PDF_INDEX = 5;
    private static final int SCR_INDEX = 6;
    private static final int PCB_INDEX = 7;
    private static final double EPS = 1.0E-5;
    private JComboBox<String> resolution;
    private JCheckBox antiAlias_CB;
    private JCheckBox blackWhite_CB;
    private final JComboBox<String> fileFormat;
    private JTextField fileName;
    private final JTabbedPane tabsPane;
    private JTextField multiplySizes;
    private JTextField xsizePixel;
    private JTextField ysizePixel;
    private final DrawingModel dm;
    private final DimensionG dim;
    private JCheckBox splitLayers_CB;
    private JLabel expectedSize;

    public DialogExport(JFrame jFrame, DrawingModel drawingModel) {
        super(450, 400, jFrame, Globals.messages.getString("Circ_exp_t"), true);
        this.dm = drawingModel;
        this.getRootPane().putClientProperty("apple.awt.documentModalSheet", Boolean.TRUE);
        PointG pointG = new PointG();
        this.dim = DrawingSize.getImageSize(this.dm, 1.0, true, pointG);
        this.addComponentListener(this);
        this.export = false;
        this.parent = jFrame;
        GridBagLayout gridBagLayout = new GridBagLayout();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(Globals.messages.getString("File_format"));
        GridBagConstraints gridBagConstraints = DialogUtil.createConst(1, 0, 1, 1, 0, 0, 13, 0, new Insets(12, 40, 0, 0));
        container.add((Component)jLabel, gridBagConstraints);
        this.fileFormat = new JComboBox();
        this.fileFormat.addItem("PNG (Bitmap)");
        this.fileFormat.addItem("JPG (Bitmap)");
        this.fileFormat.addItem("SVG (Vector, Scalable Vector Graphic)");
        this.fileFormat.addItem("EPS (Vector, Encapsulated Postscript)");
        this.fileFormat.addItem("PGF (Vector, PGF packet for LaTeX)");
        this.fileFormat.addItem("PDF (Vector, Portable Document File)");
        this.fileFormat.addItem("CadSoft Eagle SCR (Script)");
        this.fileFormat.addItem("gEDA PCB, pcb-rnd (.pcb) file");
        this.fileFormat.setSelectedIndex(0);
        gridBagConstraints = DialogUtil.createConst(2, 0, 1, 1, 100, 100, 17, 2, new Insets(12, 0, 0, 20));
        container.add(this.fileFormat, gridBagConstraints);
        this.fileFormat.addActionListener(this);
        JPanel jPanel = this.createResolutionBasedExportPanel();
        JButton jButton = new JButton(Globals.messages.getString("Ok_btn"));
        JButton jButton2 = new JButton(Globals.messages.getString("Cancel_btn"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        this.tabsPane = new JTabbedPane();
        this.tabsPane.addTab(Globals.messages.getString("res_export"), jPanel);
        JPanel jPanel2 = this.createSizeBasedExportPanel();
        this.tabsPane.addTab(Globals.messages.getString("size_export"), jPanel2);
        container.add((Component)this.tabsPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        JPanel jPanel3 = this.createCommonInterfaceElements();
        container.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        jButton.setPreferredSize(jButton2.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            box.add(jButton);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton2);
        } else {
            box.add(jButton2);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton);
        }
        container.add((Component)box, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = Double.parseDouble(DialogExport.this.multiplySizes.getText());
                if (DialogExport.this.multiplySizes.isEnabled() && (d < 0.01 || d > 100.0)) {
                    DialogExport.this.export = false;
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("Warning_mul"), Globals.messages.getString("Warning"), 2);
                    return;
                }
                if (DialogExport.this.fileName.getText().trim().equals("")) {
                    DialogExport.this.export = false;
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("Warning_noname"), Globals.messages.getString("Warning"), 2);
                    return;
                }
                boolean bl = false;
                if (!bl) {
                    DialogExport.this.export = true;
                    DialogExport.this.setVisible(false);
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogExport.this.setVisible(false);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogExport.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, abstractAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(jButton);
    }

    public boolean shouldExport() {
        return this.export;
    }

    public boolean getAntiAlias() {
        return this.antiAlias_CB.isSelected();
    }

    public boolean getBlackWhite() {
        return this.blackWhite_CB.isSelected();
    }

    public boolean getSplitLayers() {
        return this.splitLayers_CB.isSelected();
    }

    public void setSplitLayers(boolean bl) {
        this.splitLayers_CB.setSelected(bl);
    }

    public boolean getResolutionBasedExport() {
        return this.tabsPane.getSelectedIndex() == 0;
    }

    public void setResolutionBasedExport(boolean bl) {
        this.tabsPane.setSelectedIndex(bl ? 0 : 1);
    }

    public String getFormat() {
        switch (this.fileFormat.getSelectedIndex()) {
            case 0: {
                return "png";
            }
            case 1: {
                return "jpg";
            }
            case 2: {
                return "svg";
            }
            case 3: {
                return "eps";
            }
            case 4: {
                return "pgf";
            }
            case 5: {
                return "pdf";
            }
            case 6: {
                return "scr";
            }
            case 7: {
                return "pcb";
            }
        }
        System.out.println("dialogExport.getExportFormat Warning: file format set to png");
        return "png";
    }

    public String getFileName() {
        return this.fileName.getText();
    }

    public void setFileName(String string) {
        this.fileName.setText(string);
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias_CB.setSelected(bl);
    }

    public void setBlackWhite(boolean bl) {
        this.blackWhite_CB.setSelected(bl);
    }

    public void setUnitPerPixel(double d) {
        int n = 0;
        if (Math.abs(d - 0.36) < 1.0E-5) {
            n = 0;
        }
        if (Math.abs(d - 0.75) < 1.0E-5) {
            n = 1;
        }
        if (Math.abs(d - 1.5) < 1.0E-5) {
            n = 2;
        }
        if (Math.abs(d - 3.0) < 1.0E-5) {
            n = 3;
        }
        if (Math.abs(d - 6.0) < 1.0E-5) {
            n = 4;
        }
        if (Math.abs(d - 9.0) < 1.0E-5) {
            n = 5;
        }
        if (Math.abs(d - 12.0) < 1.0E-5) {
            n = 6;
        }
        this.resolution.setSelectedIndex(n);
    }

    public void setMagnification(double d) {
        this.multiplySizes.setText("" + d);
    }

    public double getMagnification() {
        return Double.parseDouble(this.multiplySizes.getText());
    }

    public void setXsizeInPixels(int n) {
        this.xsizePixel.setText("" + n);
    }

    public int getXsizeInPixels() {
        return Integer.parseInt(this.xsizePixel.getText());
    }

    public void setYsizeInPixels(int n) {
        this.ysizePixel.setText("" + n);
    }

    public int getYsizeInPixels() {
        return Integer.parseInt(this.ysizePixel.getText());
    }

    public double getUnitPerPixel() {
        int n = this.resolution.getSelectedIndex();
        switch (n) {
            case 0: {
                return 0.36;
            }
            case 1: {
                return 0.75;
            }
            case 2: {
                return 1.5;
            }
            case 3: {
                return 3.0;
            }
            case 4: {
                return 6.0;
            }
            case 5: {
                return 9.0;
            }
            case 6: {
                return 12.0;
            }
        }
        return 0.36;
    }

    public void setFormat(String string) {
        if ("png".equals(string)) {
            this.fileFormat.setSelectedIndex(0);
        } else if ("jpg".equals(string)) {
            this.fileFormat.setSelectedIndex(1);
        } else if ("svg".equals(string)) {
            this.fileFormat.setSelectedIndex(2);
        } else if ("eps".equals(string)) {
            this.fileFormat.setSelectedIndex(3);
        } else if ("pgf".equals(string)) {
            this.fileFormat.setSelectedIndex(4);
        } else if ("pdf".equals(string)) {
            this.fileFormat.setSelectedIndex(5);
        } else if ("scr".equals(string)) {
            this.fileFormat.setSelectedIndex(6);
        } else if ("pcb".equals(string)) {
            this.fileFormat.setSelectedIndex(7);
        } else {
            this.fileFormat.setSelectedIndex(0);
        }
    }

    private JPanel createSizeBasedExportPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(Globals.messages.getString("ctrl_x_radius"));
        gridBagConstraints = DialogUtil.createConst(1, 0, 1, 1, 0, 0, 13, 1, new Insets(6, 40, 6, 6));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.xsizePixel = new JTextField();
        gridBagConstraints = DialogUtil.createConst(2, 0, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.xsizePixel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Globals.messages.getString("ctrl_y_radius"));
        gridBagConstraints = DialogUtil.createConst(1, 1, 1, 1, 0, 0, 13, 1, new Insets(6, 40, 6, 6));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.ysizePixel = new JTextField();
        gridBagConstraints = DialogUtil.createConst(2, 1, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.ysizePixel, gridBagConstraints);
        return jPanel;
    }

    private JPanel createResolutionBasedExportPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(Globals.messages.getString("Resolution"));
        gridBagConstraints = DialogUtil.createConst(1, 0, 1, 1, 0, 0, 13, 1, new Insets(6, 40, 6, 6));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.resolution = this.createResolutionComboBox();
        gridBagConstraints = DialogUtil.createConst(2, 0, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        jPanel.add(this.resolution, gridBagConstraints);
        this.expectedSize = new JLabel("x");
        gridBagConstraints = DialogUtil.createConst(2, 1, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.expectedSize, gridBagConstraints);
        return jPanel;
    }

    private JPanel createCommonInterfaceElements() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        this.antiAlias_CB = new JCheckBox(Globals.messages.getString("Anti_aliasing"));
        gridBagConstraints = DialogUtil.createConst(2, 1, 1, 1, 100, 100, 17, 2, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.antiAlias_CB, gridBagConstraints);
        this.blackWhite_CB = new JCheckBox(Globals.messages.getString("B_W"));
        gridBagConstraints = DialogUtil.createConst(2, 2, 1, 1, 100, 100, 17, 2, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.blackWhite_CB, gridBagConstraints);
        JLabel jLabel = new JLabel(Globals.messages.getString("Multiply_sizes"));
        gridBagConstraints = DialogUtil.createConst(1, 3, 1, 1, 0, 0, 13, 0, new Insets(6, 40, 0, 0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.multiplySizes = new JTextField();
        gridBagConstraints = DialogUtil.createConst(2, 3, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.multiplySizes, gridBagConstraints);
        this.splitLayers_CB = new JCheckBox(Globals.messages.getString("Split_layers_multiple_files"));
        gridBagConstraints = DialogUtil.createConst(2, 4, 1, 1, 100, 100, 17, 2, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.splitLayers_CB, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Globals.messages.getString("File_name"));
        gridBagConstraints = DialogUtil.createConst(1, 5, 1, 1, 0, 0, 13, 0, new Insets(6, 40, 12, 0));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.fileName = new JTextField();
        gridBagConstraints = DialogUtil.createConst(2, 5, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 12, 0));
        jPanel.add((Component)this.fileName, gridBagConstraints);
        JButton jButton = new JButton(Globals.messages.getString("Browse"));
        gridBagConstraints = DialogUtil.createConst(3, 5, 1, 1, 0, 0, 10, 0, new Insets(6, 0, 12, 12));
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(this.createBrowseActionListener());
        return jPanel;
    }

    private ActionListener createBrowseActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Globals.useNativeFileDialogs) {
                    FileDialog fileDialog = new FileDialog((Frame)DialogExport.this.parent, Globals.messages.getString("Select_file_export"), 1);
                    fileDialog.setDirectory(new File(DialogExport.this.fileName.getText()).getPath());
                    fileDialog.setVisible(true);
                    if (fileDialog.getFile() != null) {
                        String string = Globals.createCompleteFileName(fileDialog.getDirectory(), fileDialog.getFile());
                        DialogExport.this.fileName.setText(string);
                    }
                } else {
                    JFileChooser jFileChooser = new JFileChooser(new File(DialogExport.this.fileName.getText()).getPath());
                    int n = jFileChooser.showSaveDialog(null);
                    if (n == 0) {
                        DialogExport.this.fileName.setText(jFileChooser.getSelectedFile().toString());
                    }
                }
            }
        };
    }

    private JComboBox<String> createResolutionComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("72x72 dpi");
        jComboBox.addItem("150x150 dpi");
        jComboBox.addItem("300x300 dpi");
        jComboBox.addItem("600x600 dpi");
        jComboBox.addItem("1200x1200 dpi");
        jComboBox.addItem("1800x1800 dpi");
        jComboBox.addItem("2400x2400 dpi");
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = (int)((double)(((DialogExport)DialogExport.this).dim.width + 6) * DialogExport.this.getUnitPerPixel());
                int n2 = (int)((double)(((DialogExport)DialogExport.this).dim.height + 6) * DialogExport.this.getUnitPerPixel());
                DialogExport.this.expectedSize.setText(n + " x " + n2 + " pixels");
            }
        });
        return jComboBox;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.fileFormat.getSelectedIndex();
        if (n == 0 || n == 1) {
            this.xsizePixel.setEnabled(true);
            this.ysizePixel.setEnabled(true);
            this.resolution.setEnabled(true);
            this.antiAlias_CB.setEnabled(true);
            this.blackWhite_CB.setEnabled(true);
            this.multiplySizes.setEnabled(false);
            this.multiplySizes.setText("1.0");
        } else {
            this.xsizePixel.setEnabled(false);
            this.ysizePixel.setEnabled(false);
            this.expectedSize.setText("");
            this.resolution.setEnabled(false);
            this.antiAlias_CB.setEnabled(false);
            this.blackWhite_CB.setEnabled(true);
            this.multiplySizes.setEnabled(true);
        }
    }
}

