/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import net.sourceforge.fidocadj.dialogs.DialogUtil;
import net.sourceforge.fidocadj.dialogs.mindimdialog.MinimumSizeDialog;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.swing.ColorSwing;
import net.sourceforge.fidocadj.layers.LayerDesc;

public class DialogEditLayer
extends MinimumSizeDialog {
    static final int ALPHA_MIN = 0;
    static final int ALPHA_MAX = 100;
    private JButton color;
    private final JColorChooser tcc;
    private final JCheckBox visibility;
    private final JTextField description;
    private final JSlider opacity;
    private boolean active;
    private final LayerDesc ll;

    public DialogEditLayer(JFrame jFrame, LayerDesc layerDesc) {
        super(500, 450, jFrame, Globals.messages.getString("Layer_options") + layerDesc.getDescription(), true);
        this.ll = layerDesc;
        this.addComponentListener(this);
        this.active = false;
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = DialogUtil.createConst(0, 0, 3, 1, 100, 100, 10, 0, new Insets(20, 20, 6, 20));
        ColorSwing colorSwing = (ColorSwing)layerDesc.getColor();
        this.tcc = new JColorChooser(colorSwing.getColorSwing());
        container.add((Component)this.tcc, gridBagConstraints);
        JLabel jLabel = new JLabel(Globals.messages.getString("Description"));
        gridBagConstraints = DialogUtil.createConst(1, 1, 1, 1, 100, 100, 13, 0, new Insets(0, 20, 0, 0));
        container.add((Component)jLabel, gridBagConstraints);
        this.description = new JTextField();
        this.description.setText(layerDesc.getDescription());
        gridBagConstraints = DialogUtil.createConst(2, 1, 1, 1, 100, 0, 17, 2, new Insets(0, 0, 0, 120));
        container.add((Component)this.description, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Globals.messages.getString("Opacity"));
        gridBagConstraints = DialogUtil.createConst(1, 3, 1, 1, 100, 0, 13, 0, new Insets(0, 0, 0, 20));
        container.add((Component)jLabel2, gridBagConstraints);
        this.opacity = new JSlider(0, 0, 100, Math.round(layerDesc.getAlpha() * 100.0f));
        this.opacity.setMajorTickSpacing(20);
        this.opacity.setMinorTickSpacing(1);
        this.opacity.setPaintTicks(true);
        this.opacity.setPaintLabels(true);
        gridBagConstraints = DialogUtil.createConst(2, 3, 1, 1, 100, 0, 17, 2, new Insets(0, 0, 0, 120));
        container.add((Component)this.opacity, gridBagConstraints);
        this.visibility = new JCheckBox(Globals.messages.getString("IsVisible"));
        this.visibility.setSelected(layerDesc.getVisible());
        gridBagConstraints = DialogUtil.createConst(2, 4, 1, 1, 100, 0, 17, 2, new Insets(0, 0, 20, 120));
        container.add((Component)this.visibility, gridBagConstraints);
        JButton jButton = new JButton(Globals.messages.getString("Ok_btn"));
        JButton jButton2 = new JButton(Globals.messages.getString("Cancel_btn"));
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        jButton.setPreferredSize(jButton2.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            box.add(jButton);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton2);
        } else {
            box.add(jButton2);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton);
        }
        gridBagConstraints = DialogUtil.createConst(0, 5, 3, 1, 100, 0, 17, 2, new Insets(0, 20, 20, 20));
        container.add((Component)box, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogEditLayer.this.active = true;
                DialogEditLayer.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogEditLayer.this.setVisible(false);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogEditLayer.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, abstractAction);
        this.pack();
        DialogUtil.center(this);
    }

    public void acceptLayer() {
        this.ll.setVisible(this.visibility.isSelected());
        this.ll.setDescription(this.description.getText());
        this.ll.setColor(new ColorSwing(this.tcc.getColor()));
        this.ll.setAlpha((float)this.opacity.getValue() / 100.0f);
        this.ll.setModified(true);
    }

    public boolean getActive() {
        return this.active;
    }
}

