/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.dialogs.DialogUtil;
import net.sourceforge.fidocadj.dialogs.mindimdialog.MinimumSizeDialog;
import net.sourceforge.fidocadj.geom.DrawingSize;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointG;

public class DialogCopyAsImage
extends MinimumSizeDialog
implements ActionListener {
    private final JFrame parent;
    private boolean copy;
    private static final double EPS = 1.0E-5;
    private JComboBox<String> resolution;
    private JCheckBox antiAlias_CB;
    private JCheckBox blackWhite_CB;
    private final JTabbedPane tabsPane;
    private JTextField xsizePixel;
    private JTextField ysizePixel;
    private final DrawingModel dm;
    private final DimensionG dim;
    private JLabel expectedSize;

    public DialogCopyAsImage(JFrame jFrame, DrawingModel drawingModel) {
        super(450, 400, jFrame, Globals.messages.getString("Circ_exp_t"), true);
        this.dm = drawingModel;
        this.getRootPane().putClientProperty("apple.awt.documentModalSheet", Boolean.TRUE);
        PointG pointG = new PointG();
        this.dim = DrawingSize.getImageSize(this.dm, 1.0, true, pointG);
        this.addComponentListener(this);
        this.copy = false;
        this.parent = jFrame;
        GridBagLayout gridBagLayout = new GridBagLayout();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = DialogUtil.createConst(1, 0, 1, 1, 0, 0, 13, 1, new Insets(12, 40, 0, 0));
        JPanel jPanel = this.createResolutionBasedExportPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        this.tabsPane = new JTabbedPane();
        this.tabsPane.addTab(Globals.messages.getString("res_export"), jPanel);
        JPanel jPanel2 = this.createSizeBasedExportPanel();
        this.tabsPane.addTab(Globals.messages.getString("size_export"), jPanel2);
        container.add((Component)this.tabsPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        JPanel jPanel3 = this.createCommonInterfaceElements();
        container.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(Globals.messages.getString("Ok_btn"));
        JButton jButton2 = new JButton(Globals.messages.getString("Cancel_btn"));
        jButton.setPreferredSize(jButton2.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            box.add(jButton);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton2);
        } else {
            box.add(jButton2);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton);
        }
        container.add((Component)box, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                if (!bl) {
                    DialogCopyAsImage.this.copy = true;
                    DialogCopyAsImage.this.setVisible(false);
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogCopyAsImage.this.setVisible(false);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogCopyAsImage.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, abstractAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(jButton);
    }

    public boolean shouldExport() {
        return this.copy;
    }

    public boolean getAntiAlias() {
        return this.antiAlias_CB.isSelected();
    }

    public boolean getBlackWhite() {
        return this.blackWhite_CB.isSelected();
    }

    public boolean getResolutionBasedExport() {
        return this.tabsPane.getSelectedIndex() == 0;
    }

    public void setResolutionBasedExport(boolean bl) {
        this.tabsPane.setSelectedIndex(bl ? 0 : 1);
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias_CB.setSelected(bl);
    }

    public void setBlackWhite(boolean bl) {
        this.blackWhite_CB.setSelected(bl);
    }

    public void setUnitPerPixel(double d) {
        int n = 0;
        if (Math.abs(d - 0.36) < 1.0E-5) {
            n = 0;
        }
        if (Math.abs(d - 0.75) < 1.0E-5) {
            n = 1;
        }
        if (Math.abs(d - 1.5) < 1.0E-5) {
            n = 2;
        }
        if (Math.abs(d - 3.0) < 1.0E-5) {
            n = 3;
        }
        if (Math.abs(d - 6.0) < 1.0E-5) {
            n = 4;
        }
        if (Math.abs(d - 9.0) < 1.0E-5) {
            n = 5;
        }
        if (Math.abs(d - 12.0) < 1.0E-5) {
            n = 6;
        }
        this.resolution.setSelectedIndex(n);
    }

    public void setXsizeInPixels(int n) {
        this.xsizePixel.setText("" + n);
    }

    public int getXsizeInPixels() {
        return Integer.parseInt(this.xsizePixel.getText());
    }

    public void setYsizeInPixels(int n) {
        this.ysizePixel.setText("" + n);
    }

    public int getYsizeInPixels() {
        return Integer.parseInt(this.ysizePixel.getText());
    }

    public double getUnitPerPixel() {
        int n = this.resolution.getSelectedIndex();
        switch (n) {
            case 0: {
                return 0.36;
            }
            case 1: {
                return 0.75;
            }
            case 2: {
                return 1.5;
            }
            case 3: {
                return 3.0;
            }
            case 4: {
                return 6.0;
            }
            case 5: {
                return 9.0;
            }
            case 6: {
                return 12.0;
            }
        }
        return 0.36;
    }

    private JPanel createSizeBasedExportPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(Globals.messages.getString("ctrl_x_radius"));
        gridBagConstraints = DialogUtil.createConst(1, 0, 1, 1, 0, 0, 13, 1, new Insets(6, 40, 6, 6));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.xsizePixel = new JTextField();
        gridBagConstraints = DialogUtil.createConst(2, 0, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.xsizePixel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Globals.messages.getString("ctrl_y_radius"));
        gridBagConstraints = DialogUtil.createConst(1, 1, 1, 1, 0, 0, 13, 1, new Insets(6, 40, 6, 6));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.ysizePixel = new JTextField();
        gridBagConstraints = DialogUtil.createConst(2, 1, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.ysizePixel, gridBagConstraints);
        return jPanel;
    }

    private JPanel createResolutionBasedExportPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(Globals.messages.getString("Resolution"));
        gridBagConstraints = DialogUtil.createConst(1, 0, 1, 1, 0, 0, 13, 1, new Insets(6, 40, 6, 6));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.resolution = this.createResolutionComboBox();
        gridBagConstraints = DialogUtil.createConst(2, 0, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        jPanel.add(this.resolution, gridBagConstraints);
        this.expectedSize = new JLabel("x");
        gridBagConstraints = DialogUtil.createConst(2, 1, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.expectedSize, gridBagConstraints);
        return jPanel;
    }

    private JPanel createCommonInterfaceElements() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        this.antiAlias_CB = new JCheckBox(Globals.messages.getString("Anti_aliasing"));
        gridBagConstraints = DialogUtil.createConst(2, 1, 1, 1, 100, 100, 17, 2, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.antiAlias_CB, gridBagConstraints);
        this.blackWhite_CB = new JCheckBox(Globals.messages.getString("B_W"));
        gridBagConstraints = DialogUtil.createConst(2, 2, 1, 1, 100, 100, 17, 0, new Insets(6, 0, 0, 0));
        jPanel.add((Component)this.blackWhite_CB, gridBagConstraints);
        return jPanel;
    }

    private JComboBox<String> createResolutionComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("72x72 dpi");
        jComboBox.addItem("150x150 dpi");
        jComboBox.addItem("300x300 dpi");
        jComboBox.addItem("600x600 dpi");
        jComboBox.addItem("1200x1200 dpi");
        jComboBox.addItem("1800x1800 dpi");
        jComboBox.addItem("2400x2400 dpi");
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = (int)((double)(((DialogCopyAsImage)DialogCopyAsImage.this).dim.width + 6) * DialogCopyAsImage.this.getUnitPerPixel());
                int n2 = (int)((double)(((DialogCopyAsImage)DialogCopyAsImage.this).dim.height + 6) * DialogCopyAsImage.this.getUnitPerPixel());
                DialogCopyAsImage.this.expectedSize.setText(n + " x " + n2 + " pixels");
            }
        });
        return jComboBox;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.xsizePixel.setEnabled(true);
        this.ysizePixel.setEnabled(true);
        this.resolution.setEnabled(true);
        this.antiAlias_CB.setEnabled(true);
        this.blackWhite_CB.setEnabled(true);
    }
}

